/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.model.table;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.FactorOrDescriptor;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.AbstractRuntimeModel;
import se.prediktera.breeze.frontend.common.swing.table.DefaultBreezeTableImpl;

public class BreezeModelCompareTableModel
extends DefaultBreezeTableImpl {
    @Override
    public Vector createVOVector(Object object) {
        Vector<Object> vector = new Vector<Object>();
        Analyse analyse = (Analyse)object;
        BasicAnalyse.ModelMethod modelMethod = analyse.getModelMethod();
        vector.add(analyse.getName());
        vector.add(this.getVariableNames(analyse));
        vector.add(modelMethod.getMethod());
        vector.add(new ModelCompare((int)Math.round(100.0 * analyse.getRating()), 0.0f, 100.0f, BreezeType.Analyse.getColor()));
        if (modelMethod.isRuntime()) {
            List<AbstractRuntimeModel.RuntimeResult> list = new AbstractRuntimeModel.RuntimeResultList((Node)analyse.getSetupXmlNode()).results;
            if (list.isEmpty()) {
                vector.add(new ModelCompare(0.0f, 0.0f, 1.0f, RtPerfectSpread.generateColor(2)));
                vector.add(new ModelCompare(0.0f, 0.0f, 1.0f, RtPerfectSpread.generateColor(0)));
                vector.add("");
            } else {
                AbstractRuntimeModel.RuntimeResult runtimeResult = list.get(0);
                vector.add(new ModelCompare((float)runtimeResult.crossValidationResult, 0.0f, 1.0f, RtPerfectSpread.generateColor(2)));
                vector.add(new ModelCompare(runtimeResult.accuracy.get(0).floatValue(), 0.0f, 1.0f, RtPerfectSpread.generateColor(0)));
                vector.add(runtimeResult.algorithmName);
            }
        } else {
            vector.add(new ModelCompare((float)analyse.getQ2y(), 0.0f, 1.0f, RtPerfectSpread.generateColor(2)));
            vector.add(new ModelCompare((float)analyse.getR2y(), 0.0f, 1.0f, RtPerfectSpread.generateColor(0)));
            int n = analyse.getComponents();
            if (n > 0) {
                vector.add(n + " components");
            } else {
                vector.add("");
            }
        }
        return vector;
    }

    private String getVariableNames(Analyse analyse) {
        StringBuffer stringBuffer = new StringBuffer();
        List<FactorOrDescriptor> list = analyse.getVariables();
        if (list != null) {
            for (FactorOrDescriptor factorOrDescriptor : list) {
                if (factorOrDescriptor == null) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(factorOrDescriptor.getName());
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public List<Object> getTableHeader(List list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add("Name");
        arrayList.add("Variable");
        arrayList.add("Method");
        arrayList.add("Rating");
        arrayList.add("Q2Y");
        arrayList.add("R2Y");
        arrayList.add("Other");
        return arrayList;
    }

    public static class ModelCompare
    extends Number {
        public float value;
        public float min;
        public float max;
        public Color color;

        public ModelCompare(float f, float f2, float f3, Color color) {
            this.value = f;
            this.min = f2;
            this.max = f3;
            this.color = color;
        }

        public String toString() {
            return RtDataFormat.toString(this.value);
        }

        public float normalised() {
            float f = this.max - this.min;
            if (f > 0.0f) {
                return (this.value - this.min) / f;
            }
            return 0.0f;
        }

        @Override
        public int intValue() {
            return (int)this.value;
        }

        @Override
        public long longValue() {
            return (long)this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }
    }
}

