/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.model.table;

import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.AbstractRuntimeModel;
import se.prediktera.breeze.entry.analyse.model.ClassificationModel;
import se.prediktera.breeze.evince.data.VisualizationDataHelper;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanelInterface;
import se.prediktera.breeze.frontend.main.model.table.BreezeInnerTable;
import se.prediktera.breeze.frontend.main.model.table.BreezeModelTableModel;
import se.prediktera.map.common.wizard.AbstractInit;
import se.prediktera.map.data.DataInit;
import se.prediktera.map.data.tablegenerator.AbstractTableInfo;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.model.AbstractModel;

public class BreezeModelTable
extends BreezeInnerTable {
    private Analyse analyse;

    public BreezeModelTable(DataInit dataInit) {
        super(dataInit, false, false);
        this.innerTable.getTable().getSelectionModel().setSelectionMode(2);
    }

    @Override
    protected BreezeTablePanelInterface createTableModel() {
        return new BreezeModelTableModel();
    }

    public String getGUI_Name() {
        return "BreezeModelTable";
    }

    protected String getDefaultTitle() {
        return "Breeze Model Table";
    }

    @Override
    public void nodeReplaced(DataTreeEvent dataTreeEvent) {
        ModelMatrix modelMatrix = (ModelMatrix)dataTreeEvent.getReplaceDataTreeInterface();
        AbstractModel abstractModel = modelMatrix.getModel();
        if (this.analyse != null && this.analyse.getModelMethod().isRuntime()) {
            AbstractRuntimeModel.RuntimeResultList runtimeResultList = new AbstractRuntimeModel.RuntimeResultList(this.analyse.getSetupXmlNode());
            if (runtimeResultList != null) {
                this.innerTable.setTableList(runtimeResultList.results, null);
            }
        } else {
            ArrayList<BreezeModelTableModel.ModelComponentRow> arrayList = new ArrayList<BreezeModelTableModel.ModelComponentRow>();
            if (abstractModel.getModelName().equals("SIMCA")) {
                List<AbstractModel> list = ClassificationModel.getModels(abstractModel);
                for (AbstractModel abstractModel2 : list) {
                    BreezeModelTableModel.ModelComponentRow modelComponentRow = new BreezeModelTableModel.ModelComponentRow(abstractModel2, abstractModel2.getComponentsInt() - 1);
                    modelComponentRow.showName = true;
                    arrayList.add(modelComponentRow);
                }
            } else {
                for (int i = 0; i < abstractModel.getComponentsInt(); ++i) {
                    arrayList.add(new BreezeModelTableModel.ModelComponentRow(abstractModel, i));
                }
            }
            this.innerTable.setTableList(arrayList, null);
        }
    }

    public void setAnalyse(Analyse analyse) {
        this.analyse = analyse;
    }

    public static class Info
    extends AbstractTableInfo {
        public AbstractWindow createWindow(AbstractWindow_GUI abstractWindow_GUI, AbstractInit abstractInit) {
            return new BreezeModelTable((DataInit)abstractInit);
        }

        public ImageIcon getWizardImage() {
            return null;
        }

        public String getWizardInfo() {
            return "Creates a table per model";
        }

        public boolean supportData(DataTreeInterface dataTreeInterface) {
            return VisualizationDataHelper.isBreezeModelMatrix(dataTreeInterface);
        }

        public String toString() {
            return "Breeze Model Table";
        }
    }
}

