/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.model.table;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.backend.measure.applychanges.ApplyChanges;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredClassificationDescriptor;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SamplePredictionList;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.evince.data.MeasurementDataHelper;
import se.prediktera.breeze.evince.data.queue.UpdateVisualizationJob;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.pp.DefaultSettingsPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.common.view.visualization.TableViewPanel;
import se.prediktera.breeze.frontend.main.model.table.BreezeClassificationTable;
import se.prediktera.breeze.frontend.main.model.table.BreezeInnerTable;
import se.prediktera.breeze.frontend.wizard.model.panel.EvaluatePanelStep;
import se.prediktera.map.data.AbstractTable;

public class ClassificationSummaryViewContainer
extends ViewContainer {
    private final TableViewPanel viewPanel;
    private Object entrydata = null;
    private BreezeClassificationTable classificationTable;

    public ClassificationSummaryViewContainer(final BreezeMainPanel breezeMainPanel, final Workflow workflow, final FunctionResult functionResult, final Object object) {
        super(breezeMainPanel, false);
        this.viewPanel = new TableViewPanel(this, breezeMainPanel, "Confusion Matrix", "BreezeClassificationTable", "xtraining"){
            final /* synthetic */ ClassificationSummaryViewContainer this$0;
            {
                this.this$0 = classificationSummaryViewContainer;
                super(pPEntryMainInterface, string, string2, string3);
            }

            @Override
            public boolean hasInteraction(boolean bl) {
                return true;
            }

            @Override
            public void tableSetup(AbstractTable abstractTable) {
                this.this$0.classificationTable = (BreezeClassificationTable)abstractTable;
                this.this$0.classificationTable.setCreator(abstractDataSource -> {
                    CategoryFactor categoryFactor = (CategoryFactor)functionResult.getFactor();
                    CategoryFactor categoryFactor2 = this.getWorkflowFactor(workflow, categoryFactor);
                    if (workflow.getSegmentationHashId() != null) {
                        return SamplePredictionList.fromSamples(Sample.getSamples(object, workflow.getSegmentationHashId()), categoryFactor2, categoryFactor, functionResult.getNode());
                    }
                    return SamplePredictionList.fromSamples(Sample.getSamples(object, workflow.getSegmentationLevel()), categoryFactor2, categoryFactor, functionResult.getNode());
                });
                BreezeTablePanel breezeTablePanel = this.this$0.classificationTable.getInnerTable();
                breezeTablePanel.setRowHeight(BreezeProperties.getInstance().getTableCellHeight());
                breezeTablePanel.setColumnWidth(BreezeProperties.getInstance().getTableCellWidth());
            }

            private CategoryFactor getWorkflowFactor(Workflow workflow2, CategoryFactor categoryFactor) {
                CategoryFactor categoryFactor2 = workflow2.getCategoryFactors().getByOrigUid(categoryFactor.getOrigUid());
                if (categoryFactor2 != null) {
                    return categoryFactor2;
                }
                return workflow2.getCategoryFactors().getByName(categoryFactor.getName());
            }

            @Override
            public Object getInData(BreezeProgressManager breezeProgressManager, UpdateVisualizationJob updateVisualizationJob, String string, Analyse analyse, int n) throws Exception {
                return MeasurementDataHelper.getInmatrix(this.getOrCreateEvinceProject(), breezeProgressManager, updateVisualizationJob, (Workflow)this.this$0.entrydata, string);
            }
        };
        this.addViewPanel((Component)((Object)this.viewPanel), 0, 0, 1, 1);
        this.viewPanel.addComponent(EntryMainHelper.createButton("Table height", "material/height", () -> this.getTable().getInnerTable().showCellHeightDialog(breezeMainPanel)));
        this.viewPanel.addComponent(EntryMainHelper.createButton("Table width", "material/width", () -> this.getTable().getInnerTable().showCellWidthDialog(breezeMainPanel)));
        this.viewPanel.addComponent(EntryMainHelper.createButton("Table auto-fit", "material/fit_width", () -> {
            this.getTable().getInnerTable().setColumnWidth(0);
            BreezeProperties.getInstance().setTableCellWidth(0);
        }));
        this.viewPanel.addSeparator();
        this.viewPanel.addComponent(EntryMainHelper.createApplyButton(breezeMainPanel, new ProgressAction(this){
            final /* synthetic */ ClassificationSummaryViewContainer this$0;
            {
                this.this$0 = classificationSummaryViewContainer;
            }

            @Override
            public void runAction() throws Exception {
                DataSetCache.clear((Analyse)this.this$0.entrydata);
                breezeMainPanel.setDirty(true);
            }
        }));
        AbstractBreezeFunction abstractBreezeFunction = functionResult.getFunction();
        final ArrayList<EvaluatePanelStep.ModelCutOff> arrayList = new ArrayList<EvaluatePanelStep.ModelCutOff>();
        DefaultSettingsPanel defaultSettingsPanel = new DefaultSettingsPanel();
        if (abstractBreezeFunction instanceof PlsPredClassificationDescriptor) {
            this.setRightSettingsPanel(defaultSettingsPanel);
            ClassificationSummaryViewContainer.addModels(functionResult.getNode(), defaultSettingsPanel, arrayList);
        }
        DefaultSettingsPanel.SectionCollapsePanel sectionCollapsePanel = defaultSettingsPanel.addCollapseSection("Tools", false, false);
        if (abstractBreezeFunction instanceof PlsPredClassificationDescriptor) {
            sectionCollapsePanel.addPanel(EntryMainHelper.createApplyButton(breezeMainPanel, new ProgressAction(this){
                final /* synthetic */ ClassificationSummaryViewContainer this$0;
                {
                    this.this$0 = classificationSummaryViewContainer;
                }

                @Override
                public void runAction() {
                    boolean bl = false;
                    for (EvaluatePanelStep.ModelCutOff modelCutOff : arrayList) {
                        ModelProperties.CriticalValues criticalValues = modelCutOff.getCriticalValues();
                        Analyse analyse = (Analyse)criticalValues.getAnalyse();
                        analyse.checkFullyParsed();
                        ModelProperties modelProperties = new ModelProperties(analyse);
                        boolean bl2 = this.this$0.setValue(modelProperties, "cutOffLow", criticalValues.getCutOffLow());
                        bl2 = this.this$0.setValue(modelProperties, "cutOffHigh", criticalValues.getCutOffHigh()) || bl2;
                        if (!bl2) continue;
                        DataSetCache.clear(analyse);
                        modelProperties.updateAnalyseProperties(analyse);
                        analyse.updateModel(this.getProgressManager());
                        bl = true;
                    }
                    if (bl) {
                        ApplyChanges.applyChanges((BreezeProgress)this.getProgressManager(), Measurement.getMeasurements(workflow));
                        this.this$0.showEntry(this.this$0.entrydata, this.this$0.entrydata);
                    }
                }
            }));
        }
        sectionCollapsePanel.addPanel(EntryMainHelper.createButton("Save", "file_save", () -> this.classificationTable.save(workflow.getName())));
    }

    private boolean setValue(ModelProperties modelProperties, String string, double d) {
        double d2 = RtDataFormat.toNumber(modelProperties.getProperty((String)string).value);
        if (d2 != d) {
            modelProperties.getProperty((String)string).value = RtDataFormat.toString(d);
            return true;
        }
        return false;
    }

    private static void addModels(DescriptorTreeNode descriptorTreeNode, DefaultSettingsPanel defaultSettingsPanel, List<EvaluatePanelStep.ModelCutOff> list) {
        Object object = descriptorTreeNode.getAnalyse();
        if (object instanceof Analyse) {
            Analyse analyse = (Analyse)object;
            object = defaultSettingsPanel.addSection(analyse.getName());
            EvaluatePanelStep.ModelCutOff modelCutOff = new EvaluatePanelStep.ModelCutOff();
            modelCutOff.update(new ModelProperties.CriticalValues(analyse));
            modelCutOff.addModelSettings((DefaultSettingsPanel.SectionPanel)object, criticalValues -> {}, false);
            list.add(modelCutOff);
            for (FunctionTreeNode functionTreeNode : descriptorTreeNode.getChildList()) {
                if (!(functionTreeNode.getFunction() instanceof PlsPredClassificationDescriptor)) continue;
                ClassificationSummaryViewContainer.addModels((DescriptorTreeNode)functionTreeNode, defaultSettingsPanel, list);
            }
        }
    }

    @Override
    public boolean showLeftSettingsPanel() {
        return false;
    }

    @Override
    public boolean showRightSettingsPanel() {
        return false;
    }

    @Override
    public void setData(boolean bl) {
        super.showEntry(this.entrydata, null);
    }

    @Override
    public void showEntry(Object object, Object object2) {
        super.showEntry(object, object2);
        this.entrydata = object;
    }

    private BreezeInnerTable getTable() {
        return (BreezeInnerTable)this.viewPanel.getVisualization();
    }
}

