/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.model.table;

import java.awt.Component;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.common.view.visualization.TableViewPanel;
import se.prediktera.breeze.frontend.main.model.table.BreezeModelCompareTable;
import se.prediktera.map.data.AbstractTable;

public class ModelCompareViewContainer
extends ViewContainer {
    private TableViewPanel viewPanel;
    private Object entrydata = null;
    private BreezeModelCompareTable measurementTable;

    public ModelCompareViewContainer(EntryMainPanel entryMainPanel) {
        super(entryMainPanel, false);
        this.viewPanel = new TableViewPanel(entryMainPanel, "Compare models", "BreezeModelCompareTable", "model"){

            @Override
            public boolean hasInteraction(boolean bl) {
                return true;
            }

            @Override
            public void tableSetup(AbstractTable abstractTable) throws Exception {
                ModelCompareViewContainer.this.measurementTable = (BreezeModelCompareTable)abstractTable;
                BreezeTablePanel breezeTablePanel = ModelCompareViewContainer.this.measurementTable.getInnerTable();
                breezeTablePanel.setRowHeight(BreezeProperties.getInstance().getTableCellHeight());
                breezeTablePanel.setColumnWidth(BreezeProperties.getInstance().getTableCellWidth());
                breezeTablePanel.setSortable(true);
            }
        };
        this.addViewPanel((Component)((Object)this.viewPanel), 0, 0, 1, 1);
        this.viewPanel.addComponent(EntryMainHelper.createButton("Table height", "material/height", () -> this.getTable().getInnerTable().showCellHeightDialog(entryMainPanel)));
        this.viewPanel.addComponent(EntryMainHelper.createButton("Table width", "material/width", () -> this.getTable().getInnerTable().showCellWidthDialog(entryMainPanel)));
        this.viewPanel.addComponent(EntryMainHelper.createButton("Table auto-fit", "material/fit_width", () -> {
            this.getTable().getInnerTable().setColumnWidth(0);
            BreezeProperties.getInstance().setTableCellWidth(0);
        }));
        this.viewPanel.addSeparator();
        this.viewPanel.addComponent(EntryMainHelper.createButton("Save", "file_save", () -> this.measurementTable.save(((Analyse)this.entrydata).getWorkflow().getName() + " - Compare models")));
    }

    @Override
    public boolean showLeftSettingsPanel() {
        return false;
    }

    @Override
    public void setData(boolean bl) {
        super.showEntry(this.entrydata, null);
    }

    @Override
    public void showEntry(Object object, Object object2) {
        Analyse analyse = (Analyse)object;
        super.showEntry(object, object2);
        this.entrydata = object;
        ThreadUtil.awaitOrThrow(() -> this.measurementTable != null, new Time.Seconds(10.0), "Timeout waiting for table");
        if (this.measurementTable != null) {
            this.measurementTable.setAnalyse(analyse);
        }
    }

    private BreezeModelCompareTable getTable() {
        return (BreezeModelCompareTable)this.viewPanel.getVisualization();
    }
}

