/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.model.table;

import java.awt.Component;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.common.view.visualization.TableViewPanel;
import se.prediktera.breeze.frontend.main.model.table.BreezeModelTable;
import se.prediktera.map.data.AbstractTable;

public class ModelTableViewContainer
extends ViewContainer {
    private TableViewPanel viewPanel;
    private Object entrydata = null;
    private BreezeModelTable measurementTable;

    public ModelTableViewContainer(EntryMainPanel entryMainPanel) {
        super(entryMainPanel, false);
        this.viewPanel = new TableViewPanel(entryMainPanel, "Model statistics", "BreezeModelTable", "model"){

            @Override
            public boolean hasInteraction(boolean bl) {
                return true;
            }

            @Override
            public void tableSetup(AbstractTable abstractTable) {
                ModelTableViewContainer.this.measurementTable = (BreezeModelTable)abstractTable;
                BreezeTablePanel breezeTablePanel = ModelTableViewContainer.this.measurementTable.getInnerTable();
                breezeTablePanel.setRowHeight(BreezeProperties.getInstance().getTableCellHeight());
                breezeTablePanel.setColumnWidth(BreezeProperties.getInstance().getTableCellWidth());
            }
        };
        this.addViewPanel((Component)((Object)this.viewPanel), 0, 0, 1, 1);
        this.viewPanel.addComponent(EntryMainHelper.createButton("Table height", "material/height", () -> this.getTable().getInnerTable().showCellHeightDialog(entryMainPanel)));
        this.viewPanel.addComponent(EntryMainHelper.createButton("Table width", "material/width", () -> this.getTable().getInnerTable().showCellWidthDialog(entryMainPanel)));
        this.viewPanel.addComponent(EntryMainHelper.createButton("Table auto-fit", "material/fit_width", () -> {
            this.getTable().getInnerTable().setColumnWidth(0);
            BreezeProperties.getInstance().setTableCellWidth(0);
        }));
        this.viewPanel.addSeparator();
        this.viewPanel.addComponent(EntryMainHelper.createButton("Save", "file_save", () -> this.measurementTable.save(((BasicAnalyse)this.entrydata).getName())));
    }

    @Override
    public boolean showLeftSettingsPanel() {
        return false;
    }

    @Override
    public void setData(boolean bl) {
        super.showEntry(this.entrydata, null);
    }

    @Override
    public void showEntry(Object object, Object object2) {
        Analyse analyse = (Analyse)object;
        super.showEntry(object, object2);
        this.entrydata = object;
        if (analyse.getModelMethod().isRuntime()) {
            ThreadUtil.awaitOrThrow(() -> this.measurementTable != null, new Time.Seconds(10.0), "Timeout waiting for table");
        }
        if (this.measurementTable != null) {
            this.measurementTable.setAnalyse(analyse);
        }
    }

    private BreezeModelTable getTable() {
        return (BreezeModelTable)this.viewPanel.getVisualization();
    }
}

