/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.model.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.BreezeProgressImpl;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.evince.data.VisualizationDataHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanelInterface;
import se.prediktera.breeze.frontend.common.swing.table.DefaultBreezeTableImpl;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.common.view.visualization.TableViewPanel;
import se.prediktera.breeze.frontend.main.model.ModelVersionsComparePanel;
import se.prediktera.breeze.frontend.main.model.table.BreezeInnerTable;
import se.prediktera.breeze.util.ModelLogHelper;
import se.prediktera.breeze.util.ModelVersionHelper;
import se.prediktera.map.common.wizard.AbstractInit;
import se.prediktera.map.data.AbstractTable;
import se.prediktera.map.data.DataInit;
import se.prediktera.map.data.tablegenerator.AbstractTableInfo;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.main.window.AbstractWindow_GUI;

public class ModelVersionsViewContainer
extends ViewContainer {
    private Object entryData = null;
    private BreezeModelVersionsTable versionsTable;

    public ModelVersionsViewContainer(final EntryMainPanel entryMainPanel) {
        super(entryMainPanel, false);
        this.addViewPanel((Component)((Object)new TableViewPanel(this, entryMainPanel, "Version history", "BreezeModelVersionsTable", "analyse"){
            final /* synthetic */ ModelVersionsViewContainer this$0;
            {
                this.this$0 = modelVersionsViewContainer;
                super(pPEntryMainInterface, string, string2, string3);
            }

            @Override
            public boolean hasInteraction(boolean bl) {
                return true;
            }

            @Override
            public void tableSetup(final AbstractTable abstractTable) {
                this.this$0.versionsTable = (BreezeModelVersionsTable)abstractTable;
                BreezeTablePanel breezeTablePanel = this.this$0.versionsTable.getInnerTable();
                breezeTablePanel.setRowHeight(BreezeProperties.getInstance().getTableCellHeight());
                breezeTablePanel.setColumnWidth(BreezeProperties.getInstance().getTableCellWidth());
                breezeTablePanel.getTable().addMouseListener(new MouseAdapter(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                            ModelVersionHelper.VersionFile versionFile2 = ((BreezeModelVersionsTable)abstractTable).getSelectedVersion();
                            List list = abstractTable.getSelectedValues();
                            if (versionFile2 == null || versionFile2.getVersion() == -1 && list.size() == 1) {
                                return;
                            }
                            BreezeContextMenu breezeContextMenu = new BreezeContextMenu(this.this$1.getFrame(), Color.red);
                            boolean bl = true;
                            if (list.size() == 1 && versionFile2.getVersion() != -1) {
                                breezeContextMenu.addButtonCloseClick("Revert", () -> this.this$1.this$0.versionsTable.revert(entryMainPanel));
                            } else if (list.size() == 2) {
                                breezeContextMenu.addButtonCloseClick("Compare versions", () -> this.this$1.this$0.versionsTable.compare(entryMainPanel));
                            } else {
                                bl = false;
                            }
                            if (list.stream().noneMatch(versionFile -> versionFile.getVersion() == -1)) {
                                if (bl) {
                                    breezeContextMenu.addSeparator();
                                }
                                breezeContextMenu.addButtonCloseClick("Delete", () -> this.this$1.this$0.versionsTable.delete(entryMainPanel));
                            }
                            this.this$1.getFrame().addPage((JPanel)((Object)breezeContextMenu));
                            breezeContextMenu.setPositionLater(mouseEvent);
                        }
                    }
                });
            }
        }), 0, 0, 1, 1);
        TableViewPanel tableViewPanel = new TableViewPanel(entryMainPanel, "Log", "BreezeModelLogTable", "analyse"){

            @Override
            public boolean hasInteraction(boolean bl) {
                return true;
            }

            @Override
            public void tableSetup(AbstractTable abstractTable) {
                BreezeModelLogTable breezeModelLogTable = (BreezeModelLogTable)abstractTable;
                BreezeTablePanel breezeTablePanel = breezeModelLogTable.getInnerTable();
                breezeTablePanel.setRowHeight(BreezeProperties.getInstance().getTableCellHeight());
                breezeTablePanel.setColumnWidth(BreezeProperties.getInstance().getTableCellWidth());
            }
        };
        this.addViewPanel((Component)((Object)tableViewPanel), 0, 1, 1, 1);
        tableViewPanel.addComponent(EntryMainHelper.createButton("Revert", "material/settings_backup_restore", () -> this.versionsTable.revert(entryMainPanel)));
        tableViewPanel.addComponent(EntryMainHelper.createButton("Compare", "material/difference", () -> this.versionsTable.compare(entryMainPanel)));
        tableViewPanel.addSeparator();
        tableViewPanel.addComponent(EntryMainHelper.createButton("Delete", "material/delete", () -> this.versionsTable.delete(entryMainPanel)));
    }

    @Override
    public boolean showLeftSettingsPanel() {
        return false;
    }

    @Override
    public void setData(boolean bl) {
        super.showEntry(this.entryData, null);
    }

    @Override
    public void showEntry(Object object, Object object2) {
        Analyse analyse = (Analyse)object;
        super.showEntry(object, object2);
        this.entryData = object;
        if (analyse.getModelMethod().isRuntime()) {
            ThreadUtil.awaitOrThrow(() -> this.versionsTable != null, new Time.Seconds(10.0), "Timeout waiting for table");
        }
    }

    public static class BreezeModelVersionsTable
    extends BreezeInnerTable {
        private Analyse analyse;

        public BreezeModelVersionsTable(DataInit dataInit) {
            super(dataInit, false, false);
            this.innerTable.getTable().getSelectionModel().setSelectionMode(2);
        }

        public void revert(EntryMainPanel entryMainPanel) {
            ModelVersionHelper.VersionFile versionFile = this.getSelectedVersion();
            if (versionFile != null && versionFile.getVersion() != -1) {
                BreezeOptionDialog.showDialog(entryMainPanel, AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Revert", "Are you sure that you want to revert to selected version (" + versionFile.getVersion() + ")? Current model will be discarded", breezeActionEvent -> {
                    ModelVersionHelper.unpackModelFiles(this.analyse.getFolder(), BreezeProgressImpl.createEmpty(), versionFile.getVersion());
                    this.analyse.reload();
                    entryMainPanel.setDirty(true);
                });
            }
        }

        public void compare(EntryMainPanel entryMainPanel) {
            List list = this.getSelectedValues();
            if (list.size() == 2) {
                File file = this.analyse.getFolder();
                BreezeOptionDialog.showDialog(entryMainPanel.getFrame(), BreezeType.Analyse.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Compare versions", "", (AbstractBreezeCustomPanel)new ModelVersionsComparePanel(entryMainPanel, ModelVersionHelper.getAnalysisFromVersion(file, ((ModelVersionHelper.VersionFile)list.get(0)).getVersion()), ModelVersionHelper.getAnalysisFromVersion(file, ((ModelVersionHelper.VersionFile)list.get(1)).getVersion())), null, null);
            }
        }

        public void delete(EntryMainPanel entryMainPanel) {
            List list = this.getSelectedValues();
            if (list != null) {
                String string = this.listOfIntsToStringRange(list.stream().map(ModelVersionHelper.VersionFile::getVersion).collect(Collectors.toList()));
                BreezeOptionDialog.showDialog(entryMainPanel, AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Delete", "Are you sure that you want to delete selected version(s): " + string + "?", breezeActionEvent -> {
                    File file = ((ModelVersionHelper.VersionFile)list.get(0)).getModelZipFile();
                    if (list.size() == 1) {
                        ModelVersionHelper.deleteModelArchive(file, true);
                    } else {
                        list.stream().map(ModelVersionHelper.VersionFile::getModelZipFile).forEach(ModelVersionHelper::deleteModelArchive);
                        String string = this.listOfIntsToStringRange(list.stream().map(ModelVersionHelper.VersionFile::getVersion).collect(Collectors.toList()));
                        ModelLogHelper.Log(file.getParentFile().getParentFile(), "Deleting multiple archive files: " + string, ModelLogHelper.Action.REMOVE);
                    }
                    entryMainPanel.setDirty(true);
                });
            }
        }

        private String listOfIntsToStringRange(List<Integer> list) {
            if (list.size() == 1) {
                return list.get(0).toString();
            }
            Collections.sort(list);
            Integer n = list.get(0);
            StringBuilder stringBuilder = new StringBuilder(n.toString());
            boolean bl = false;
            for (Integer n2 : list.subList(1, list.size())) {
                if (n == n2 - 1) {
                    n = n2;
                    if (bl) continue;
                    stringBuilder.append('-');
                    bl = true;
                    continue;
                }
                stringBuilder.append(n).append(",").append(n2);
                n = n2;
                bl = false;
            }
            if (bl) {
                stringBuilder.append(n);
            }
            return stringBuilder.toString();
        }

        private ModelVersionHelper.VersionFile getSelectedVersion() {
            List list = this.getSelectedValues();
            if (list.isEmpty()) {
                return null;
            }
            return (ModelVersionHelper.VersionFile)list.get(0);
        }

        @Override
        protected BreezeTablePanelInterface createTableModel() {
            return new BreezeModelVersionsTableModel();
        }

        @Override
        public void setData(Object object) {
            List<ModelVersionHelper.VersionFile> list;
            this.analyse = (Analyse)object;
            this.innerTable.setTableList(list, (list = ModelVersionHelper.getAvailableVersions(this.analyse.getFolder(), true)).isEmpty() ? null : list.get(0), true);
        }

        public String getGUI_Name() {
            return "BreezeModelVersionsTable";
        }

        protected String getDefaultTitle() {
            return "Breeze Model Versions Table";
        }

        public static class Info
        extends AbstractTableInfo {
            public AbstractWindow createWindow(AbstractWindow_GUI abstractWindow_GUI, AbstractInit abstractInit) {
                return new BreezeModelVersionsTable((DataInit)abstractInit);
            }

            public ImageIcon getWizardImage() {
                return null;
            }

            public String getWizardInfo() {
                return "Creates a table per model";
            }

            public boolean supportData(DataTreeInterface dataTreeInterface) {
                return VisualizationDataHelper.isBreezeModelMatrix(dataTreeInterface);
            }

            public String toString() {
                return "Breeze Model Versions Table";
            }
        }
    }

    public static class BreezeModelLogTableModel
    extends DefaultBreezeTableImpl {
        @Override
        public Vector createVOVector(Object object) {
            Vector<String> vector = new Vector<String>();
            ModelLogHelper.LogEntry logEntry = (ModelLogHelper.LogEntry)object;
            vector.add(DateTimeFormatter.ofPattern("yyyy-MM-dd - HH:mm:ss").withZone(ZoneId.from(ZoneOffset.UTC)).format(Instant.ofEpochSecond(logEntry.timeStamp)));
            vector.add(logEntry.username);
            vector.add(logEntry.message);
            return vector;
        }

        @Override
        public List<Object> getTableHeader(List list) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add("Date");
            arrayList.add("UserName");
            arrayList.add("Message");
            return arrayList;
        }
    }

    public static class BreezeModelLogTable
    extends BreezeInnerTable {
        public BreezeModelLogTable(DataInit dataInit) {
            super(dataInit, false, false);
            this.innerTable.getTable().getSelectionModel().setSelectionMode(2);
        }

        @Override
        protected BreezeTablePanelInterface createTableModel() {
            return new BreezeModelLogTableModel();
        }

        @Override
        public void setData(Object object) {
            List<ModelLogHelper.LogEntry> list;
            Analyse analyse = (Analyse)object;
            ModelLogHelper.LogFileData logFileData = ModelLogHelper.getLogFileData(analyse.getFolder());
            this.innerTable.setTableList(list, (list = logFileData.entries).isEmpty() ? null : list.get(0), true);
        }

        public String getGUI_Name() {
            return "BreezeModelLogTable";
        }

        protected String getDefaultTitle() {
            return "Breeze Model Log Table";
        }

        public static class Info
        extends AbstractTableInfo {
            public AbstractWindow createWindow(AbstractWindow_GUI abstractWindow_GUI, AbstractInit abstractInit) {
                return new BreezeModelLogTable((DataInit)abstractInit);
            }

            public ImageIcon getWizardImage() {
                return null;
            }

            public String getWizardInfo() {
                return "Creates a table per model";
            }

            public boolean supportData(DataTreeInterface dataTreeInterface) {
                return VisualizationDataHelper.isBreezeModelMatrix(dataTreeInterface);
            }

            public String toString() {
                return "Breeze Model Log Table";
            }
        }
    }

    public static class BreezeModelVersionsTableModel
    extends DefaultBreezeTableImpl {
        @Override
        public Vector createVOVector(Object object) {
            Vector<Object> vector = new Vector<Object>();
            ModelVersionHelper.VersionFile versionFile = (ModelVersionHelper.VersionFile)object;
            vector.add(versionFile.getVersion() == -1 ? "Current" : Integer.valueOf(versionFile.getVersion()));
            vector.add(versionFile.getChanges());
            vector.add(new Timestamp(versionFile.getModelZipFile().lastModified()));
            vector.add(versionFile.getFileSizeString());
            return vector;
        }

        @Override
        public List<Object> getTableHeader(List list) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add("Version");
            arrayList.add("Changes from previous version");
            arrayList.add("Date");
            arrayList.add("Size");
            return arrayList;
        }

        @Override
        public int[] getColumnWidth() {
            return new int[]{10, 60, 20, 10};
        }
    }
}

