/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.model.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.identifier.Identifier;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.data.AnalyseDataHelper;
import se.prediktera.breeze.frontend.common.swing.table.DefaultBreezeTableImpl;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailSample;
import se.prediktera.breeze.frontend.main.model.table.PredictionTable;

public class PredictionTableModel
extends DefaultBreezeTableImpl {
    private PredictionTable predictionTable;
    private Workflow root;

    public PredictionTableModel(PredictionTable predictionTable) {
        this.predictionTable = predictionTable;
    }

    public PredictionTableModel(Workflow workflow) {
        this.root = workflow;
    }

    public PredictionTableModel() {
    }

    public void setRoot(Workflow workflow) {
        this.root = workflow;
    }

    @Override
    public Vector createVOVector(Object object) {
        return PredictionTableModel.createTableRowVector(this.getDataSource(), (Sample)object, true);
    }

    public AnalyseDataHelper.PredictionDataSource getDataSource() {
        return (AnalyseDataHelper.PredictionDataSource)this.predictionTable.getDataSource();
    }

    public static Vector createTableRowVector(AnalyseDataHelper.PredictionDataSource predictionDataSource, Sample sample, boolean bl) {
        Vector<Object> vector = new Vector<Object>();
        Measurement measurement = sample.measurement();
        Group group = measurement.getParent();
        vector.add(sample);
        vector.add(group);
        if (bl) {
            vector.add((Object)new ThumbnailSample(measurement.getCustomImageFile(), measurement, sample));
        } else {
            vector.add(measurement);
        }
        for (Identifier identifier : group.getIdentifiers()) {
            vector.add(identifier);
        }
        vector.addElement(predictionDataSource.getSamplePredictionList());
        for (Identifier identifier : predictionDataSource.getFactorList()) {
            vector.add(identifier);
        }
        return vector;
    }

    @Override
    public List<Object> getTableHeader(List list) {
        if (this.predictionTable != null) {
            this.root = this.predictionTable.getRoot();
        }
        if (this.root instanceof Workflow) {
            return PredictionTableModel.createTableHeader(this.getDataSource(), list, this.root, true);
        }
        return new ArrayList<Object>();
    }

    public static List<Object> createTableHeader(AnalyseDataHelper.PredictionDataSource predictionDataSource, List list, Workflow workflow, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : PredictionTableModel.collectTableHeader(predictionDataSource, list, workflow, bl)) {
            if (object instanceof DescriptorTreeNode) {
                arrayList.add(((DescriptorTreeNode)object).getAliasOrNodeString());
                continue;
            }
            arrayList.add(object.toString());
        }
        return arrayList;
    }

    public static List<Object> collectTableHeader(AnalyseDataHelper.PredictionDataSource predictionDataSource, List list, Workflow workflow, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add("Sample");
        arrayList.add("Group");
        if (bl) {
            arrayList.add("Image");
        } else {
            arrayList.add("Measurement");
        }
        for (Identifier identifier : workflow.getIdentifiers()) {
            arrayList.add(identifier);
        }
        arrayList.add("Predicted_" + predictionDataSource.getSamplePredictionList().getActualFactor().getName());
        for (Identifier identifier : predictionDataSource.getFactorList()) {
            arrayList.add(identifier);
        }
        return arrayList;
    }
}

