/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.model.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import lombok.Generated;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.evince.data.AnalyseDataHelper;
import se.prediktera.breeze.evince.data.queue.UpdateVisualizationJob;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.DefaultSettingsPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.common.swing.table.SortedTableModel;
import se.prediktera.breeze.frontend.common.swing.validator.NumericMinMaxValidator;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.common.view.preview.InteractionPreviewPanel;
import se.prediktera.breeze.frontend.common.view.visualization.TableViewPanel;
import se.prediktera.breeze.frontend.main.model.table.BreezeClassificationTable;
import se.prediktera.breeze.frontend.main.model.table.BreezeInnerTable;
import se.prediktera.breeze.frontend.main.model.table.PredictionTable;
import se.prediktera.breeze.frontend.wizard.model.panel.EvaluatePanelStep;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.data.AbstractTable;

public class PredictionTableViewContainer
extends ViewContainer {
    private final InteractionPreviewPanel previewPanel;
    private final TableViewPanel viewPanel;
    private Object entrydata = null;
    private BreezeClassificationTable classificationTable;
    private final TrainTestInputField trainTestInputField = new TrainTestInputField();
    private final DefaultSettingsPanel settingsPanel = new DefaultSettingsPanel();
    private final EvaluatePanelStep.ModelCutOff modelCutOff = new EvaluatePanelStep.ModelCutOff();
    private ModelProperties.CriticalValues criticalValues;
    private final DcritSection dcritSection;

    public PredictionTableViewContainer(final EntryMainPanel entryMainPanel) {
        super(entryMainPanel, false);
        this.viewPanel = new TableViewPanel(entryMainPanel, "Confusion Matrix (For classification models only)", "BreezeClassificationTable", "xtraining"){

            @Override
            public boolean hasInteraction(boolean bl) {
                return true;
            }

            @Override
            public void tableSetup(AbstractTable abstractTable) {
                PredictionTableViewContainer.this.classificationTable = (BreezeClassificationTable)abstractTable;
                BreezeTablePanel breezeTablePanel = PredictionTableViewContainer.this.classificationTable.getInnerTable();
                breezeTablePanel.setRowHeight(BreezeProperties.getInstance().getTableCellHeight());
                breezeTablePanel.setColumnWidth(BreezeProperties.getInstance().getTableCellWidth());
            }

            @Override
            public void postSetup(AbstractTable abstractTable) {
                PredictionTableViewContainer.this.classificationTable = (BreezeClassificationTable)abstractTable;
                BreezeTablePanel breezeTablePanel = PredictionTableViewContainer.this.classificationTable.getInnerTable();
                PredictionTableViewContainer.this.viewPanel.setVisible(breezeTablePanel.getTable().getRowCount() > 0);
            }

            @Override
            public Object getInData(BreezeProgressManager breezeProgressManager, UpdateVisualizationJob updateVisualizationJob, String string, Analyse analyse, int n) {
                return AnalyseDataHelper.getInmatrix(this.getOrCreateEvinceProject(), breezeProgressManager, (Analyse)PredictionTableViewContainer.this.entrydata, string, PredictionTableViewContainer.this.trainTestInputField.getType());
            }
        };
        this.addViewPanel((Component)((Object)this.viewPanel), 0, 0, 1, 1);
        if (BreezeFrame.isPredictionTableFeature()) {
            this.addViewPanel((Component)((Object)new TableViewPanel(entryMainPanel, "", "PredictionTable", "xtraining"){

                @Override
                public boolean hasInteraction(boolean bl) {
                    return true;
                }

                @Override
                public void tableSetup(AbstractTable abstractTable) {
                    PredictionTable predictionTable = (PredictionTable)abstractTable;
                    predictionTable.setScrollToVisible(true);
                    BreezeTablePanel breezeTablePanel = predictionTable.getInnerTable();
                    TableModel tableModel = breezeTablePanel.getTable().getModel();
                    if (tableModel instanceof SortedTableModel) {
                        SortedTableModel sortedTableModel = (SortedTableModel)tableModel;
                        sortedTableModel.sortByColumn(0, true);
                    }
                    breezeTablePanel.setRowHeight(BreezeProperties.getInstance().getTableCellHeight());
                    breezeTablePanel.setColumnWidth(BreezeProperties.getInstance().getTableCellWidth());
                }
            }), 0, 1, 1, 1);
        }
        this.add(this.trainTestInputField, "South");
        this.viewPanel.addComponent(EntryMainHelper.createButton("Table height", "material/height", () -> this.getTable().getInnerTable().showCellHeightDialog(entryMainPanel)));
        this.viewPanel.addComponent(EntryMainHelper.createButton("Table width", "material/width", () -> this.getTable().getInnerTable().showCellWidthDialog(entryMainPanel)));
        this.viewPanel.addComponent(EntryMainHelper.createButton("Table auto-fit", "material/fit_width", () -> {
            this.getTable().getInnerTable().setColumnWidth(0);
            BreezeProperties.getInstance().setTableCellWidth(0);
        }));
        this.previewPanel = new InteractionPreviewPanel(null);
        this.setLeftSettingsPanel(this.previewPanel);
        this.setRightSettingsPanel(this.settingsPanel);
        this.viewPanel.addSeparator();
        this.viewPanel.addComponent(EntryMainHelper.createApplyButton(entryMainPanel, new ProgressAction(this){
            final /* synthetic */ PredictionTableViewContainer this$0;
            {
                this.this$0 = predictionTableViewContainer;
            }

            @Override
            public void runAction() {
                DataSetCache.clear((Analyse)this.this$0.entrydata);
                entryMainPanel.setDirty(true);
            }
        }));
        this.viewPanel.addSeparator();
        this.viewPanel.addComponent(EntryMainHelper.createButton("Save", "file_save", () -> this.classificationTable.save(((BasicAnalyse)this.entrydata).getName())));
        this.modelCutOff.addModelSettings(this.settingsPanel, criticalValues -> BreezeProgressDialog.startProgress(this.getFrame(), new ProgressAction(this){
            final /* synthetic */ PredictionTableViewContainer this$0;
            {
                this.this$0 = predictionTableViewContainer;
            }

            @Override
            public void runAction() {
                Analyse analyse = (Analyse)this.this$0.entrydata;
                ModelProperties modelProperties = new ModelProperties(analyse);
                modelProperties.getProperty((String)"cutOffLow").value = RtDataFormat.toString(criticalValues.getCutOffLow());
                modelProperties.getProperty((String)"cutOffHigh").value = RtDataFormat.toString(criticalValues.getCutOffHigh());
                modelProperties.updateAnalyseProperties(analyse);
                analyse.updateModel(this.getProgressManager());
                DataSetCache.clear(analyse);
                this.this$0.getMainPanel().setDirty(true);
            }
        }, "Retraining"), false, false, "Confidence Level");
        this.dcritSection = new DcritSection(entryMainPanel, this.settingsPanel);
    }

    @Override
    public boolean showLeftSettingsPanel() {
        return false;
    }

    @Override
    public void setData(boolean bl) {
        super.showEntry(this.entrydata, null);
    }

    @Override
    public void showEntry(Object object, Object object2) {
        super.showEntry(object, object2);
        this.entrydata = object;
        if (this.previewPanel != null) {
            this.previewPanel.enableInteraction(this.mainpanel);
            if (object instanceof Analyse) {
                Analyse analyse = (Analyse)object;
                this.previewPanel.setSegmentationLevel(analyse.getSegmentationIdentifier().Level, analyse.getSegmentationIdentifier().HashId);
                BasicAnalyse.ModelMethod modelMethod = analyse.getModelMethod();
                if (modelMethod.supportCutOff()) {
                    this.settingsPanel.setVisible(true);
                    try {
                        this.criticalValues = new ModelProperties.CriticalValues(analyse);
                        this.modelCutOff.update(this.criticalValues);
                        this.dcritSection.update(analyse, this.criticalValues);
                    }
                    catch (Exception exception) {
                        Logg.warn((String)"Classification table error", (Object[])new Object[]{exception});
                    }
                } else {
                    this.settingsPanel.setVisible(false);
                }
                if (this.trainTestInputField.getType().equals((Object)ClassificationViewType.TestExternal) && analyse.getExternalGroups().isEmpty()) {
                    this.trainTestInputField.setType(ClassificationViewType.Train);
                }
            }
        }
    }

    private BreezeInnerTable getTable() {
        return (BreezeInnerTable)this.viewPanel.getVisualization();
    }

    private class TrainTestInputField
    extends JPanel {
        private final BreezeComboBoxInputField<ClassificationViewType> comboBox;

        public TrainTestInputField() {
            super(new GridBagLayout());
            this.comboBox = new BreezeComboBoxInputField("Type", "", BreezeInputFieldHelper.Format.OneRow);
            this.setOpaque(false);
            for (ClassificationViewType classificationViewType2 : ClassificationViewType.values()) {
                this.comboBox.addItem(classificationViewType2);
            }
            this.comboBox.setChangedListener(classificationViewType -> {
                Object object = PredictionTableViewContainer.this.entrydata;
                if (object instanceof Analyse) {
                    Analyse analyse = (Analyse)object;
                    if (this.getType().external && analyse.getExternalGroups().isEmpty()) {
                        BreezeOptionDialog.showDialog(PredictionTableViewContainer.this.getMainPanel(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "No external test group available", "Please add at least one external record test group under Edit and try again");
                        this.comboBox.setSelectedIndex(0);
                    } else {
                        DataSetCache.clear(analyse);
                        PredictionTableViewContainer.this.getMainPanel().setDirty(true);
                    }
                }
            });
            this.comboBox.setPreferredSize(new Dimension(250, 26));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 0, 2, 2);
            this.add(this.comboBox, gridBagConstraints);
        }

        public ClassificationViewType getType() {
            return this.comboBox.getSelectedItem();
        }

        public void setType(ClassificationViewType classificationViewType) {
            this.comboBox.setSelectedItem(classificationViewType);
        }
    }

    private static class DcritSection {
        private final EntryMainPanel mainPanel;
        private boolean updateingEntry = false;
        private final DefaultSettingsPanel.SectionPanel section;
        private final BreezeCheckBox enableDcritButton;
        private BreezeInputField.Number dcritInputField;
        private Analyse analyse;
        private ModelProperties.CriticalValues criticalValues;

        public DcritSection(EntryMainPanel entryMainPanel, DefaultSettingsPanel defaultSettingsPanel) {
            this.mainPanel = entryMainPanel;
            this.section = defaultSettingsPanel.addSection("Critical distance");
            this.enableDcritButton = new BreezeCheckBox("Enable", false);
            this.enableDcritButton.addItemListener(itemEvent -> {
                if (this.updateingEntry) {
                    return;
                }
                this.dcritInputField.setEnabled(this.enableDcritButton.isSelected());
                this.setDcritAndUpdateModel(this.criticalValues.getDcrit());
            });
            this.section.addComponentVertical(this.enableDcritButton);
            this.dcritInputField = new BreezeInputField.Number("Dcrit", 0.5, "");
            this.dcritInputField.addValidator(new NumericMinMaxValidator(0.0, Double.MAX_VALUE));
            this.dcritInputField.addChangeListener(textActionEvent -> {
                if (this.updateingEntry) {
                    return;
                }
                this.setDcritAndUpdateModel(textActionEvent.getValue());
            });
            this.section.addComponentVertical(this.dcritInputField);
        }

        public void update(Analyse analyse, ModelProperties.CriticalValues criticalValues) {
            this.analyse = analyse;
            this.criticalValues = criticalValues;
            this.section.setVisible(analyse.getModelMethod().equals((Object)BasicAnalyse.ModelMethod.ClassificationPlsDa));
            this.updateingEntry = true;
            this.enableDcritButton.setSelected(criticalValues.isDcrit());
            this.dcritInputField.setEnabled(criticalValues.isDcrit());
            this.dcritInputField.setValue(criticalValues.getDcrit());
            this.updateingEntry = false;
        }

        private void setDcritAndUpdateModel(final double d) {
            BreezeProgressDialog.startProgress(this.mainPanel.getFrame(), new ProgressAction(this){
                final /* synthetic */ DcritSection this$0;
                {
                    this.this$0 = dcritSection;
                }

                @Override
                public void runAction() {
                    ModelProperties modelProperties = new ModelProperties(this.this$0.analyse);
                    ModelProperties.Property property = modelProperties.getProperty("dcrit");
                    if (this.this$0.enableDcritButton.isSelected()) {
                        if (property == null) {
                            property = new ModelProperties.Property("dcrit", "", "");
                            modelProperties.addProperty(property);
                        }
                        property.value = RtDataFormat.toString(d);
                    } else {
                        modelProperties.removeProperty(property);
                    }
                    modelProperties.updateAnalyseProperties(this.this$0.analyse);
                    this.this$0.analyse.updateModel(this.getProgressManager());
                    DataSetCache.clear(this.this$0.analyse);
                    this.this$0.mainPanel.setDirty(true);
                }
            }, "Retaining");
        }
    }

    public static enum ClassificationViewType {
        Train("Train", true, false),
        Test("Test", false, false),
        TestExternal("Test (External)", true, true);

        private final String name;
        private final boolean train;
        private final boolean external;

        private ClassificationViewType(String string2, boolean bl, boolean bl2) {
            this.name = string2;
            this.train = bl;
            this.external = bl2;
        }

        public String toString() {
            return this.name;
        }

        @Generated
        public boolean isTrain() {
            return this.train;
        }

        @Generated
        public boolean isExternal() {
            return this.external;
        }
    }
}

