/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.play;

import java.io.File;
import java.util.List;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.parameter.AnalyseParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FunctionParameter;
import se.prediktera.breeze.common.realtime.unmixing.MembersSetting;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.AnalyseList;
import se.prediktera.breeze.entry.analyse.AnalyseSpectralGroup;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;

public class DuplicateWorkflowHelper {
    public static Entry duplicateWorkflow(BreezeProgressManager breezeProgressManager, Object object, String string, boolean bl, boolean bl2) {
        Workflow workflow = (Workflow)object;
        Workflow workflow2 = new Workflow(workflow.getFolder(), string, true);
        if (bl) {
            DuplicateWorkflowHelper.copyWorkflowMeasurements(breezeProgressManager, workflow, workflow2);
        } else {
            workflow2.createDefaultGroup();
        }
        if (bl2) {
            DuplicateWorkflowHelper.copyWorkflowAnalysis(breezeProgressManager, workflow, workflow2);
        }
        DuplicateWorkflowHelper.updatePathInTree(workflow2.getAnalyseTree().getRoot(), workflow.getFolder().getAbsolutePath(), workflow2.getFolder().getAbsolutePath());
        workflow2.save();
        return workflow2;
    }

    public static void copyWorkflowMeasurements(BreezeProgressManager breezeProgressManager, Workflow workflow, Workflow workflow2) {
        List<Measurement> list = workflow.getAllMeasurements();
        int n = breezeProgressManager.setGroupMaximumAndReset(list.size());
        for (Group group : workflow.getChildList()) {
            if (breezeProgressManager.isAborted()) break;
            Group group2 = new Group(group.getName(), workflow2);
            workflow2.addChild(group2);
            DuplicateWorkflowHelper.copyGroupMeasurements(breezeProgressManager, n, group, group2);
            group2.save();
            DuplicateWorkflowHelper.copyExportFolders(breezeProgressManager, group, group2);
        }
        DuplicateWorkflowHelper.copyExportFolders(breezeProgressManager, workflow, workflow2);
    }

    public static void copyGroupMeasurements(BreezeProgressManager breezeProgressManager, int n, Group group, Group group2) {
        for (Measurement measurement : group.getChildList()) {
            if (breezeProgressManager.isAborted()) break;
            File file = new File(group2.getFolder(), measurement.getName());
            file.mkdirs();
            FileHelper.copyFolder(breezeProgressManager, measurement.getFolder(), file);
            Measurement measurement2 = new Measurement(file, group2);
            group2.addChild(measurement2);
            breezeProgressManager.incStepGroup(n);
            DuplicateWorkflowHelper.copyExportFolders(breezeProgressManager, measurement, measurement2);
        }
    }

    private static void copyExportFolders(BreezeProgressManager breezeProgressManager, Entry entry, Entry entry2) {
        File file = new File(entry.getFolder(), "Export");
        if (file.exists() && file.isDirectory()) {
            FileHelper.copyFolder(breezeProgressManager, file, new File(entry2.getFolder(), "Export"));
        }
    }

    public static void copyWorkflowAnalysis(BreezeProgressManager breezeProgressManager, Workflow workflow, Workflow workflow2) {
        AnalyseList analyseList = BreezeMasterCache.getInstance().getAnalyseList();
        List<BasicAnalyse> list = workflow.getAnalysisFromStudyId();
        breezeProgressManager.setMaximumAndReset(list.size());
        for (BasicAnalyse basicAnalyse : list) {
            if (breezeProgressManager.isAborted()) break;
            breezeProgressManager.setInfoText("Duplicating analyse: " + basicAnalyse.getName());
            Analyse analyse = ((Analyse)basicAnalyse).createDuplicateAndSave(EntryMainHelper.getUniqueName(basicAnalyse.getName(), analyseList));
            DuplicateWorkflowHelper.updateAnalysisGroups(analyse.getGroups(), workflow, workflow2);
            analyse.setStudyId(workflow2.getStudyId());
            analyse.save();
            analyseList.add(analyse);
            DuplicateWorkflowHelper.updateAnalysisInTree(workflow2.getAnalyseTree().getRoot(), basicAnalyse, analyse);
            breezeProgressManager.incStep();
        }
    }

    private static void updateAnalysisGroups(AnalyseSpectralGroup.AnalyseSpectralGroups analyseSpectralGroups, Workflow workflow, Workflow workflow2) {
        String string = workflow.getStudyId();
        for (AnalyseSpectralGroup analyseSpectralGroup : analyseSpectralGroups) {
            Group group;
            if (!string.equals(analyseSpectralGroup.getStudyId())) continue;
            analyseSpectralGroup.setStudyId(workflow2.getStudyId());
            Group group2 = workflow.getGroupById(analyseSpectralGroup.getGroupId());
            if (group2 != null && (group = workflow2.getGroupByName(group2.getName())) != null) {
                analyseSpectralGroup.setGroupId(group.getUid());
            }
            analyseSpectralGroup.clear();
        }
    }

    private static void updateAnalysisInTree(FunctionTreeNode functionTreeNode, BasicAnalyse basicAnalyse, Analyse analyse) {
        for (FunctionParameter object : functionTreeNode.getFunction().getParameterList()) {
            if (!(object instanceof AnalyseParameter)) continue;
            AnalyseParameter analyseParameter = (AnalyseParameter)object;
            if (!basicAnalyse.getUid().equals(analyseParameter.getValueStr())) continue;
            analyseParameter.setValueStr(analyse.getUid());
        }
        for (FunctionTreeNode functionTreeNode2 : functionTreeNode.getChildList()) {
            DuplicateWorkflowHelper.updateAnalysisInTree(functionTreeNode2, basicAnalyse, analyse);
        }
    }

    private static void updatePathInTree(FunctionTreeNode functionTreeNode, String string, String string2) {
        for (FunctionParameter object : functionTreeNode.getFunction().getParameterList()) {
            if (!(object instanceof MembersSetting.EndMemberFileParameter)) continue;
            MembersSetting.EndMemberFileParameter endMemberFileParameter = (MembersSetting.EndMemberFileParameter)object;
            endMemberFileParameter.setValueStr(FileHelper.updateFilePath(endMemberFileParameter.getValueStr(), string, string2));
        }
        for (FunctionTreeNode functionTreeNode2 : functionTreeNode.getChildList()) {
            DuplicateWorkflowHelper.updatePathInTree(functionTreeNode2, string, string2);
        }
    }
}

