/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.play;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationPort;
import se.prediktera.breeze.common.entry.tree.evaluatetree.impl.NoneEvaluate;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionHelper;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanelInterface;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeTogglePanel;
import se.prediktera.breeze.frontend.common.swing.dialog.card.BreezeNodeTogglePanel;
import se.prediktera.breeze.frontend.common.swing.dialog.card.NodeCard;

public class GraphHelper {
    public static void addNewFunction(EntryMainPanelInterface entryMainPanelInterface, OnAddCallback onAddCallback, String string, String string2) {
        List<AbstractBreezeFunctionInfo> list = FunctionHelper.getFunctionsSorted();
        BreezeType breezeType = entryMainPanelInterface.getPageType();
        ArrayList<BreezeTogglePanel.ToggleItem<? extends AbstractCardInfo>> arrayList = new ArrayList<BreezeTogglePanel.ToggleItem<? extends AbstractCardInfo>>();
        arrayList.add(new BreezeTogglePanel.ToggleItem<AbstractBreezeFunctionInfo>("All", "All", "Method", GraphHelper.getMethods(list, breezeType, AbstractBreezeFunctionInfo.FunctionType.All)));
        arrayList.add(new BreezeTogglePanel.ToggleItem<AbstractBreezeFunctionInfo>("Segmentation", "Add new segmentation", "Method", GraphHelper.getMethods(list, breezeType, AbstractBreezeFunctionInfo.FunctionType.Segmentation)));
        arrayList.add(new BreezeTogglePanel.ToggleItem<AbstractBreezeFunctionInfo>("Descriptor", "Add new descriptor", "Method", GraphHelper.getMethods(list, breezeType, AbstractBreezeFunctionInfo.FunctionType.Descriptor)));
        arrayList.add(new BreezeTogglePanel.ToggleItem<AbstractBreezeFunctionInfo>("Action", "Add new action", "Method", GraphHelper.getMethods(list, breezeType, AbstractBreezeFunctionInfo.FunctionType.Action)));
        BreezeOptionDialog.showDialog(entryMainPanelInterface.getFrame(), entryMainPanelInterface.getPageColor(), AbstractBreezeDialog.MessageType.CANCEL_OPTION, string, "", (AbstractBreezeCustomPanel)new BreezeNodeTogglePanel(arrayList, breezeType, string2), null, breezeActionEvent -> onAddCallback.added(FunctionHelper.createNew((AbstractBreezeFunctionInfo)((BreezeNodeTogglePanel)breezeActionEvent.getBreezeCustomPanel()).getType())));
    }

    public static List<AbstractBreezeFunctionInfo> getMethods(List<AbstractBreezeFunctionInfo> list, BreezeType breezeType, AbstractBreezeFunctionInfo.FunctionType functionType) {
        ArrayList<AbstractBreezeFunctionInfo> arrayList = new ArrayList<AbstractBreezeFunctionInfo>();
        for (AbstractBreezeFunctionInfo abstractBreezeFunctionInfo : list) {
            if (!functionType.equals((Object)AbstractBreezeFunctionInfo.FunctionType.All) && !functionType.equals((Object)abstractBreezeFunctionInfo.getType()) || !abstractBreezeFunctionInfo.support(breezeType) || !abstractBreezeFunctionInfo.isVisibleInList()) continue;
            arrayList.add(abstractBreezeFunctionInfo);
        }
        return arrayList;
    }

    public static Rectangle getBoundsRelativeToAncestor(Component component, Component component2) {
        if (component == null || component2 == null) {
            throw new IllegalArgumentException("Components cannot be null");
        }
        Rectangle rectangle = new Rectangle(component.getX(), component.getY(), component.getWidth(), component.getHeight());
        for (Container container = component.getParent(); container != null && container != component2; container = container.getParent()) {
            rectangle.x += container.getX();
            rectangle.y += container.getY();
            if (container.getParent() == null && container != component2) break;
        }
        return rectangle;
    }

    public static interface OnAddCallback {
        public void added(FunctionTreeNode var1);
    }

    public static class EditFunctionButton
    extends JPanel {
        private final EntryMainHelper.ClickCallBack callback;

        public EditFunctionButton(String string, EntryMainHelper.ClickCallBack clickCallBack) {
            super(new BorderLayout());
            this.callback = clickCallBack;
            this.setPreferredSize(new Dimension(0, 75));
            this.setOpaque(false);
        }

        public void setNode(FunctionTreeNode functionTreeNode) {
            if (functionTreeNode == null || functionTreeNode instanceof SegmentationPort || functionTreeNode.getFunction() instanceof NoneEvaluate) {
                this.setVisible(false);
            } else {
                this.removeAll();
                this.add((Component)new NodeCard(functionTreeNode.getFunction().getInfo(), true, "", abstractCardInfo -> this.callback.doClick()), "Center");
                this.revalidate();
                this.repaint();
                this.setVisible(true);
            }
        }
    }
}

