/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.play;

import com.mxgraph.model.mxCell;
import com.mxgraph.swing.mxGraphComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.backend.measure.applychanges.ApplyChanges;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationPort;
import se.prediktera.breeze.common.entry.tree.evaluatetree.impl.NoneEvaluate;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionHelper;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeList;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeListMap;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.realtime.descriptor.SegmentationLabelDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.parameter.AddParameter;
import se.prediktera.breeze.common.realtime.segmentation.spatial.ManualSegmentation;
import se.prediktera.breeze.common.realtime.segmentation.spatial.OnnxSegmentation;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.entry.workflow.WorkflowMergeHandler;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.Toast;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanelInterface;
import se.prediktera.breeze.frontend.common.entry.OpenEntryProgressAction;
import se.prediktera.breeze.frontend.common.graphcollection.FunctionTreePanel;
import se.prediktera.breeze.frontend.common.pp.DefaultSettingsPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.WaitCursor;
import se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.util.BreezeUserManager;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.main.model.ModelMainPanel;
import se.prediktera.breeze.frontend.main.play.GraphHelper;
import se.prediktera.breeze.frontend.main.play.edit.EditDescriptorHelper;
import se.prediktera.breeze.frontend.main.play.edit.EditDescriptorPanel;
import se.prediktera.breeze.frontend.main.play.edit.FunctionPropertyPanel;
import se.prediktera.breeze.frontend.main.record.edit.common.AbstractEditEntryMainPanel;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.map.common.error.ErrorHandler;

public class GraphOverviewPanel
extends AbstractViewPanel {
    private final FunctionTreePanel graphManager;
    private final GraphSettingsPanel graphSettingsPanel;
    private Object entry;
    private Workflow workflow;
    private FunctionTreeNode selectedTreeNode;
    private FunctionTreeNode moveTreeNode;
    private final BreezeButton duplicateButton;
    private final BreezeButton addSubNodeButton;
    private final BreezeButton levelUpButton;
    private final BreezeButton levelDownButton;
    private final BreezeButton upButton;
    private final BreezeButton downButton;
    private final BreezeButton openButton;
    private final BreezeButton applyChangesButton;
    private final BreezeButton enableDisableButton;
    private final BreezeButton deleteButton;
    private final BreezeCheckBox transformationCheckBox;
    private boolean addingChild = false;
    private BreezeButton mergeButton;

    public GraphOverviewPanel(final EntryMainPanel entryMainPanel, Object object) {
        super(entryMainPanel);
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.setBackground(breezeTheme.getPanelBackground());
        this.setLayout(new GridBagLayout());
        this.graphManager = new FunctionTreePanel(true, true);
        this.graphManager.setEnabled(false);
        this.graphManager.setBackground(breezeTheme.getPanelBackground());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)((Object)this.graphManager), gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = 2;
        this.add(new FunctionTreePanel.FunctionTreeToolbar(this.graphManager), gridBagConstraints2);
        this.graphSettingsPanel = new GraphSettingsPanel(this, Workflow.getWorkflow(object));
        this.setRightSettingsPanel(this.graphSettingsPanel);
        final mxGraphComponent mxGraphComponent2 = this.graphManager.getGraphComponent();
        BreezeScrollPane.setTheme((JScrollPane)mxGraphComponent2);
        mxGraphComponent2.setPageBackgroundColor(breezeTheme.getPanelBackground());
        mxGraphComponent2.getViewport().setBackground(breezeTheme.getPanelBackground());
        mxGraphComponent2.setBorder(BorderFactory.createEmptyBorder());
        mxGraphComponent2.getGraphControl().addMouseListener((MouseListener)new MouseAdapter(this){
            final /* synthetic */ GraphOverviewPanel this$0;
            {
                this.this$0 = graphOverviewPanel;
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                mouseEvent.consume();
                this.this$0.addingChild = false;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                FunctionTreeNode functionTreeNode;
                Object object;
                super.mousePressed(mouseEvent);
                mxCell mxCell2 = (mxCell)mxGraphComponent2.getCellAt(mouseEvent.getX(), mouseEvent.getY());
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    if (this.this$0.moveTreeNode != null) {
                        if (mxCell2 != null && (object = mxCell2.getValue()) instanceof FunctionTreeNode) {
                            functionTreeNode = (FunctionTreeNode)object;
                            if (!this.this$0.moveTreeNode.isChildTo(functionTreeNode)) {
                                EditDescriptorHelper.changeParent(this.this$0.moveTreeNode, SegmentationNode.getNodeOrDefaultPort(functionTreeNode));
                                this.this$0.selectGraphAndSaveWorkflow(this.this$0.moveTreeNode);
                                mxCell2 = (mxCell)this.this$0.graphManager.getVertexFromObject(this.this$0.moveTreeNode);
                            } else {
                                ToastHandler.getInstance().showToast("Cannot move to child node", Toast.IconType.Warning);
                            }
                        }
                        this.this$0.moveTreeNode = null;
                    } else if (mxCell2 != null && mxCell2.getValue() instanceof FunctionTreePanel.AddNewFunction) {
                        this.this$0.addNewFunction(entryMainPanel, ((FunctionTreePanel.AddNewFunction)mxCell2.getValue()).getNode());
                    }
                }
                if (SwingUtilities.isLeftMouseButton(mouseEvent) || !mxGraphComponent2.getGraph().isCellSelected((Object)mxCell2)) {
                    if (!this.this$0.addingChild) {
                        if (mxCell2 != null && FunctionTreePanel.supportSelection(mxCell2.getValue())) {
                            this.this$0.selectedTreeNode = functionTreeNode = (FunctionTreeNode)mxCell2.getValue();
                            mxGraphComponent2.selectCellForEvent((Object)mxCell2, mouseEvent);
                        } else {
                            mxGraphComponent2.getGraph().clearSelection();
                            this.this$0.selectedTreeNode = null;
                        }
                        if (this.this$0.graphManager.getSelectedNodes().size() <= 1) {
                            this.this$0.graphManager.addAddShape(mxCell2, this.this$0.selectedTreeNode);
                        }
                    }
                    this.this$0.graphSettingsPanel.update(this.this$0.workflow, this.this$0.entry, this.this$0.selectedTreeNode);
                    this.this$0.updateButtons();
                }
                if (SwingUtilities.isRightMouseButton(mouseEvent) && mxCell2 != null && FunctionTreePanel.supportSelection(mxCell2.getValue())) {
                    functionTreeNode = (FunctionTreeNode)mxCell2.getValue();
                    object = new BreezeContextMenu(this.this$0.getFrame(), Color.red);
                    if (this.isManualSegmentationOnly(this.this$0.graphManager.getSelectedNodes())) {
                        this.addButtonToPopup((BreezeContextMenu)((Object)object), this.this$0.mergeButton);
                        ((BreezeContextMenu)((Object)object)).addSeparator();
                    }
                    this.addButtonToPopup((BreezeContextMenu)((Object)object), this.this$0.duplicateButton);
                    this.addButtonToPopup((BreezeContextMenu)((Object)object), this.this$0.addSubNodeButton);
                    if (functionTreeNode instanceof SegmentationNode) {
                        SegmentationNode segmentationNode = (SegmentationNode)functionTreeNode;
                        ((BreezeContextMenu)((Object)object)).addButtonCloseClick("Show in table", () -> {
                            this.this$0.workflow.getVisualisationNode().setSegmentationLevel(SegmentationNode.getSegmentationLevel(segmentationNode), segmentationNode.getUid());
                            entryMainPanel.selectTab("Table");
                        });
                    }
                    if (functionTreeNode.getParent() != null && !(functionTreeNode instanceof SegmentationPort)) {
                        ((BreezeContextMenu)((Object)object)).addButtonCloseClick("Move to", () -> {
                            this.this$0.moveTreeNode = functionTreeNode;
                            this.this$0.updateGraph();
                            ToastHandler.getInstance().showToast("Select node to move to");
                        });
                    }
                    ((BreezeContextMenu)((Object)object)).addSeparator();
                    this.addButtonToPopup((BreezeContextMenu)((Object)object), this.this$0.levelUpButton);
                    this.addButtonToPopup((BreezeContextMenu)((Object)object), this.this$0.levelDownButton);
                    ((BreezeContextMenu)((Object)object)).addSeparator();
                    this.addButtonToPopup((BreezeContextMenu)((Object)object), this.this$0.upButton);
                    this.addButtonToPopup((BreezeContextMenu)((Object)object), this.this$0.downButton);
                    if (functionTreeNode.getAnalyse() instanceof Analyse) {
                        ((BreezeContextMenu)((Object)object)).addSeparator();
                        this.addButtonToPopup((BreezeContextMenu)((Object)object), this.this$0.openButton);
                    }
                    ((BreezeContextMenu)((Object)object)).addSeparator();
                    this.addButtonToPopup((BreezeContextMenu)((Object)object), this.this$0.enableDisableButton);
                    ((BreezeContextMenu)((Object)object)).addSeparator();
                    this.addButtonToPopup((BreezeContextMenu)((Object)object), this.this$0.deleteButton);
                    if (((BreezeContextMenu)((Object)object)).resize()) {
                        this.this$0.getFrame().addPage((JPanel)object);
                        ((BreezeContextMenu)((Object)object)).setPositionLater(mouseEvent);
                    }
                }
            }

            private boolean isManualSegmentationOnly(List<FunctionTreeNode> list) {
                if (list.size() > 1) {
                    FunctionTreeNode functionTreeNode = list.getFirst().getParent();
                    for (FunctionTreeNode functionTreeNode2 : list) {
                        if (functionTreeNode2.getFunction() instanceof ManualSegmentation && functionTreeNode2.getParent() == functionTreeNode) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }

            private void addButtonToPopup(BreezeContextMenu breezeContextMenu, BreezeButton breezeButton) {
                if (breezeButton.isEnabled()) {
                    breezeContextMenu.addButtonCloseClick(breezeButton.getDesc(), breezeButton::doClick);
                }
            }
        });
        mxGraphComponent2.getGraphControl().addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(this){
            final /* synthetic */ GraphOverviewPanel this$0;
            {
                this.this$0 = graphOverviewPanel;
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                mxCell mxCell2 = (mxCell)mxGraphComponent2.getCellAt(mouseEvent.getX(), mouseEvent.getY());
                if (mxCell2 != null && (FunctionTreePanel.supportSelection(mxCell2.getValue()) || mxCell2.getValue() instanceof FunctionTreePanel.AddNewFunction)) {
                    this.this$0.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    this.this$0.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.duplicateButton = EntryMainHelper.createButton("functionDuplicate", "Duplicate", "material/content_copy", () -> {
            FunctionTreeNode functionTreeNode = this.selectedTreeNode.clone(false);
            this.selectedTreeNode.getParent().addChild(functionTreeNode);
            this.selectGraphAndSaveWorkflow(functionTreeNode);
        });
        this.mergeButton = EntryMainHelper.createButton("functionMerge", "Merge", "material/arrow_and_edge", () -> this.merge(this.graphManager.getSelectedNodes()));
        this.addSubNodeButton = EntryMainHelper.createButton("functionAdd", "Add node", "material/add_circle", () -> this.addNewFunction(this.mainpanel, this.selectedTreeNode));
        this.levelUpButton = EntryMainHelper.createButton("functionLevelUp", "Level up", "material/arrow_back", () -> {
            for (FunctionTreeNode functionTreeNode : this.graphManager.getSelectedNodes()) {
                EditDescriptorHelper.changeParent(functionTreeNode, EditDescriptorHelper.getParent(functionTreeNode));
            }
            this.selectGraphAndSaveWorkflow(this.selectedTreeNode);
        });
        this.levelDownButton = EntryMainHelper.createButton("functionLevelDown", "Level down", "material/arrow_forward", () -> {
            for (FunctionTreeNode functionTreeNode : this.graphManager.getSelectedNodes()) {
                EditDescriptorHelper.changeParent(functionTreeNode, EditDescriptorHelper.getNext(functionTreeNode));
            }
            this.selectGraphAndSaveWorkflow(this.selectedTreeNode);
        });
        this.upButton = EntryMainHelper.createButton("functionUp", "Order up", "material/arrow_upward", () -> {
            List<FunctionTreeNode> list = this.graphManager.getSelectedNodes();
            for (FunctionTreeNode functionTreeNode : list) {
                FunctionTreeNode functionTreeNode2 = functionTreeNode.getParent();
                int n = functionTreeNode2.getChildIndex(functionTreeNode);
                int n2 = n - 1;
                if (n <= 0) continue;
                FunctionTreeNode functionTreeNode3 = functionTreeNode2.getChild(n2);
                functionTreeNode2.getChildList().set(n2, functionTreeNode);
                functionTreeNode2.getChildList().set(n, functionTreeNode3);
            }
            this.selectGraphAndSaveWorkflow(this.selectedTreeNode);
        });
        this.downButton = EntryMainHelper.createButton("functionDown", "Order down", "material/arrow_downward", () -> {
            List<FunctionTreeNode> list = this.graphManager.getSelectedNodes();
            for (int i = list.size() - 1; i >= 0; --i) {
                FunctionTreeNode functionTreeNode = list.get(i);
                FunctionTreeNode functionTreeNode2 = functionTreeNode.getParent();
                int n = functionTreeNode2.getChildIndex(functionTreeNode);
                int n2 = n + 1;
                if (n2 >= functionTreeNode2.getChildCount()) continue;
                FunctionTreeNode functionTreeNode3 = functionTreeNode2.getChild(n2);
                functionTreeNode2.getChildList().set(n2, functionTreeNode);
                functionTreeNode2.getChildList().set(n, functionTreeNode3);
            }
            this.selectGraphAndSaveWorkflow(this.selectedTreeNode);
        });
        this.openButton = EntryMainHelper.createButton("Open", "material/file_open", () -> BreezeProgressDialog.startProgress(this.getFrame(), new OpenEntryProgressAction(this, this.getFrame()){
            final /* synthetic */ GraphOverviewPanel this$0;
            {
                this.this$0 = graphOverviewPanel;
                super(breezeFrame);
            }

            @Override
            protected BreezeMainPanel createOpenPanel() {
                BasicAnalyse basicAnalyse = this.this$0.selectedTreeNode.getAnalyse();
                if (basicAnalyse instanceof Analyse) {
                    return ModelMainPanel.createModelWizard(this.getProgressManager(), entryMainPanel, (Analyse)basicAnalyse, null);
                }
                throw new ErrorHandler.InformationMessageException("No available wizard for analyse : " + String.valueOf(basicAnalyse));
            }
        }, "Opening...", 0));
        this.applyChangesButton = EntryMainHelper.createApplyButton(entryMainPanel, new ProgressAction(this){
            final /* synthetic */ GraphOverviewPanel this$0;
            {
                this.this$0 = graphOverviewPanel;
            }

            @Override
            public void runAction() {
                try {
                    ApplyChanges.applyChanges((BreezeProgress)this.getProgressManager(), Measurement.getMeasurements(entryMainPanel.getSelectedEntries()));
                }
                catch (TcpManager.CommandErrorException commandErrorException) {
                    this.this$0.selectedTreeNode = this.this$0.workflow.getAnalyseTree().getTreeNodeById(commandErrorException.getFunctionId());
                    throw commandErrorException;
                }
                finally {
                    this.this$0.updateSettingsPanelAndGraph();
                }
            }
        });
        this.enableDisableButton = EntryMainHelper.createButton("Enable", "material/toggle_on", () -> {
            List<FunctionTreeNode> list = this.graphManager.getSelectedNodes();
            if (!list.isEmpty()) {
                boolean bl;
                boolean bl2 = bl = !this.selectedTreeNode.isEnabled();
                if (!bl && this.hasManualSegmentation(list)) {
                    BreezeOptionDialog.showDialog(entryMainPanel, AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Confirm disable", "Manual segmentation sample object will not be stored when disabled and apply changes has been made.\n\nDo you want to continue?", breezeActionEvent -> this.enableDisableNodes(list, bl));
                } else {
                    this.enableDisableNodes(list, bl);
                }
            }
        });
        this.deleteButton = EntryMainHelper.createButton("Delete", "material/delete", () -> {
            List<FunctionTreeNode> list = this.graphManager.getSelectedNodes();
            if (!list.isEmpty()) {
                BreezeOptionDialog.showDialog(entryMainPanel, AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Confirm delete", AbstractEditEntryMainPanel.getDeleteText(list), breezeActionEvent -> {
                    try (WaitCursor waitCursor = new WaitCursor();){
                        for (FunctionTreeNode functionTreeNode : list) {
                            if (functionTreeNode.getParent() == null) continue;
                            functionTreeNode.delete();
                            functionTreeNode.getParent().removeChild(functionTreeNode);
                        }
                        this.selectGraphAndSaveWorkflow(null);
                    }
                });
            }
        });
        this.transformationCheckBox = new BreezeCheckBox("Show pretreatments", false, bl -> {
            this.graphManager.showTransformations(bl);
            this.updateGraph();
        });
        EntryMainHelper.registerKeyAction((JComponent)((Object)this), KeyStroke.getKeyStroke(127, 0), () -> this.deleteButton.doClick());
    }

    private void merge(List<FunctionTreeNode> list2) {
        SegmentationNode segmentationNode = (SegmentationNode)list2.getFirst();
        for (int i = 1; i < list2.size(); ++i) {
            SegmentationNode segmentationNode2 = (SegmentationNode)list2.get(i);
            WorkflowMergeHandler.forEverySample(this.workflow, list -> GraphOverviewPanel.updateSegmentation(list, segmentationNode2.getUid(), segmentationNode.getUid()));
            segmentationNode2.delete();
            segmentationNode2.getParent().removeChild(segmentationNode2);
        }
        this.selectGraphAndSaveWorkflow(null);
    }

    private static boolean updateSegmentation(List<BasicSample> list, String string, String string2) {
        boolean bl = false;
        for (BasicSample basicSample : list) {
            Sample sample = (Sample)basicSample;
            String string3 = sample.getSegmentationHashId();
            if (string.equals(string3)) {
                sample.setSegmentationHashId(string2);
                bl = true;
            }
            if (!GraphOverviewPanel.updateSegmentation(sample.getChildList(), string, string2)) continue;
            bl = true;
        }
        return bl;
    }

    protected void addNewFunction(EntryMainPanelInterface entryMainPanelInterface, FunctionTreeNode functionTreeNode) {
        GraphHelper.addNewFunction(entryMainPanelInterface, functionTreeNode2 -> {
            try (WaitCursor waitCursor = new WaitCursor();){
                if (functionTreeNode2 instanceof SegmentationNode) {
                    ((SegmentationNode)functionTreeNode2).recreateSegmentationPorts(this.workflow);
                }
                this.addChild(functionTreeNode, functionTreeNode2);
                functionTreeNode2.setEnabled(functionTreeNode.isEnabled());
            }
        }, "Add node", null);
        this.addingChild = false;
    }

    private void enableDisableNodes(List<FunctionTreeNode> list, boolean bl) {
        for (FunctionTreeNode functionTreeNode : list) {
            GraphOverviewPanel.setEnableRecursive(functionTreeNode, bl);
            if (!bl) continue;
            for (FunctionTreeNode functionTreeNode2 = functionTreeNode.getParent(); functionTreeNode2 != null; functionTreeNode2 = functionTreeNode2.getParent()) {
                functionTreeNode2.setEnabled(bl);
            }
        }
        this.selectGraphAndSaveWorkflow(this.selectedTreeNode);
    }

    private boolean hasManualSegmentation(List<FunctionTreeNode> list) {
        for (FunctionTreeNode functionTreeNode : list) {
            if (!(functionTreeNode.getFunction() instanceof ManualSegmentation)) continue;
            return true;
        }
        return false;
    }

    private static void setEnableRecursive(FunctionTreeNode functionTreeNode, boolean bl) {
        functionTreeNode.setEnabled(bl);
        for (FunctionTreeNode functionTreeNode2 : functionTreeNode.getChildList()) {
            GraphOverviewPanel.setEnableRecursive(functionTreeNode2, bl);
        }
    }

    private void addChild(FunctionTreeNode functionTreeNode, FunctionTreeNode functionTreeNode2) {
        if (functionTreeNode instanceof SegmentationNode) {
            ((SegmentationNode)functionTreeNode).getDefaultPort().addChild(functionTreeNode2);
        } else {
            functionTreeNode.addChild(functionTreeNode2);
        }
        if (functionTreeNode2.getFunction() instanceof OnnxSegmentation) {
            FunctionTreeNode functionTreeNode3 = FunctionHelper.createNew(new SegmentationLabelDescriptor.Info());
            ((SegmentationNode)functionTreeNode2).getDefaultPort().addChild(functionTreeNode3);
            DescriptorTreeNode descriptorTreeNode = (DescriptorTreeNode)FunctionHelper.createNew(new SegmentationLabelDescriptor.Info());
            descriptorTreeNode.setIndex(1);
            ((SegmentationNode)functionTreeNode2).getDefaultPort().addChild(descriptorTreeNode);
        }
        EditDescriptorHelper.copyDescriptorParametersFromParent(functionTreeNode2);
        this.selectGraphAndSaveWorkflow(functionTreeNode2);
    }

    private void selectGraphAndSaveWorkflow(FunctionTreeNode functionTreeNode) {
        this.setSelectedAndUpdateGraph(functionTreeNode);
        EditDescriptorHelper.resetAndSaveWorkflow(this.workflow);
    }

    @Override
    public String getType() {
        return "GraphOverview";
    }

    @Override
    public boolean showRightSettingsPanel() {
        return true;
    }

    @Override
    public void addComponent(BreezeMainPanel breezeMainPanel) {
        super.addComponent(breezeMainPanel);
        breezeMainPanel.addRightButton(this.duplicateButton);
        breezeMainPanel.addRightButton(this.addSubNodeButton);
        breezeMainPanel.addRightButton(new BreezeSeparator.Vertical());
        breezeMainPanel.addRightButton(this.levelUpButton);
        breezeMainPanel.addRightButton(this.levelDownButton);
        breezeMainPanel.addRightButton(new BreezeSeparator.Vertical());
        breezeMainPanel.addRightButton(this.upButton);
        breezeMainPanel.addRightButton(this.downButton);
        breezeMainPanel.addRightButton(new BreezeSeparator.Vertical());
        breezeMainPanel.addRightButton(this.openButton);
        breezeMainPanel.addRightButton(this.applyChangesButton);
        breezeMainPanel.addRightButton(new BreezeSeparator.Vertical());
        breezeMainPanel.addRightButton(this.enableDisableButton);
        breezeMainPanel.addRightButton(new BreezeSeparator.Vertical());
        breezeMainPanel.addRightButton(this.deleteButton);
        breezeMainPanel.addRightButton(new BreezeSeparator.Vertical());
        breezeMainPanel.addRightButton(this.transformationCheckBox);
    }

    @Override
    public void showEntry(Object object, Object object2) {
        this.workflow = Workflow.getWorkflow(object);
        if (this.entry != object) {
            FunctionTreeNode functionTreeNode;
            SegmentationNode segmentationNode;
            this.entry = object;
            this.selectedTreeNode = this.workflow != null ? ((segmentationNode = SegmentationNode.getNextSegmentationNode(functionTreeNode = this.workflow.getRoot())) != null ? segmentationNode : functionTreeNode) : null;
        }
        this.graphManager.setWorkflow(this.workflow);
        this.updateSettingsPanelAndGraph();
    }

    private void setSelectedAndUpdateGraph(FunctionTreeNode functionTreeNode) {
        this.selectedTreeNode = functionTreeNode;
        this.updateSettingsPanelAndGraph();
    }

    public void updateSettingsPanelAndGraph() {
        this.graphSettingsPanel.update(this.workflow, this.entry, this.selectedTreeNode);
        this.updateGraph();
    }

    private void updateGraph() {
        this.graphManager.clear();
        if (this.workflow != null) {
            Object object;
            FunctionTreeListMap functionTreeListMap = this.workflow.getContextHolder();
            if (functionTreeListMap != null) {
                object = functionTreeListMap.getFunctionGraphs().iterator();
                while (object.hasNext()) {
                    FunctionTreeList functionTreeList = object.next();
                    this.graphManager.addFunctionTree(functionTreeList);
                }
                this.graphManager.updateGraph();
            }
            if (this.selectedTreeNode != null && (object = this.graphManager.getVertexFromObject(this.selectedTreeNode)) != null) {
                this.graphManager.getGraphComponent().getGraph().getSelectionModel().addCell(object);
            }
            if (this.moveTreeNode == null && BreezeUserManager.hasAccess(BreezeUserManager.AccessRight.AnalyseTree)) {
                this.graphManager.addAddShape(this.selectedTreeNode);
            }
        }
        this.updateButtons();
        this.graphManager.repaint();
    }

    private void updateButtons() {
        boolean bl = BreezeUserManager.hasAccess(BreezeUserManager.AccessRight.AnalyseTree);
        this.addSubNodeButton.setEnabled(bl && this.selectedTreeNode != null && this.selectedTreeNode.isManualAdd());
        this.duplicateButton.setEnabled(bl && this.selectedTreeNode != null && this.selectedTreeNode.isDuplicate());
        this.levelUpButton.setEnabled(bl && this.selectedTreeNode != null && this.selectedTreeNode.isDuplicate());
        this.levelDownButton.setEnabled(bl && this.selectedTreeNode != null && this.selectedTreeNode.isDuplicate());
        this.upButton.setEnabled(bl && this.selectedTreeNode != null && this.selectedTreeNode.isDuplicate());
        this.downButton.setEnabled(bl && this.selectedTreeNode != null && this.selectedTreeNode.isDuplicate());
        this.openButton.setEnabled(bl && this.selectedTreeNode != null && this.selectedTreeNode.getAnalyseCatchError() instanceof Analyse);
        if (this.selectedTreeNode != null) {
            this.enableDisableButton.setDesc(this.selectedTreeNode.isEnabled() ? "Disable" : "Enable");
            this.enableDisableButton.setResourceIcon("material/" + (this.selectedTreeNode.isEnabled() ? "toggle_on" : "toggle_off"));
            this.enableDisableButton.setEnabled(bl && this.selectedTreeNode.isDuplicate());
        } else {
            this.enableDisableButton.setDesc("Disable");
            this.enableDisableButton.setResourceIcon("toggle_on");
            this.enableDisableButton.setEnabled(false);
        }
        this.deleteButton.setEnabled(bl && this.selectedTreeNode != null && this.selectedTreeNode.isDuplicate());
    }

    public static class GraphSettingsPanel
    extends DefaultSettingsPanel {
        private final DefaultSettingsPanel.SectionCollapsePanel parametersSection;
        private final GraphOverviewPanel graphPanel;
        private final BreezeInputField aliasTextField = new BreezeInputField("Alias", "", "");
        private final BreezeComboBoxInputField<String> outputComboBox = new BreezeComboBoxInputField("Output", "", BreezeInputFieldHelper.Format.TwoRows);
        private final BreezeButton helpButton;
        private final GraphHelper.EditFunctionButton editFunctionButton;
        private Workflow workflow;
        private final DefaultSettingsPanel.SectionCollapsePanel generalSection;
        private FunctionTreeNode functionNode;
        private boolean settingdata = false;
        private Object entry;

        public GraphSettingsPanel(GraphOverviewPanel graphOverviewPanel, Workflow workflow) {
            super(300, false);
            this.graphPanel = graphOverviewPanel;
            this.workflow = workflow;
            this.generalSection = this.addCollapseSection("Method", false);
            this.helpButton = EntryMainHelper.createButton("", "help", () -> AbstractBreezeFunctionInfo.showHelpOnline(this.functionNode != null ? this.functionNode.getFunction().getInfo() : null));
            GridBagConstraints gridBagConstraints = GridBagHelper.createWithWeigthX1(0, new Insets(0, 10, 0, 10));
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            this.generalSection.add((Component)this.helpButton, gridBagConstraints);
            this.editFunctionButton = new GraphHelper.EditFunctionButton("Edit", () -> GraphHelper.addNewFunction(graphOverviewPanel.getMainPanel(), functionTreeNode -> {
                GraphSettingsPanel.replaceFunctionTreeNode(functionTreeNode.getFunction(), this.functionNode, functionTreeNode);
                this.functionNode = functionTreeNode;
                this.updateParameterSection();
                if (this.functionNode instanceof SegmentationNode) {
                    ((SegmentationNode)this.functionNode).recreateSegmentationPorts(this.workflow);
                }
                graphOverviewPanel.selectGraphAndSaveWorkflow(functionTreeNode);
            }, "Edit node", this.functionNode.getFunction().getInfo().toString()));
            this.generalSection.addComponentHorizontal(this.editFunctionButton);
            this.aliasTextField.addChangeListener(textActionEvent -> {
                String string = this.aliasTextField.getValue();
                this.functionNode.setAlias(!string.isEmpty() ? string : null);
                EditDescriptorHelper.resetAndSaveWorkflow(this.workflow);
                graphOverviewPanel.updateSettingsPanelAndGraph();
            });
            this.aliasTextField.setName("alias");
            this.generalSection.addComponentHorizontal(this.aliasTextField);
            this.parametersSection = this.addCollapseSection("Parameters", false);
            this.outputComboBox.setRenderer(new EditDescriptorPanel.DescriptorListCellRenderer());
            this.outputComboBox.setChangedListener(string -> {
                FunctionTreeNode functionTreeNode;
                if (!this.settingdata && (functionTreeNode = this.functionNode) instanceof DescriptorTreeNode) {
                    DescriptorTreeNode descriptorTreeNode = (DescriptorTreeNode)functionTreeNode;
                    short s = (short)this.outputComboBox.getSelectedIndex();
                    if (descriptorTreeNode.getIndex() != s) {
                        descriptorTreeNode.setIndex(s);
                        EditDescriptorHelper.resetAndSaveWorkflow(this.workflow);
                        graphOverviewPanel.updateGraph();
                    }
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    this.update(workflow, entry, functionNode);
                }
            });
        }

        public static void replaceFunctionTreeNode(AbstractBreezeFunction abstractBreezeFunction, FunctionTreeNode functionTreeNode, FunctionTreeNode functionTreeNode2) {
            AbstractBreezeFunction abstractBreezeFunction2 = functionTreeNode.getFunction();
            if (abstractBreezeFunction2 instanceof AddParameter.AddFunctionInterface) {
                AddParameter.AddFunctionInterface addFunctionInterface = (AddParameter.AddFunctionInterface)((Object)abstractBreezeFunction2);
                addFunctionInterface.clearSupported(functionTreeNode);
            }
            functionTreeNode2.setFunction(abstractBreezeFunction);
            if (functionTreeNode instanceof SegmentationNode && functionTreeNode2.getFunction() instanceof ManualSegmentation) {
                ((FunctionTreeNodeWithId)functionTreeNode2).setUid(((FunctionTreeNodeWithId)functionTreeNode).getUid());
            }
            functionTreeNode.replaceWith(functionTreeNode2);
            EditDescriptorHelper.copyDescriptorParametersFromParent(functionTreeNode2);
        }

        public void update(Workflow workflow, Object object, FunctionTreeNode functionTreeNode) {
            this.workflow = workflow;
            this.entry = object;
            this.functionNode = functionTreeNode;
            this.editFunctionButton.setNode(this.functionNode);
            this.settingdata = true;
            if (functionTreeNode != null) {
                this.aliasTextField.setText(functionTreeNode.getAlias() != null ? functionTreeNode.getAlias() : "");
            } else {
                this.aliasTextField.setText("");
            }
            this.aliasTextField.setVisible(GraphSettingsPanel.canChangeAlias(functionTreeNode));
            this.updateParameterSection();
            this.settingdata = false;
        }

        private void updateParameterSection() {
            this.parametersSection.clear();
            if (this.functionNode != null) {
                FunctionPropertyPanel functionPropertyPanel = new FunctionPropertyPanel(this.graphPanel.getFrame(), this.workflow, this.entry, this.functionNode, bl -> {
                    this.workflow.setApplyChangesNeededOnAllMeasurements();
                    this.graphPanel.getMainPanel().repaintEntryList();
                    if (bl) {
                        this.updateParameterSection();
                    }
                    this.graphPanel.updateGraph();
                    this.workflow.save();
                    ToastHandler.getInstance().showToast(BreezeFrame.getInstance(), "Parameter saved");
                }, BreezeInputFieldHelper.Format.TwoRows);
                this.parametersSection.addComponentHorizontal(functionPropertyPanel);
                if (functionPropertyPanel.hasChanged() && !this.functionNode.isFresh()) {
                    EditDescriptorHelper.resetAndSaveWorkflow(this.workflow);
                    functionPropertyPanel.showToasterOnChanged();
                }
                AbstractBreezeFunction abstractBreezeFunction = this.functionNode.getFunction();
                ItemListener[] itemListenerArray = this.outputComboBox.removeAllItemListeners();
                this.outputComboBox.removeAllItems();
                for (String object : abstractBreezeFunction.getOutputList()) {
                    this.outputComboBox.addItem(object);
                }
                this.outputComboBox.addItemListeners(itemListenerArray);
                if (this.outputComboBox.getItemCount() > 1 && abstractBreezeFunction.showOutputs()) {
                    FunctionTreeNode functionTreeNode = this.functionNode;
                    if (functionTreeNode instanceof DescriptorTreeNode) {
                        DescriptorTreeNode descriptorTreeNode = (DescriptorTreeNode)functionTreeNode;
                        this.outputComboBox.setSelectedItem(abstractBreezeFunction.getOutputString(descriptorTreeNode.getIndex()));
                    }
                    this.parametersSection.addComponentHorizontal(this.outputComboBox);
                }
            }
            this.parametersSection.update();
            this.parametersSection.hideIfEmpty();
        }

        private static boolean canChangeAlias(FunctionTreeNode functionTreeNode) {
            return functionTreeNode != null && !(functionTreeNode.getFunction() instanceof NoneEvaluate);
        }
    }
}

