/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.play;

import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.FactorList;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationPort;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.EvaluationTree;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionHelper;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeList;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeListMap;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.AbstractModelDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredClassificationDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredQuantificationDescriptor;
import se.prediktera.breeze.common.realtime.segmentation.spatial.GridInsetsSegmentation;
import se.prediktera.breeze.common.realtime.segmentation.spatial.RepresentativeSegmentation;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.workflow.VisualisationNode;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.pp.PostProcessingPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.main.play.GraphOverviewPanel;
import se.prediktera.breeze.frontend.main.play.WorkflowMainPanel;
import se.prediktera.breeze.frontend.main.play.WorkflowOverviewPanel;
import se.prediktera.breeze.frontend.main.play.group.PlayGroupPanel;
import se.prediktera.breeze.frontend.main.play.group.panel.PostProcessingPlayPanel;
import se.prediktera.breeze.frontend.main.record.panel.EditMeasurementTableInteraction;
import se.prediktera.breeze.frontend.main.record.panel.GroupExplorePanel;

public class PlayWorkflowPanel
extends WorkflowMainPanel {
    public PlayWorkflowPanel(BreezeProgress breezeProgress, BreezeFrame breezeFrame) {
        this(breezeProgress, breezeFrame, null);
    }

    public PlayWorkflowPanel(BreezeProgress breezeProgress, BreezeFrame breezeFrame, Workflow workflow) {
        super(breezeFrame, BreezeType.Workflow);
        ArrayList<ViewClass> arrayList = new ArrayList<ViewClass>();
        arrayList.add(new ViewClass("Overview", new WorkflowOverviewPanel(this)));
        arrayList.add(new ViewClass("Table", new EditMeasurementTableInteraction(this, null)));
        arrayList.add(new ViewClass("Analyse Tree", new GraphOverviewPanel(this, null)));
        arrayList.add(new ViewClass("Explore", new GroupExplorePanel(breezeProgress, this, null)));
        arrayList.add(new ViewClass("Import / Export", new PostProcessingPlayPanel(this, PostProcessingPanel.BreezeLevel.Workflow)));
        this.setLists(arrayList, BreezeMasterCache.getInstance().getWorkflowList(), "Workflow_big");
        this.setStudyContext(workflow);
    }

    @Override
    protected Entry createEntryLocal(Entry entry, String string) {
        Workflow workflow = new Workflow(string, WorkspaceManager.getInstance().getWorkspace().getPlayPath());
        FunctionTreeListMap functionTreeListMap = workflow.getContextHolder();
        FunctionTreeList functionTreeList = functionTreeListMap.getFunctionTreeList("workflow");
        EvaluationTree evaluationTree = new EvaluationTree();
        functionTreeList.addChild(evaluationTree);
        Workflow workflow2 = this.getStudyContext();
        if (workflow2 != null) {
            this.createWorkflowFromStudyContext(workflow2, workflow);
            VisualisationNode visualisationNode = workflow.getVisualisationNode();
            visualisationNode.addLimit(visualisationNode.createLimitFromModel(BreezeProgressManager.createEmpty(), "Default"));
            workflow.setMaxLines(workflow2.getMaxLines());
            workflow.setColorScale(workflow2.getColorScale());
            workflow.setReferenceConvertTo(workflow2.getReferenceConvertTo());
            workflow.setImageHistogramPerctage(workflow2.getImageHistogramPerctage());
            workflow.setImageHistogramBucketSize(workflow2.getImageHistogramBucketSize());
            workflow.setImageHistogramNormalizeMin(workflow2.getImageHistogramNormalizeMin());
            workflow.setImageHistogramStrechAll(workflow2.getImageHistogramStrechAll());
            workflow.setImageHistogramRange(workflow2.getImageHistogramRange());
        } else {
            evaluationTree.setRoot(FunctionHelper.createDefaultFunction("None"));
        }
        workflow.save();
        workflow.createDefaultGroup();
        return workflow;
    }

    private void createWorkflowFromStudyContext(Workflow workflow, Workflow workflow2) {
        workflow2.setStudyId(workflow.getUid());
        FunctionTreeNode functionTreeNode = workflow.getRoot().clone(true);
        this.filterSegmentations(functionTreeNode);
        workflow2.getAnalyseTree().setRoot(functionTreeNode);
        List<DescriptorTreeNode> list = functionTreeNode.getAllDescriptorNodes();
        if (!this.hasAnalyse(list)) {
            SegmentationNode segmentationNode = SegmentationNode.getLastSegmentationNode(functionTreeNode);
            if (segmentationNode != null) {
                this.addModelDescriptorsToNode(list, segmentationNode.getDefaultPort());
            } else {
                this.addModelDescriptorsToNode(list, functionTreeNode);
            }
        }
        workflow2.getVisualisationNode().setDefaultLevel(true, true);
    }

    private boolean hasAnalyse(List<DescriptorTreeNode> list) {
        for (DescriptorTreeNode descriptorTreeNode : list) {
            if (descriptorTreeNode.getAnalyse() == null) continue;
            return true;
        }
        return false;
    }

    private void filterSegmentations(FunctionTreeNode functionTreeNode) {
        if (this.shouldFilter(functionTreeNode)) {
            functionTreeNode.getParent().removeChild(functionTreeNode);
        } else {
            for (FunctionTreeNode functionTreeNode2 : new ArrayList<FunctionTreeNode>(functionTreeNode.getChildList())) {
                this.filterSegmentations(functionTreeNode2);
            }
        }
    }

    private boolean shouldFilter(FunctionTreeNode functionTreeNode) {
        AbstractBreezeFunction abstractBreezeFunction = functionTreeNode.getFunction();
        if (abstractBreezeFunction instanceof RepresentativeSegmentation || abstractBreezeFunction instanceof GridInsetsSegmentation) {
            SegmentationPort segmentationPort = ((SegmentationNode)functionTreeNode).getDefaultPort();
            return segmentationPort.getChildCount() == 0;
        }
        return false;
    }

    private void addModelDescriptorsToNode(List<DescriptorTreeNode> list, FunctionTreeNode functionTreeNode) {
        for (BasicAnalyse basicAnalyse : BreezeMasterCache.getInstance().getAnalyseList()) {
            if (!this.contextFilter.matches(basicAnalyse) || this.hasAnalyse(list, basicAnalyse)) continue;
            BasicAnalyse.ModelMethod modelMethod = basicAnalyse.getModelMethod();
            FactorList factorList = basicAnalyse.getFactorList();
            if (factorList == null) continue;
            for (Factor factor : factorList) {
                FunctionTreeNode functionTreeNode2 = null;
                if (modelMethod.isClassification()) {
                    functionTreeNode2 = FunctionHelper.createNew(new PlsPredClassificationDescriptor.Info());
                } else if (modelMethod.isQuantification()) {
                    functionTreeNode2 = FunctionHelper.createNew(new PlsPredQuantificationDescriptor.Info());
                }
                AbstractModelDescriptor abstractModelDescriptor = (AbstractModelDescriptor)functionTreeNode2.getFunction();
                abstractModelDescriptor.setAnalyse(basicAnalyse);
                abstractModelDescriptor.setFactor(factor);
                functionTreeNode.addChild(functionTreeNode2);
            }
            return;
        }
    }

    private boolean hasAnalyse(List<DescriptorTreeNode> list, BasicAnalyse basicAnalyse) {
        for (DescriptorTreeNode descriptorTreeNode : list) {
            if (!basicAnalyse.equals(descriptorTreeNode.getAnalyse())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected BreezeMainPanel createOpenPanel(BreezeProgress breezeProgress, Object object) {
        return new PlayGroupPanel(breezeProgress, this.frame, (Workflow)object);
    }

    @Override
    public String getEntryName() {
        return "Workflow";
    }

    @Override
    public String getNextEntryName() {
        Workflow workflow = this.getStudyContext();
        if (workflow != null) {
            return workflow.getName();
        }
        return super.getNextEntryName();
    }
}

