/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.play;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.main.record.RecordWorkflowPanel;
import se.prediktera.breeze.util.ZipManager;
import se.prediktera.map.common.connection.Url;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.register.RegInfo;
import se.prediktera.map.register.RegisterKeyManager;

public class TutorialManager {
    public static void download(final RecordWorkflowPanel recordWorkflowPanel, final TutorialData tutorialData, final TutorialCallback tutorialCallback) {
        if (recordWorkflowPanel.getEntryList().getNodeByName(tutorialData.getWorkflowName()) != null) {
            throw new ErrorHandler.InformationMessageException(tutorialData.getWorkflowName() + " tutorial is already downloaded");
        }
        BreezeProgressDialog.startProgressWithCancel(recordWorkflowPanel.getFrame(), new ProgressAction(){

            @Override
            public void runAction() throws Exception {
                this.setInfoText("Checking " + String.valueOf(tutorialData));
                WorkspaceManager.Workspace workspace = WorkspaceManager.getInstance().getWorkspace();
                File file = new File(workspace.getDownloadPath(), tutorialData.getFilename() + ".zip");
                if (tutorialData.validFile(file)) {
                    this.unpackFile(recordWorkflowPanel, tutorialData, tutorialCallback, workspace, file);
                } else {
                    this.setInfoText("Downloading " + String.valueOf(tutorialData));
                    if (UpdateHelper.download((ProgressManager)this.getProgressManager(), (Url)tutorialData.getUrl(), (File)file, (int)tutorialData.getSize())) {
                        this.unpackFile(recordWorkflowPanel, tutorialData, tutorialCallback, workspace, file);
                    } else {
                        FileUtils.deleteQuietly((File)file);
                    }
                }
            }

            private void unpackFile(RecordWorkflowPanel recordWorkflowPanel2, TutorialData tutorialData2, TutorialCallback tutorialCallback2, WorkspaceManager.Workspace workspace, File file) {
                Workflow workflow = this.getOrCreateWorkflow(recordWorkflowPanel2, tutorialData2.getWorkflowName());
                this.setInfoText("Unpacking " + String.valueOf(tutorialData2));
                ZipManager zipManager = new ZipManager(file);
                zipManager.extractAll(this.getProgressManager(), workspace.getPath(), true);
                if (tutorialData2.useWorkflow()) {
                    workflow = new Workflow(workflow.getFolder());
                    workflow.getEntryData().setCreatedDate(new Date());
                }
                workflow.clearChildList();
                recordWorkflowPanel2.addEntry(workflow);
                workflow.save();
                tutorialCallback2.downloadComplete(workflow);
            }

            private Workflow getOrCreateWorkflow(RecordWorkflowPanel recordWorkflowPanel2, String string) {
                for (Object e : recordWorkflowPanel2.getEntryList().getList()) {
                    Workflow workflow = (Workflow)e;
                    if (!workflow.getName().equals(string)) continue;
                    return workflow;
                }
                return Workflow.createWorkflow(string);
            }
        }, "Tutorial data");
    }

    public static List<TutorialData> getTutorials() {
        return Arrays.asList(new TutorialData.PowderTutorialData(), new TutorialData.NutsTutorialData(), new TutorialData.PlasticTutorialData(), new TutorialData.DrillCoreData(), new TutorialData.PeruMosaicTutorialData(), new TutorialData.FieldData());
    }

    public static abstract class TutorialData {
        private final String name;
        private final String filename;
        private final String workflowName;

        private TutorialData(String string, String string2) {
            this.name = string;
            this.workflowName = string2;
            this.filename = string2;
        }

        public abstract int getSize();

        public abstract long getCRC();

        public abstract String getHelpSite();

        public boolean validFile(File file) {
            if (file.exists()) {
                long l;
                long l2 = FileUtils.checksumCRC32((File)file);
                if (l2 == (l = this.getCRC())) {
                    return true;
                }
                Logg.info((String)"CRC for tutorial file {} is different: {} : {}", (Object[])new Object[]{this.getFilename(), l2, l});
            }
            return false;
        }

        public Url getUrl() throws IOException {
            RegInfo regInfo = RegisterKeyManager.getRegInfo();
            int n = regInfo.ID;
            int n2 = regInfo.LID;
            return new Url(String.format("https://internal.prediktera.se/api/download?filename=%s&userid=%d&licenseid=%s", this.filename + ".zip", n, n2 == 0 ? "" : Integer.valueOf(n2)));
        }

        public String toString() {
            return this.name;
        }

        public boolean useWorkflow() {
            return false;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getFilename() {
            return this.filename;
        }

        @Generated
        public String getWorkflowName() {
            return this.workflowName;
        }

        public static class FieldData
        extends TutorialData {
            public FieldData() {
                super("Field Shapefile Classification", "Field_Shapefile_Classification");
            }

            @Override
            public int getSize() {
                return 268921699;
            }

            @Override
            public long getCRC() {
                return 3410783778L;
            }

            @Override
            public boolean useWorkflow() {
                return true;
            }

            @Override
            public String getHelpSite() {
                return "shapefile-classification";
            }
        }

        public static class DrillCoreData
        extends TutorialData {
            public DrillCoreData() {
                super("Drill Core Logging and Classification", "Drill_Core");
            }

            @Override
            public int getSize() {
                return 871084032;
            }

            @Override
            public long getCRC() {
                return 1815132078L;
            }

            @Override
            public String getHelpSite() {
                return "logging-and-classification-tutorial";
            }
        }

        public static class PeruMosaicTutorialData
        extends TutorialData {
            public PeruMosaicTutorialData() {
                super("Peru Mineral Mosaic SAM Classification", "Peru_Mineral_Mosaic");
            }

            @Override
            public int getSize() {
                return 58622416;
            }

            @Override
            public long getCRC() {
                return 3717412155L;
            }

            @Override
            public boolean useWorkflow() {
                return true;
            }

            @Override
            public String getHelpSite() {
                return "peru-mosaic";
            }
        }

        public static class PlasticTutorialData
        extends TutorialData {
            public PlasticTutorialData() {
                super("Plastic Classification", "Plastic_Classification");
            }

            @Override
            public int getSize() {
                return 70660096;
            }

            @Override
            public long getCRC() {
                return 2820050126L;
            }

            @Override
            public String getHelpSite() {
                return "plastic-classification";
            }
        }

        public static class NutsTutorialData
        extends TutorialData {
            public NutsTutorialData() {
                super("Nuts Classification", "Nuts_Classification");
            }

            @Override
            public int getSize() {
                return 127017873;
            }

            @Override
            public long getCRC() {
                return 1614094635L;
            }

            @Override
            public String getHelpSite() {
                return "nut-classification";
            }
        }

        public static class PowderTutorialData
        extends TutorialData {
            public PowderTutorialData() {
                super("Powder Quantification", "Powder_Quantification");
            }

            @Override
            public int getSize() {
                return 91269299;
            }

            @Override
            public long getCRC() {
                return 598630461L;
            }

            @Override
            public String getHelpSite() {
                return "powder-quantification";
            }
        }
    }

    public static interface TutorialCallback {
        public void downloadComplete(Workflow var1);
    }
}

