/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.play;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import se.prediktera.breeze.backend.measure.applychanges.ApplyChanges;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.FactorHolder;
import se.prediktera.breeze.common.entry.factor.FactorList;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainSwitchPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMeasurementPanel;
import se.prediktera.breeze.frontend.common.entry.LabelEntry;
import se.prediktera.breeze.frontend.common.entry.OpenEntryProgressAction;
import se.prediktera.breeze.frontend.common.pp.wizard.PPImportWorkflow;
import se.prediktera.breeze.frontend.common.pp.wizard.importdata.PPImportData;
import se.prediktera.breeze.frontend.common.swing.BreezeActionListener;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeList;
import se.prediktera.breeze.frontend.common.swing.BreezeRadioButton;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTextField;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeTogglePanel;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.util.ListHelper;
import se.prediktera.breeze.frontend.common.view.preview.MeasurementPopup;
import se.prediktera.breeze.frontend.main.play.DuplicateWorkflowHelper;
import se.prediktera.breeze.frontend.main.play.TutorialManager;
import se.prediktera.breeze.frontend.main.record.RecordGroupPanel;
import se.prediktera.breeze.frontend.main.record.RecordWorkflowPanel;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.register.RegInfo;

public class WorkflowMainPanel
extends EntryMainSwitchPanel {
    public WorkflowMainPanel(BreezeFrame breezeFrame, BreezeType breezeType) {
        super(breezeFrame, breezeType);
        this.setStatusPanel(this.createStatusPanel());
    }

    @Override
    public void rightClickOnSelected(MouseEvent mouseEvent) {
        MeasurementPopup.showMeasurementsPopup(this, this.getSelectedEntries(), mouseEvent);
    }

    @Override
    protected Entry duplicateEntry(BreezeProgressManager breezeProgressManager, Object object, String string, boolean bl, boolean bl2) {
        return DuplicateWorkflowHelper.duplicateWorkflow(breezeProgressManager, object, string, bl, bl2);
    }

    @Override
    protected void createLocal() {
        WorkflowMainPanel.showNewDialog(this, 0);
    }

    public static void showNewDialog(final WorkflowMainPanel workflowMainPanel, int n) {
        ArrayList<BreezeTogglePanel.ToggleItem> arrayList = new ArrayList<BreezeTogglePanel.ToggleItem>();
        arrayList.add(new BreezeTogglePanel.ToggleItem("New", "Create new empty " + workflowMainPanel.getEntryName(), "material/add_circle"));
        if (workflowMainPanel instanceof RecordWorkflowPanel) {
            if (RegInfo.isApplicationFeature()) {
                arrayList.add(new BreezeTogglePanel.ToggleItem("Import Images", "Create new " + workflowMainPanel.getEntryName() + " and import external images", "material/photo_library"));
                arrayList.add(new BreezeTogglePanel.ToggleItem("Import Project", "Import Project with recorded measurements, connected models and workflows", "material/archive"));
                arrayList.add(new BreezeTogglePanel.ToggleItem<TutorialManager.TutorialData>("Tutorial", "Download tutorial data to new Project\n\nNo Internet connection? Read more, and manually download tutorial data from:\nhttps://help.prediktera.com/breeze/tutorials", "Name", "material/menu_book", TutorialManager.getTutorials()));
            }
        } else {
            arrayList.add(new BreezeTogglePanel.ToggleItem("Import Images", "Create new " + workflowMainPanel.getEntryName() + ", import external data and apply the workflow to it", "material/download_2"));
            Workflow workflow = workflowMainPanel.getStudyContext();
            if (workflow != null) {
                arrayList.add(new ToggleItemRecordData("Record Data", "Import Record group image data into new " + workflowMainPanel.getEntryName() + " and apply changes", "Group", workflow.getChildList()));
            }
        }
        BreezeOptionDialog.showDialog(workflowMainPanel.getFrame(), workflowMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.CANCEL_OPTION, "New " + workflowMainPanel.getEntryName(), "", (AbstractBreezeCustomPanel)new BreezeTogglePanel(arrayList, workflowMainPanel.getPageType(), EntryMainHelper.getUniqueName(workflowMainPanel.getNextEntryName(), workflowMainPanel.getEntryList().getList()), (breezeTogglePanel, toggleItem) -> {
            breezeTogglePanel.setName(toggleItem.getName());
            breezeTogglePanel.getNameInputField().setEnabled(!toggleItem.getName().equals("Import Project") && !toggleItem.getName().equals("Tutorial"));
        }, n), null, new BreezeActionListener(){

            @Override
            public void actionPerformed(BreezeActionListener.BreezeActionEvent breezeActionEvent) {
                BreezeTogglePanel.ToggleItem toggleItem = (BreezeTogglePanel.ToggleItem)breezeActionEvent.result();
                BreezeTogglePanel breezeTogglePanel = (BreezeTogglePanel)breezeActionEvent.getBreezeCustomPanel();
                if (toggleItem.getName().equals("Tutorial")) {
                    TutorialManager.download((RecordWorkflowPanel)workflowMainPanel, (TutorialManager.TutorialData)breezeTogglePanel.getType(), workflow -> SwingUtilities.invokeLater(() -> {
                        workflowMainPanel.selectTab("Table");
                        workflowMainPanel.setDirty(true);
                    }));
                } else if (toggleItem.getName().equals("Import Project")) {
                    BreezeProgressDialog.startProgress(workflowMainPanel.getFrame(), new OpenEntryProgressAction.OpenEntryDialogProgressAction(this, workflowMainPanel.getFrame()){

                        @Override
                        protected BreezeMainPanel createOpenPanel() {
                            return new PPImportWorkflow(workflowMainPanel, "Import Project", BreezeMasterCache.getInstance());
                        }
                    }, "Opening...");
                    workflowMainPanel.showFirstTab();
                } else {
                    Workflow workflow2 = (Workflow)workflowMainPanel.createEntryLocal(null, breezeTogglePanel.getInputName());
                    workflowMainPanel.addEntry(workflow2);
                    final Group group = workflow2.getChild(0);
                    if (toggleItem.getName().equals("Import Images")) {
                        BreezeProgressDialog.startProgress(workflowMainPanel.getFrame(), new OpenEntryProgressAction.OpenEntryDialogProgressAction(this, workflowMainPanel.getFrame()){

                            @Override
                            protected BreezeMainPanel createOpenPanel() {
                                return new PPImportData(workflowMainPanel, "Import Images", group);
                            }
                        }, "Opening...");
                        workflowMainPanel.showFirstTab();
                    } else if (toggleItem.getName().equals("Record Data")) {
                        workflowMainPanel.selectTab("Table");
                        this.copyDataAndApplyChanges(workflow2, (Group)breezeTogglePanel.getType(), !((ToggleItemRecordData)toggleItem).includeFactors());
                    } else {
                        workflowMainPanel.showFirstTab();
                    }
                }
            }

            private void copyDataAndApplyChanges(final Workflow workflow, final Group group, final boolean bl) {
                BreezeProgressDialog.startProgressWithCancel(workflowMainPanel.getFrame(), new ProgressAction(this){

                    @Override
                    public void runAction() throws Exception {
                        this.setInfoText("Copying data from Record to Play");
                        Group group2 = workflow.getChild(0);
                        FileUtils.copyDirectory((File)group.getFolder(), (File)group2.getFolder());
                        workflow.clearChildList();
                        workflow.getFactorHolder().addFactors(group.getParent().getFactorHolder());
                        List<Measurement> list = workflow.getAllMeasurements();
                        if (!list.isEmpty()) {
                            ApplyChanges.applyChanges((BreezeProgress)this.getProgressManager(), list);
                            if (bl) {
                                workflowMainPanel.removeAllFactors(workflow, workflow.getFactorHolder());
                            }
                        }
                        workflow.save();
                        workflowMainPanel.setDirty(true);
                    }
                }, "Apply changes");
            }
        });
    }

    public void removeAllFactors(Workflow workflow, FactorHolder factorHolder) {
        this.removeAllFactors(workflow, factorHolder.getCategoryFactors());
        this.removeAllFactors(workflow, factorHolder.getPropertyFactors());
    }

    private void removeAllFactors(Workflow workflow, FactorList factorList) {
        Iterator iterator = factorList.iterator();
        while (iterator.hasNext()) {
            Factor factor = (Factor)iterator.next();
            iterator.remove();
            WorkflowMainPanel.removeFactorFromSamples(workflow, factor);
        }
    }

    public static void removeFactorFromSamples(Workflow workflow, Factor factor) {
        for (Group group : workflow.getChildList()) {
            for (Measurement measurement : group.getChildList()) {
                measurement.getRootSample().forEverySample(basicSample -> basicSample.getSampleValues().removeValue(factor));
                measurement.save();
            }
        }
    }

    public static void getEmptyGroupOrCreateNew(BreezeMainPanel breezeMainPanel, Workflow workflow, String string, WorkflowGroupCallback workflowGroupCallback) {
        if (workflow == null) {
            throw new ErrorHandler.InformationMessageException("No workflow selected");
        }
        List<Group> list = workflow.getChildList();
        Color color = breezeMainPanel.getPageColor();
        BreezeFrame breezeFrame = breezeMainPanel.getFrame();
        if (list.isEmpty()) {
            BreezeOptionDialog.showDialog(breezeFrame, color, AbstractBreezeDialog.MessageType.INPUT_OPTION, string + " into new Group", "Enter name for the new Group:", EntryMainHelper.getUniqueName("Group", list), breezeActionEvent -> {
                Group group = new Group(breezeActionEvent.getInputText(), workflow);
                group.save();
                list.add(group);
                workflowGroupCallback.perform(group);
            });
        } else if (list.size() == 1 && list.get(0).getChildCount() == 0) {
            workflowGroupCallback.perform(list.get(0));
        } else {
            BreezeOptionDialog.showDialog(breezeFrame, color, AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Select Group", "", (AbstractBreezeCustomPanel)new SelectOrCreateGroupPanel(workflow), null, breezeActionEvent -> {
                SelectOrCreateGroupPanel selectOrCreateGroupPanel = (SelectOrCreateGroupPanel)breezeActionEvent.getBreezeCustomPanel();
                workflowGroupCallback.perform(selectOrCreateGroupPanel.getOrCreateGroup(workflow));
            });
        }
    }

    private static class ToggleItemRecordData
    extends BreezeTogglePanel.ToggleItem {
        private final BreezeCheckBox checkBox = new BreezeCheckBox("Include categories and properties values from Record", false);

        public ToggleItemRecordData(String string, String string2, String string3, List list) {
            super(string, string2, string3, "", list);
        }

        @Override
        public JComponent getCustom() {
            return this.checkBox;
        }

        public boolean includeFactors() {
            return this.checkBox.isSelected();
        }
    }

    public static interface WorkflowGroupCallback {
        public void perform(Group var1);
    }

    public static class SelectOrCreateGroupPanel
    extends AbstractBreezeCustomPanel {
        private final ButtonGroup buttonGroup = new ButtonGroup();
        final BreezeRadioButton existingGroup = new BreezeRadioButton("Select existing group:", this.buttonGroup, true);
        final BreezeRadioButton newGroup = new BreezeRadioButton("Create new group with name:", this.buttonGroup);
        private final BreezeList list = new BreezeList();
        private final BreezeTextField nameField = new BreezeTextField();
        private BreezeButton okButton;

        public SelectOrCreateGroupPanel(Workflow workflow) {
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            this.setPreferredSize(new Dimension(550, 500));
            ItemListener itemListener = itemEvent -> {
                this.list.setEnabled(this.existingGroup.isSelected());
                this.nameField.setEnabled(this.newGroup.isSelected());
                this.updateOkButton();
            };
            itemListener.itemStateChanged(null);
            this.add((Component)this.existingGroup, GridBagHelper.create(0, new Insets(0, 12, 0, 12)));
            this.existingGroup.addItemListener(itemListener);
            this.list.setBackground(BreezeTheme.getInstance().getDialogBackground());
            this.list.setSelectionMode(0);
            this.list.setCellRenderer(new LabelEntry());
            List<Group> list = workflow.getChildList();
            ListHelper.sort(list, ListHelper.SortType.Created, false);
            this.list.setModel(list);
            this.list.setSelectedIndex(0);
            this.list.addScroll();
            BreezeScrollPane breezeScrollPane = new BreezeScrollPane();
            breezeScrollPane.setViewportView((Component)((Object)this.list));
            this.add((Component)breezeScrollPane, GridBagHelper.create(0, this.getComponentCount(), 1.0, 1.0, 1, new Insets(0, 24, 0, 12)));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(12, 12, 0, 12);
            this.add((Component)this.newGroup, gridBagConstraints);
            this.newGroup.addItemListener(itemListener);
            this.add((Component)this.nameField, GridBagHelper.create(this.getComponentCount(), new Insets(6, 24, 24, 12)));
            this.nameField.setText(EntryMainHelper.getUniqueName("Group", workflow.getChildList()));
            this.nameField.setMinimumSize(new Dimension(100, 30));
        }

        @Override
        public boolean usePreferredSize() {
            return true;
        }

        @Override
        public void customButton(BreezeButton breezeButton, BreezeButton breezeButton2, BreezeButton breezeButton3) {
            this.okButton = breezeButton2;
            this.updateOkButton();
        }

        private void updateOkButton() {
            if (this.okButton != null) {
                this.okButton.setText(this.existingGroup.isSelected() ? "Select" : "Add");
            }
        }

        @Override
        public Object getResult() {
            return null;
        }

        public Group getOrCreateGroup(Workflow workflow) {
            return this.getOrCreateGroup(workflow, null);
        }

        public Group getOrCreateGroup(Workflow workflow, BreezeMainPanel breezeMainPanel) {
            if (this.existingGroup.isSelected()) {
                return (Group)this.list.getSelectedValue();
            }
            Group group = new Group(this.nameField.getText(), workflow);
            group.save();
            if (breezeMainPanel instanceof EntryMeasurementPanel) {
                EntryMeasurementPanel entryMeasurementPanel = (EntryMeasurementPanel)breezeMainPanel;
                entryMeasurementPanel.getGroupPanel().getEntryList().insertElement(group);
            } else if (breezeMainPanel instanceof RecordGroupPanel) {
                breezeMainPanel.getEntryList().insertElement(group);
            } else {
                workflow.insertChild(group);
            }
            return group;
        }
    }
}

