/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.play;

import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import se.prediktera.breeze.common.entry.BasicEntry;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryOverviewPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeLabelField;
import se.prediktera.breeze.frontend.common.swing.BreezeListReadOnlyField;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.BreezeTabListField;

public class WorkflowOverviewPanel
extends EntryOverviewPanel {
    private final BreezeLabelField groupLabelField;
    private final BreezeLabelField measurementLabelField;
    private final BreezeLabelField sampleLabelField;
    private final BreezeListReadOnlyField limitListField = new BreezeListReadOnlyField("Limits");
    private final BreezeListReadOnlyField segmentationListField = new BreezeListReadOnlyField("Segmentations");
    private final BreezeListReadOnlyField identifiersListField = new BreezeListReadOnlyField("Identifiers", this.getClickCallbackAddNewVariableOrId(0));
    private final BreezeListReadOnlyField propertiesListField = new BreezeListReadOnlyField("Properties", this.getClickCallbackAddNewVariableOrId(1));
    private final BreezeTabListField categoriesTabListField;
    private final BreezeButton applyChangesButton;
    private final ImageIcon folderIcon;

    public WorkflowOverviewPanel(EntryMainPanel entryMainPanel) {
        super(entryMainPanel);
        this.categoriesTabListField = new BreezeTabListField("Categories", entryMainPanel.getPageColor(), this.getClickCallbackAddNewVariableOrId(2));
        this.groupLabelField = this.addLabelField("Groups");
        this.measurementLabelField = this.addLabelField("Measurements");
        this.sampleLabelField = this.addLabelField("Samples");
        this.addComponentToField(this.limitListField);
        this.addComponentToField(this.segmentationListField);
        this.addComponentToField(this.identifiersListField);
        this.addComponentToField(this.propertiesListField);
        this.addComponentToField(this.categoriesTabListField);
        this.segmentationListField.setWidth(300);
        this.applyChangesButton = EntryMainHelper.createApplyButton(entryMainPanel);
        this.folderIcon = new ImageIcon(this.getClass().getResource("/images/" + (this.mainpanel.getPageType().equals((Object)BreezeType.Project) ? "Recordings2_big.png" : "Workflow_big.png")));
    }

    @Override
    protected void setIcon(BasicEntry basicEntry) {
        Workflow workflow;
        if (basicEntry instanceof Workflow && (workflow = (Workflow)basicEntry).getType().equals((Object)Workflow.WorkflowType.Record)) {
            this.iconPanel.setImage(this.folderIcon.getImage());
        } else {
            super.setIcon(basicEntry);
        }
    }

    @Override
    protected Image getDefaultImage() {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/images/" + (this.mainpanel.getPageType().equals((Object)BreezeType.Project) ? "Recordings2_big.png" : "Workflow_big.png")));
        return imageIcon.getImage();
    }

    @Override
    public void addComponent(BreezeMainPanel breezeMainPanel) {
        super.addComponent(breezeMainPanel);
        breezeMainPanel.addRightButton(new BreezeSeparator.Vertical());
        breezeMainPanel.addRightButton(this.applyChangesButton);
    }

    @Override
    protected void setListsToField(BasicEntry basicEntry) {
        Workflow workflow = Workflow.getWorkflow(basicEntry);
        if (basicEntry instanceof Group) {
            Group group = (Group)basicEntry;
            this.groupLabelField.setVisible(false);
            this.measurementLabelField.setValue(group.getFirstDescriptorValueByName("Measurements"));
            this.sampleLabelField.setValue(group.getFirstDescriptorValueByName("Samples"));
        } else {
            this.groupLabelField.setVisible(true);
            this.groupLabelField.setValue(workflow.getChildCount());
            this.measurementLabelField.setValue(this.countDescriptorValueByName(workflow, "Measurements"));
            this.sampleLabelField.setValue(this.countDescriptorValueByName(workflow, "Samples"));
        }
        this.limitListField.setList(workflow.getVisualisationNode().getLimitList());
        this.segmentationListField.setList(this.getNamesToListRecursiveByClass(workflow.getRoot(), SegmentationNode.class));
        this.identifiersListField.setList(workflow.getIdentifiers().getList());
        this.propertiesListField.setList(workflow.getPropertyFactors().getList());
        this.categoriesTabListField.setList(workflow.getCategoryFactors().getList());
        this.limitListField.setVisibleIfItems();
        if (this.mainpanel.getPageType().equals((Object)BreezeType.Workflow)) {
            this.identifiersListField.setVisibleIfItems();
            this.propertiesListField.setVisibleIfItems();
            this.categoriesTabListField.setVisibleIfItems();
        }
    }

    private int countDescriptorValueByName(Workflow workflow, String string) {
        int n = 0;
        for (Group group : workflow.getChildList()) {
            n = (int)((double)n + group.getFirstDescriptorValueByName(string));
        }
        return n;
    }

    private List<String> getNamesToListRecursiveByClass(FunctionTreeNode functionTreeNode, Class clazz) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.addNamesToListRecursiveByClass(functionTreeNode, arrayList, clazz);
        return arrayList;
    }

    private void addNamesToListRecursiveByClass(FunctionTreeNode functionTreeNode, List<String> list, Class clazz) {
        if (functionTreeNode.getClass().isAssignableFrom(clazz)) {
            list.add(functionTreeNode.getAliasOrNodeString());
        }
        for (FunctionTreeNode functionTreeNode2 : functionTreeNode.getChildList()) {
            this.addNamesToListRecursiveByClass(functionTreeNode2, list, clazz);
        }
    }
}

