/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.play.edit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import lombok.Generated;
import se.prediktera.breeze.backend.measure.applychanges.ApplyChanges;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationPort;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionHelper;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.workflow.BasicWorkflow;
import se.prediktera.breeze.common.realtime.descriptor.parameter.OptionParameter;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.common.BreezeTextComponentAncestor;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntrySettingsPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.BreezeTextField;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.main.play.GraphOverviewPanel;
import se.prediktera.breeze.frontend.main.play.edit.EditDescriptorHelper;
import se.prediktera.breeze.frontend.main.play.edit.EditWorkflowPanel;
import se.prediktera.breeze.frontend.main.play.edit.FunctionPropertyPanel;
import se.prediktera.breeze.frontend.main.record.edit.common.EditBreezeList;

public class EditDescriptorPanel
extends AbstractViewPanel
implements BreezeTextComponentAncestor {
    private FunctionTreeNode functionNode;
    private final EditWorkflowPanel editPanel;
    private boolean settingdata = false;
    private final BreezeButton duplicateButton;
    private final BreezeButton addSubNodeButton;
    private final BreezeButton levelUpButton;
    private final BreezeButton levelDownButton;
    private BreezeButton applyChangesButton = null;
    private final DescriptorListCellRenderer descriptorListCellRenderer = new DescriptorListCellRenderer();
    private final List<AbstractBreezeFunctionInfo> exportInfoList;
    private final Workflow workflow;
    private FunctionPropertyPanel functionPropertyPanel;
    private final BreezeButton helpButton;
    private JLabel aliasLabel;
    private BreezeTextField aliasTextField;
    private JPanel centerEditPanel;
    private JPanel emptyPanel;
    private BreezeButton expandInputButton;
    private BreezeButton expandOutputButton;
    private BreezeComboBox functionComboBox;
    private BreezeComboBox inputComboBox;
    private JLabel inputLabel;
    private JPanel inputPanel;
    private JSeparator inputSeparator;
    private JLabel nameLabel;
    private BreezeComboBox outputComboBox;
    private JLabel outputLabel;
    private JPanel outputPanel;
    private JSeparator outputSeparator;
    private JLabel parametersLabel;
    private JPanel propertyPanel;
    private BreezeComboBoxInputField sampleInputField;
    private BreezeScrollPane scrollPane;
    private BreezeComboBox typeComboBox;
    private JLabel typeLabel;

    public EditDescriptorPanel(EditWorkflowPanel editWorkflowPanel, final Workflow workflow) {
        super(editWorkflowPanel);
        this.editPanel = editWorkflowPanel;
        this.workflow = workflow;
        this.initComponents();
        this.exportInfoList = FunctionHelper.getFunctionsSorted();
        this.inputComboBox.setRenderer(new InputListCellRenderer());
        this.setInputCollapsed(true);
        this.typeComboBox.setRenderer(this.descriptorListCellRenderer);
        this.typeComboBox.addItem((Object)AbstractBreezeFunctionInfo.FunctionType.Segmentation);
        this.typeComboBox.addItem((Object)AbstractBreezeFunctionInfo.FunctionType.Descriptor);
        if (BreezeFrame.development) {
            this.typeComboBox.addItem((Object)AbstractBreezeFunctionInfo.FunctionType.Evaluate);
        }
        this.typeComboBox.addItem((Object)AbstractBreezeFunctionInfo.FunctionType.Action);
        this.functionComboBox.setRenderer(this.descriptorListCellRenderer);
        this.outputComboBox.setRenderer(this.descriptorListCellRenderer);
        this.sampleInputField.addItem("true");
        this.sampleInputField.addItem("false");
        this.populateFunctions();
        this.aliasTextField.addChangeListener(textActionEvent -> {
            String string = this.aliasTextField.getText();
            this.functionNode.setAlias(!string.isEmpty() ? string : null);
            editWorkflowPanel.refreshListAndUpdateTitleFromEntry(this.functionNode);
            workflow.save();
        });
        this.aliasTextField.setName("alias");
        this.duplicateButton = EntryMainHelper.createButton("functionDuplicate", "Duplicate", "material/content_copy", () -> {
            FunctionTreeNode functionTreeNode = this.functionNode.clone(false);
            this.functionNode.getParent().addChild(functionTreeNode);
            editWorkflowPanel.selectEntry(functionTreeNode);
            EditDescriptorHelper.resetAndSaveWorkflow(workflow);
        });
        this.addSubNodeButton = EntryMainHelper.createButton("functionAdd", "Add sub-node", "material/add", () -> {
            FunctionTreeNode functionTreeNode = FunctionHelper.createDefault(this.mainpanel.getPageType());
            if (this.functionNode instanceof SegmentationNode) {
                ((SegmentationNode)this.functionNode).getDefaultPort().addChild(functionTreeNode);
            } else {
                this.functionNode.addChild(functionTreeNode);
            }
            EditDescriptorHelper.copyDescriptorParametersFromParent(functionTreeNode);
            editWorkflowPanel.selectEntry(EditBreezeList.BreezeListType.AnalyseTree, functionTreeNode);
            EditDescriptorHelper.resetAndSaveWorkflow(workflow);
        });
        this.levelUpButton = EntryMainHelper.createButton("functionLevelUp", "Level up", "material/arrow_back", () -> {
            Object[] objectArray;
            for (Object object : objectArray = editWorkflowPanel.getList(EditBreezeList.BreezeListType.AnalyseTree).getSelectedValues()) {
                EditDescriptorHelper.changeParent((FunctionTreeNode)object, EditDescriptorHelper.getParent((FunctionTreeNode)object));
            }
            editWorkflowPanel.selectEntry(null);
            editWorkflowPanel.selectEntries(EditBreezeList.BreezeListType.AnalyseTree, objectArray);
            EditDescriptorHelper.resetAndSaveWorkflow(workflow);
        });
        this.levelDownButton = EntryMainHelper.createButton("functionLevelDown", "Level down", "material/arrow_forward", () -> {
            Object[] objectArray;
            for (Object object : objectArray = editWorkflowPanel.getList(EditBreezeList.BreezeListType.AnalyseTree).getSelectedValues()) {
                EditDescriptorHelper.changeParent((FunctionTreeNode)object, EditDescriptorHelper.getNext((FunctionTreeNode)object));
            }
            editWorkflowPanel.selectEntry(null);
            editWorkflowPanel.selectEntries(EditBreezeList.BreezeListType.AnalyseTree, objectArray);
            EditDescriptorHelper.resetAndSaveWorkflow(workflow);
        });
        this.applyChangesButton = EntryMainHelper.createApplyButton(editWorkflowPanel, new ProgressAction(this){

            @Override
            public void runAction() throws Exception {
                List<Measurement> list = workflow.getAllMeasurements();
                if (!list.isEmpty()) {
                    ApplyChanges.applyChanges((BreezeProgress)this.getProgressManager(), list);
                }
            }
        });
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.setBackground(breezeTheme.getPanelBackground());
        this.centerEditPanel.setBackground(breezeTheme.getPanelBackground());
        this.scrollPane.getViewport().setBackground(breezeTheme.getPanelBackground());
        this.helpButton = EntryMainHelper.createButton("", "help", () -> AbstractBreezeFunctionInfo.showHelpOnline((AbstractBreezeFunctionInfo)this.functionComboBox.getSelectedItem()));
        GridBagConstraints gridBagConstraints = GridBagHelper.createWithWeigthX1(0, new Insets(0, 10, 0, 10));
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.centerEditPanel.add((Component)this.helpButton, gridBagConstraints);
    }

    @Override
    public EntrySettingsPanel.SettingsComponent getRightSettingsPanel(EntrySettingsPanel entrySettingsPanel) {
        return super.getRightSettingsPanel(entrySettingsPanel);
    }

    private void populateFunctions() {
        AbstractBreezeFunctionInfo.FunctionType functionType = (AbstractBreezeFunctionInfo.FunctionType)((Object)this.typeComboBox.getSelectedItem());
        this.functionComboBox.removeAllItems();
        for (AbstractBreezeFunctionInfo abstractBreezeFunctionInfo : this.exportInfoList) {
            if (!abstractBreezeFunctionInfo.isVisibleInList() || !abstractBreezeFunctionInfo.getType().equals((Object)functionType) || !abstractBreezeFunctionInfo.support(this.mainpanel.getPageType())) continue;
            this.functionComboBox.addItem(abstractBreezeFunctionInfo);
        }
    }

    @Override
    public void addComponent(BreezeMainPanel breezeMainPanel) {
        super.addComponent(breezeMainPanel);
        breezeMainPanel.addRightButton(this.duplicateButton);
        breezeMainPanel.addRightButton(this.addSubNodeButton);
        breezeMainPanel.addRightButton(new BreezeSeparator.Vertical());
        breezeMainPanel.addRightButton(this.levelUpButton);
        breezeMainPanel.addRightButton(this.levelDownButton);
        breezeMainPanel.addRightButton(new BreezeSeparator.Vertical());
        breezeMainPanel.addRightButton(this.applyChangesButton);
    }

    @Override
    public String getType() {
        return "Descriptors";
    }

    @Override
    public void showEntry(Object object, Object object2) {
        this.settingdata = true;
        if (object instanceof FunctionTreeNode) {
            Object object3;
            this.functionNode = (FunctionTreeNode)object;
            this.addSubNodeButton.setEnabled(this.functionNode.isManualAdd());
            this.duplicateButton.setEnabled(this.functionNode.isDuplicate());
            this.levelUpButton.setEnabled(this.functionNode.isDuplicate());
            this.levelDownButton.setEnabled(this.functionNode.isDuplicate());
            this.addAllPossibleParents(this.functionNode);
            AbstractBreezeFunctionInfo abstractBreezeFunctionInfo = this.getFunctionParentIfPort(this.functionNode).getFunction().getInfo();
            this.typeComboBox.setSelectedItem((Object)abstractBreezeFunctionInfo.getType());
            this.typeComboBox.setEnabled(this.canChangeTypeOrFunction(this.functionNode));
            for (int i = 0; i < this.functionComboBox.getItemCount(); ++i) {
                object3 = (AbstractBreezeFunctionInfo)this.functionComboBox.getItemAt(i);
                if (!object3.getShortName().equals(abstractBreezeFunctionInfo.getShortName())) continue;
                this.functionComboBox.setSelectedIndex(i);
                break;
            }
            this.functionComboBox.setEnabled(this.canChangeTypeOrFunction(this.functionNode));
            String string = this.functionNode.getAlias();
            this.aliasTextField.setText(string != null ? string : "");
            object3 = this.functionNode.getFunction();
            this.setOutputs((AbstractBreezeFunction)object3);
            FunctionTreeNode functionTreeNode = this.functionNode;
            if (functionTreeNode instanceof DescriptorTreeNode) {
                DescriptorTreeNode descriptorTreeNode = (DescriptorTreeNode)functionTreeNode;
                this.outputComboBox.setSelectedItem(((AbstractBreezeFunction)object3).getOutputString(descriptorTreeNode.getIndex()));
            }
            this.sampleInputField.setVisible(false);
            this.updatePropertiesPanel();
        }
        this.settingdata = false;
    }

    private FunctionTreeNode getFunctionParentIfPort(FunctionTreeNode functionTreeNode) {
        if (functionTreeNode instanceof SegmentationPort) {
            return functionTreeNode.getParent();
        }
        return functionTreeNode;
    }

    private boolean canChangeTypeOrFunction(FunctionTreeNode functionTreeNode) {
        return !(functionTreeNode instanceof SegmentationPort);
    }

    private void addAllPossibleParents(FunctionTreeNode functionTreeNode) {
        this.inputComboBox.removeAllItems();
        this.addAllRecursive(functionTreeNode, this.workflow.getRoot());
        FunctionTreeNode functionTreeNode2 = functionTreeNode.getParent();
        this.inputComboBox.setSelectedItem(functionTreeNode2);
        this.inputComboBox.setEnabled(functionTreeNode2.isManualAdd());
    }

    private void addAllRecursive(FunctionTreeNode functionTreeNode, FunctionTreeNode functionTreeNode2) {
        if (functionTreeNode instanceof SegmentationNode && functionTreeNode2 == functionTreeNode) {
            return;
        }
        if (functionTreeNode2.isManualAdd() && functionTreeNode != functionTreeNode2) {
            if (functionTreeNode2 instanceof SegmentationPort) {
                SegmentationPort segmentationPort = (SegmentationPort)functionTreeNode2;
                if (segmentationPort.getParent() != functionTreeNode) {
                    this.inputComboBox.addItem(functionTreeNode2);
                }
            } else {
                this.inputComboBox.addItem(functionTreeNode2);
            }
        }
        for (FunctionTreeNode functionTreeNode3 : functionTreeNode2.getChildList()) {
            this.addAllRecursive(functionTreeNode, functionTreeNode3);
        }
    }

    private void updatePropertiesPanel() {
        this.propertyPanel.removeAll();
        this.functionPropertyPanel = new FunctionPropertyPanel(this.getFrame(), this.workflow, this.workflow, this.functionNode, bl -> {
            if (bl) {
                this.editPanel.selectEntry(this.functionNode);
            }
            EditDescriptorHelper.resetAndSaveWorkflow(this.workflow);
            ToastHandler.getInstance().showToast(BreezeFrame.getInstance(), "Parameter saved");
            if (bl) {
                this.updatePropertiesPanel();
            }
        }, BreezeInputFieldHelper.Format.OneRow);
        this.propertyPanel.add((Component)this.functionPropertyPanel, "Center");
        if (this.functionPropertyPanel.hasChanged() && !this.functionNode.isFresh()) {
            this.editPanel.selectEntry(this.functionNode);
            EditDescriptorHelper.resetAndSaveWorkflow(this.workflow);
        }
        this.propertyPanel.revalidate();
        this.propertyPanel.repaint();
        this.parametersLabel.setVisible(this.functionPropertyPanel.hasProperties());
    }

    private void initComponents() {
        this.scrollPane = new BreezeScrollPane();
        this.centerEditPanel = new JPanel();
        this.inputLabel = new JLabel();
        this.nameLabel = new JLabel();
        this.functionComboBox = new BreezeComboBox();
        this.parametersLabel = new JLabel();
        this.propertyPanel = new JPanel();
        this.aliasLabel = new JLabel();
        this.aliasTextField = new BreezeTextField();
        this.typeLabel = new JLabel();
        this.typeComboBox = new BreezeComboBox();
        this.outputLabel = new JLabel();
        this.emptyPanel = new JPanel();
        this.outputSeparator = new JSeparator();
        this.inputPanel = new JPanel();
        this.inputComboBox = new BreezeComboBox();
        this.expandInputButton = new BreezeButton();
        this.outputPanel = new JPanel();
        this.outputComboBox = new BreezeComboBox();
        this.sampleInputField = new BreezeComboBoxInputField();
        this.inputSeparator = new JSeparator();
        this.expandOutputButton = new BreezeButton();
        this.setBackground(new Color(51, 51, 51));
        this.setLayout(new BorderLayout());
        this.scrollPane.setBackground(new Color(255, 255, 255));
        this.scrollPane.setBorder(null);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.centerEditPanel.setBackground(new Color(255, 255, 255));
        this.centerEditPanel.setLayout(new GridBagLayout());
        this.inputLabel.setFont(new Font("Tahoma", 0, 14));
        this.inputLabel.setForeground(new Color(255, 255, 255));
        this.inputLabel.setText("Input");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 40, 0, 0);
        this.centerEditPanel.add((Component)this.inputLabel, gridBagConstraints);
        this.nameLabel.setFont(new Font("Tahoma", 0, 14));
        this.nameLabel.setForeground(new Color(255, 255, 255));
        this.nameLabel.setText("Method");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 40, 0, 0);
        this.centerEditPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.functionComboBox.setName("functionComboBox");
        this.functionComboBox.addItemListener(itemEvent -> this.functionComboBoxItemStateChanged(itemEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 40, 10, 40);
        this.centerEditPanel.add((Component)this.functionComboBox, gridBagConstraints);
        this.parametersLabel.setFont(new Font("Tahoma", 0, 18));
        this.parametersLabel.setForeground(new Color(255, 255, 255));
        this.parametersLabel.setText("Parameters");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 40, 0, 0);
        this.centerEditPanel.add((Component)this.parametersLabel, gridBagConstraints);
        this.propertyPanel.setOpaque(false);
        this.propertyPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(10, 60, 0, 40);
        this.centerEditPanel.add((Component)this.propertyPanel, gridBagConstraints);
        this.aliasLabel.setFont(new Font("Tahoma", 0, 14));
        this.aliasLabel.setForeground(new Color(255, 255, 255));
        this.aliasLabel.setText("Alias (Optional)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 40, 0, 0);
        this.centerEditPanel.add((Component)this.aliasLabel, gridBagConstraints);
        this.aliasTextField.setName("functionAlias");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 40, 10, 40);
        this.centerEditPanel.add((Component)this.aliasTextField, gridBagConstraints);
        this.typeLabel.setFont(new Font("Tahoma", 0, 14));
        this.typeLabel.setForeground(new Color(255, 255, 255));
        this.typeLabel.setText("Node type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 40, 0, 0);
        this.centerEditPanel.add((Component)this.typeLabel, gridBagConstraints);
        this.typeComboBox.setName("typeComboBox");
        this.typeComboBox.addItemListener(itemEvent -> this.typeComboBoxItemStateChanged(itemEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 40, 10, 40);
        this.centerEditPanel.add((Component)this.typeComboBox, gridBagConstraints);
        this.outputLabel.setFont(new Font("Tahoma", 0, 14));
        this.outputLabel.setForeground(new Color(255, 255, 255));
        this.outputLabel.setText("Output");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 40, 0, 0);
        this.centerEditPanel.add((Component)this.outputLabel, gridBagConstraints);
        this.emptyPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.centerEditPanel.add((Component)this.emptyPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 20, 10, 20);
        this.centerEditPanel.add((Component)this.outputSeparator, gridBagConstraints);
        this.inputPanel.setOpaque(false);
        this.inputPanel.setLayout(new GridBagLayout());
        this.inputComboBox.setName("functionInput");
        this.inputComboBox.addItemListener(itemEvent -> this.inputComboBoxItemStateChanged(itemEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 40, 10, 40);
        this.inputPanel.add((Component)this.inputComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.centerEditPanel.add((Component)this.inputPanel, gridBagConstraints);
        this.expandInputButton.setIcon(new ImageIcon(this.getClass().getResource("/images/expand_more.png")));
        this.expandInputButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                EditDescriptorPanel.this.expandInputButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(14, 12, 0, 0);
        this.centerEditPanel.add((Component)this.expandInputButton, gridBagConstraints);
        this.outputPanel.setOpaque(false);
        this.outputPanel.setLayout(new GridBagLayout());
        this.outputComboBox.setName("functionAlias");
        this.outputComboBox.addItemListener(itemEvent -> this.outputComboBoxItemStateChanged(itemEvent));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 40, 10, 40);
        this.outputPanel.add((Component)this.outputComboBox, gridBagConstraints);
        this.sampleInputField.setDescription("Add samples");
        this.sampleInputField.setFormat(BreezeInputFieldHelper.Format.TwoRows);
        this.sampleInputField.setLabelForeground(new Color(240, 240, 240));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 40, 10, 40);
        this.outputPanel.add((Component)this.sampleInputField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        this.centerEditPanel.add((Component)this.outputPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 20, 10, 20);
        this.centerEditPanel.add((Component)this.inputSeparator, gridBagConstraints);
        this.expandOutputButton.setIcon(new ImageIcon(this.getClass().getResource("/images/expand_less.png")));
        this.expandOutputButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                EditDescriptorPanel.this.expandOutputButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(24, 12, 0, 0);
        this.centerEditPanel.add((Component)this.expandOutputButton, gridBagConstraints);
        this.scrollPane.setViewportView(this.centerEditPanel);
        this.add(this.scrollPane, "Center");
    }

    private void expandOutputButtonMouseClicked(MouseEvent mouseEvent) {
        this.setOutputCollapsed(this.outputPanel.isVisible());
    }

    private void expandInputButtonMouseClicked(MouseEvent mouseEvent) {
        this.setInputCollapsed(this.inputPanel.isVisible());
    }

    private void setInputCollapsed(boolean bl) {
        if (bl) {
            this.inputPanel.setVisible(false);
            this.expandInputButton.setIcon(new ImageIcon(this.getClass().getResource("/images/expand_less.png")));
        } else {
            this.inputPanel.setVisible(true);
            this.expandInputButton.setIcon(new ImageIcon(this.getClass().getResource("/images/expand_more.png")));
        }
    }

    private void inputComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1 && !this.settingdata) {
            EditDescriptorHelper.changeParent(this.functionNode, (FunctionTreeNode)this.inputComboBox.getSelectedItem());
            this.editPanel.selectEntry(this.functionNode);
            EditDescriptorHelper.resetAndSaveWorkflow(this.workflow);
        }
    }

    private void typeComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.populateFunctions();
        }
    }

    private void outputComboBoxItemStateChanged(ItemEvent itemEvent) {
        FunctionTreeNode functionTreeNode;
        if (itemEvent.getStateChange() == 1 && !this.settingdata && (functionTreeNode = this.functionNode) instanceof DescriptorTreeNode) {
            DescriptorTreeNode descriptorTreeNode = (DescriptorTreeNode)functionTreeNode;
            short s = (short)this.outputComboBox.getSelectedIndex();
            if (descriptorTreeNode.getIndex() != s) {
                descriptorTreeNode.setIndex(s);
                this.editPanel.selectEntry(this.functionNode);
                EditDescriptorHelper.resetAndSaveWorkflow(this.workflow);
            }
        }
    }

    private void functionComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1 && !this.settingdata && this.functionNode != null) {
            AbstractBreezeFunctionInfo abstractBreezeFunctionInfo = (AbstractBreezeFunctionInfo)this.functionComboBox.getSelectedItem();
            AbstractBreezeFunction abstractBreezeFunction = abstractBreezeFunctionInfo.createFunction();
            if (!abstractBreezeFunction.getName().equals(this.functionNode.getFunction().getName())) {
                FunctionTreeNode functionTreeNode = abstractBreezeFunctionInfo.createNode();
                GraphOverviewPanel.GraphSettingsPanel.replaceFunctionTreeNode(abstractBreezeFunction, this.functionNode, functionTreeNode);
                this.functionNode = functionTreeNode;
                this.updatePropertiesPanel();
                if (this.functionNode instanceof SegmentationNode) {
                    ((SegmentationNode)this.functionNode).recreateSegmentationPorts(this.workflow);
                }
                this.editPanel.selectEntry(this.functionNode);
                EditDescriptorHelper.resetAndSaveWorkflow(this.workflow);
                this.setOutputs(abstractBreezeFunction);
            }
            this.updatePropertiesPanel();
        }
    }

    private void setOutputs(AbstractBreezeFunction abstractBreezeFunction) {
        this.outputComboBox.removeAllItems();
        for (String string : abstractBreezeFunction.getOutputList()) {
            this.outputComboBox.addItem(string);
        }
        this.outputComboBox.setEnabled(this.outputComboBox.getItemCount() > 1);
        this.setOutputCollapsed(this.outputComboBox.getItemCount() <= 1);
    }

    private void setOutputCollapsed(boolean bl) {
        if (bl) {
            this.outputPanel.setVisible(false);
            this.expandOutputButton.setIcon(new ImageIcon(this.getClass().getResource("/images/expand_less.png")));
        } else {
            this.outputPanel.setVisible(true);
            this.expandOutputButton.setIcon(new ImageIcon(this.getClass().getResource("/images/expand_more.png")));
        }
    }

    @Override
    public void setBgColor(Color color) {
        super.setBgColor(color);
        this.setComponentChild(this.centerEditPanel, color, true);
        this.setComponentChild(this.inputPanel, color, true);
        this.setComponentChild(this.outputPanel, color, true);
    }

    @Generated
    public FunctionPropertyPanel getFunctionPropertyPanel() {
        return this.functionPropertyPanel;
    }

    @Generated
    public BreezeTextField getAliasTextField() {
        return this.aliasTextField;
    }

    @Generated
    public BreezeComboBox getFunctionComboBox() {
        return this.functionComboBox;
    }

    @Generated
    public BreezeComboBox getInputComboBox() {
        return this.inputComboBox;
    }

    @Generated
    public BreezeComboBox getOutputComboBox() {
        return this.outputComboBox;
    }

    @Generated
    public BreezeComboBox getTypeComboBox() {
        return this.typeComboBox;
    }

    public static class DescriptorListCellRenderer
    extends BreezeComboBox.ComboBoxListCellRenderer {
        private Object origValue;

        public DescriptorListCellRenderer() {
            super(0);
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.origValue = object;
            if (object instanceof AbstractBreezeFunctionInfo) {
                AbstractBreezeFunctionInfo abstractBreezeFunctionInfo = (AbstractBreezeFunctionInfo)object;
                object = abstractBreezeFunctionInfo.getShortDescription();
            } else if (object instanceof Analyse) {
                Analyse analyse = (Analyse)object;
                object = String.valueOf(object) + " (" + analyse.getModelMethod().getMethod() + ")";
            } else if (object instanceof FunctionTreeNode) {
                FunctionTreeNode functionTreeNode = (FunctionTreeNode)object;
                object = functionTreeNode.getAliasOrNodeString();
            } else if (!(object instanceof BreezeComboBox.SeparatorClass)) {
                if (object instanceof OptionParameter) {
                    OptionParameter optionParameter = (OptionParameter)object;
                    object = optionParameter.getDisplayString();
                } else if (object instanceof OptionParameter.Option) {
                    OptionParameter.Option option = (OptionParameter.Option)object;
                    object = option.getDisplayName();
                } else if (object != null) {
                    object = StringHelper.formatLabel(object.toString());
                }
            }
            return super.getListCellRendererComponent(jList, object, n, bl, bl2);
        }

        @Override
        protected String getToolTip(Object object) {
            Object object2 = this.origValue;
            if (object2 instanceof Analyse) {
                Analyse analyse = (Analyse)object2;
                object2 = BreezeMasterCache.getInstance().getStudyList().byId(analyse.getStudyId());
                if (object2 != null) {
                    return ((BasicWorkflow)object2).getName() + " / " + String.valueOf(object);
                }
            }
            return super.getToolTip(object);
        }
    }

    private class InputListCellRenderer
    extends BreezeComboBox.ComboBoxListCellRenderer {
        public InputListCellRenderer() {
            super(0);
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            FunctionTreeNode functionTreeNode = (FunctionTreeNode)object;
            StringBuffer stringBuffer = new StringBuffer();
            if (!(functionTreeNode.getParent() instanceof FunctionTreeNode)) {
                stringBuffer.append("Root");
            } else {
                this.addPath(functionTreeNode, stringBuffer);
            }
            return super.getListCellRendererComponent(jList, (Object)stringBuffer.toString(), n, bl, bl2);
        }

        private void addPath(FunctionTreeNode functionTreeNode, StringBuffer stringBuffer) {
            if (functionTreeNode.getParent() instanceof FunctionTreeNode) {
                this.addPath(functionTreeNode.getParent(), stringBuffer);
                if (!stringBuffer.isEmpty()) {
                    stringBuffer.append(" - ");
                }
                stringBuffer.append(functionTreeNode.getAliasOrNodeString());
            }
        }
    }

    public static class FormatListCellRenderer
    extends BreezeComboBox.ComboBoxListCellRenderer {
        public FormatListCellRenderer() {
            super(0);
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            return super.getListCellRendererComponent(jList, (Object)this.format(object), n, bl, bl2);
        }

        protected String format(Object object) {
            return StringHelper.formatObject(object);
        }
    }
}

