/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.play.edit;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.segmentation.model.ModelSegmentation;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.main.play.edit.EditDescriptorPanel;
import se.prediktera.breeze.frontend.main.play.edit.EditWorkflowPanel;
import se.prediktera.breeze.frontend.main.play.edit.FunctionPropertyPanel;
import se.prediktera.breeze.test.MockBreezePropertiesAndMasterCache;
import se.prediktera.breeze.test.stubs.WorkflowWithoutIO;

public class EditDescriptorPanelTest
extends MockBreezePropertiesAndMasterCache {
    @Test
    public void shouldDisplaySegmentationNodeWithFields() {
        WorkflowWithoutIO workflowWithoutIO = new WorkflowWithoutIO();
        PreparedModelSegmentationNode preparedModelSegmentationNode = new PreparedModelSegmentationNode();
        workflowWithoutIO.getAnalyseTree().getRoot().addChild(preparedModelSegmentationNode);
        TestEditDescriptorPanel testEditDescriptorPanel = new TestEditDescriptorPanel(BreezeType.Workflow, (Workflow)workflowWithoutIO);
        testEditDescriptorPanel.showEntry(preparedModelSegmentationNode, null);
        MatcherAssert.assertThat((Object)testEditDescriptorPanel.getInputComboBox().getSelectedItem().toString(), (Matcher)Matchers.is((Object)"None"));
        MatcherAssert.assertThat((Object)testEditDescriptorPanel.getTypeComboBox().getSelectedItem().toString(), (Matcher)Matchers.is((Object)"Segmentation"));
        MatcherAssert.assertThat((Object)testEditDescriptorPanel.getFunctionComboBox().getSelectedItem(), (Matcher)Matchers.instanceOf(ModelSegmentation.Info.class));
        MatcherAssert.assertThat((Object)testEditDescriptorPanel.getAliasTextField().getText(), (Matcher)Matchers.is((Object)""));
        FunctionPropertyPanel functionPropertyPanel = testEditDescriptorPanel.getFunctionPropertyPanel();
        MatcherAssert.assertThat((Object)functionPropertyPanel.getParameterComboBoxByLabelText("Model").getSelectedItem(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)functionPropertyPanel.getParameterTextFieldByLabelText("Min area").getText(), (Matcher)Matchers.is((Object)"50"));
        MatcherAssert.assertThat((Object)functionPropertyPanel.getParameterTextFieldByLabelText("Shrink").getText(), (Matcher)Matchers.is((Object)"0"));
        MatcherAssert.assertThat((Object)functionPropertyPanel.getParameterComboBoxByLabelText("Separate / Merge").getSelectedItem().toString(), (Matcher)Matchers.is((Object)"Normal"));
        MatcherAssert.assertThat((Object)testEditDescriptorPanel.getOutputComboBox().getSelectedItem().toString(), (Matcher)Matchers.is((Object)"value"));
    }

    @Test
    public void changeTypeShouldChangeSegmentationNodeToDescriptorNodeAndRemovePorts() {
        WorkflowWithoutIO workflowWithoutIO = new WorkflowWithoutIO();
        PreparedModelSegmentationNode preparedModelSegmentationNode = new PreparedModelSegmentationNode();
        workflowWithoutIO.getAnalyseTree().getRoot().addChild(preparedModelSegmentationNode);
        TestEditDescriptorPanel testEditDescriptorPanel = new TestEditDescriptorPanel(BreezeType.Project, (Workflow)workflowWithoutIO);
        testEditDescriptorPanel.showEntry(preparedModelSegmentationNode, null);
        testEditDescriptorPanel.getTypeComboBox().setSelectedItemAndTrigger((Object)AbstractBreezeFunctionInfo.FunctionType.Descriptor);
        MatcherAssert.assertThat((Object)workflowWithoutIO.getAnalyseTree().getRoot().getChild(0), (Matcher)Matchers.instanceOf(DescriptorTreeNode.class));
        MatcherAssert.assertThat((Object)workflowWithoutIO.getAnalyseTree().getRoot().getChild(0).getFunction(), (Matcher)Matchers.instanceOf(AbstractDescriptor.class));
        MatcherAssert.assertThat((String)"all ports are removed", (Object)workflowWithoutIO.getAnalyseTree().getRoot().getChild(0).getChildCount(), (Matcher)Matchers.is((Object)0));
    }

    private static class PreparedModelSegmentationNode
    extends SegmentationNode {
        public PreparedModelSegmentationNode() {
            this.setFunction(new ModelSegmentation(new ModelSegmentation.Info()));
            this.recreateSegmentationPorts(null);
        }
    }

    private static class TestEditDescriptorPanel
    extends EditDescriptorPanel {
        public TestEditDescriptorPanel(BreezeType breezeType, Workflow workflow) {
            super(new EditWorkflowPanel(null, new BreezeFrame.FakeBreezeFrame(), BreezeType.Project, workflow, false){

                @Override
                public void selectEntry(Object object) {
                }

                @Override
                public ViewClass getViewClass() {
                    return new ViewClass();
                }
            }, workflow);
        }
    }
}

