/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.play.edit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.entry.workflow.LimitConfiguration;
import se.prediktera.breeze.entry.workflow.PropertyLimit;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.BreezeTextComponentAncestor;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeTextField;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.common.swing.table.DefaultBreezeTableImpl;
import se.prediktera.breeze.frontend.common.swing.table.ValueCellInterface;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.main.record.edit.common.AbstractEditEntryMainPanel;
import se.prediktera.map.common.NiceDataFormat;

public class EditLimitPanel
extends AbstractViewPanel
implements BreezeTextComponentAncestor {
    private final BreezeTablePanel breezeTablePanel;
    private final JLabel nameLabel = new JLabel();
    private final BreezeTextField nameTextField = new BreezeTextField();
    private final JLabel valuesLabel;
    private LimitConfiguration limitNode;
    private final BreezeButton duplicateButton;
    private final BreezeButton updateButton;

    public EditLimitPanel(final AbstractEditEntryMainPanel abstractEditEntryMainPanel, final Workflow workflow) {
        super(abstractEditEntryMainPanel);
        this.breezeTablePanel = new BreezeTablePanel();
        this.valuesLabel = new JLabel();
        this.setBackground(new Color(51, 51, 51));
        this.setLayout(new GridBagLayout());
        this.nameLabel.setFont(new Font("Tahoma", 0, 12));
        this.nameLabel.setForeground(new Color(255, 255, 255));
        this.nameLabel.setText("Limit name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 40, 0, 0);
        this.add(this.nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 40, 10, 40);
        this.add(this.nameTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 40, 0, 40);
        this.add((Component)((Object)this.breezeTablePanel), gridBagConstraints);
        this.valuesLabel.setFont(new Font("Tahoma", 0, 14));
        this.valuesLabel.setForeground(new Color(255, 255, 255));
        this.valuesLabel.setText("Values");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 40, 0, 0);
        this.add(this.valuesLabel, gridBagConstraints);
        this.breezeTablePanel.setAbstractViewPanel(this);
        this.breezeTablePanel.initTable(new TableHelper(), null, false);
        this.breezeTablePanel.getTable().setSelectionMode(2);
        this.nameTextField.addChangeListener(textActionEvent -> {
            String string = this.nameTextField.getText();
            this.limitNode.setName(string);
            abstractEditEntryMainPanel.selectEntryAndSave(this.limitNode);
        });
        this.duplicateButton = EntryMainHelper.createButton("Duplicate", "material/content_copy", () -> {
            LimitConfiguration limitConfiguration = this.limitNode.clone();
            workflow.getVisualisationNode().getLimitList().add(limitConfiguration);
            abstractEditEntryMainPanel.selectEntryAndSave(limitConfiguration);
        });
        this.updateButton = EntryMainHelper.createButton("Update", "material/upgrade", () -> BreezeProgressDialog.startProgress(abstractEditEntryMainPanel.getFrame(), new ProgressAction(this){
            final /* synthetic */ EditLimitPanel this$0;
            {
                this.this$0 = editLimitPanel;
            }

            @Override
            public void runAction() throws Exception {
                workflow.getVisualisationNode().updateLimits(this.getProgressManager(), false);
                abstractEditEntryMainPanel.selectEntryAndSave(this.this$0.limitNode);
                abstractEditEntryMainPanel.setSelectedValue(this.this$0.limitNode);
            }
        }, "Progress"));
    }

    @Override
    public void addComponent(BreezeMainPanel breezeMainPanel) {
        super.addComponent(breezeMainPanel);
        breezeMainPanel.addRightButton(this.duplicateButton);
        breezeMainPanel.addRightButton(this.updateButton);
    }

    @Override
    public String getType() {
        return "Limit";
    }

    @Override
    public void showEntry(Object object, Object object2) {
        if (object instanceof LimitConfiguration) {
            this.limitNode = (LimitConfiguration)object;
            this.nameTextField.setText(this.limitNode.getName());
            List<PropertyLimit> list = this.limitNode.getChildList();
            this.breezeTablePanel.setTableList(list, list.isEmpty() ? null : list.get(0));
        }
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
    }

    private class TableHelper
    extends DefaultBreezeTableImpl {
        private TableHelper() {
        }

        @Override
        public Vector createVOVector(Object object) {
            Vector<Object> vector = new Vector<Object>();
            PropertyLimit propertyLimit = (PropertyLimit)object;
            PropertyFactor propertyFactor = propertyLimit.getFactor();
            if (propertyFactor != null) {
                vector.add(propertyFactor.getName());
                vector.add(new LimitValueCell(propertyLimit, true));
                vector.add(new LimitValueCell(propertyLimit, false));
                return vector;
            }
            return null;
        }

        @Override
        public List<Object> getTableHeader(List list) {
            return Arrays.asList("Descriptor", "Min", "Max");
        }
    }

    public class LimitValueCell
    implements ValueCellInterface {
        private final PropertyLimit wrapper;
        private final boolean min;

        public LimitValueCell(PropertyLimit propertyLimit, boolean bl) {
            this.wrapper = propertyLimit;
            this.min = bl;
        }

        private double getValueLocal() {
            return this.min ? (double)this.wrapper.getMin() : (double)this.wrapper.getMax();
        }

        @Override
        public Double getValue() {
            return this.getValueLocal();
        }

        @Override
        public void setValue(Double d) {
            if (this.min) {
                this.wrapper.setMin(d.floatValue());
            } else {
                this.wrapper.setMax(d.floatValue());
            }
            EditLimitPanel.this.limitNode.setUpdated();
            ((AbstractEditEntryMainPanel)EditLimitPanel.this.mainpanel).selectEntryAndSave(EditLimitPanel.this.limitNode);
        }

        public String toString() {
            return NiceDataFormat.toString((double)this.getValueLocal());
        }
    }
}

