/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.play.edit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.tuple.Pair;
import se.prediktera.breeze.backend.measure.applychanges.ApplyChanges;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.realtime.descriptor.SpectralAngleMapperDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.parameter.AddParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.BooleanParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.ExpressionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FolderParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FunctionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.LabelParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.NumberParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.NumberRangeParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.NumberSliderParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.RuleImageParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.SeparatorParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TextEditParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TransformationParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.WorkflowSettingsParameter;
import se.prediktera.breeze.common.realtime.descriptor.spatial.SpatialDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.spatial.expression.CatClassExpression;
import se.prediktera.breeze.common.realtime.descriptor.spatial.expression.CategoryExpressionParameter;
import se.prediktera.breeze.common.realtime.descriptor.spatial.expression.DataSlicingDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.usgs.UsgsDescriptor;
import se.prediktera.breeze.common.realtime.segmentation.spatial.DepthIntervalSegmentation;
import se.prediktera.breeze.common.realtime.unmixing.EditGroupingCustomPanel;
import se.prediktera.breeze.common.realtime.unmixing.GroupingUtils;
import se.prediktera.breeze.common.realtime.unmixing.MembersSetting;
import se.prediktera.breeze.common.realtime.unmixing.Reference;
import se.prediktera.breeze.common.realtime.unmixing.SelectMembersPanel;
import se.prediktera.breeze.common.realtime.unmixing.SpectralLibraryGroupParameter;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SampleSegmentationColumn;
import se.prediktera.breeze.entry.workflow.VisualisationNode;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.TextActionEvent;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeRangeSliderPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.BreezeSlider;
import se.prediktera.breeze.frontend.common.swing.BreezeTextArea;
import se.prediktera.breeze.frontend.common.swing.BreezeTextEditButtonField;
import se.prediktera.breeze.frontend.common.swing.BreezeTextField;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.DeleteCatClassInputField;
import se.prediktera.breeze.frontend.common.swing.FileInputField;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlPropertyViewPanel;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.plot.axisplot.settings.Color.PlotContinuousColor;

public class FunctionParameterCustomInput {
    public static JComponent customInput(FunctionParameter functionParameter, BreezeFrame breezeFrame, Workflow workflow, Object object, FunctionTreeNode functionTreeNode, FunctionParameter.ChangeCallback changeCallback) {
        if (functionParameter instanceof MembersSetting.EndMemberFileParameter) {
            MembersSetting.EndMemberFileParameter endMemberFileParameter = (MembersSetting.EndMemberFileParameter)functionParameter;
            return new EndMemberInputPanel(endMemberFileParameter, breezeFrame, workflow, functionTreeNode, changeCallback);
        }
        if (functionParameter instanceof SpectralLibraryGroupParameter) {
            SpectralLibraryGroupParameter spectralLibraryGroupParameter = (SpectralLibraryGroupParameter)functionParameter;
            return new SpectralLibraryGroupInputPanel(spectralLibraryGroupParameter, breezeFrame, workflow, functionTreeNode, changeCallback);
        }
        if (functionParameter instanceof FolderParameter) {
            FolderParameter folderParameter = (FolderParameter)functionParameter;
            return new FileInputPanel(folderParameter, breezeFrame, changeCallback);
        }
        if (functionParameter instanceof CategoryExpressionParameter) {
            CategoryExpressionParameter categoryExpressionParameter = (CategoryExpressionParameter)functionParameter;
            return new CategoryExpressionInputPanel(breezeFrame, categoryExpressionParameter, ((ExpressionClassificationFactorInterface)((Object)functionTreeNode.getFunction())).getFactor(functionTreeNode), changeCallback);
        }
        if (functionParameter instanceof ExpressionParameter) {
            ExpressionParameter expressionParameter = (ExpressionParameter)functionParameter;
            return new ExpressionInputPanel(expressionParameter, changeCallback);
        }
        if (functionParameter instanceof TextEditParameter) {
            TextEditParameter textEditParameter = (TextEditParameter)functionParameter;
            return new TextEditInputPanel(textEditParameter, breezeFrame, workflow, object, changeCallback);
        }
        if (functionParameter instanceof WorkflowSettingsParameter) {
            WorkflowSettingsParameter workflowSettingsParameter = (WorkflowSettingsParameter)functionParameter;
            return WorkflowSettingsPanel.create(workflowSettingsParameter, breezeFrame, workflow, changeCallback);
        }
        if (functionParameter instanceof LabelParameter) {
            LabelParameter labelParameter = (LabelParameter)functionParameter;
            return new BreezeLabel(labelParameter.getText(), labelParameter.isBold(), labelParameter.getFontSize());
        }
        if (functionParameter instanceof SeparatorParameter) {
            return new BreezeSeparator();
        }
        if (functionParameter instanceof TransformationParameter) {
            TransformationParameter transformationParameter = (TransformationParameter)functionParameter;
            return new EditTransformationPanel(transformationParameter, breezeFrame, workflow.getType().getColor(), changeCallback, "Select Pretreatments", true);
        }
        if (functionParameter instanceof AddParameter) {
            AddParameter addParameter = (AddParameter)functionParameter;
            return new AddPanel(breezeFrame, addParameter, workflow, functionTreeNode, changeCallback);
        }
        if (functionParameter instanceof RuleImageParameter) {
            RuleImageParameter ruleImageParameter = (RuleImageParameter)functionParameter;
            return new RuleImagePanel(breezeFrame, ruleImageParameter, workflow, functionTreeNode, changeCallback);
        }
        if (functionParameter instanceof BooleanParameter) {
            return new BooleanInputPanel((BooleanParameter)functionParameter, changeCallback);
        }
        if (functionParameter instanceof NumberParameter.WorkflowUnitParameter) {
            NumberParameter.WorkflowUnitParameter workflowUnitParameter = (NumberParameter.WorkflowUnitParameter)functionParameter;
            return new WorkflowUnitInputField(workflowUnitParameter, workflow, changeCallback);
        }
        if (functionParameter instanceof DepthIntervalSegmentation.DepthIntervalParameter) {
            DepthIntervalSegmentation.DepthIntervalParameter depthIntervalParameter = (DepthIntervalSegmentation.DepthIntervalParameter)functionParameter;
            return new DepthIntervalInputPanel(breezeFrame, workflow, depthIntervalParameter, changeCallback);
        }
        if (functionParameter instanceof DataSlicingDescriptor.DataSlicingParameter) {
            DataSlicingDescriptor.DataSlicingParameter dataSlicingParameter = (DataSlicingDescriptor.DataSlicingParameter)functionParameter;
            return new DataSlicingInputPanel(breezeFrame, dataSlicingParameter, changeCallback);
        }
        if (functionParameter instanceof NumberSliderParameter) {
            NumberSliderParameter numberSliderParameter = (NumberSliderParameter)functionParameter;
            return new NumberSliderPanel(breezeFrame, numberSliderParameter, changeCallback);
        }
        if (functionParameter instanceof NumberRangeParameter) {
            NumberRangeParameter numberRangeParameter = (NumberRangeParameter)functionParameter;
            return new NumberRangePanel(numberRangeParameter, changeCallback);
        }
        return null;
    }

    private static class EndMemberInputPanel
    extends JPanel
    implements CustomLabelInputInterface {
        public EndMemberInputPanel(MembersSetting.EndMemberFileParameter endMemberFileParameter, BreezeFrame breezeFrame, Workflow workflow, FunctionTreeNode functionTreeNode, FunctionParameter.ChangeCallback changeCallback) {
            super(new GridBagLayout());
            this.setOpaque(false);
            FileInputPanel fileInputPanel = new FileInputPanel(endMemberFileParameter, breezeFrame, changeCallback);
            BreezeLabel breezeLabel = new BreezeLabel(StringHelper.formatLabel(endMemberFileParameter.getAliasOrName()), false, 14);
            this.add((Component)breezeLabel, GridBagHelper.create(0, new Insets(0, 0, 0, 0)));
            GridBagConstraints gridBagConstraints = GridBagHelper.create(1, new Insets(1, 0, 0, 0));
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            this.add((Component)fileInputPanel, gridBagConstraints);
            File file = fileInputPanel.getFile(workflow);
            if (file != null) {
                GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
                gridBagConstraints2.gridx = 1;
                gridBagConstraints2.gridy = 0;
                gridBagConstraints2.anchor = 12;
                if (file.exists()) {
                    gridBagConstraints2.insets = new Insets(0, 10, 2, 0);
                    this.add((Component)EntryMainHelper.createSmallTextButton("Select", () -> {
                        SpectralLibraryGroupParameter spectralLibraryGroupParameter;
                        List<Reference> list = endMemberFileParameter.read(workflow);
                        AbstractBreezeFunction abstractBreezeFunction = functionTreeNode.getFunction();
                        if (abstractBreezeFunction instanceof SpectralAngleMapperDescriptor) {
                            SpectralAngleMapperDescriptor spectralAngleMapperDescriptor = (SpectralAngleMapperDescriptor)abstractBreezeFunction;
                            spectralLibraryGroupParameter = spectralAngleMapperDescriptor.getMembersSetting().getSpectralLibraryGroupParameter();
                        } else {
                            abstractBreezeFunction = functionTreeNode.getFunction();
                            if (abstractBreezeFunction instanceof UsgsDescriptor) {
                                UsgsDescriptor usgsDescriptor = (UsgsDescriptor)abstractBreezeFunction;
                                spectralLibraryGroupParameter = usgsDescriptor.getMineralGroup();
                            } else {
                                spectralLibraryGroupParameter = null;
                            }
                        }
                        BreezeOptionDialog.showDialog(breezeFrame, workflow.getType().getPageType().getColor(), AbstractBreezeDialog.MessageType.POPUP_OPTION, "Select End Members", "", (AbstractBreezeCustomPanel)new SelectMembersPanel(breezeFrame, list, spectralLibraryGroupParameter, file), null, breezeActionEvent -> {
                            GroupingUtils.Grouping grouping = (GroupingUtils.Grouping)breezeActionEvent.getBreezeCustomPanel().getResult();
                            if (spectralLibraryGroupParameter != null && grouping.isUpdated()) {
                                try {
                                    grouping.saveToFile();
                                }
                                catch (IOException iOException) {
                                    throw new RuntimeException(iOException);
                                }
                                spectralLibraryGroupParameter.setValue(grouping);
                                changeCallback.changed(spectralLibraryGroupParameter, new SpectralLibraryGroupParameter.GroupingOption(grouping), true);
                            }
                            endMemberFileParameter.setSettings(list);
                            workflow.getConnectedAnalysis();
                            workflow.save();
                        });
                    }), gridBagConstraints2);
                } else {
                    gridBagConstraints2.insets = new Insets(5, 10, 2, 0);
                    BreezeLabel breezeLabel2 = new BreezeLabel("File not found", false, 14);
                    breezeLabel2.setIcon(ImageHelper.getResourceIcon("warning"));
                    this.add((Component)breezeLabel2, gridBagConstraints2);
                }
            }
        }
    }

    private static class SpectralLibraryGroupInputPanel
    extends JPanel
    implements CustomLabelInputInterface {
        public SpectralLibraryGroupInputPanel(SpectralLibraryGroupParameter spectralLibraryGroupParameter, BreezeFrame breezeFrame, Workflow workflow, FunctionTreeNode functionTreeNode, FunctionParameter.ChangeCallback changeCallback) {
            super(new GridBagLayout());
            this.setOpaque(false);
            BreezeComboBox breezeComboBox = new BreezeComboBox(true, 0);
            breezeComboBox.setName("function" + NiceDataFormat.initialLetter((String)spectralLibraryGroupParameter.getName()));
            breezeComboBox.setVisible(spectralLibraryGroupParameter.isVisible(functionTreeNode));
            SpectralLibraryGroupInputPanel.setOptions(spectralLibraryGroupParameter, workflow, functionTreeNode, breezeComboBox);
            breezeComboBox.addItemListener(itemEvent -> {
                if (itemEvent.getStateChange() == 1) {
                    changeCallback.changed(spectralLibraryGroupParameter, breezeComboBox.getValue(), true);
                }
            });
            BreezeLabel breezeLabel = new BreezeLabel(StringHelper.formatLabel(spectralLibraryGroupParameter.getAliasOrName()), false, 14);
            GridBagConstraints gridBagConstraints = GridBagHelper.create(0, new Insets(0, 0, 0, 0));
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            this.add((Component)breezeLabel, gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = GridBagHelper.create(1, new Insets(1, 0, 0, 0));
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridwidth = 3;
            this.add((Component)breezeComboBox, gridBagConstraints2);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.anchor = 12;
            gridBagConstraints3.insets = new Insets(0, 0, 2, 0);
            this.add((Component)EntryMainHelper.createSmallTextButton("Edit", () -> {
                GroupingUtils.Grouping grouping = spectralLibraryGroupParameter.getGrouping();
                BreezeOptionDialog.showDialog(breezeFrame, workflow.getType().getPageType().getColor(), AbstractBreezeDialog.MessageType.POPUP_OPTION, "Edit grouping " + (grouping.isReadOnly() ? "[Read only]" : ""), "", (AbstractBreezeCustomPanel)new EditGroupingCustomPanel(breezeFrame, grouping), null, breezeActionEvent -> {
                    GroupingUtils.Grouping grouping = (GroupingUtils.Grouping)breezeActionEvent.getBreezeCustomPanel().getResult();
                    if (grouping.isMarkedForDeletion()) {
                        spectralLibraryGroupParameter.setValue(GroupingUtils.NONE_GROUPING);
                        spectralLibraryGroupParameter.remove(grouping);
                        if (!grouping.getSourceFile().delete()) {
                            Logg.warn((String)("Failed to delete grouping file: " + grouping.getSourceFile().getAbsolutePath()), (Object[])new Object[0]);
                        }
                    } else {
                        grouping.addEndMemberFiles(spectralLibraryGroupParameter.getEndMemberFiles(workflow));
                        try {
                            grouping.saveToFile();
                        }
                        catch (IOException iOException) {
                            throw new ErrorHandler.ErrorMessageException("Failed to save group: " + iOException.getMessage(), "Error when saving");
                        }
                        spectralLibraryGroupParameter.setValue(grouping);
                    }
                    SpectralLibraryGroupInputPanel.setOptions(spectralLibraryGroupParameter, workflow, functionTreeNode, breezeComboBox);
                    this.repaint();
                    workflow.getConnectedAnalysis();
                    workflow.save();
                });
            }), gridBagConstraints3);
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 2;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.anchor = 12;
            gridBagConstraints4.insets = new Insets(0, 5, 2, 0);
            this.add((Component)EntryMainHelper.createSmallTextButton("New", () -> BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.INPUT_OPTION, "Create new grouping", "Enter new grouping name:", "", breezeActionEvent -> {
                GroupingUtils.Grouping grouping = new GroupingUtils.Grouping();
                Pair<File, String> pair = GroupingUtils.getGroupingFile();
                grouping.setSourceFile((File)pair.getLeft());
                grouping.setId((String)pair.getRight());
                grouping.setGroupingName(breezeActionEvent.getInputText());
                grouping.addEndMemberFiles(spectralLibraryGroupParameter.getEndMemberFiles(workflow));
                try {
                    grouping.saveToFile();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                spectralLibraryGroupParameter.setValue(grouping);
                SpectralLibraryGroupInputPanel.setOptions(spectralLibraryGroupParameter, workflow, functionTreeNode, breezeComboBox);
                this.repaint();
                workflow.getConnectedAnalysis();
                workflow.save();
            })), gridBagConstraints4);
        }

        private static void setOptions(SpectralLibraryGroupParameter spectralLibraryGroupParameter, Workflow workflow, FunctionTreeNode functionTreeNode, BreezeComboBox breezeComboBox) {
            Object[] objectArray;
            for (Object object : objectArray = spectralLibraryGroupParameter.getOptions(workflow, functionTreeNode)) {
                breezeComboBox.addItem(object);
            }
            breezeComboBox.setSelectedItem(spectralLibraryGroupParameter.getValueObj());
        }
    }

    private static class FileInputPanel
    extends FileInputField {
        private final FolderParameter parameter;

        public FileInputPanel(FolderParameter folderParameter, BreezeFrame breezeFrame, FunctionParameter.ChangeCallback changeCallback) {
            super((Component)breezeFrame, "", folderParameter.getValueStr(), (TextActionEvent textActionEvent) -> changeCallback.changed(folderParameter, textActionEvent.getText(), true), true);
            this.getInputField().setName("function" + NiceDataFormat.initialLetter((String)folderParameter.getName()));
            this.getInputField().getLabel().setVisible(false);
            this.parameter = folderParameter;
        }

        @Override
        protected void customizeDialog(jopensaveDialog jopensaveDialog2) {
            this.parameter.customizeDialog(jopensaveDialog2);
        }
    }

    private static class CategoryExpressionInputPanel
    extends JPanel {
        private final JPanel expressionPanel = new JPanel(new GridBagLayout());

        public CategoryExpressionInputPanel(BreezeFrame breezeFrame, CategoryExpressionParameter categoryExpressionParameter, CategoryFactor categoryFactor, FunctionParameter.ChangeCallback changeCallback) {
            super(new BorderLayout());
            this.setOpaque(false);
            if (categoryFactor != null) {
                categoryExpressionParameter.configure(categoryFactor);
            }
            this.expressionPanel.setOpaque(false);
            this.add((Component)this.expressionPanel, "Center");
            this.updateList(categoryExpressionParameter, categoryFactor, changeCallback);
            List list = categoryExpressionParameter.getExpressionLists();
            JPanel jPanel = new JPanel(new FlowLayout(0, 10, 5));
            jPanel.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, BreezeTheme.getInstance().getLabelForegroundMoreDifuse()));
            jPanel.setOpaque(false);
            jPanel.add(EntryMainHelper.createButton("Add", "material/add", () -> {
                CatClass catClass = new CatClass("New", null);
                catClass.setColor(RtPerfectSpread.generateColor(categoryExpressionParameter.getMaxSize()));
                categoryExpressionParameter.selectedExpression = new CatClassExpression(catClass, categoryExpressionParameter);
                categoryExpressionParameter.add(categoryExpressionParameter.selectedExpression);
                changeCallback.changed(categoryExpressionParameter, "", true);
            }));
            jPanel.add(new BreezeSeparator());
            jPanel.add(EntryMainHelper.createButton("Up", "material/arrow_upward", () -> {
                int n;
                int n2 = n = categoryExpressionParameter.selectedExpression != null ? list.indexOf(categoryExpressionParameter.selectedExpression) : 0;
                if (n > 0) {
                    this.swap(list, n, n - 1);
                    changeCallback.changed(categoryExpressionParameter, "", true);
                }
            }));
            jPanel.add(EntryMainHelper.createButton("Down", "material/arrow_downward", () -> {
                int n;
                int n2 = n = categoryExpressionParameter.selectedExpression != null ? list.indexOf(categoryExpressionParameter.selectedExpression) : list.size();
                if (n < list.size() - 1) {
                    this.swap(list, n, n + 1);
                    changeCallback.changed(categoryExpressionParameter, "", true);
                }
            }));
            this.add((Component)jPanel, "South");
        }

        private CatClassExpression swap(List<CatClassExpression> list, int n, int n2) {
            CatClassExpression catClassExpression = list.get(n2);
            CatClassExpression catClassExpression2 = list.get(n);
            list.set(n2, catClassExpression2);
            list.set(n, catClassExpression);
            return catClassExpression2;
        }

        private void updateList(final CategoryExpressionParameter categoryExpressionParameter, CategoryFactor categoryFactor, final FunctionParameter.ChangeCallback changeCallback) {
            this.expressionPanel.removeAll();
            for (final CatClassExpression catClassExpression : categoryExpressionParameter.getExpressionLists()) {
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = this.expressionPanel.getComponentCount();
                gridBagConstraints.insets = new Insets(6, 0, 6, 0);
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                DeleteCatClassInputField.ExpressionDeleteCatClassInputField expressionDeleteCatClassInputField = new DeleteCatClassInputField.ExpressionDeleteCatClassInputField(catClassExpression.getCatClass(), catClassExpression.getExpression(), new DeleteCatClassInputField.OnChangeCallback(){

                    @Override
                    public void onChange(DeleteCatClassInputField deleteCatClassInputField) {
                        catClassExpression.set(deleteCatClassInputField.getValue());
                        changeCallback.changed(categoryExpressionParameter, deleteCatClassInputField.getValue(), false);
                    }

                    @Override
                    public void action() {
                        categoryExpressionParameter.getExpressionLists().remove(catClassExpression);
                        changeCallback.changed(categoryExpressionParameter, "", true);
                    }
                });
                expressionDeleteCatClassInputField.setEditable(catClassExpression.isAdded());
                BreezeInputField breezeInputField = expressionDeleteCatClassInputField.getValueField();
                if (catClassExpression == categoryExpressionParameter.selectedExpression) {
                    SwingUtilities.invokeLater(breezeInputField::requestFocusAndSelectAll);
                }
                expressionDeleteCatClassInputField.addFocusListener(new FocusAdapter(this){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        categoryExpressionParameter.selectedExpression = catClassExpression;
                    }
                });
                expressionDeleteCatClassInputField.setName("function" + NiceDataFormat.initialLetter((String)categoryExpressionParameter.getName()));
                this.expressionPanel.add((Component)expressionDeleteCatClassInputField, gridBagConstraints);
            }
            this.expressionPanel.revalidate();
            this.expressionPanel.repaint();
        }
    }

    public static interface ExpressionClassificationFactorInterface {
        public CategoryFactor getFactor(FunctionTreeNode var1);

        public CategoryExpressionParameter getExpression();
    }

    private static class ExpressionInputPanel
    extends JPanel {
        public ExpressionInputPanel(ExpressionParameter expressionParameter, FunctionParameter.ChangeCallback changeCallback) {
            super(new BorderLayout());
            for (Object t : expressionParameter.getExpressionLists()) {
                ExpressionParameter.Expression expression = (ExpressionParameter.Expression)t;
                BreezeTextField breezeTextField = new BreezeTextField();
                breezeTextField.setName("function" + NiceDataFormat.initialLetter((String)expressionParameter.getName()));
                breezeTextField.setText(expression.getExpression());
                breezeTextField.addChangeListener(textActionEvent -> {
                    expression.set(breezeTextField.getText());
                    changeCallback.changed(expressionParameter, breezeTextField.getText(), false);
                });
                this.add((Component)breezeTextField, "Center");
            }
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            for (int i = 0; i < this.getComponentCount(); ++i) {
                this.getComponent(i).setEnabled(bl);
            }
        }
    }

    private static class TextEditInputPanel
    extends BreezeTextEditButtonField {
        private final TextEditParameter parameter;
        private final Workflow workflow;
        private final Object entry;

        public TextEditInputPanel(TextEditParameter textEditParameter, BreezeFrame breezeFrame, Workflow workflow, Object object, FunctionParameter.ChangeCallback changeCallback) {
            super(breezeFrame, "", textEditParameter.getValueStr(), textEditParameter.getButtonText(), textActionEvent -> changeCallback.changed(textEditParameter, textActionEvent.getText(), false), BreezeInputFieldHelper.Format.OneRow);
            this.workflow = workflow;
            this.entry = object;
            this.getInputField().setName("function" + NiceDataFormat.initialLetter((String)textEditParameter.getName()));
            this.getInputField().getLabel().setVisible(false);
            this.parameter = textEditParameter;
        }

        @Override
        protected void showDialog(BreezeFrame breezeFrame, BreezeTextEditButtonField breezeTextEditButtonField) {
            this.parameter.showDialog(breezeFrame, this.workflow, this.entry, breezeTextEditButtonField);
        }
    }

    private static class WorkflowSettingsPanel
    extends JPanel {
        private WorkflowSettingsPanel() {
        }

        public static JComponent create(WorkflowSettingsParameter workflowSettingsParameter, BreezeFrame breezeFrame, Workflow workflow, FunctionParameter.ChangeCallback changeCallback) {
            String string2 = workflowSettingsParameter.getName();
            if (string2.equals("colorScale")) {
                return new XmlPropertyViewPanel.ColorScaleComboBoxPanel(workflow.getColorScale(), plotContinuousColor -> {
                    workflow.setColorScale(new VisualisationNode.ColorScale((PlotContinuousColor)plotContinuousColor));
                    workflow.save();
                    DataSetCache.clearRecursive(workflow);
                    Main_GUI.updateColorScales((String)plotContinuousColor.getName(), (boolean)plotContinuousColor.isReversed());
                });
            }
            String string3 = WorkflowSettingsPanel.getValue(workflow, workflowSettingsParameter);
            Color color = workflow.getType().getColor();
            if (string2.equals("reduce")) {
                return new XmlPropertyViewPanel.ReduceComboBox(string3, reduceItem -> WorkflowSettingsPanel.setValueClearDataSetCache(workflow, workflowSettingsParameter, String.valueOf(reduceItem.getIndex())));
            }
            if (string2.equals("direction")) {
                return new XmlPropertyViewPanel.DirectionComboBox(string3, string -> WorkflowSettingsPanel.setValue(workflow, workflowSettingsParameter, string.toLowerCase()));
            }
            if (string2.equals("verticalDirection")) {
                return new XmlPropertyViewPanel.VerticalDirectionComboBox(string3, string -> WorkflowSettingsPanel.setValue(workflow, workflowSettingsParameter, string.toLowerCase()));
            }
            if (string2.equals("horizontalDirection")) {
                return new XmlPropertyViewPanel.HorizontalDirectionComboBox(string3, string -> WorkflowSettingsPanel.setValue(workflow, workflowSettingsParameter, string.toLowerCase()));
            }
            if (string2.equals("referenceConvertTo")) {
                return new XmlPropertyViewPanel.ReferenceConvertToComboBox(breezeFrame, color, string3, string -> {
                    WorkflowSettingsPanel.setValueClearDataSetCache(workflow, workflowSettingsParameter, string.toLowerCase());
                    workflow.clearPixelExploreCache();
                });
            }
            if (string2.equals("applyValueCorrection")) {
                return new BooleanInputPanel(workflowSettingsParameter.getAliasOrName(), Boolean.parseBoolean(string3), bl -> {
                    WorkflowSettingsPanel.setValueClearDataSetCache(workflow, workflowSettingsParameter, Boolean.toString(bl).toLowerCase());
                    workflow.clearPixelExploreCache();
                });
            }
            if (string2.equals("defaultUnit")) {
                return new XmlPropertyViewPanel.UnitComboBox(breezeFrame, color, SpatialDescriptor.SiUnit.parse(string3), siUnit -> WorkflowSettingsPanel.setValue(workflow, workflowSettingsParameter, siUnit.name()));
            }
            if (XmlPropertyViewPanel.BooleanCheckBox.isBoolean(string3)) {
                return new BooleanInputPanel(workflowSettingsParameter.getAliasOrName(), Boolean.parseBoolean(string3), bl -> WorkflowSettingsPanel.setValue(workflow, workflowSettingsParameter, Boolean.toString(bl).toLowerCase()));
            }
            return new BreezeTextField(string3, textActionEvent -> WorkflowSettingsPanel.setValue(workflow, workflowSettingsParameter, textActionEvent.getText()));
        }

        private static String getValue(Workflow workflow, WorkflowSettingsParameter workflowSettingsParameter) {
            return workflow.getProperties().getPropertyLocal(workflowSettingsParameter.getPath(), "");
        }

        private static void setValueClearDataSetCache(Workflow workflow, WorkflowSettingsParameter workflowSettingsParameter, String string) {
            WorkflowSettingsPanel.setValue(workflow, workflowSettingsParameter, string);
            DataSetCache.clearRecursive(workflow);
        }

        private static void setValue(Workflow workflow, WorkflowSettingsParameter workflowSettingsParameter, String string) {
            workflow.getProperties().setPropertyLocal(workflowSettingsParameter.getPath(), string);
            workflow.save();
            ToastHandler.getInstance().showToast("Parameter saved");
        }
    }

    public static class EditTransformationPanel
    extends JPanel {
        private final BreezeTextArea textArea = new BreezeTextArea();
        private TransformationParameter parameter;
        private final JPanel buttonsPanel = new JPanel(new GridBagLayout());

        public EditTransformationPanel(TransformationParameter transformationParameter, BreezeFrame breezeFrame, Color color, FunctionParameter.ChangeCallback changeCallback, String string, boolean bl) {
            super(new GridBagLayout());
            this.setBackground(BreezeTheme.getInstance().getPanelBackground());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.setParameter(transformationParameter);
            this.textArea.setFontSize(12);
            this.textArea.setEditable(false);
            this.textArea.hideVerticalScrollBar();
            this.textArea.setColumns(1);
            this.textArea.setBorder(BorderFactory.createEmptyBorder());
            this.textArea.setTextBackground(BreezeTheme.getInstance().getPanelBackground());
            this.add((Component)this.textArea, gridBagConstraints);
            this.buttonsPanel.setOpaque(false);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 12;
            gridBagConstraints2.insets = new Insets(0, 5, 0, 0);
            this.add((Component)this.buttonsPanel, gridBagConstraints2);
            this.addButton(EntryMainHelper.createButton("Edit", "explore/edit", () -> BreezeOptionDialog.showDialog(breezeFrame, color, AbstractBreezeDialog.MessageType.CONFIRM_OPTION, string, "", (AbstractBreezeCustomPanel)new TransformationParameter.SelectTransformationsPanel(this.parameter.getTransformationHashMap(), 100, transformationParameter), null, breezeActionEvent -> {
                this.parameter.setTransformations((List)breezeActionEvent.result());
                this.setParameter(this.parameter);
                changeCallback.changed(this.parameter, null, true);
            })));
            if (bl) {
                this.setBorder(BorderFactory.createLineBorder(BreezeTheme.getInstance().getLabelForegroundMoreDifuse()));
            }
        }

        public void addButton(BreezeButton breezeButton) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints.gridx = this.buttonsPanel.getComponentCount();
            this.buttonsPanel.add((Component)breezeButton, gridBagConstraints);
        }

        public void setParameter(TransformationParameter transformationParameter) {
            this.parameter = transformationParameter;
            EditTransformationPanel.updateTextArea(transformationParameter.getTransformationHashMap(), this.textArea);
        }

        private static void updateTextArea(HashMap<Model.Transformation, ModelProperties.TransformationProperties> hashMap, BreezeTextArea breezeTextArea) {
            int n = 0;
            StringBuilder stringBuilder = new StringBuilder();
            for (Model.Transformation transformation : Model.Transformation.values()) {
                ModelProperties.TransformationProperties transformationProperties = hashMap.get((Object)transformation);
                if (transformationProperties == null || !transformationProperties.enabled()) continue;
                if (!stringBuilder.isEmpty()) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append("\u2022 ").append(StringHelper.formatLabel(transformation.toString()));
                ++n;
            }
            breezeTextArea.setRows(n);
            if (!stringBuilder.isEmpty()) {
                breezeTextArea.setText(stringBuilder.toString());
            } else {
                breezeTextArea.setText("No pretreatments");
            }
        }
    }

    public static class AddPanel
    extends JPanel
    implements CustomLabelInputInterface {
        public AddPanel(BreezeFrame breezeFrame, final AddParameter addParameter, final Workflow workflow, final FunctionTreeNode functionTreeNode, final FunctionParameter.ChangeCallback changeCallback) {
            super(new GridBagLayout());
            this.setOpaque(false);
            NumberParameter numberParameter = addParameter.getNumberParameter();
            AddParameter.AddFunctionInterface addFunctionInterface = addParameter.getAddFunction();
            if (numberParameter != null) {
                int n = numberParameter.getValueInt() * 2 - 1;
                if (functionTreeNode.getChildCount() != n) {
                    SwingUtilities.invokeLater(() -> {
                        addFunctionInterface.clearSupported(functionTreeNode);
                        AddPanel.addNodes(functionTreeNode, addFunctionInterface.getAddNodes());
                        changeCallback.changed(addParameter, true, true);
                    });
                }
            } else {
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(10, 0, 0, 0);
                this.add((Component)new BreezeSeparator(0, 10, 10), gridBagConstraints);
                if (addParameter.isCheckBox()) {
                    gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridy = 1;
                    gridBagConstraints.gridwidth = 2;
                    gridBagConstraints.anchor = 18;
                    gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                    this.add((Component)new BreezeCheckBox(addParameter.getAliasOrName(), addParameter.getValueBool(), bl -> {
                        addFunctionInterface.clearSupported(functionTreeNode);
                        if (bl) {
                            AddPanel.addNodes(functionTreeNode, addFunctionInterface.getAddNodes());
                        }
                        addParameter.setValueBool(bl);
                        changeCallback.changed(addParameter, bl, true);
                    }), gridBagConstraints);
                } else {
                    gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridy = 1;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.insets = new Insets(0, 10, 0, 0);
                    this.add((Component)EntryMainHelper.createSmallTextButton("Select child nodes", () -> BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Settings.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Select child nodes", "", (AbstractBreezeCustomPanel)new AddParameter.AddParameterSelectionPanel(addFunctionInterface.getAddNodes(), "Descriptor"), null, breezeActionEvent -> {
                        addFunctionInterface.clearSupported(functionTreeNode);
                        AddPanel.addNodes(functionTreeNode, ((AddParameter.AddParameterSelectionPanel)breezeActionEvent.getBreezeCustomPanel()).getSelectedNodes());
                        changeCallback.changed(addParameter, false, true);
                    })), gridBagConstraints);
                    AddParameter.AddNodeList addNodeList = addFunctionInterface.getAddNodes();
                    gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridy = 2;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.insets = new Insets(2, 10, 0, 0);
                    this.add((Component)new BreezeLabel("Included: " + addNodeList.getNumberIncluded() + " of " + addNodeList.size(), false, 12), gridBagConstraints);
                    gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridy = 3;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.insets = new Insets(10, 10, 0, 0);
                    this.add((Component)AddPanel.addLabelButton("material/swap_vert", () -> BreezeProgressDialog.startProgress(breezeFrame, new ProgressAction(this){

                        @Override
                        public void runAction() throws Exception {
                            this.setInfoText("Sorting...");
                            List<Measurement> list = workflow.getAllMeasurements();
                            HashMap<FunctionTreeNode, Float> hashMap = AddPanel.createResultMap(list, functionTreeNode);
                            functionTreeNode.getChildList().sort((functionTreeNode, functionTreeNode2) -> Float.compare(((Float)hashMap.get(functionTreeNode2)).floatValue(), ((Float)hashMap.get(functionTreeNode)).floatValue()));
                            ApplyChanges.reloadMeasurements(this.getProgressManager(), workflow, list);
                            changeCallback.changed(addParameter, false, true);
                        }
                    }, "Finish"), "Sort child nodes by number"), gridBagConstraints);
                }
            }
        }

        private static void addNodes(FunctionTreeNode functionTreeNode, List list) {
            for (Object e : list.reversed()) {
                if (e instanceof AddParameter.AddClass) {
                    AddParameter.AddClass addClass = (AddParameter.AddClass)e;
                    functionTreeNode.insertChild((FunctionTreeNode)addClass.getObject());
                    continue;
                }
                if (e instanceof AddParameter.AddNode) {
                    AddParameter.AddNode addNode = (AddParameter.AddNode)e;
                    functionTreeNode.insertChild(addNode.node);
                    continue;
                }
                if (!(e instanceof FunctionTreeNode)) continue;
                FunctionTreeNode functionTreeNode2 = (FunctionTreeNode)e;
                functionTreeNode.insertChild(functionTreeNode2);
            }
        }

        private static HashMap<FunctionTreeNode, Float> createResultMap(List<Measurement> list, FunctionTreeNode functionTreeNode) {
            HashMap<FunctionTreeNode, Float> hashMap = new HashMap<FunctionTreeNode, Float>();
            String string = SegmentationNode.getSegmentationHashId(SegmentationNode.getParentNode(functionTreeNode));
            for (FunctionTreeNode functionTreeNode2 : functionTreeNode.getChildList()) {
                float f = 0.0f;
                for (Measurement measurement : list) {
                    SampleSegmentationColumn sampleSegmentationColumn = measurement.getSamples(string);
                    for (Sample sample : sampleSegmentationColumn) {
                        FunctionResult functionResult = sample.getFunctionResult(((FunctionTreeNodeWithId)functionTreeNode2).getUid());
                        f += functionResult != null ? functionResult.getValue() : 0.0f;
                    }
                }
                hashMap.put(functionTreeNode2, Float.valueOf(f));
            }
            return hashMap;
        }

        private static JPanel addLabelButton(String string, EntryMainHelper.ClickCallBack clickCallBack, String string2) {
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setOpaque(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            jPanel.add((Component)EntryMainHelper.createButton("", string, clickCallBack), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 10, 0, 0);
            jPanel.add((Component)new BreezeLabel(string2, false, 12), gridBagConstraints);
            return jPanel;
        }
    }

    public static class RuleImagePanel
    extends JPanel
    implements CustomLabelInputInterface {
        public RuleImagePanel(BreezeFrame breezeFrame, RuleImageParameter ruleImageParameter, Workflow workflow, FunctionTreeNode functionTreeNode, FunctionParameter.ChangeCallback changeCallback) {
            super(new GridBagLayout());
            this.setOpaque(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            this.add((Component)new BreezeSeparator(0, 10, 10), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            BreezeCheckBox breezeCheckBox = new BreezeCheckBox(ruleImageParameter.getAliasOrName(), ruleImageParameter.getValueBool(), bl -> {
                ruleImageParameter.setValueBool(bl);
                changeCallback.changed(ruleImageParameter, bl, true);
            });
            breezeCheckBox.setName("functionRule");
            this.add((Component)breezeCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 10, 0, 0);
            this.add((Component)EntryMainHelper.createSmallTextButton("Select", () -> BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Settings.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Select " + ruleImageParameter.getAliasOrName(), "", (AbstractBreezeCustomPanel)new AddParameter.AddParameterSelectionPanel(ruleImageParameter.getRuleImages(), ruleImageParameter.getAliasOrName()), null, breezeActionEvent -> {
                ruleImageParameter.setSettings(((AddParameter.AddParameterSelectionPanel)breezeActionEvent.getBreezeCustomPanel()).getNodeList());
                changeCallback.changed(ruleImageParameter, ruleImageParameter.getValueBool(), true);
            })), gridBagConstraints);
            List<? extends AddParameter.AddBasic> list = ruleImageParameter.getRuleImages();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(2, 10, 0, 0);
            int n = 0;
            for (AddParameter.AddBasic addBasic : list) {
                if (!addBasic.included) continue;
                ++n;
            }
            this.add((Component)new BreezeLabel("Included: " + n + " of " + list.size(), false, 12), gridBagConstraints);
        }
    }

    public static class BooleanInputPanel
    extends BreezeCheckBox
    implements CustomLabelInputInterface {
        public BooleanInputPanel(BooleanParameter booleanParameter, FunctionParameter.ChangeCallback changeCallback) {
            super(booleanParameter.getAliasOrName(), booleanParameter.getValueBool(), bl -> changeCallback.changed(booleanParameter, bl, true));
            this.setName("function" + NiceDataFormat.initialLetter((String)booleanParameter.getName()));
        }

        public BooleanInputPanel(String string, boolean bl, BreezeCheckBox.CheckBoxCallback checkBoxCallback) {
            super(string, bl, checkBoxCallback);
        }
    }

    public static class WorkflowUnitInputField
    extends BreezeInputField.Number
    implements CustomLabelInputInterface {
        public WorkflowUnitInputField(NumberParameter.WorkflowUnitParameter workflowUnitParameter, Workflow workflow, FunctionParameter.ChangeCallback changeCallback) {
            super(workflowUnitParameter.getAliasOrName(), workflowUnitParameter.getValue(), workflow.getDefaultUnit().name(), (TextActionEvent textActionEvent) -> changeCallback.changed(workflowUnitParameter, textActionEvent.getValue(), true));
            this.setUsage(workflowUnitParameter.getUsage());
        }
    }

    private static class DepthIntervalInputPanel
    extends JPanel {
        private final JPanel depthInputPanel = new JPanel(new GridBagLayout());

        public DepthIntervalInputPanel(Component component, Workflow workflow, DepthIntervalSegmentation.DepthIntervalParameter depthIntervalParameter, FunctionParameter.ChangeCallback changeCallback) {
            super(new GridBagLayout());
            this.setOpaque(false);
            FileInputField fileInputField = new FileInputField(component, "Import intervals", "", textActionEvent -> this.importIntervals(depthIntervalParameter, changeCallback, textActionEvent.getFile()), true){

                @Override
                protected void customizeDialog(jopensaveDialog jopensaveDialog2) {
                    jopensaveDialog2.addExtension("txt", "Text format");
                    jopensaveDialog2.addExtension("csv", "CSV format");
                    jopensaveDialog2.addAllSupported();
                    jopensaveDialog2.addAllFiles();
                }
            };
            fileInputField.getInputField().getTextField().setVisible(false);
            fileInputField.getInputField().setLabelWidth(100);
            fileInputField.getInputField().add((Component)new JLabel(""), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)fileInputField, GridBagHelper.create(this.getComponentCount(), new Insets(6, 0, 0, 0)));
            this.add((Component)new BreezeSeparator(), GridBagHelper.create(this.getComponentCount(), new Insets(12, 0, 0, 0)));
            this.depthInputPanel.setOpaque(false);
            this.add((Component)this.depthInputPanel, GridBagHelper.create(this.getComponentCount(), new Insets(6, 0, 0, 0)));
            this.updateList(workflow, depthIntervalParameter, depthIntervalParameter.getIntervalRules(), changeCallback);
            JPanel jPanel = new JPanel(new FlowLayout(0, 10, 5));
            jPanel.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, BreezeTheme.getInstance().getLabelForegroundMoreDifuse()));
            jPanel.setOpaque(false);
            jPanel.add(EntryMainHelper.createButton("Add", "add", () -> changeCallback.changed(depthIntervalParameter, this.getIntervals() + ";0:0", true)));
            jPanel.add(EntryMainHelper.createButton("Export", "file_save", () -> this.lambda$new$2(fileInputField, component, workflow)));
            jPanel.add(new BreezeSeparator());
            this.add((Component)jPanel, GridBagHelper.createLast(this.getComponentCount(), new Insets(12, 0, 0, 0)));
        }

        private void importIntervals(DepthIntervalSegmentation.DepthIntervalParameter depthIntervalParameter, FunctionParameter.ChangeCallback changeCallback, File file) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder();
            try {
                int n;
                object = Files.readAllLines(file.toPath());
                String string = object.getFirst().trim();
                String string2 = Reference.getDelimiter(string);
                String[] stringArray = string.split(string2);
                boolean bl = RtDataFormat.isText(stringArray[0]);
                String[] stringArray2 = null;
                int n2 = n = bl ? 1 : 0;
                while (n < object.size()) {
                    String[] stringArray3 = object.get(n).trim().split(string2);
                    if (stringArray.length == 2) {
                        stringBuilder.append(stringArray3[0].trim());
                        stringBuilder.append(":");
                        stringBuilder.append(stringArray3[1].trim());
                        stringBuilder.append(";");
                    } else if (stringArray.length == 1) {
                        if (stringArray2 != null) {
                            String string3 = stringArray2[0].trim();
                            double d = RtDataFormat.toNumber(string3);
                            double d2 = RtDataFormat.toNumber(stringArray3[0].trim());
                            stringBuilder.append(string3);
                            stringBuilder.append(":");
                            stringBuilder.append(RtDataFormat.toStringAll(d2 - d));
                            stringBuilder.append(";");
                        }
                        stringArray2 = stringArray3;
                    }
                    ++n;
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            object = stringBuilder.toString();
            depthIntervalParameter.setValueStr((String)object);
            changeCallback.changed(depthIntervalParameter, object, true);
        }

        private void updateList(Workflow workflow, DepthIntervalSegmentation.DepthIntervalParameter depthIntervalParameter, List<DepthIntervalSegmentation.DepthIntervalParameter.DepthIntervalSegmentationRule> list, FunctionParameter.ChangeCallback changeCallback) {
            this.depthInputPanel.removeAll();
            for (DepthIntervalSegmentation.DepthIntervalParameter.DepthIntervalSegmentationRule depthIntervalSegmentationRule : list) {
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = this.depthInputPanel.getComponentCount();
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(6, 6, 0, 0);
                DepthIntervalInputField depthIntervalInputField2 = new DepthIntervalInputField(workflow, depthIntervalSegmentationRule, textActionEvent -> changeCallback.changed(depthIntervalParameter, this.getIntervals(), false), depthIntervalInputField -> {
                    this.depthInputPanel.remove(depthIntervalInputField);
                    this.depthInputPanel.revalidate();
                    this.depthInputPanel.repaint();
                    depthIntervalParameter.setValueStr(this.getIntervals());
                    changeCallback.changed(depthIntervalParameter, this.getIntervals(), true);
                }, this.depthInputPanel.getComponentCount() == 0);
                this.depthInputPanel.add((Component)depthIntervalInputField2, gridBagConstraints);
            }
            this.depthInputPanel.revalidate();
            this.depthInputPanel.repaint();
        }

        private String getIntervals() {
            return this.getIntervals(null);
        }

        private String getIntervals(Workflow workflow) {
            boolean bl;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = bl = workflow != null;
            if (bl) {
                String string = workflow.getDefaultUnit().getUnit();
                stringBuilder.append("Start (").append(string).append(")\tInterval (").append(string).append(")\n");
            }
            for (int i = 0; i < this.depthInputPanel.getComponentCount(); ++i) {
                DepthIntervalInputField depthIntervalInputField = (DepthIntervalInputField)this.depthInputPanel.getComponent(i);
                if (i > 0) {
                    stringBuilder.append(bl ? "\n" : ";");
                }
                stringBuilder.append(depthIntervalInputField.fromInputField.getValue());
                stringBuilder.append(bl ? "\t" : ":");
                stringBuilder.append(depthIntervalInputField.valueInputField.getValue());
            }
            return stringBuilder.toString();
        }

        private /* synthetic */ void lambda$new$2(1 var1_1, Component component, Workflow workflow) {
            var1_1.save(component, "Export intervals", workflow.getName() + "_Depth_Intervals.txt", file -> {
                try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, false));){
                    bufferedWriter.append(this.getIntervals(workflow));
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            });
        }

        public static class DepthIntervalInputField
        extends JPanel {
            public final BreezeInputField.Number fromInputField;
            public final BreezeInputField.Number valueInputField;

            public DepthIntervalInputField(Workflow workflow, DepthIntervalSegmentation.DepthIntervalParameter.DepthIntervalSegmentationRule depthIntervalSegmentationRule, TextActionEvent.TextActionListener textActionListener, OnDeleteCallback onDeleteCallback, boolean bl) {
                super(new GridBagLayout());
                String string = workflow.getDefaultUnit().getUnit();
                this.setOpaque(false);
                this.fromInputField = new BreezeInputField.Number("Start (" + string + ")", depthIntervalSegmentationRule.startingFrom(), "", textActionListener);
                this.fromInputField.setValueWidth(100);
                this.fromInputField.getLabel().setVisible(bl);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 1;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                this.add((Component)this.fromInputField, gridBagConstraints);
                this.valueInputField = new BreezeInputField.Number("Interval (" + string + ")", depthIntervalSegmentationRule.magnitudePerInterval(), "", textActionListener);
                this.valueInputField.getLabel().setVisible(bl);
                GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
                gridBagConstraints2.gridx = 1;
                gridBagConstraints2.fill = 1;
                gridBagConstraints2.weighty = 1.0;
                gridBagConstraints2.weightx = 1.0;
                gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
                this.add((Component)this.valueInputField, gridBagConstraints2);
                BreezeButton breezeButton = new BreezeButton();
                breezeButton.setEnabled(!bl);
                breezeButton.setPreferredSize(new Dimension(20, 24));
                breezeButton.setText("-");
                breezeButton.setToolTipText("Delete");
                breezeButton.setTextFont(new Font("Tahoma", 0, 16));
                breezeButton.addClickCallBack(() -> onDeleteCallback.delete(this));
                GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
                gridBagConstraints3.gridx = 2;
                gridBagConstraints3.anchor = 15;
                gridBagConstraints3.insets = new Insets(0, 0, 1, 0);
                this.add((Component)breezeButton, gridBagConstraints3);
            }

            public static interface OnDeleteCallback {
                public void delete(DepthIntervalInputField var1);
            }
        }
    }

    private static class DataSlicingInputPanel
    extends JPanel {
        private final JPanel mainPanel = new JPanel(new GridBagLayout());

        public DataSlicingInputPanel(BreezeFrame breezeFrame, DataSlicingDescriptor.DataSlicingParameter dataSlicingParameter, FunctionParameter.ChangeCallback changeCallback) {
            super(new BorderLayout());
            this.setOpaque(false);
            this.mainPanel.setOpaque(false);
            this.add((Component)this.mainPanel, "Center");
            CategoryFactor categoryFactor = dataSlicingParameter.createCategoryFactor("uid");
            List<CatClass> list = categoryFactor.getClasses();
            this.updateList(dataSlicingParameter, categoryFactor, changeCallback);
            JPanel jPanel = new JPanel(new FlowLayout(0, 10, 5));
            jPanel.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, BreezeTheme.getInstance().getLabelForegroundMoreDifuse()));
            jPanel.setOpaque(false);
            jPanel.add(EntryMainHelper.createButton("Add", "material/add", () -> {
                dataSlicingParameter.selected = new DataSlicingDescriptor.DataSlicingParameter.DataSliceCatClass("New", categoryFactor);
                dataSlicingParameter.selected.setColor(RtPerfectSpread.generateColor(categoryFactor.getTotalCount()));
                list.add(dataSlicingParameter.selected);
                changeCallback.changed(dataSlicingParameter, dataSlicingParameter.getUpdatedText(categoryFactor), true);
            }));
            jPanel.add(new BreezeSeparator());
            jPanel.add(EntryMainHelper.createButton("Up", "material/arrow_upward", () -> {
                int n;
                int n2 = n = dataSlicingParameter.selected != null ? list.indexOf(dataSlicingParameter.selected) : 0;
                if (n > 0) {
                    this.swap(list, n, n - 1);
                    changeCallback.changed(dataSlicingParameter, dataSlicingParameter.getUpdatedText(categoryFactor), true);
                }
            }));
            jPanel.add(EntryMainHelper.createButton("Down", "material/arrow_downward", () -> {
                int n;
                int n2 = n = dataSlicingParameter.selected != null ? list.indexOf(dataSlicingParameter.selected) : list.size();
                if (n < list.size() - 1) {
                    this.swap(list, n, n + 1);
                    changeCallback.changed(dataSlicingParameter, dataSlicingParameter.getUpdatedText(categoryFactor), true);
                }
            }));
            this.add((Component)jPanel, "South");
        }

        private CatClass swap(List<CatClass> list, int n, int n2) {
            CatClass catClass = list.get(n2);
            CatClass catClass2 = list.get(n);
            list.set(n2, catClass2);
            list.set(n, catClass);
            return catClass2;
        }

        private void updateList(final DataSlicingDescriptor.DataSlicingParameter dataSlicingParameter, final CategoryFactor categoryFactor, final FunctionParameter.ChangeCallback changeCallback) {
            this.mainPanel.removeAll();
            final List<CatClass> list = categoryFactor.getClasses();
            for (final CatClass catClass : list) {
                if (catClass.isNoClass()) continue;
                DataSlicingDescriptor.DataSlicingParameter.DataSliceCatClass dataSliceCatClass = (DataSlicingDescriptor.DataSlicingParameter.DataSliceCatClass)catClass;
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = this.mainPanel.getComponentCount();
                gridBagConstraints.insets = new Insets(6, 0, 6, 0);
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                DeleteCatClassInputField.DataSliceDeleteCatClassInputField dataSliceDeleteCatClassInputField = new DeleteCatClassInputField.DataSliceDeleteCatClassInputField(dataSliceCatClass, new DeleteCatClassInputField.OnChangeCallback(){

                    @Override
                    public void onChange(DeleteCatClassInputField deleteCatClassInputField) {
                        changeCallback.changed(dataSlicingParameter, dataSlicingParameter.getUpdatedText(categoryFactor), false);
                    }

                    @Override
                    public void action() {
                        list.remove(catClass);
                        changeCallback.changed(dataSlicingParameter, dataSlicingParameter.getUpdatedText(categoryFactor), true);
                    }
                });
                if (dataSlicingParameter.selected != null && catClass.getName().equals(dataSlicingParameter.selected.getName())) {
                    SwingUtilities.invokeLater(() -> dataSliceDeleteCatClassInputField.getValueField().requestFocusAndSelectAll());
                }
                dataSliceDeleteCatClassInputField.addFocusListener(new FocusAdapter(this){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        dataSlicingParameter.selected = catClass;
                    }
                });
                dataSliceDeleteCatClassInputField.setName("dataslice" + NiceDataFormat.initialLetter((String)dataSlicingParameter.getName()));
                this.mainPanel.add((Component)dataSliceDeleteCatClassInputField, gridBagConstraints);
            }
            this.mainPanel.revalidate();
            this.mainPanel.repaint();
        }
    }

    private static class NumberSliderPanel
    extends BreezeSlider.BreezeSliderInputField {
        public NumberSliderPanel(BreezeFrame breezeFrame, NumberSliderParameter numberSliderParameter, FunctionParameter.ChangeCallback changeCallback) {
            super(null, numberSliderParameter.getMinMax().min().floatValue(), numberSliderParameter.getMinMax().max().floatValue(), numberSliderParameter.getValueFloat(), f -> changeCallback.changed(numberSliderParameter, Float.valueOf(f), false), numberSliderParameter.getDecimalFactor());
        }
    }

    private static class NumberRangePanel
    extends BreezeRangeSliderPanel {
        public NumberRangePanel(NumberRangeParameter numberRangeParameter, FunctionParameter.ChangeCallback changeCallback) {
            super(numberRangeParameter.getRangeMinMax().min().floatValue(), numberRangeParameter.getRangeMinMax().max().floatValue(), numberRangeParameter.getSetValues().min().floatValue(), numberRangeParameter.getSetValues().max().floatValue(), numberRangeParameter.getDecimalFactor(), minMax -> {
                changeCallback.changed(numberRangeParameter, minMax.formatRange(), false);
                return minMax;
            });
        }
    }

    public static interface CustomLabelInputInterface {
    }
}

