/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.play.edit;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FunctionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.NumberParameter;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.Toast;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeTextField;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.validator.NumericMinMaxValidator;
import se.prediktera.breeze.frontend.main.play.edit.EditDescriptorHelper;
import se.prediktera.breeze.frontend.main.play.edit.EditDescriptorPanel;
import se.prediktera.breeze.frontend.main.play.edit.FunctionParameterCustomInput;
import se.prediktera.map.common.NiceDataFormat;

public class FunctionPropertyPanel
extends JPanel {
    private final List<FunctionParameter> changedList = new ArrayList<FunctionParameter>();
    private final FunctionTreeNode functionNode;
    private final ParameterChangedCallback callback;

    public FunctionPropertyPanel(BreezeFrame breezeFrame, Workflow workflow, Object object, FunctionTreeNode functionTreeNode, ParameterChangedCallback parameterChangedCallback, BreezeInputFieldHelper.Format format) {
        super(new GridBagLayout());
        this.functionNode = functionTreeNode;
        this.callback = parameterChangedCallback;
        this.setOpaque(false);
        AbstractBreezeFunction abstractBreezeFunction = functionTreeNode.getFunction();
        for (FunctionParameter functionParameter : abstractBreezeFunction.getParameterList()) {
            Serializable serializable;
            JComponent jComponent;
            if (!functionParameter.isVisible(functionTreeNode)) continue;
            String string = NiceDataFormat.initialLetter((String)functionParameter.getAliasOrName());
            JComponent jComponent2 = FunctionParameterCustomInput.customInput(functionParameter, breezeFrame, workflow, object, functionTreeNode, this::parameterChanged);
            if (jComponent2 == null) {
                jComponent2 = this.createComponent(workflow, functionTreeNode, functionParameter);
            }
            if (!jComponent2.isVisible()) continue;
            if (functionParameter.isEditable()) {
                if (jComponent2 instanceof JComboBox && ((JComboBox)(jComponent = (JComboBox)jComponent2)).getItemCount() <= 1) {
                    ((JComboBox)jComponent).setEnabled(false);
                }
            } else {
                jComponent2.setEnabled(false);
            }
            jComponent = new JPanel(new GridBagLayout());
            jComponent.setOpaque(false);
            if (FunctionPropertyPanel.showLabel(jComponent2)) {
                serializable = new BreezeLabel(string, false, 14);
                ((JComponent)serializable).setPreferredSize(new Dimension(100, 20));
                jComponent.add((Component)serializable, GridBagHelper.create(0, new Insets(0, 0, 0, 0)));
            }
            serializable = new GridBagConstraints();
            ((GridBagConstraints)serializable).fill = 2;
            ((GridBagConstraints)serializable).weightx = 1.0;
            if (format.equals((Object)BreezeInputFieldHelper.Format.OneRow)) {
                ((GridBagConstraints)serializable).gridx = 1;
            } else {
                ((GridBagConstraints)serializable).gridy = 1;
            }
            ((GridBagConstraints)serializable).insets = new Insets(2, 0, 0, 0);
            jComponent.add((Component)jComponent2, serializable);
            String string2 = functionParameter.getUsage();
            if (string2 != null && string2.length() > 0) {
                serializable = new GridBagConstraints();
                ((GridBagConstraints)serializable).fill = 2;
                if (format.equals((Object)BreezeInputFieldHelper.Format.OneRow)) {
                    ((GridBagConstraints)serializable).gridx = 1;
                    ((GridBagConstraints)serializable).gridy = 1;
                } else {
                    ((GridBagConstraints)serializable).gridy = 2;
                }
                ((GridBagConstraints)serializable).insets = new Insets(2, 0, 0, 0);
                BreezeLabel breezeLabel = new BreezeLabel(string2);
                breezeLabel.setFont(new Font(breezeLabel.getFont().getFontName(), 2, 12));
                breezeLabel.setForeground(BreezeTheme.getInstance().getLabelForegroundDifuse());
                breezeLabel.setPreferredSize(new Dimension(0, 20));
                breezeLabel.setToolTipText(string2);
                jComponent.add((Component)breezeLabel, serializable);
            }
            serializable = new GridBagConstraints();
            ((GridBagConstraints)serializable).fill = 2;
            ((GridBagConstraints)serializable).weightx = 1.0;
            ((GridBagConstraints)serializable).gridy = this.getComponentCount();
            ((GridBagConstraints)serializable).insets = new Insets(this.getComponentCount() > 0 ? 6 : 0, 0, 0, 0);
            this.add((Component)jComponent, serializable);
        }
        if (!this.changedList.isEmpty()) {
            for (FunctionParameter functionParameter : abstractBreezeFunction.getParameterList()) {
                EditDescriptorHelper.changeParameterRecursive(functionTreeNode, functionParameter);
            }
        }
    }

    private static boolean showLabel(JComponent jComponent) {
        return !(jComponent instanceof FunctionParameterCustomInput.CustomLabelInputInterface);
    }

    /*
     * WARNING - void declaration
     */
    private JComponent createComponent(Workflow workflow, FunctionTreeNode functionTreeNode, FunctionParameter functionParameter) {
        Object[] objectArray = functionParameter.getOptions(workflow, functionTreeNode);
        if (objectArray != null) {
            void var6_10;
            Object object;
            BreezeComboBox breezeComboBox = new BreezeComboBox(true, 0);
            breezeComboBox.setName("function" + NiceDataFormat.initialLetter((String)functionParameter.getName()));
            breezeComboBox.setRenderer(new EditDescriptorPanel.DescriptorListCellRenderer());
            breezeComboBox.setVisible(functionParameter.isVisible(functionTreeNode));
            for (Object object2 : objectArray) {
                breezeComboBox.addItem(object2);
            }
            Object numberParameter = functionParameter.getValueObj();
            int n = 0;
            for (Object object3 : objectArray) {
                if (!object3.equals(numberParameter)) continue;
                n = 1;
                break;
            }
            if (objectArray.length > 0 && n == 0 && functionParameter.setValue(object = FunctionPropertyPanel.getOption(objectArray, functionParameter.getOptionIndex()))) {
                this.changedList.add(functionParameter);
            }
            breezeComboBox.setSelectedItem(var6_10);
            breezeComboBox.addItemListener(itemEvent -> {
                if (itemEvent.getStateChange() == 1) {
                    this.parameterChanged(functionParameter, breezeComboBox.getValue(), true);
                }
            });
            return breezeComboBox;
        }
        BreezeTextField breezeTextField = new BreezeTextField();
        breezeTextField.setName("function" + NiceDataFormat.initialLetter((String)functionParameter.getName()));
        breezeTextField.setText(functionParameter.getValueStr());
        breezeTextField.setVisible(functionParameter.isVisible(null));
        if (functionParameter instanceof NumberParameter) {
            NumberParameter numberParameter = (NumberParameter)functionParameter;
            breezeTextField.setNumberField(true);
            if (numberParameter.getMinMax() != null) {
                breezeTextField.addValidator(new NumericMinMaxValidator(numberParameter.getMinMax()));
            }
        }
        breezeTextField.addChangeListener(textActionEvent -> this.parameterChanged(functionParameter, breezeTextField.getText(), true));
        return breezeTextField;
    }

    private static Object getOption(Object[] objectArray, int n) {
        if (n < objectArray.length) {
            return objectArray[n];
        }
        return objectArray[0];
    }

    public boolean hasChanged() {
        return !this.changedList.isEmpty();
    }

    public void showToasterOnChanged() {
        for (FunctionParameter functionParameter : this.changedList) {
            ToastHandler.getInstance().showToast("\"" + functionParameter.getAliasOrName() + "\" changed to " + String.valueOf(functionParameter.getValueObj()), Toast.IconType.Warning, Time.FiveSeconds);
        }
    }

    public boolean hasProperties() {
        return this.getComponentCount() > 0;
    }

    private void parameterChanged(FunctionParameter functionParameter, Object object, boolean bl) {
        if (object != null) {
            functionParameter.setValue(object);
            AbstractBreezeFunction abstractBreezeFunction = this.functionNode.getFunction();
            if (abstractBreezeFunction.isDescriptor() && functionParameter.updateParameterRecursive()) {
                EditDescriptorHelper.changeParameterRecursive(this.functionNode, functionParameter);
            }
        }
        this.callback.parameterChanged(bl);
    }

    public BreezeComboBox getParameterComboBoxByLabelText(String string) {
        for (Component component : this.getComponents()) {
            BreezeLabel breezeLabel = (BreezeLabel)((JPanel)component).getComponent(0);
            if (!breezeLabel.getText().equals(string)) continue;
            return (BreezeComboBox)((JPanel)component).getComponent(1);
        }
        return null;
    }

    public BreezeTextField getParameterTextFieldByLabelText(String string) {
        for (Component component : this.getComponents()) {
            BreezeLabel breezeLabel = (BreezeLabel)((JPanel)component).getComponent(0);
            if (!breezeLabel.getText().equals(string)) continue;
            return (BreezeTextField)((JPanel)component).getComponent(1);
        }
        return null;
    }

    public static interface ParameterChangedCallback {
        public void parameterChanged(boolean var1);
    }
}

