/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.play.group.measurement;

import java.awt.Component;
import java.util.Properties;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SampleSegmentationColumn;
import se.prediktera.breeze.entry.workflow.LimitConfiguration;
import se.prediktera.breeze.entry.workflow.PropertyLimit;
import se.prediktera.breeze.entry.workflow.VisualisationNode;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.data.PixelDataHelper;
import se.prediktera.breeze.evince.data.SamplePredictionDataHelper;
import se.prediktera.breeze.evince.data.queue.UpdateVisualizationJob;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMeasurementPanel;
import se.prediktera.breeze.frontend.common.pp.PPEntryMainInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.common.view.visualization.PlotViewPanel;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.plot.AbstractPlot;
import se.prediktera.map.plot.PlotPopupMenu;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.windows.LegendWindow;
import se.prediktera.map.plot.layout.AbstractPlotLayout;

public class YPredPlotPanel
extends ViewContainer
implements PPEntryMainInterface {
    private final Analyse analyse;
    private Factor factor;
    private Object entrydata;
    private final DescriptorTreeNode node;
    private final Workflow workflow;
    private final Group group;
    private BreezeButton saveButton;
    private boolean usesPredictionData;

    public YPredPlotPanel(EntryMeasurementPanel entryMeasurementPanel, DescriptorTreeNode descriptorTreeNode, Group group) {
        super(entryMeasurementPanel, false);
        this.node = descriptorTreeNode;
        this.group = group;
        this.workflow = group.getParent();
        AbstractBreezeFunction abstractBreezeFunction = descriptorTreeNode.getFunction();
        String string = abstractBreezeFunction.getParameterByName("analyse").getValueStr();
        String string2 = abstractBreezeFunction.getParameterByName("factor").getValueStr();
        this.analyse = (Analyse)BreezeMasterCache.getInstance().getAnalyseList().byId(string);
        if (this.analyse != null) {
            this.factor = this.analyse.getFactorHolder().getFactorByUid(string2);
            int n = this.analyse.getFactorHolder().getFactorIndex(this.factor) + 1;
            PlotViewPanel plotViewPanel = this.factor instanceof PropertyFactor ? this.createPropertyPlot(entryMeasurementPanel, this.analyse, (PropertyFactor)this.factor, n) : this.createCategoryPlot(entryMeasurementPanel, this.analyse, (CategoryFactor)this.factor, n);
            plotViewPanel.setName("result" + this.factor.getName());
            this.addViewPanel((Component)((Object)plotViewPanel));
            this.saveButton = EntryMainHelper.createButton("Save", "save", () -> PlotPopupMenu.showSaveDialog((AbstractPlot)plotViewPanel.getVisualization(), (String)(this.workflow.getName() + "_" + this.factor.getName())));
        }
    }

    @Override
    public void addComponent(BreezeMainPanel breezeMainPanel) {
        if (this.saveButton != null) {
            breezeMainPanel.addRightButton(this.saveButton);
        }
    }

    public Analyse getAnalyse() {
        return this.analyse;
    }

    public Factor getFactor() {
        return this.factor;
    }

    @Override
    public Object getInData(BreezeProgressManager breezeProgressManager, UpdateVisualizationJob updateVisualizationJob, String string) {
        Measurement measurement = this.getMeasurement();
        this.usesPredictionData = false;
        if (measurement.hasDataOrPrediction()) {
            if (measurement.hasData()) {
                return PixelDataHelper.getInmatrix(this.getOrCreateEvinceProject(), breezeProgressManager, updateVisualizationJob, this.analyse, string);
            }
            this.usesPredictionData = true;
            return SamplePredictionDataHelper.getInmatrix(breezeProgressManager, updateVisualizationJob, this.analyse, string);
        }
        throw new RuntimeException("No raw or prediction data available");
    }

    private Measurement getMeasurement() {
        if (this.entrydata instanceof Measurement) {
            return (Measurement)this.entrydata;
        }
        if (this.entrydata instanceof Sample) {
            return ((Sample)this.entrydata).measurement();
        }
        return null;
    }

    @Override
    public Project_GUI getOrCreateEvinceProject() {
        return this.mainpanel.getOrCreateEvinceProject();
    }

    @Override
    public String getType() {
        return "YPred";
    }

    @Override
    public void showEntry(Object object, Object object2) {
        super.showEntry(object, object2);
        this.entrydata = object;
    }

    private PlotViewPanel createCategoryPlot(EntryMeasurementPanel entryMeasurementPanel, Analyse analyse, final CategoryFactor categoryFactor, final int n) {
        final String[] stringArray = new String[]{"origmatrix", "prediction_" + analyse.getUid()};
        return new PlotViewPanel(this, entryMeasurementPanel, "Predicted distribution", "Contour2D", stringArray, analyse){
            final /* synthetic */ YPredPlotPanel this$0;
            {
                this.this$0 = yPredPlotPanel;
                super(pPEntryMainInterface, string, string2, stringArray3, analyse);
            }

            @Override
            public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
                AbstractAxisLayer abstractAxisLayer;
                Properties properties = new Properties();
                properties.put("title", categoryFactor.getName());
                if (stringArray.length > 1) {
                    properties.put("colorscheme", "gray");
                    properties.put("forcereflectance", String.valueOf(abstractPlotLayout.isAbsorbanceData()));
                    abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(2.0));
                    abstractAxisLayer.setColor(new Object[]{"amplitude", properties});
                    abstractAxisLayer.setDataRange(new Object[]{"range", "matrix", 43.0, properties});
                }
                abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(1.0));
                abstractAxisLayer.setDataRange(new Object[]{"range", "matrix", (double)n, properties});
                LegendWindow legendWindow = abstractPlotLayout.addLegend(new Object[]{"color", "right", properties});
                legendWindow.setDimension(Double.valueOf(10.0), Double.valueOf(80.0));
                legendWindow.setPosition(Double.valueOf(100.0), Double.valueOf(50.0));
            }

            @Override
            public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
                AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(1.0));
                abstractAxisLayer.setColor(new Object[]{"predictioncategory", 1.0});
            }

            @Override
            public void preSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
            }

            @Override
            public Object getInData(BreezeProgressManager breezeProgressManager, UpdateVisualizationJob updateVisualizationJob, String string, Analyse analyse, int n2) throws Exception {
                return this.this$0.getInData(breezeProgressManager, updateVisualizationJob, string);
            }

            @Override
            protected boolean supportChange() {
                return false;
            }
        };
    }

    private PlotViewPanel createPropertyPlot(EntryMeasurementPanel entryMeasurementPanel, final Analyse analyse, final PropertyFactor propertyFactor, final int n) {
        final String[] stringArray = new String[]{"origmatrix", "prediction_" + analyse.getUid()};
        return new PlotViewPanel(this, entryMeasurementPanel, "Predicted distribution", "Contour2D", stringArray){
            final /* synthetic */ YPredPlotPanel this$0;
            {
                this.this$0 = yPredPlotPanel;
                super(pPEntryMainInterface, string, string2, stringArray3);
            }

            @Override
            public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
                AbstractAxisLayer abstractAxisLayer;
                Properties properties = new Properties();
                properties.put("title", propertyFactor.getName());
                if (stringArray.length > 1) {
                    properties.put("colorscheme", "gray");
                    properties.put("forcereflectance", String.valueOf(abstractPlotLayout.isAbsorbanceData()));
                    abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(2.0));
                    abstractAxisLayer.setColor(new Object[]{"amplitude", properties});
                    abstractAxisLayer.setDataRange(new Object[]{"range", "matrix", 43.0, properties});
                }
                abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(1.0));
                abstractAxisLayer.setDataRange(new Object[]{"range", "matrix", (double)n, properties});
                LegendWindow legendWindow = abstractPlotLayout.addLegend(new Object[]{"color", "right", properties});
                legendWindow.setDimension(Double.valueOf(10.0), Double.valueOf(80.0));
                legendWindow.setPosition(Double.valueOf(100.0), Double.valueOf(50.0));
            }

            @Override
            public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
                AbstractModel abstractModel = analyse.getBaseModel(breezeProgressManager);
                AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(1.0));
                if (this.this$0.usesPredictionData) {
                    abstractAxisLayer.setDataRange(new Object[]{"range", "matrix", analyse.getUid() + "_" + propertyFactor.getName(), null});
                }
                Properties properties = this.getColorMinMaxProperties(abstractModel);
                abstractAxisLayer.setColor(new Object[]{"amplitude", properties});
                StringBuilder stringBuilder = new StringBuilder();
                if (this.this$0.entrydata instanceof Measurement) {
                    stringBuilder.append(NiceDataFormat.toString((double)this.calculateAverage((Measurement)this.this$0.entrydata), (int)6));
                    stringBuilder.append(propertyFactor.getUnit());
                } else if (this.this$0.entrydata instanceof Sample) {
                    stringBuilder.append(NiceDataFormat.toString((double)((Sample)this.this$0.entrydata).getDescriptorValue(this.this$0.node), (int)6));
                    stringBuilder.append(propertyFactor.getUnit());
                } else {
                    stringBuilder.append("N/A");
                }
                this.setSubLabel("Average " + propertyFactor.getName(), stringBuilder.toString());
            }

            private float calculateAverage(Measurement measurement) {
                SampleSegmentationColumn sampleSegmentationColumn = measurement.getSamples(this.this$0.workflow.getSegmentationLevel());
                float f = 0.0f;
                for (Sample sample : sampleSegmentationColumn) {
                    f += sample.getDescriptorValue(this.this$0.node);
                }
                if (sampleSegmentationColumn.size() > 0) {
                    f /= (float)sampleSegmentationColumn.size();
                }
                return f;
            }

            private Properties getColorMinMaxProperties(AbstractModel abstractModel) {
                PropertyLimit propertyLimit;
                Properties properties = new Properties();
                VisualisationNode visualisationNode = this.this$0.workflow.getVisualisationNode();
                LimitConfiguration limitConfiguration = visualisationNode.getDefaultLimitNode(this.this$0.group);
                if (limitConfiguration != null && (propertyLimit = limitConfiguration.getWrapper(propertyFactor)) != null) {
                    properties.put("min", String.valueOf(propertyLimit.getMin()));
                    properties.put("max", String.valueOf(propertyLimit.getMax()));
                    return properties;
                }
                if (abstractModel != null) {
                    propertyLimit = abstractModel.getOutput();
                    properties.put("min", String.valueOf(propertyLimit.getYmin(propertyFactor.getName())));
                    properties.put("max", String.valueOf(propertyLimit.getYmax(propertyFactor.getName())));
                    return properties;
                }
                if (propertyFactor != null) {
                    properties.put("min", String.valueOf(propertyFactor.getMin()));
                    properties.put("max", String.valueOf(propertyFactor.getMax()));
                }
                return properties;
            }

            @Override
            public void preSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
                this.setSubLabel("Average " + propertyFactor.getName(), "Calculating...");
            }

            @Override
            public Object getInData(BreezeProgressManager breezeProgressManager, UpdateVisualizationJob updateVisualizationJob, String string, Analyse analyse2, int n2) throws Exception {
                return this.this$0.getInData(breezeProgressManager, updateVisualizationJob, string);
            }

            @Override
            protected boolean supportChange() {
                return false;
            }
        };
    }
}

