/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.play.group.panel;

import java.awt.Component;
import java.util.List;
import java.util.Properties;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.realtime.descriptor.AbstractModelDescriptor;
import se.prediktera.breeze.entry.workflow.VisualisationNode;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.pp.PPEntryMainInterface;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.view.TabViewContainer;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.common.view.visualization.PlotViewPanel;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.model.AbstractPrediction;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.plot2D.serie.serie2D.FloatWindowSerie;
import se.prediktera.map.plot.axisplot.plot2D.spectral.FloatWindowSpectral;
import se.prediktera.map.plot.axisplot.settings.PlotOptionException;
import se.prediktera.map.plot.layout.AbstractPlotLayout;

public class ExploreSummaryPlots {
    private final TabViewLinePlotContainer tabViewLinePlotContainer;

    public ExploreSummaryPlots(BreezeFrame breezeFrame, ViewContainer viewContainer, PPEntryMainInterface pPEntryMainInterface, Workflow workflow, boolean bl) {
        boolean bl2;
        List<DescriptorTreeNode> list = workflow.getSegmentationLevelDescriptorNodes(true);
        boolean[] blArray = ExploreSummaryPlots.getModelDescriptorType(list);
        VisualisationNode visualisationNode = workflow.getVisualisationNode();
        PlotViewPanel plotViewPanel = ExploreSummaryPlots.createExplorePredPanel(breezeFrame, pPEntryMainInterface, visualisationNode, workflow);
        viewContainer.addViewPanel((Component)((Object)plotViewPanel), 0, 0);
        viewContainer.addViewPanel((Component)((Object)ExploreSummaryPlots.createDmodXPanel(breezeFrame, pPEntryMainInterface, visualisationNode, workflow)), 1, 0);
        boolean bl3 = bl2 = ExploreSummaryPlots.isOnlyQuantificationOrNoModels(blArray);
        this.tabViewLinePlotContainer = new TabViewLinePlotContainer(viewContainer.getMainPanel(), pPEntryMainInterface, bl3, workflow, list);
        if (bl) {
            plotViewPanel.addComponent(EntryMainHelper.createOpenMeasurementFromPlotButton(viewContainer.getMainPanel(), this.tabViewLinePlotContainer.getLinePlotViewPanel()));
        }
        if (bl2 || list.isEmpty()) {
            viewContainer.addViewPanel((Component)((Object)this.tabViewLinePlotContainer), 0, 1, 2, 0, null, 1.0, 1.0);
        } else {
            viewContainer.addViewPanel((Component)((Object)this.tabViewLinePlotContainer), 0, 1);
            viewContainer.addViewPanel((Component)((Object)ExploreSummaryPlots.createCountPanel(pPEntryMainInterface, list, visualisationNode)), 1, 1);
        }
    }

    public void setData(Workflow workflow) {
        this.tabViewLinePlotContainer.updateDescriptorNodesIfChanged(workflow.getSegmentationLevelDescriptorNodes(true));
    }

    private static boolean isOnlyQuantificationOrNoModels(boolean[] blArray) {
        return blArray[0] && !blArray[1] || !blArray[0] && !blArray[1];
    }

    public static boolean[] getModelDescriptorType(List<DescriptorTreeNode> list) {
        boolean[] blArray = new boolean[2];
        for (DescriptorTreeNode descriptorTreeNode : list) {
            if (!(descriptorTreeNode.getFunction() instanceof AbstractModelDescriptor)) continue;
            Factor factor = descriptorTreeNode.getFactor();
            if (factor instanceof PropertyFactor) {
                blArray[0] = true;
                continue;
            }
            if (!(factor instanceof CategoryFactor)) continue;
            blArray[1] = true;
        }
        return blArray;
    }

    public static PlotViewPanel createCountPanel(PPEntryMainInterface pPEntryMainInterface, List<DescriptorTreeNode> list, VisualisationNode visualisationNode) {
        CategoryFactor categoryFactor = (CategoryFactor)ExploreSummaryPlots.getFirstClassificationFactor(list);
        List<CatClass> list2 = categoryFactor.getClasses();
        final Properties properties = new Properties();
        properties.setProperty("colorscheme", "[custom]");
        properties.setProperty("colors", String.valueOf(list2.size()));
        for (int i = 0; i < list2.size(); ++i) {
            properties.setProperty("color" + (i + 1), list2.get(i).getColorString());
        }
        return new PlotViewPanel(pPEntryMainInterface, "Classes count", "Column", "descriptors_count"){

            @Override
            public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
                super.plotSetup(abstractPlotLayout);
                abstractPlotLayout.addLegend(new Object[]{"color", "right", new Properties()});
                abstractPlotLayout.setColor(new Object[]{"index", properties});
                ((FloatWindowSerie)abstractPlotLayout.getMainWindow()).setDrawnumber(true, true);
            }

            @Override
            public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
                AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(1.0));
                abstractAxisLayer.setLayerName("Samples");
                abstractPlotLayout.setLabel(new Object[]{"identifier"});
            }
        };
    }

    public static Factor getFirstClassificationFactor(List<DescriptorTreeNode> list) {
        for (DescriptorTreeNode descriptorTreeNode : list) {
            Factor factor;
            AbstractBreezeFunction abstractBreezeFunction = descriptorTreeNode.getFunction();
            if (!(abstractBreezeFunction instanceof AbstractModelDescriptor) || !((factor = descriptorTreeNode.getFactor()) instanceof CategoryFactor)) continue;
            return factor;
        }
        return null;
    }

    public static PlotViewPanel createExplorePredPanel(BreezeFrame breezeFrame, PPEntryMainInterface pPEntryMainInterface, final VisualisationNode visualisationNode, Workflow workflow) {
        return new PlotViewPanel(pPEntryMainInterface, "Predicted Measurements", "Scatter2D", new String[]{"modelPca_t", "modelPca_tpred"}){

            @Override
            public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
                super.plotSetup(abstractPlotLayout);
                abstractPlotLayout.getPlotInit().relatedToAll = true;
                AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(1.0));
                abstractAxisLayer.setLayerName("Samples");
                abstractAxisLayer.setLine(new Object[]{"index"});
                abstractAxisLayer.setColor(new Object[]{"fixed", visualisationNode.getColor()});
                abstractAxisLayer.setSize(new Object[]{"index", new Double[]{4.0, 16.0}});
                AbstractAxisLayer abstractAxisLayer2 = abstractPlotLayout.getLayer(Double.valueOf(2.0));
                abstractAxisLayer2.setInteraction(false);
                abstractAxisLayer2.setStatistics(new Object[]{"hotelling", new ScriptHelper.ScriptProperties(new ScriptHelper.Property[]{new ScriptHelper.Property("autoadjustminmax", "false")})});
                abstractAxisLayer2.setColor(new Object[]{"fixed", "white"});
                abstractAxisLayer2.setSize(new Object[]{"fixed", 0.0});
            }

            @Override
            public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
            }

            @Override
            protected boolean supportChange() {
                return false;
            }
        };
    }

    public static PlotViewPanel createDmodXPanel(BreezeFrame breezeFrame, PPEntryMainInterface pPEntryMainInterface, final VisualisationNode visualisationNode, Workflow workflow) {
        return new PlotViewPanel(pPEntryMainInterface, "Distance to model", "Column", new String[]{"modelPca_obsdmxpred"}){

            @Override
            public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
                super.plotSetup(abstractPlotLayout);
                abstractPlotLayout.getPlotInit().relatedToAll = true;
                abstractPlotLayout.removeArea("labelx");
                Properties properties = new Properties();
                properties.put("editable", "false");
                abstractPlotLayout.setStatistics(new Object[]{"dcrit", properties});
                AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(1.0));
                abstractAxisLayer.setColor(new Object[]{"fixed", visualisationNode.getColor()});
                abstractPlotLayout.setLabel(new Object[]{"none"});
            }

            @Override
            public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
                AbstractPrediction abstractPrediction;
                AbstractDataMatrix abstractDataMatrix;
                DataTreeInterface dataTreeInterface;
                PlotInit plotInit = abstractPlotLayout.getPlotInit();
                if (plotInit != null && (dataTreeInterface = (abstractDataMatrix = (AbstractDataMatrix)plotInit.getDataTreeInterface()).getTreeParent()) instanceof AbstractPrediction && (abstractPrediction = (AbstractPrediction)dataTreeInterface) != null) {
                    abstractPlotLayout.setDataRange(new Object[]{"y", "value", (double)abstractPrediction.getModel().getComponentsInt()});
                }
            }
        };
    }

    private static void setPlotByVariableName(AbstractPlotLayout abstractPlotLayout, String string, String string2) {
        try {
            abstractPlotLayout.setDataRange(new Object[]{string, "value", string2});
        }
        catch (PlotOptionException plotOptionException) {
            Logg.warn((String)"Variable not found in plot", (Object[])new Object[]{string2});
        }
    }

    private static class TabViewLinePlotContainer
    extends TabViewContainer {
        private final LinePlotViewPanel linePlotViewPanel;
        private final ViewContainer viewContainer = new ViewContainer();
        private HistogramPlotViewPanel histogramPanel;
        private List<DescriptorTreeNode> descriptorNodes;

        public TabViewLinePlotContainer(BreezeMainPanel breezeMainPanel, PPEntryMainInterface pPEntryMainInterface, boolean bl, Workflow workflow, List<DescriptorTreeNode> list) {
            super(breezeMainPanel);
            VisualisationNode visualisationNode = workflow.getVisualisationNode();
            this.linePlotViewPanel = new LinePlotViewPanel(pPEntryMainInterface, visualisationNode);
            this.viewContainer.addViewPanel((Component)((Object)this.linePlotViewPanel));
            if (bl) {
                this.histogramPanel = new HistogramPlotViewPanel(breezeMainPanel, visualisationNode);
                this.viewContainer.addViewPanel((Component)((Object)this.histogramPanel));
            }
            this.updateDescriptorNodesIfChanged(list);
        }

        @Override
        public void updateSelected(ViewClass viewClass) {
            if (this.descriptorNodes != null && viewClass != null) {
                DescriptorTreeNode descriptorTreeNode = (DescriptorTreeNode)viewClass.getValue();
                String string = descriptorTreeNode.getAliasOrNodeString();
                this.linePlotViewPanel.setVariableName(string);
                if (this.histogramPanel != null) {
                    this.histogramPanel.setVariableName(string);
                }
            }
            super.updateSelected(viewClass);
        }

        public void updateDescriptorNodesIfChanged(List<DescriptorTreeNode> list) {
            if (list == null) {
                return;
            }
            if (this.descriptorNodes == null || list.size() != this.descriptorNodes.size()) {
                this.clearTabs();
                for (DescriptorTreeNode descriptorTreeNode : list) {
                    String string = descriptorTreeNode.getAliasOrSimpleNodeString();
                    if (string == null) {
                        throw new RuntimeException(String.format("DescriptorTreeNode of class %s getAliasOrSimpleNodeString() returned null, cant create tab", descriptorTreeNode.getClass().getSimpleName()));
                    }
                    this.addTab(descriptorTreeNode.getSummaryViewGroupName(), string, descriptorTreeNode, this.viewContainer);
                }
                if (this.getGroups() > 0) {
                    this.setSelectedTab(0, 0);
                }
                this.descriptorNodes = list;
            }
        }

        public LinePlotViewPanel getLinePlotViewPanel() {
            return this.linePlotViewPanel;
        }
    }

    private static class LinePlotViewPanel
    extends PlotViewPanel {
        private static final String plotTitle = "Control Chart";
        private final VisualisationNode visualisationNode;
        private String variableName;

        public LinePlotViewPanel(PPEntryMainInterface pPEntryMainInterface, VisualisationNode visualisationNode) {
            super(pPEntryMainInterface, plotTitle, "Line", "descriptors");
            this.visualisationNode = visualisationNode;
        }

        @Override
        public Properties createProperties() {
            Properties properties = super.createProperties();
            properties.put("direction", "columns");
            return properties;
        }

        @Override
        public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
            super.plotSetup(abstractPlotLayout);
            abstractPlotLayout.show("tickdenistyX", Double.valueOf(0.5));
            Properties properties = new Properties();
            properties.put("width", String.valueOf(this.visualisationNode.getLineWidth()));
            abstractPlotLayout.setColor(new Object[]{"fixed", this.visualisationNode.getColor()});
            abstractPlotLayout.setLine(new Object[]{"index", properties});
            abstractPlotLayout.setShape(new Object[]{"fixed", 1.0});
            abstractPlotLayout.setSize(new Object[]{"fixed", this.visualisationNode.getObjectSize()});
            abstractPlotLayout.show("ymin", Double.valueOf(0.0));
            ((FloatWindowSpectral)abstractPlotLayout.getMainWindow()).setDrawLineSelection(false);
        }

        @Override
        public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
            ExploreSummaryPlots.setPlotByVariableName(abstractPlotLayout, "Y", this.variableName);
        }

        @Override
        public boolean hasInteraction(boolean bl) {
            return true;
        }

        public void setVariableName(String string) {
            this.variableName = string;
            this.setTitle("Control Chart (" + string + ")");
        }
    }

    private static class HistogramPlotViewPanel
    extends PlotViewPanel {
        private static final String plotTitle = "Histogram";
        private final VisualisationNode visualisationNode;
        private String variableName;

        public HistogramPlotViewPanel(PPEntryMainInterface pPEntryMainInterface, VisualisationNode visualisationNode) {
            super(pPEntryMainInterface, plotTitle, plotTitle, "descriptors");
            this.visualisationNode = visualisationNode;
        }

        @Override
        public Properties createProperties() {
            Properties properties = super.createProperties();
            properties.put("direction", "columns");
            properties.put("buckets", "20");
            return properties;
        }

        @Override
        public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
            abstractPlotLayout.setColor(new Object[]{"fixed", this.visualisationNode.getColor()});
        }

        @Override
        public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
            ExploreSummaryPlots.setPlotByVariableName(abstractPlotLayout, "X", this.variableName);
        }

        @Override
        public boolean hasInteraction(boolean bl) {
            return true;
        }

        public void setVariableName(String string) {
            this.variableName = string;
        }
    }
}

