/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.play.realtime;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.MwlDescriptor;
import se.prediktera.breeze.common.realtime.variable.RtBasicVariable;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.workflow.LimitConfiguration;
import se.prediktera.breeze.entry.workflow.PropertyLimit;
import se.prediktera.breeze.entry.workflow.VisualisationNode;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.Thumbnail;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailProperty;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.view.preview.BasicPreviewPanel;
import se.prediktera.breeze.test.stubs.WorkflowWithoutIO;
import se.prediktera.map.common.color.ContinuousColorInterface;
import se.prediktera.map.plot.axisplot.AxisRange;
import se.prediktera.map.plot.axisplot.TickInfo;
import se.prediktera.map.plot.axisplot.settings.Color.PlotContinuousColor;

public class LegendPanel
extends JPanel {
    private LegendRenderer renderer;
    private final BreezeLabel legendLabel = new BreezeLabel("Text", true);
    private final JCheckBox sortByName = new JCheckBox("Sort by name", true);
    private final JCheckBox showOnlyIncluded = new JCheckBox("Only included", false);
    private LegendItemListener listener;
    private final BasicPreviewPanel previewPanel;
    private final LegendChangedCallback callback;
    static VisualisationNode.ColorScale cachedColorScale;
    static PlotContinuousColor cachedContinuesColor;

    public LegendPanel() {
        this(null, null);
    }

    public LegendPanel(BasicPreviewPanel basicPreviewPanel, LegendChangedCallback legendChangedCallback) {
        super(new GridBagLayout());
        this.previewPanel = basicPreviewPanel;
        this.callback = legendChangedCallback;
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.setBackground(breezeTheme.getPanelBackground());
        this.setBorder(new LineBorder(breezeTheme.getLabelForegroundMoreDifuse(), 2, true));
        this.setPreferredSize(new Dimension(150, 0));
        this.setMinimumSize(new Dimension(150, 0));
        this.legendLabel.setFontSize(BreezeLabel.FontSize.H1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.legendLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        final InnerLegendPanel innerLegendPanel = new InnerLegendPanel();
        this.add((Component)innerLegendPanel, gridBagConstraints);
        this.sortByName.setFocusable(false);
        this.sortByName.setOpaque(false);
        this.sortByName.setForeground(breezeTheme.getLabelForegroundDifuse());
        this.sortByName.setSelected(BreezeProperties.getInstance().isSortByName());
        this.sortByName.addItemListener(itemEvent -> {
            LegendRenderer legendRenderer = this.renderer;
            if (legendRenderer instanceof CategoryRenderer) {
                CategoryRenderer categoryRenderer = (CategoryRenderer)legendRenderer;
                boolean bl = this.sortByName.isSelected();
                BreezeProperties.getInstance().setSortByName(bl);
                categoryRenderer.updateClasslist(this.showOnlyIncluded.isSelected(), bl);
                this.repaint();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        this.add((Component)this.sortByName, gridBagConstraints);
        this.showOnlyIncluded.setFocusable(false);
        this.showOnlyIncluded.setOpaque(false);
        this.showOnlyIncluded.setForeground(breezeTheme.getLabelForegroundDifuse());
        this.showOnlyIncluded.setVisible(false);
        this.showOnlyIncluded.setSelected(BreezeProperties.getInstance().isShowIncluded());
        this.showOnlyIncluded.addItemListener(itemEvent -> {
            LegendRenderer legendRenderer = this.renderer;
            if (legendRenderer instanceof CategoryRenderer) {
                CategoryRenderer categoryRenderer = (CategoryRenderer)legendRenderer;
                boolean bl = this.showOnlyIncluded.isSelected();
                BreezeProperties.getInstance().setShowInlcuded(bl);
                categoryRenderer.updateClasslist(bl, this.sortByName.isSelected());
                this.repaint();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        this.add((Component)this.showOnlyIncluded, gridBagConstraints);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                LegendPanel.this.legendLabel.adjustFontSizeForComponent((int)((double)LegendPanel.this.getWidth() * 0.9));
            }
        });
        MouseAdapter mouseAdapter = new MouseAdapter(this){
            final /* synthetic */ LegendPanel this$0;
            {
                this.this$0 = legendPanel;
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Object object;
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    BreezeFrame breezeFrame = BreezeFrame.getInstance();
                    BreezeContextMenu breezeContextMenu = new BreezeContextMenu(breezeFrame, Color.red);
                    this.this$0.renderer.addToPopup(breezeFrame, breezeContextMenu);
                    if (breezeContextMenu.resize()) {
                        breezeContextMenu.setPositionLater(mouseEvent);
                        breezeFrame.addPage((JPanel)((Object)breezeContextMenu));
                    }
                } else if (this.this$0.listener != null && mouseEvent.getSource() == innerLegendPanel && (object = this.this$0.renderer.getItemAt(mouseEvent.getX(), mouseEvent.getY())) != null) {
                    this.this$0.listener.onClick(this.this$0.renderer.getNode(), this.this$0.renderer.getFactor(), object);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                this.this$0.setCursor(Cursor.getDefaultCursor());
            }
        };
        this.addMouseListener(mouseAdapter);
        innerLegendPanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (LegendPanel.this.renderer != null) {
                    Object object = LegendPanel.this.renderer.getItemAt(mouseEvent.getX(), mouseEvent.getY());
                    if (object != null) {
                        LegendPanel.this.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        LegendPanel.this.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        });
        innerLegendPanel.addMouseListener(mouseAdapter);
    }

    public void setListener(LegendItemListener legendItemListener) {
        this.listener = legendItemListener;
    }

    public void setTitle(String string) {
        this.legendLabel.setText(string);
        this.legendLabel.adjustFontSizeForComponent((int)((double)this.getWidth() * 0.9));
    }

    public void setClassTypes(DescriptorTreeNode descriptorTreeNode, CategoryFactor categoryFactor, boolean[] blArray) {
        this.sortByName.setVisible(true);
        this.showOnlyIncluded.setVisible(blArray != null);
        this.renderer = new CategoryRenderer(this, descriptorTreeNode, categoryFactor, blArray, this.showOnlyIncluded.isSelected(), this.sortByName.isSelected());
    }

    public void setMinMax(Workflow workflow, PropertyFactor propertyFactor, LimitConfiguration limitConfiguration, MinMax minMax, DescriptorTreeNode descriptorTreeNode) {
        this.setContinuesType(workflow.getColorScale(), workflow, propertyFactor, limitConfiguration, minMax, descriptorTreeNode, null);
    }

    public void setContinuesType(VisualisationNode.ColorScale colorScale, Workflow workflow, Factor factor, LimitConfiguration limitConfiguration, MinMax minMax, DescriptorTreeNode descriptorTreeNode, RtBasicVariable rtBasicVariable) {
        this.sortByName.setVisible(false);
        this.showOnlyIncluded.setVisible(false);
        if (factor instanceof MwlDescriptor.PropertyFactorMwl) {
            MwlDescriptor.PropertyFactorMwl propertyFactorMwl = (MwlDescriptor.PropertyFactorMwl)factor;
            this.renderer = new MwlPropertyRenderer(this, workflow, propertyFactorMwl, limitConfiguration, minMax, colorScale);
        } else {
            this.renderer = new PropertyRenderer(workflow, factor, limitConfiguration, minMax, colorScale, descriptorTreeNode, rtBasicVariable);
        }
    }

    public void takeScreenshot(Graphics2D graphics2D) {
        boolean bl = this.sortByName.isVisible();
        boolean bl2 = this.showOnlyIncluded.isVisible();
        this.sortByName.setVisible(false);
        this.showOnlyIncluded.setVisible(false);
        this.paint(graphics2D);
        this.sortByName.setVisible(bl);
        this.showOnlyIncluded.setVisible(bl2);
    }

    private ContinuousColorInterface getColorScale(VisualisationNode.ColorScale colorScale) {
        if (colorScale.notEquals(cachedColorScale)) {
            cachedColorScale = colorScale;
            cachedContinuesColor = cachedColorScale.create();
        }
        return cachedContinuesColor;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        LegendPanel legendPanel = new LegendPanel();
        BandNames bandNames = new BandNames("1755", "1765", "1775", "1880", "1990", "2000");
        legendPanel.setContinuesType(new VisualisationNode.ColorScale("hsv"), new WorkflowWithoutIO(), new MwlDescriptor.PropertyFactorMwl("test", "id", bandNames, null, 0.0f), null, new MinMax(0.0f, 1.0f), null, null);
        jFrame.getContentPane().add(legendPanel);
        jFrame.setSize(600, 600);
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    public static interface LegendChangedCallback {
        public void onChange();
    }

    private class InnerLegendPanel
    extends JPanel {
        public InnerLegendPanel() {
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            graphics2D.setColor(BreezeTheme.getInstance().getPanelBackground());
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.setFont(new Font("SansSerif", 1, 12));
            if (LegendPanel.this.renderer != null) {
                PropertyFactor propertyFactor;
                String string;
                Factor factor = LegendPanel.this.renderer.getFactor();
                if (factor instanceof PropertyFactor && (string = (propertyFactor = (PropertyFactor)factor).getUnit()) != null && !string.isEmpty()) {
                    int n3 = (int)((double)n * 0.02);
                    int n4 = (int)((double)n2 * 0.05);
                    graphics2D.setColor(BreezeTheme.getInstance().getLabelForeground());
                    graphics2D.drawString(string, n3, n4);
                }
                LegendPanel.this.renderer.render(graphics2D, n, n2);
            }
        }
    }

    public static interface LegendItemListener {
        public void onClick(DescriptorTreeNode var1, Factor var2, Object var3);
    }

    private class CategoryRenderer
    implements LegendRenderer {
        private List<CatClass> classList = new ArrayList<CatClass>();
        private TextGrid textGrid;
        private int textHeight;
        private double corrY;
        private int textHeightOrig;
        private final DescriptorTreeNode node;
        private final CategoryFactor factor;
        private final boolean[] included;

        public CategoryRenderer(LegendPanel legendPanel, DescriptorTreeNode descriptorTreeNode, CategoryFactor categoryFactor, boolean[] blArray, boolean bl, boolean bl2) {
            this.node = descriptorTreeNode;
            this.factor = categoryFactor;
            this.included = blArray;
            this.updateClasslist(bl, bl2);
        }

        private void updateClasslist(boolean bl, boolean bl2) {
            if (this.factor != null) {
                List<CatClass> list = this.classList = bl && this.included != null ? this.factor.getLeafs(this.included) : this.factor.getLeafs();
                if (bl2) {
                    this.classList.sort((catClass, catClass2) -> catClass.getName().compareToIgnoreCase(catClass2.getName()));
                }
                HashSet<Object> hashSet = new HashSet<Object>();
                Iterator<CatClass> iterator = this.classList.iterator();
                while (iterator.hasNext()) {
                    CatClass catClass3 = iterator.next();
                    Object object = catClass3.getName().toLowerCase();
                    Color color = catClass3.getColor();
                    if (color != null) {
                        object = (String)object + ":" + color.getRGB();
                    }
                    if (hashSet.contains(object)) {
                        iterator.remove();
                        continue;
                    }
                    hashSet.add(object);
                }
            } else {
                this.classList = new ArrayList<CatClass>();
            }
        }

        @Override
        public void render(Graphics2D graphics2D, int n, int n5) {
            BreezeTheme breezeTheme = BreezeTheme.getInstance();
            graphics2D.setColor(breezeTheme.getLabelForeground());
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            this.textHeightOrig = this.textHeight = fontMetrics.getHeight();
            this.corrY = (double)this.textHeight * 0.1;
            this.textHeight = (int)((double)this.textHeight + this.corrY * 2.0);
            int n6 = (int)(Math.ceil(this.textHeightOrig) * 1.05);
            int n7 = (int)((double)(TextGrid.getMaxTextWidth(fontMetrics, this.classList) + n6) * 1.05);
            if (n7 > 0) {
                this.textGrid = new TextGrid(this.classList.size(), n7, this.textHeight, n, n5);
                this.textGrid.render(graphics2D, (n2, n3, n4, d, d2) -> {
                    CatClass catClass = this.classList.get(n4);
                    int n5 = (int)((double)this.textHeightOrig * 0.6);
                    int n6 = (int)((double)n2 + this.corrY);
                    int n7 = (int)((double)n3 + d2 / 2.0 - (double)n5 / 2.0);
                    int n8 = (int)((double)n3 + d2 / 2.0 + (double)this.textHeightOrig / 3.0);
                    graphics2D.setColor(catClass.getColor());
                    graphics2D.fillOval(n6, n7, n5, n5);
                    graphics2D.setColor(breezeTheme.getLabelForeground());
                    graphics2D.drawOval(n6, n7, n5, n5);
                    graphics2D.drawString(catClass.getName(), n2 + n6, n8);
                });
            }
        }

        @Override
        public void addToPopup(BreezeFrame breezeFrame, BreezeContextMenu breezeContextMenu) {
        }

        @Override
        public CatClass getItemAt(int n, int n2) {
            int n5;
            if (this.textGrid != null && (n5 = this.textGrid.getIndexAt((n3, n4, d) -> {
                double d2;
                int n5 = (int)((double)this.textHeightOrig * 0.6 * d);
                double d3 = ((double)n3 + this.corrY + (double)n5 / 2.0) * d;
                double d4 = ((double)n4 + (double)this.textHeight / 2.0) * d;
                double d5 = Math.abs(d3 - (double)n);
                double d6 = Math.sqrt(d5 * d5 + (d2 = Math.abs(d4 - (double)n2)) * d2);
                if (d6 < (double)n5) {
                    return d6;
                }
                return -1.0;
            })) >= 0 && n5 < this.classList.size()) {
                return this.classList.get(n5);
            }
            return null;
        }

        @Override
        public CategoryFactor getFactor() {
            return this.factor;
        }

        @Override
        public DescriptorTreeNode getNode() {
            return this.node;
        }
    }

    private static interface LegendRenderer {
        public void render(Graphics2D var1, int var2, int var3);

        public Factor getFactor();

        public DescriptorTreeNode getNode();

        public Object getItemAt(int var1, int var2);

        public void addToPopup(BreezeFrame var1, BreezeContextMenu var2);
    }

    private class MwlPropertyRenderer
    extends PropertyRenderer {
        private final BandNames bandNames;
        private final MwlColors mwlColors;

        public MwlPropertyRenderer(LegendPanel legendPanel, Workflow workflow, MwlDescriptor.PropertyFactorMwl propertyFactorMwl, LimitConfiguration limitConfiguration, MinMax minMax, VisualisationNode.ColorScale colorScale) {
            super(workflow, propertyFactorMwl, limitConfiguration, minMax, colorScale, null, null);
            this.bandNames = propertyFactorMwl.getBandNames();
            this.mwlColors = new MwlColors(this.continuesColor);
        }

        @Override
        public void render(Graphics2D graphics2D, int n, int n2) {
            double d;
            int n3;
            int n4 = (int)Math.max(60.0, (double)n * 0.2);
            int n5 = (int)((double)n2 * 0.1);
            int n6 = n - n4;
            int n7 = (int)((double)n2 * 0.8);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n8 = fontMetrics.getHeight();
            int n9 = this.mwlColors.getColorCount();
            double d2 = (double)n6 / (double)n9;
            int n10 = (int)Math.ceil(d2 + 2.0);
            int n11 = this.mwlColors.getBlendCount();
            double d3 = (double)n7 / (double)n11;
            int n12 = (int)Math.ceil(d3 + 2.0);
            double d4 = n4;
            for (int i = 0; i < n9; ++i) {
                double d5 = n5;
                for (n3 = 0; n3 < n11; ++n3) {
                    graphics2D.setColor(this.mwlColors.getColor(i, n11 - n3 - 1));
                    graphics2D.fillRect((int)d4, (int)d5, n10, n12);
                    d5 += d3;
                }
                d4 += d2;
            }
            Float f = this.minMax.min();
            Float f2 = this.minMax.max();
            float f3 = f2.floatValue() - f.floatValue();
            n3 = (double)f3 < 0.5 ? 4 : 3;
            int n13 = (int)((double)n * 0.05);
            AxisRange axisRange = new AxisRange((double)f.floatValue(), (double)f2.floatValue());
            axisRange.setAxisTicks((double)n7, 35, n3, false, false);
            List list = axisRange.getTickList();
            graphics2D.setColor(BreezeTheme.getInstance().getLabelForeground());
            for (TickInfo tickInfo : list) {
                d = tickInfo.pos;
                int n14 = (int)((double)n7 - (d - (double)f.floatValue()) / (double)f3 * (double)n7) + n5;
                graphics2D.drawLine(n4 - n13, n14, n4 + n6, n14);
                String string = tickInfo.text;
                graphics2D.drawString(string, n4 - (int)((double)n * 0.1 + (double)fontMetrics.stringWidth(string)), n14 + n8 / 3);
            }
            double d6 = Math.min((double)this.bandNames.size(), Math.ceil((double)n6 / ((double)fontMetrics.stringWidth(this.bandNames.get(0)) * 1.8)));
            d = (double)(n6 - 1) / d6;
            double d7 = (double)(this.bandNames.size() - 1) / d6;
            graphics2D.setColor(BreezeTheme.getInstance().getLabelForeground());
            int n15 = 0;
            while ((double)n15 <= d6) {
                int n16 = (int)((double)n4 + d * (double)n15);
                int n17 = n5 + n7;
                graphics2D.drawLine(n16, n17, n16, n17 + n8 / 2);
                int n18 = n17 + n8 * 2;
                String string = this.bandNames.getFormated(Math.min(this.bandNames.size() - 1, (int)((double)n15 * d7)));
                int n19 = fontMetrics.stringWidth(string);
                graphics2D.drawString(string, n16 - n19, n18);
                if (d < (double)n19) break;
                ++n15;
            }
        }

        @Override
        public void addToPopup(BreezeFrame breezeFrame, BreezeContextMenu breezeContextMenu) {
            super.addToPopup(breezeFrame, breezeContextMenu);
        }
    }

    private class PropertyRenderer
    implements LegendRenderer {
        private final Workflow workflow;
        private final Factor factor;
        private final LimitConfiguration limit;
        protected MinMax minMax;
        protected final ContinuousColorInterface continuesColor;
        private final FunctionTreeNode node;
        private final RtBasicVariable variable;

        public PropertyRenderer(Workflow workflow, Factor factor, LimitConfiguration limitConfiguration, MinMax minMax, VisualisationNode.ColorScale colorScale, DescriptorTreeNode descriptorTreeNode, RtBasicVariable rtBasicVariable) {
            this.workflow = workflow;
            this.factor = factor;
            this.limit = limitConfiguration;
            this.minMax = minMax;
            this.continuesColor = LegendPanel.this.getColorScale(colorScale);
            this.node = descriptorTreeNode;
            this.variable = rtBasicVariable;
        }

        @Override
        public void render(Graphics2D graphics2D, int n, int n2) {
            double d;
            int n3 = (int)((double)n * 0.5);
            int n4 = (int)((double)n2 * 0.1);
            int n5 = (int)((double)n * 0.5) + 1;
            int n6 = (int)((double)n2 * 0.8);
            int n7 = this.continuesColor.getNrColors();
            if (n7 <= 0 || n6 <= 0) {
                return;
            }
            double d2 = (double)n6 / (double)n7;
            double d3 = n4;
            for (int i = 0; i < n7; ++i) {
                graphics2D.setColor(this.continuesColor.getColor(n7 - i - 1));
                double d4 = i == n7 - 1 ? (double)(n4 + n6) : (double)n4 + (double)(i + 1) * d2;
                int n8 = (int)Math.round(d3);
                int n9 = (int)Math.round(d4) - n8;
                if (n9 <= 0) {
                    n9 = 1;
                }
                graphics2D.fillRect(n3, n8, n5, n9);
                d3 = d4;
            }
            double d5 = this.minMax.min().floatValue();
            double d6 = this.minMax.max().floatValue();
            graphics2D.setColor(BreezeTheme.getInstance().getLabelForeground());
            Font font = graphics2D.getFont();
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            if (d6 == d5) {
                int n10 = n4 + n6 / 2;
                graphics2D.drawLine(n3 - (int)((double)n * 0.05), n10, n3 + n5, n10);
                String string = RtDataFormat.toString(d5, 4);
                double d7 = fontMetrics.stringWidth(string);
                int n11 = fontMetrics.getHeight();
                int n12 = n3 - (int)((double)n * 0.1 + d7);
                if (n12 < 0) {
                    n12 = 0;
                }
                graphics2D.drawString(string, n12, n10 + n11 / 3);
                return;
            }
            AxisRange axisRange = new AxisRange(d5, d6);
            axisRange.setAxisTicks((double)n6, 35, 4, false, false);
            List list = axisRange.getTickList();
            int n13 = Math.max(2, list.size());
            double d8 = d = n13 > 1 ? (double)n6 / (double)(n13 - 1) : (double)n6;
            if ((double)fontMetrics.getHeight() > d * 0.8) {
                float f = font.getSize2D();
                float f2 = (float)(d * 0.8 / (double)fontMetrics.getHeight());
                float f3 = Math.max(8.0f, f * f2);
                font = font.deriveFont(f3);
                graphics2D.setFont(font);
                fontMetrics = graphics2D.getFontMetrics(font);
            }
            for (int i = 0; i < n13; ++i) {
                double d9 = n13 == 1 ? 0.0 : (double)i / (double)(n13 - 1);
                double d10 = d5 + d9 * (d6 - d5);
                int n14 = (int)Math.round((double)(n4 + n6) - d9 * (double)n6);
                graphics2D.drawLine(n3 - (int)((double)n * 0.05), n14, n3 + n5, n14);
                String string = RtDataFormat.toString(d10, 4);
                int n15 = fontMetrics.stringWidth(string);
                int n16 = fontMetrics.getHeight();
                int n17 = n3 - (int)((double)n * 0.1 + (double)n15);
                if (n17 < 0) {
                    n17 = 0;
                }
                graphics2D.drawString(string, n17, n14 + n16 / 3);
            }
        }

        @Override
        public void addToPopup(BreezeFrame breezeFrame, BreezeContextMenu breezeContextMenu) {
            Thumbnail thumbnail;
            if (LegendPanel.this.previewPanel != null && (thumbnail = LegendPanel.this.previewPanel.getThumbnail()) instanceof ThumbnailProperty) {
                final ThumbnailProperty thumbnailProperty = (ThumbnailProperty)thumbnail;
                breezeContextMenu.addButtonCloseClick("Auto adjust", () -> BreezeProgressDialog.startProgressWithCancel(breezeFrame, new ProgressAction(this){
                    final /* synthetic */ PropertyRenderer this$1;
                    {
                        this.this$1 = propertyRenderer;
                    }

                    @Override
                    public void runAction() throws Exception {
                        this.this$1.updateMinMax(thumbnailProperty.getOrCalculateMinMax());
                    }
                }, "Auto adjusting"));
            }
            breezeContextMenu.addButtonCloseClick("Set min", () -> BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.INPUT_OPTION, "Set min", this.getText("min"), RtDataFormat.toString(this.minMax.min().floatValue()), breezeActionEvent -> {
                float f = RtDataFormat.toNumberFloat(breezeActionEvent.result().toString());
                this.updateMinMax(new MinMax(f, this.minMax.max().floatValue()));
            }));
            breezeContextMenu.addButtonCloseClick("Set max", () -> BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.INPUT_OPTION, "Set max", this.getText("max"), RtDataFormat.toString(this.minMax.max().floatValue()), breezeActionEvent -> {
                float f = RtDataFormat.toNumberFloat(breezeActionEvent.result().toString());
                this.updateMinMax(new MinMax(this.minMax.min().floatValue(), f));
            }));
        }

        private void updateMinMax(MinMax minMax) {
            this.minMax = minMax;
            if (this.factor != null) {
                BasicAnalyse basicAnalyse;
                Object object;
                if (this.limit != null) {
                    object = this.limit.getWrapper(this.factor);
                    if (object != null) {
                        ((PropertyLimit)object).setMinMax(minMax);
                    } else {
                        this.factor.setMinMax(minMax);
                    }
                } else {
                    this.factor.setMinMax(minMax);
                }
                BasicAnalyse basicAnalyse2 = basicAnalyse = this.node != null ? this.node.getAnalyse() : null;
                if (basicAnalyse instanceof Analyse) {
                    object = (Analyse)basicAnalyse;
                    ((Analyse)object).save();
                }
                if (this.workflow != null) {
                    this.workflow.saveNoChangeIndex();
                }
            } else if (this.node != null) {
                this.node.setLegendMin(minMax.min());
                this.node.setLegendMax(minMax.max());
                this.workflow.saveNoChangeIndex();
            } else if (this.variable != null) {
                this.variable.setMinMax(minMax);
            }
            LegendPanel.this.repaint();
            if (LegendPanel.this.callback != null) {
                LegendPanel.this.callback.onChange();
            }
        }

        private String getText(String string) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Set " + string + " value");
            if (this.factor != null) {
                stringBuffer.append("\n\nFactor: ");
                stringBuffer.append(this.factor);
            }
            if (this.limit != null) {
                stringBuffer.append("\nLimit: ");
                stringBuffer.append(this.limit);
            }
            return stringBuffer.toString();
        }

        @Override
        public Object getItemAt(int n, int n2) {
            return null;
        }

        @Override
        public Factor getFactor() {
            return this.factor;
        }

        @Override
        public DescriptorTreeNode getNode() {
            return null;
        }
    }

    public static class MwlColors {
        private final Color[][] colors;
        private final int[][][] colorArray;

        public MwlColors(ContinuousColorInterface continuousColorInterface) {
            int n = this.getBlendCount() + 1;
            this.colors = new Color[continuousColorInterface.getNrColors()][n];
            this.colorArray = new int[continuousColorInterface.getNrColors()][n][4];
            for (int i = 0; i < continuousColorInterface.getNrColors(); ++i) {
                Color color = continuousColorInterface.getColor(i);
                for (int j = 0; j < n; ++j) {
                    double d = (double)j / (double)n;
                    this.colorArray[i][j][0] = RtPerfectSpread.blendDark(color.getRed(), d, 0.0);
                    this.colorArray[i][j][1] = RtPerfectSpread.blendDark(color.getGreen(), d, 0.0);
                    this.colorArray[i][j][2] = RtPerfectSpread.blendDark(color.getBlue(), d, 0.0);
                    this.colorArray[i][j][3] = 255;
                    this.colors[i][j] = new Color(this.colorArray[i][j][0], this.colorArray[i][j][1], this.colorArray[i][j][2]);
                }
            }
        }

        public int getBlendCount() {
            return 255;
        }

        public int getColorCount() {
            return this.colors.length;
        }

        public Color getColor(int n, int n2) {
            return this.colors[n][n2];
        }

        public int[] getArray(int n, int n2) {
            return this.colorArray[n][n2];
        }
    }

    public static class TextGrid {
        private final int rows;
        private int columns;
        private double ratio;
        private final int numText;
        private final double textWidth;
        private final double textHeight;

        public TextGrid(int n, double d, double d2, int n2, int n3) {
            this.numText = n;
            this.textWidth = d;
            this.textHeight = d2;
            for (int i = 1; i <= n; ++i) {
                double d3 = (double)(n2 / i) / d;
                double d4 = Math.ceil((double)n / (double)i);
                double d5 = (double)n3 / d4;
                double d6 = d5 / d2;
                double d7 = Math.min(d3, d6);
                if (!(d7 > this.ratio)) continue;
                this.ratio = d7;
                this.columns = i;
            }
            this.rows = (int)Math.max(Math.ceil((double)n / (double)this.columns), (double)n3 / (d2 * this.ratio));
        }

        public void render(Graphics2D graphics2D, RenderCallback renderCallback) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.scale(this.ratio, this.ratio);
            for (int i = 0; i < this.columns; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n = i * this.rows + j;
                    if (n >= this.numText) continue;
                    int n2 = (int)((double)i * this.textWidth);
                    int n3 = (int)((double)j * this.textHeight);
                    renderCallback.render(n2, n3, n, this.textWidth, this.textHeight);
                }
            }
            graphics2D.setTransform(affineTransform);
        }

        public int getIndexAt(ItemAtCallback itemAtCallback) {
            double d = 2.147483647E9;
            int n = -1;
            for (int i = 0; i < this.columns; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    int n2;
                    int n3;
                    double d2;
                    int n4 = i * this.rows + j;
                    if (n4 >= this.numText || !((d2 = itemAtCallback.itemDist(n3 = (int)((double)i * this.textWidth), n2 = (int)((double)j * this.textHeight), this.ratio)) >= 0.0) || !(d2 < d)) continue;
                    d = d2;
                    n = n4;
                }
            }
            return n;
        }

        public int getRows() {
            return this.rows;
        }

        public int getColumns() {
            return this.columns;
        }

        public double getRatio() {
            return this.ratio;
        }

        public static int getMaxTextWidth(FontMetrics fontMetrics, List<CatClass> list) {
            int n = fontMetrics.stringWidth("12345");
            for (CatClass catClass : list) {
                int n2 = fontMetrics.stringWidth(catClass.getName());
                if (n >= n2) continue;
                n = n2;
            }
            return n;
        }

        public static interface RenderCallback {
            public void render(int var1, int var2, int var3, double var4, double var6);
        }

        public static interface ItemAtCallback {
            public double itemDist(int var1, int var2, double var3);
        }
    }
}

