/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.play.realtime;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import se.prediktera.breeze.common.entry.sample.TrackInformation;
import se.prediktera.breeze.common.realtime.variable.RtBasicVariable;
import se.prediktera.breeze.common.realtime.variable.SampleTrackInterface;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.frontend.common.view.visualization.camerastream.CameraStreamPanel;
import se.prediktera.breeze.frontend.common.view.visualization.camerastream.PushbroomStreamImage;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.recorder.BreezeRecorder;

public class SampleTrackRenderer
implements CameraStreamPanel.ImagePostProcessor {
    private static BasicStroke trackStroke;
    private final List<SampleTrack> trackList = new LinkedList<SampleTrack>();
    private final Color[] trackColor;
    private final Color[] trackCrossColor;
    private final float trackStrokeWidth = 2.0f;
    private boolean showTrackBox = true;
    private boolean showCenterCross = true;
    private boolean drawTrack = false;
    private RtBasicVariable realtimeVariable;
    private boolean blending = false;
    private final HashMap<Color, Color> hashMap = new HashMap();
    private BreezeRecorder.RecordMode recordMode;
    private static int MaxTrackSize;

    public SampleTrackRenderer() {
        this.trackColor = new Color[CameraStreamPanel.TrackInfo.MaxAge + 1];
        this.trackCrossColor = new Color[CameraStreamPanel.TrackInfo.MaxAge + 1];
        for (int i = 0; i < this.trackColor.length; ++i) {
            int n = 255 - i * 50;
            this.trackCrossColor[i] = this.trackColor[i] = new Color(n, n, n, n);
        }
    }

    public void setVariable(RtBasicVariable rtBasicVariable) {
        this.realtimeVariable = rtBasicVariable;
    }

    public void setBlending(boolean bl) {
        this.blending = bl;
    }

    public void setShowTrackBox(boolean bl) {
        this.showTrackBox = bl;
        this.showCenterCross = bl;
    }

    public void setShowTrackBorder(boolean bl) {
        this.drawTrack = bl;
    }

    public void setRecordMode(BreezeRecorder.RecordMode recordMode) {
        this.recordMode = recordMode;
    }

    @Override
    public void postProcessImage(CameraStreamPanel.StreamImage streamImage, long l) {
        float f;
        if (this.trackList.isEmpty()) {
            return;
        }
        PushbroomStreamImage.ImageDirection imageDirection = streamImage.getImageDirection();
        float f2 = streamImage.getImageScale();
        Camera.CameraCaptureType cameraCaptureType = streamImage.getType();
        float f3 = 1.0f / f2;
        float f4 = cameraCaptureType.equals((Object)Camera.CameraCaptureType.Linescan) ? 2.0f * f2 : 2.0f;
        Graphics2D graphics2D = streamImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        if (trackStroke == null || trackStroke.getLineWidth() != f4) {
            trackStroke = new BasicStroke(f4, 1, 1, 1.0f);
        }
        graphics2D.setStroke(trackStroke);
        int n = cameraCaptureType.equals((Object)Camera.CameraCaptureType.Linescan) ? Math.round(6.0f * f2) : 6;
        float f5 = (float)streamImage.getWidth() * f2;
        float f6 = (float)streamImage.getHeight() * f2;
        float f7 = f = imageDirection.isVertical() ? f6 : f5;
        while (this.trackList.size() > MaxTrackSize) {
            this.trackList.remove(0);
        }
        try {
            for (int i = this.trackList.size() - 1; i >= 0; --i) {
                Color color;
                SampleTrack sampleTrack = this.trackList.get(i);
                if (sampleTrack == null) {
                    this.trackList.remove(i);
                    continue;
                }
                Shape shape = sampleTrack.getPath();
                Rectangle rectangle = shape.getBounds();
                TrackInformation trackInformation = sampleTrack.getTrackInformation();
                long l2 = trackInformation.getStartLine() + (long)rectangle.height;
                CameraStreamPanel.TrackInfo trackInfo = streamImage.getFrameNumberLineIndex(l2);
                if (trackInfo == null) {
                    if (!this.recordMode.equals((Object)BreezeRecorder.RecordMode.Play) || streamImage.isInside(l2)) continue;
                    this.trackList.remove(i);
                    continue;
                }
                int n2 = trackInfo.line();
                AffineTransform affineTransform = graphics2D.getTransform();
                if (imageDirection.shouldRotate()) {
                    graphics2D.translate(f5, f6);
                    graphics2D.rotate(Math.PI);
                }
                if (cameraCaptureType.equals((Object)Camera.CameraCaptureType.Linescan)) {
                    float f8 = imageDirection.isFlow() ? f - (float)n2 * f2 - (float)rectangle.height : (float)trackInfo.line() * f2 - (float)rectangle.height;
                    if (imageDirection.isVertical()) {
                        graphics2D.translate((double)trackInformation.getxOffset(), f8);
                    } else {
                        graphics2D.translate(f5 - f8, (double)trackInformation.getxOffset());
                        graphics2D.rotate(1.5707963267948966);
                    }
                    graphics2D.scale(f3, f3);
                } else {
                    graphics2D.translate(trackInformation.getxOffset(), n2 - rectangle.height);
                }
                if (this.realtimeVariable != null && this.realtimeVariable.isObjectOnly() && (color = this.realtimeVariable.getColor(sampleTrack)) != null) {
                    if (this.blending) {
                        Color color2 = this.hashMap.get(color);
                        if (color2 == null) {
                            color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 200);
                            this.hashMap.put(color, color2);
                        }
                        graphics2D.setColor(color2);
                    } else {
                        graphics2D.setColor(color);
                    }
                    graphics2D.fill(shape);
                }
                if (this.drawTrack) {
                    graphics2D.setStroke(trackStroke);
                    graphics2D.setColor(this.trackColor[trackInfo.age()]);
                    graphics2D.draw(shape);
                }
                graphics2D.setColor(this.trackCrossColor[trackInfo.age()]);
                if (this.showTrackBox) {
                    Rectangle rectangle2 = shape.getBounds();
                    int n3 = rectangle2.x + rectangle2.width;
                    int n4 = rectangle2.y + rectangle2.height;
                    int n5 = (int)Math.ceil(10.0f * f2);
                    graphics2D.setStroke(trackStroke);
                    graphics2D.drawLine(rectangle2.x, rectangle2.y, rectangle2.x + n5, rectangle2.y);
                    graphics2D.drawLine(rectangle2.x, rectangle2.y, rectangle2.x, rectangle2.y + n5);
                    graphics2D.drawLine(n3, rectangle2.y, n3 - n5, rectangle2.y);
                    graphics2D.drawLine(n3, rectangle2.y, n3, rectangle2.y + n5);
                    graphics2D.drawLine(rectangle2.x, n4, rectangle2.x + n5, n4);
                    graphics2D.drawLine(rectangle2.x, n4, rectangle2.x, n4 - n5);
                    graphics2D.drawLine(n3, n4, n3 - n5, n4);
                    graphics2D.drawLine(n3, n4, n3, n4 - n5);
                }
                if (this.showCenterCross) {
                    int n6 = Math.round(trackInformation.getX() - trackInformation.getxOffset());
                    int n7 = Math.round(trackInformation.getY());
                    graphics2D.drawLine(n6 - n, n7 - n, n6 + n, n7 + n);
                    graphics2D.drawLine(n6 - n, n7 + n, n6 + n, n7 - n);
                }
                graphics2D.setTransform(affineTransform);
            }
        }
        catch (Exception exception) {
            this.reset();
            System.err.println("Cannot draw samples tracks: " + exception.getMessage());
        }
        graphics2D.dispose();
    }

    public void add(SampleTrack sampleTrack) {
        this.trackList.add(sampleTrack);
    }

    public void reset() {
        try {
            this.trackList.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        MaxTrackSize = 5000;
    }

    public static class SampleTrack
    implements SampleTrackInterface {
        private final TrackInformation trackInformation;
        private Shape path;

        public SampleTrack(Sample sample) {
            this(sample.getTrackInformation(), sample.getPath().getOrCreateGeneralPath());
        }

        public SampleTrack(TrackInformation trackInformation, Shape shape) {
            this.trackInformation = trackInformation;
            this.path = shape;
        }

        public TrackInformation getTrackInformation() {
            return this.trackInformation;
        }

        public void setPath(GeneralPath generalPath) {
            this.path = generalPath;
        }

        public Shape getPath() {
            return this.path;
        }

        @Override
        public float getAnalyseValue(String string, String string2) {
            return 0.0f;
        }

        public Color getDescriptorColor(int n) {
            return null;
        }
    }
}

