/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.record;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.imgscalr.Scalr;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryPanel;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.common.view.preview.MeasurementPopup;
import se.prediktera.breeze.frontend.main.play.GraphOverviewPanel;
import se.prediktera.breeze.frontend.main.record.measurement.RecordMeasurementPanel;
import se.prediktera.breeze.frontend.main.record.panel.EditMeasurementTableInteraction;
import se.prediktera.breeze.frontend.main.record.panel.GroupExplorePanel;
import se.prediktera.breeze.frontend.main.record.panel.GroupMainPanel;
import se.prediktera.breeze.frontend.main.record.panel.GroupOverviewPanel;
import se.prediktera.breeze.frontend.main.record.panel.PostProcessingRecordPanel;

public class RecordGroupPanel
extends GroupMainPanel {
    private final StudyPanel studyPanel;
    private static final boolean selectWorkflow = false;

    public RecordGroupPanel(BreezeProgress breezeProgress, BreezeFrame breezeFrame, Workflow workflow) {
        super(breezeProgress, breezeFrame, workflow, BreezeType.Project);
        this.studyPanel = new StudyPanel(workflow);
        this.entryCenterPanel.add((Component)this.studyPanel, "North");
        ArrayList<ViewClass> arrayList = new ArrayList<ViewClass>();
        arrayList.add(new ViewClass("Overview", new GroupOverviewPanel(this)));
        arrayList.add(new ViewClass("Table", new EditMeasurementTableInteraction(this, workflow)));
        arrayList.add(new ViewClass("Analyse Tree", new GraphOverviewPanel(this, workflow)));
        arrayList.add(new ViewClass("Explore", new GroupExplorePanel(breezeProgress, this, workflow)));
        arrayList.add(new ViewClass("Import / Export", new PostProcessingRecordPanel(this)));
        this.setLists(arrayList, workflow.getChildList(), "Study_big");
        if (!WorkspaceManager.GUITEST) {
            this.entryTabPanel.setSelectedTabNoEvent("Table");
        }
    }

    @Override
    public void selectFirstItem(boolean bl) {
        if (!WorkspaceManager.GUITEST) {
            // empty if block
        }
        super.selectFirstItem(bl);
    }

    @Override
    public void showSelectedEntry(boolean bl) {
        if (super.getSelectedEntry() instanceof Group) {
            this.studyPanel.setSelected(false);
        }
        super.showSelectedEntry(bl);
    }

    @Override
    public <T> List<T> getSelectedEntries() {
        if (this.studyPanel.selected) {
            return Arrays.asList(this.studyPanel.workflow);
        }
        return super.getSelectedEntries();
    }

    @Override
    public Object getSelectedEntry() {
        if (this.studyPanel.selected) {
            return this.studyPanel.workflow;
        }
        return super.getSelectedEntry();
    }

    @Override
    public Workflow getStudyContext() {
        return this.getWorkflow();
    }

    @Override
    protected BreezeMainPanel createOpenPanel(BreezeProgress breezeProgress, Object object) {
        return new RecordMeasurementPanel(breezeProgress, this, Group.getGroup(object));
    }

    private class StudyPanel
    extends EntryPanel {
        private final Workflow workflow;
        private boolean selected;

        public StudyPanel(final Workflow workflow) {
            super("Recordings2_big", RecordGroupPanel.this.entryListPanel.getBackground(), 80);
            this.workflow = workflow;
            this.setCursorRecursive(this, Cursor.getPredefinedCursor(12));
            this.textLabel.setText(workflow.getName());
            this.sub1Label.setText(StringHelper.pluralize(FileHelper.countSubfoldersWithFile(workflow.getFolder(), "group.xml"), "group"));
            this.sub2Label.setText("Modified: " + workflow.getEntryData().getViewModifiedDate());
            this.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ StudyPanel this$1;
                {
                    this.this$1 = studyPanel;
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    this.this$1.RecordGroupPanel.this.entryListPanel.updatingEntryList = true;
                    this.this$1.RecordGroupPanel.this.getEntryList().clearSelection();
                    if (!this.this$1.selected) {
                        this.this$1.RecordGroupPanel.this.entryTabPanel.setCurrentPanel(workflow);
                    }
                    this.this$1.setSelected(true);
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        MeasurementPopup.showMeasurementsPopup(this.this$1.RecordGroupPanel.this, Arrays.asList(workflow), mouseEvent);
                    }
                    this.this$1.RecordGroupPanel.this.entryListPanel.updatingEntryList = false;
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    this.this$1.setHoverIndex(0);
                    this.this$1.repaintEntry();
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    this.this$1.setHoverIndex(-1);
                    this.this$1.repaintEntry();
                }
            });
            this.setSelected(false);
        }

        @Override
        protected void setCustomImage(Entry entry, Scalr.Method method) {
            this.setDefaultIcon(entry);
        }

        private void setCursorRecursive(Component component, Cursor cursor) {
            component.setCursor(cursor);
            if (component instanceof JComponent) {
                JComponent jComponent = (JComponent)component;
                for (int i = 0; i < jComponent.getComponentCount(); ++i) {
                    this.setCursorRecursive(jComponent.getComponent(i), cursor);
                }
            }
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
            this.repaintEntry();
            if (bl) {
                RecordGroupPanel.this.setFormatedTitle(this.workflow);
            }
        }

        private void repaintEntry() {
            this.textLabel.setText(this.workflow.getName());
            this.sub1Label.setText(StringHelper.pluralize(FileHelper.countSubfoldersWithFile(this.workflow.getFolder(), "group.xml"), "group"));
            this.sub2Label.setText("Modified: " + this.workflow.getEntryData().getViewModifiedDate());
            this.updatePanel((JComponent)((Object)RecordGroupPanel.this.getEntryList()), this.workflow, this.selected, 0);
        }
    }
}

