/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.record;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.workflow.BasicWorkflow;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.BreezeViewStack;
import se.prediktera.breeze.frontend.common.ArrayTreeModel;
import se.prediktera.breeze.frontend.common.entry.DeleteEntryCustomPanel;
import se.prediktera.breeze.frontend.common.util.BreezeFilter;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.main.play.GraphOverviewPanel;
import se.prediktera.breeze.frontend.main.play.WorkflowMainPanel;
import se.prediktera.breeze.frontend.main.play.WorkflowOverviewPanel;
import se.prediktera.breeze.frontend.main.record.RecordGroupPanel;
import se.prediktera.breeze.frontend.main.record.panel.EditMeasurementTableInteraction;
import se.prediktera.breeze.frontend.main.record.panel.GroupExplorePanel;
import se.prediktera.breeze.frontend.main.record.panel.PostProcessingRecordPanel;

public class RecordWorkflowPanel
extends WorkflowMainPanel {
    public RecordWorkflowPanel(BreezeProgress breezeProgress, BreezeFrame breezeFrame) {
        super(breezeFrame, BreezeType.Project);
        ArrayList<ViewClass> arrayList = new ArrayList<ViewClass>();
        if (breezeProgress != null) {
            arrayList.add(new ViewClass("Overview", new WorkflowOverviewPanel(this)));
            arrayList.add(new ViewClass("Table", new EditMeasurementTableInteraction(this, null)));
            arrayList.add(new ViewClass("Analyse Tree", new GraphOverviewPanel(this, null)));
            arrayList.add(new ViewClass("Explore", new GroupExplorePanel(breezeProgress, this, null)));
            arrayList.add(new ViewClass("Import / Export", new PostProcessingRecordPanel(this)));
        }
        this.setLists(arrayList, BreezeMasterCache.getInstance().getStudyList(breezeProgress, true), "Recordings2_big");
    }

    @Override
    public void setStudyContext(Workflow workflow) {
        this.selectEntry(workflow);
    }

    @Override
    protected Entry getFirstItem() {
        BreezeViewStack breezeViewStack = this.getFrame().getViewStack();
        if (breezeViewStack != null) {
            return breezeViewStack.getStudyContext();
        }
        return super.getFirstItem();
    }

    @Override
    public void showSelectedEntry(boolean bl) {
        super.showSelectedEntry(bl);
        Object object = this.getSelectedEntry();
        BreezeViewStack breezeViewStack = this.getFrame().getViewStack();
        if (object instanceof Workflow && breezeViewStack != null) {
            breezeViewStack.setStudyContext((Workflow)object);
        }
    }

    @Override
    public Workflow getStudyContext() {
        Object object = this.getSelectedEntry();
        if (object instanceof ArrayTreeModel.RootList) {
            return null;
        }
        return Workflow.getWorkflow(object);
    }

    @Override
    protected Entry createEntryLocal(Entry entry, String string) {
        Workflow workflow = Workflow.createWorkflow(string);
        workflow.createDefaultGroup();
        return workflow;
    }

    @Override
    protected BreezeMainPanel createOpenPanel(BreezeProgress breezeProgress, Object object) {
        return new RecordGroupPanel(breezeProgress, this.frame, Workflow.getWorkflow(object));
    }

    @Override
    protected DeleteEntryCustomPanel getDependantMessageBeforeDelete(Object object) {
        Workflow workflow = (Workflow)object;
        BreezeFilter.AnalyseStudy analyseStudy = new BreezeFilter.AnalyseStudy(workflow);
        BreezeMasterCache breezeMasterCache = BreezeMasterCache.getInstance();
        List<BasicAnalyse> list = RecordWorkflowPanel.filter(breezeMasterCache.getAnalyseList(), analyseStudy);
        List<BasicWorkflow> list2 = breezeMasterCache.getWorkflowList().filter(analyseStudy);
        if (list.isEmpty() && list2.isEmpty()) {
            return null;
        }
        DeleteEntryCustomPanel deleteEntryCustomPanel = new DeleteEntryCustomPanel(workflow, "Project \"" + String.valueOf(workflow) + "\" contains the following:", "Confirm removing model(s) and workflow(s)");
        deleteEntryCustomPanel.add(list, BreezeType.Analyse);
        deleteEntryCustomPanel.add(list2, BreezeType.Workflow);
        return deleteEntryCustomPanel;
    }

    public static List<BasicAnalyse> filter(List<? extends BasicAnalyse> list, BreezeFilter breezeFilter) {
        return list.stream().filter(basicAnalyse -> breezeFilter.matches(basicAnalyse)).collect(Collectors.toList());
    }

    @Override
    public String getEntryName() {
        return "Project";
    }

    @Override
    public void openFromMainPanel() {
        if (this.getEntryList().getList().isEmpty()) {
            this.createLocal();
        }
    }
}

