/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.record.edit;

import se.prediktera.breeze.common.entry.ThingWithName;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.FactorHolder;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.identifier.Identifier;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.swing.validator.AbstractValidator;
import se.prediktera.breeze.frontend.common.swing.validator.ValidatorResult;

public class DuplicateValidator
extends AbstractValidator {
    private Entry rootEntry;
    private ThingWithName entrydata;

    public void setElement(Entry entry, ThingWithName thingWithName) {
        this.rootEntry = entry;
        this.entrydata = thingWithName;
    }

    @Override
    public ValidatorResult validate(String string) {
        if (this.entrydata != null && !this.entrydata.getName().equalsIgnoreCase(string)) {
            Factor factor;
            FactorHolder factorHolder;
            if (this.rootEntry instanceof Workflow && this.entrydata instanceof Identifier && ((Workflow)this.rootEntry).getIdentifiers().identifierExists(string)) {
                return new ValidatorResult("Identifier name already exists");
            }
            if (this.entrydata instanceof Factor && (factorHolder = DuplicateValidator.getFactorHolder(this.rootEntry)) != null && (factor = factorHolder.getFactorByName(string)) != null) {
                return new ValidatorResult(factor.getType() + " name already exists");
            }
        }
        return null;
    }

    public static FactorHolder getFactorHolder(Entry entry) {
        if (entry instanceof Analyse) {
            return ((Analyse)entry).getFactorHolder();
        }
        if (entry instanceof Workflow) {
            return ((Workflow)entry).getFactorHolder();
        }
        if (entry instanceof Group) {
            return ((Group)entry).getFactorHolder();
        }
        return null;
    }
}

