/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.record.edit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.backend.measure.applychanges.ApplyChanges;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.sample.SampleValues;
import se.prediktera.breeze.common.realtime.unmixing.SelectMembersPanel;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.entry.EntryHolder;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.BreezeTextComponentAncestor;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeColorChooser;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.BreezeTextArea;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.common.swing.table.DefaultBreezeTableImpl;
import se.prediktera.breeze.frontend.common.util.ListHelper;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.main.record.edit.DuplicateValidator;
import se.prediktera.breeze.frontend.main.record.edit.common.AbstractEditEntryMainPanel;
import se.prediktera.breeze.frontend.main.record.edit.common.EditBreezeList;

public class EditCategoriesPanel
extends AbstractViewPanel
implements BreezeTextComponentAncestor {
    private final DuplicateValidator duplicateValidator = new DuplicateValidator();
    private final EntryHolder entry;
    private CategoryFactor variable;
    private final BreezeButton addClassButton;
    private final BreezeTablePanel table;
    private final BreezeButton downDescriptionButton;
    private final JPanel rightToolbarPanel;
    private final BreezeInputField nameTextField = new BreezeInputField("Category name", "", "");
    private final BreezeComboBoxInputField<CategoryFactor.CategoryBy> categoryByField = new BreezeComboBoxInputField("Input", "", BreezeInputFieldHelper.Format.TwoRows);
    private final BreezeButton removeDescriptionButton;
    private final BreezeButton upDescriptionButton;
    private final BreezeButton createPropertiesButton;
    private final BreezeButton updateModelsButton;
    private final BreezeButton pasteFromClipboardButton;
    private final BreezeButton syncFromRecordButton;

    public EditCategoriesPanel(final AbstractEditEntryMainPanel abstractEditEntryMainPanel, final EntryHolder entryHolder) {
        super(abstractEditEntryMainPanel);
        this.entry = entryHolder;
        this.table = new BreezeTablePanel();
        this.rightToolbarPanel = new JPanel();
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new GridBagLayout());
        this.nameTextField.setName("categoryName");
        this.nameTextField.addChangeListener(textActionEvent -> {
            String string = this.nameTextField.getValue();
            this.variable.setName(string);
            abstractEditEntryMainPanel.refreshListAndUpdateTitleFromEntry(this.variable);
            entryHolder.save();
        });
        this.nameTextField.setMinlength(1);
        this.nameTextField.addValidator(this.duplicateValidator);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 40, 0, 0);
        this.add(this.nameTextField, gridBagConstraints);
        this.categoryByField.addItem(CategoryFactor.CategoryBy.Manual);
        this.categoryByField.addSeparator();
        this.categoryByField.addItem(CategoryFactor.CategoryBy.Group);
        this.categoryByField.addItem(CategoryFactor.CategoryBy.Measurement);
        this.categoryByField.setChangedListener(categoryBy -> {
            this.variable.setCategoryBy(this.categoryByField.getSelectedItem());
            this.showEntry(this.variable, null);
        });
        if (BreezeFrame.isCategoryByFeature()) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(10, 40, 0, 0);
            this.add(this.categoryByField, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 40, 20, 90);
        this.add(new BreezeSeparator(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        this.add(new BreezeLabel("Category class", false, 14), gridBagConstraints);
        this.table.getTable().setDefaultEditor(String.class, new BreezeTable.BreezeTextCellEditor((n, string) -> {
            if (this.variable.isEditable()) {
                CatClass catClass = (CatClass)this.table.getTable().getValueAt(n, 0);
                catClass.setName(string);
                this.table.updateTable();
                this.saveEntry(entryHolder);
            }
        }));
        this.table.getTable().setDefaultRenderer(CatClass.class, new SelectMembersPanel.CatClassCellRenderer());
        this.table.getTable().setDefaultEditor(CatClass.class, new SelectMembersPanel.CatClassCellEditor(() -> this.saveEntry(entryHolder)));
        this.table.addRowHeader(50);
        this.table.initTable(new DefaultBreezeTableImpl(this){

            @Override
            public Vector createVOVector(Object object) {
                Vector<Object> vector = new Vector<Object>();
                CatClass catClass = (CatClass)object;
                vector.add(catClass);
                vector.add(catClass.getName());
                return vector;
            }

            @Override
            public List<Object> getTableHeader(List list) {
                return Arrays.asList("Color", "Name");
            }

            @Override
            public int[] getColumnWidth() {
                return new int[]{15, 85};
            }
        }, null, false);
        this.table.setRowHeight(30);
        this.table.getTable().getSelectionModel().setSelectionMode(2);
        BreezeScrollPane breezeScrollPane = new BreezeScrollPane();
        breezeScrollPane.setLineBorder();
        breezeScrollPane.setHorizontalScrollBarPolicy(31);
        breezeScrollPane.setViewportView((Component)((Object)this.table));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 40, 20, 0);
        this.add(breezeScrollPane, gridBagConstraints);
        this.rightToolbarPanel.setOpaque(false);
        this.rightToolbarPanel.setLayout(new GridBagLayout());
        this.addClassButton = EntryMainHelper.createButton("addClass", "Add", "material/add", () -> BreezeOptionDialog.showDialog(this.getFrame(), this.getMainPanel().getPageColor(), AbstractBreezeDialog.MessageType.POPUP_OPTION, "New class", "", (AbstractBreezeCustomPanel)new NewClassPanel(this.variable), null, breezeActionEvent -> {
            NewClassPanel newClassPanel = (NewClassPanel)breezeActionEvent.getBreezeCustomPanel();
            String string = newClassPanel.getResult();
            if (string.length() > 0) {
                CatClass catClass = this.variable.addClass(string, newClassPanel.getColor());
                List<CatClass> list = this.variable.getClasses();
                this.table.setTableList(list, catClass);
                entryHolder.save();
            }
        }));
        this.addClassButton.setPreferredSize(new Dimension(40, 53));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 40);
        this.rightToolbarPanel.add((Component)this.addClassButton, gridBagConstraints);
        this.removeDescriptionButton = EntryMainHelper.createButton("deleteClass", "Delete", "material/delete", () -> BreezeOptionDialog.showDialog(this.mainpanel, AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Confirm delete", "You are about to delete a class and all assigned values for this class will be cleared\n\n\n\nAre you sure you want to continue?", breezeActionEvent -> {
            List<CatClass> list = this.getSelectedClasses(false);
            if (list.size() > 0) {
                for (int i = list.size() - 1; i >= 0; --i) {
                    CatClass catClass = list.get(i);
                    if (catClass.isNoClass()) continue;
                    int n = catClass.getValueIdx();
                    this.variable.getClasses().remove(catClass);
                    EditCategoriesPanel.updateAfterRemove(this.variable, entryHolder, n);
                    this.table.updateTable();
                }
                entryHolder.save();
            }
        }));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 40);
        this.rightToolbarPanel.add((Component)this.removeDescriptionButton, gridBagConstraints);
        this.upDescriptionButton = EntryMainHelper.createButton("upClass", "Up", "material/arrow_upward", () -> {
            int n2 = this.table.getTable().getSelectedRow();
            if (n2 > 0 && EditCategoriesPanel.updateAfterSwap(this.variable, entryHolder, this.swapIndex(n2, n2 - 1, n -> !this.variable.getClasses().get(n).isNoClass()))) {
                this.table.updateTable();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 40);
        this.rightToolbarPanel.add((Component)this.upDescriptionButton, gridBagConstraints);
        this.downDescriptionButton = EntryMainHelper.createButton("downClass", "Down", "material/arrow_downward", () -> {
            int n2 = this.table.getTable().getSelectedRow();
            if (n2 >= 0 && n2 < this.table.getTable().getRowCount() - 1 && EditCategoriesPanel.updateAfterSwap(this.variable, entryHolder, this.swapIndex(n2, n2 + 1, n -> !this.variable.getClasses().get(n).isNoClass()))) {
                this.table.updateTable();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(10, 5, 0, 40);
        this.rightToolbarPanel.add((Component)this.downDescriptionButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 30, 0);
        this.add(this.rightToolbarPanel, gridBagConstraints);
        this.createPropertiesButton = EntryMainHelper.createButton("Dummy properties for each class", "material/add", () -> BreezeProgressDialog.startProgress(this.getFrame(), new ProgressAction(this){
            final /* synthetic */ EditCategoriesPanel this$0;
            {
                this.this$0 = editCategoriesPanel;
            }

            @Override
            public void runAction() throws Exception {
                this.setInfoText("Creating properties");
                PropertyFactor propertyFactor = null;
                for (CatClass catClass : this.this$0.variable.getClasses()) {
                    if (catClass.isNoClass()) continue;
                    int n = catClass.getValueIdx();
                    PropertyFactor propertyFactor2 = new PropertyFactor(catClass.getName());
                    entryHolder.getPropertyFactors().add(propertyFactor2);
                    if (entryHolder instanceof Workflow) {
                        Workflow workflow = (Workflow)entryHolder;
                        for (Measurement measurement : workflow.getAllMeasurements()) {
                            measurement.getRootSample().forEverySample(basicSample -> {
                                Float f = basicSample.getSampleValues().getValue(this.this$0.variable);
                                if (f != null && f.intValue() > 0) {
                                    basicSample.getSampleValues().setValue(propertyFactor2, f.intValue() == n ? 100.0f : 0.0f);
                                } else {
                                    basicSample.getSampleValues().removeValue(propertyFactor2);
                                }
                            });
                            measurement.save();
                        }
                    }
                    propertyFactor = propertyFactor2;
                }
                if (propertyFactor != null) {
                    entryHolder.save();
                    abstractEditEntryMainPanel.getList(EditBreezeList.BreezeListType.Property).updateList(entryHolder.getPropertyFactors().getList());
                }
            }
        }, "Progress"));
        this.updateModelsButton = EntryMainHelper.createButton("Update category in models", "material/upgrade", () -> BreezeProgressDialog.startProgress(this.getFrame(), new ProgressAction(this){
            final /* synthetic */ EditCategoriesPanel this$0;
            {
                this.this$0 = editCategoriesPanel;
            }

            @Override
            public void runAction() throws Exception {
                this.setInfoText("Updating category in models");
                StringBuilder stringBuilder = new StringBuilder();
                for (BasicAnalyse basicAnalyse : BreezeMasterCache.getInstance().getAnalyseList()) {
                    for (CategoryFactor categoryFactor : basicAnalyse.getCategoryFactors()) {
                        if (!categoryFactor.getOrigUid().equals(this.this$0.variable.getOrigUid())) continue;
                        categoryFactor.syncModelFactor(this.this$0.variable);
                        stringBuilder.append(basicAnalyse.getName() + "\n");
                        ((Analyse)basicAnalyse).save();
                    }
                }
                ModelsUpdatedPanel.showMessageAndApplyChanges(this.this$0.getMainPanel(), Workflow.getWorkflow(entryHolder), "Category", stringBuilder);
            }
        }, "Progress"));
        this.updateModelsButton.setName("updateModels");
        this.syncFromRecordButton = EntryMainHelper.createButton("Synchronize with Project category", "material/sync", () -> BreezeProgressDialog.startProgress(this.getFrame(), new ProgressAction(this){
            final /* synthetic */ EditCategoriesPanel this$0;
            {
                this.this$0 = editCategoriesPanel;
            }

            @Override
            public void runAction() throws Exception {
                CategoryFactor categoryFactor;
                this.setInfoText("Synchronized with Record category");
                Workflow workflow = (Workflow)entryHolder;
                String string = workflow.getStudyId();
                Workflow workflow2 = BreezeMasterCache.getInstance().getStudyList().byId(string);
                if (workflow2 != null && (categoryFactor = workflow2.getCategoryFactors().getByName(this.this$0.nameTextField.getValue())) != null) {
                    this.this$0.variable.syncModelFactor(categoryFactor, false);
                    this.this$0.showEntry(this.this$0.variable, null);
                    workflow.save();
                }
            }
        }, "Progress"));
        this.syncFromRecordButton.setName("synchronizeCategory");
        this.pasteFromClipboardButton = EntryMainHelper.createButton("Import from clipboard", "material/content_paste_go", () -> {
            final String[] stringArray = this.getClipboardLines();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Confirm import of ");
            stringBuilder.append(stringArray.length);
            stringBuilder.append(" classes from clipboard:\n\n");
            for (int i = 0; i < Math.min(stringArray.length, 5); ++i) {
                stringBuilder.append(stringArray[i]);
                stringBuilder.append("\n");
            }
            if (stringArray.length > 5) {
                stringBuilder.append("...");
            }
            BreezeOptionDialog.showDialog(this.getMainPanel(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Import from clipboard", stringBuilder.toString(), breezeActionEvent -> BreezeProgressDialog.startProgress(this.getFrame(), new ProgressAction(this){
                final /* synthetic */ EditCategoriesPanel this$0;
                {
                    this.this$0 = editCategoriesPanel;
                }

                @Override
                public void runAction() throws Exception {
                    this.setInfoText("Importing classes from clipboard");
                    for (String string : stringArray) {
                        CatClass catClass = new CatClass(string, this.this$0.variable);
                        catClass.setColor(RtPerfectSpread.generateColor(this.this$0.variable.getMaxSize()));
                        this.this$0.variable.getClasses().add(catClass);
                    }
                    this.this$0.table.updateTable();
                    entryHolder.save();
                }
            }, "Progress"));
        });
        this.pasteFromClipboardButton.setName("importClipboard");
    }

    private void saveEntry(EntryHolder entryHolder) {
        DataSetCache.clearRecursive(entryHolder);
        entryHolder.save();
    }

    private String[] getClipboardLines() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            String string = (String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
            return string.split("\n");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void addComponent(BreezeMainPanel breezeMainPanel) {
        BreezeType breezeType = breezeMainPanel.getPageType();
        if (this.entry instanceof Workflow) {
            if (breezeType.equals((Object)BreezeType.Project)) {
                breezeMainPanel.addRightButton(this.createPropertiesButton);
                breezeMainPanel.addRightButton(this.updateModelsButton);
            } else if (breezeType.equals((Object)BreezeType.Workflow)) {
                breezeMainPanel.addRightButton(this.syncFromRecordButton);
            }
            breezeMainPanel.addRightButton(this.pasteFromClipboardButton);
        }
    }

    @Override
    public String getType() {
        return "Categories";
    }

    @Override
    public void showEntry(Object object, Object object2) {
        if (object instanceof CategoryFactor) {
            Object object3;
            CategoryFactor categoryFactor;
            this.variable = categoryFactor = (CategoryFactor)object;
            this.nameTextField.setText(this.variable.getName());
            EntryHolder entryHolder = this.entry;
            if (entryHolder instanceof Workflow) {
                object3 = (Workflow)entryHolder;
                this.categoryByField.setSelectedItemWithoutListeners((Object)this.variable.getCategoryBy());
                if (this.variable.getCategoryBy().equals((Object)CategoryFactor.CategoryBy.Group) && this.variable.synchronizeEntries(((Workflow)object3).getChildList())) {
                    ((Workflow)object3).save();
                } else if (this.variable.getCategoryBy().equals((Object)CategoryFactor.CategoryBy.Measurement) && this.variable.synchronizeEntries(((Workflow)object3).getAllMeasurements())) {
                    ((Workflow)object3).save();
                }
            } else {
                this.categoryByField.setVisible(false);
            }
            this.setEditable(this.variable);
            object3 = this.variable.getClasses();
            this.table.setTableList((List)object3, object3.size() > 0 ? object3.get(0) : null);
            this.nameTextField.requestFocusAndSelectAll();
            this.duplicateValidator.setElement(this.entry, this.variable);
        }
    }

    private ListHelper.SwapIndex swapIndex(int n, int n2, ListHelper.SwapIndexCallback swapIndexCallback) {
        if (swapIndexCallback.canSwap(n) && swapIndexCallback.canSwap(n2)) {
            this.variable.swap(n, n2);
            return new ListHelper.SwapIndex(n, n2);
        }
        return null;
    }

    public static boolean updateAfterSwap(CategoryFactor categoryFactor, EntryHolder entryHolder, ListHelper.SwapIndex swapIndex) {
        if (swapIndex != null && entryHolder instanceof Workflow) {
            for (Group group : ((Workflow)entryHolder).getChildList()) {
                for (Measurement measurement : group.getChildList()) {
                    if (!EditCategoriesPanel.updateSamplesAfterSwap(categoryFactor, swapIndex, measurement.getChildList())) continue;
                    measurement.save();
                }
            }
            entryHolder.save();
            return true;
        }
        return false;
    }

    private List<CatClass> getSelectedClasses(boolean bl) {
        ArrayList<CatClass> arrayList = new ArrayList<CatClass>();
        for (Object e : this.table.getSelectedValues()) {
            CatClass catClass = (CatClass)e;
            if (!bl && catClass.isNoClass()) continue;
            arrayList.add(catClass);
        }
        return arrayList;
    }

    private void setEditable(CategoryFactor categoryFactor) {
        boolean bl = categoryFactor != null && categoryFactor.isEditable();
        this.addClassButton.setVisible(bl);
        this.removeDescriptionButton.setVisible(bl);
        this.pasteFromClipboardButton.setEnabled(bl);
    }

    public static void updateAfterRemove(CategoryFactor categoryFactor, EntryHolder entryHolder, int n) {
        if (entryHolder instanceof Workflow) {
            Workflow workflow = (Workflow)entryHolder;
            for (Group group : workflow.getChildList()) {
                for (Measurement measurement : group.getChildList()) {
                    if (!EditCategoriesPanel.updateSamplesAfterRemove(categoryFactor, n, measurement.getChildList())) continue;
                    measurement.save();
                }
            }
        }
    }

    private static boolean updateSamplesAfterRemove(CategoryFactor categoryFactor, int n, List<BasicSample> list) {
        boolean bl = false;
        for (BasicSample basicSample : list) {
            SampleValues sampleValues = basicSample.getSampleValues();
            Float f = sampleValues.getValue(categoryFactor);
            if (f != null && f.intValue() >= n) {
                if (f.intValue() == n) {
                    sampleValues.removeValue(categoryFactor);
                } else {
                    sampleValues.setValue(categoryFactor, f.intValue() - 1);
                }
                bl = true;
            }
            if (!EditCategoriesPanel.updateSamplesAfterRemove(categoryFactor, n, basicSample.getChildList())) continue;
            bl = true;
        }
        return bl;
    }

    private static boolean updateSamplesAfterSwap(CategoryFactor categoryFactor, ListHelper.SwapIndex swapIndex, List<BasicSample> list) {
        boolean bl = false;
        for (BasicSample basicSample : list) {
            SampleValues sampleValues = basicSample.getSampleValues();
            Float f = sampleValues.getValue(categoryFactor);
            if (f != null) {
                if (f.intValue() == swapIndex.from) {
                    sampleValues.setValue(categoryFactor, swapIndex.to);
                    bl = true;
                } else if (f.intValue() == swapIndex.to) {
                    sampleValues.setValue(categoryFactor, swapIndex.from);
                    bl = true;
                }
            }
            if (!EditCategoriesPanel.updateSamplesAfterSwap(categoryFactor, swapIndex, basicSample.getChildList())) continue;
            bl = true;
        }
        return bl;
    }

    public CategoryFactor getVariable() {
        return this.variable;
    }

    public static class NewClassPanel
    extends AbstractBreezeCustomPanel.DefaultBreezeCustomPanel {
        private final BreezeInputField nameInputField = new BreezeInputField("Enter name:", "", "");
        private final BreezeColorChooser colorChooser = new BreezeColorChooser(true);

        public NewClassPanel(CategoryFactor categoryFactor) {
            this.add((Component)this.nameInputField, GridBagHelper.create(this.getComponentCount(), new Insets(48, 24, 0, 24)));
            this.nameInputField.getTextField().setName("input");
            this.colorChooser.setSelectedItem(RtPerfectSpread.generateColor(categoryFactor.getMaxSize()));
            this.colorChooser.setMinimumSize(new Dimension(120, 30));
            this.colorChooser.setPreferredSize(new Dimension(120, 30));
            this.add((Component)this.colorChooser, GridBagHelper.createLeft(this.getComponentCount(), new Insets(12, 24, 0, 24)));
            this.addEndBlock();
        }

        @Override
        public void customButton(BreezeButton breezeButton, BreezeButton breezeButton2, BreezeButton breezeButton3) {
            breezeButton2.setText("Add");
        }

        @Override
        public void onShow() {
            SwingUtilities.invokeLater(this.nameInputField::requestFocusAndSelectAll);
        }

        @Override
        public String getResult() {
            return this.nameInputField.getValue();
        }

        public Color getColor() {
            return this.colorChooser.getSelectedColor();
        }
    }

    public static class ModelsUpdatedPanel
    extends AbstractBreezeCustomPanel {
        private final BreezeCheckBox applyChangesCheckBox = new BreezeCheckBox("Apply Changes to all measurements?", true);

        public ModelsUpdatedPanel(String string, StringBuilder stringBuilder) {
            this.setOpaque(false);
            this.setLayout(new GridBagLayout());
            BreezeTextArea breezeTextArea = new BreezeTextArea(string + " in models and workflow has been successfully updated\n\nAssociated models:\n\n" + stringBuilder.toString(), true);
            breezeTextArea.setRows(4);
            breezeTextArea.setEditable(false);
            breezeTextArea.setBorder(BorderFactory.createEmptyBorder());
            GridBagConstraints gridBagConstraints = GridBagHelper.create(0, new Insets(20, 10, 0, 10));
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)breezeTextArea, gridBagConstraints);
            this.applyChangesCheckBox.setVisible(stringBuilder.length() > 0);
            this.add((Component)this.applyChangesCheckBox, GridBagHelper.create(3, new Insets(20, 10, 10, 0)));
            this.setPreferredSize(new Dimension(600, 500));
            BreezeTheme breezeTheme = BreezeTheme.getInstance();
            breezeTextArea.setTextBackground(breezeTheme.getDialogBackground());
        }

        public static void showMessageAndApplyChanges(BreezeMainPanel breezeMainPanel, Workflow workflow, String string, StringBuilder stringBuilder) {
            BreezeOptionDialog.showDialog(breezeMainPanel.getFrame(), breezeMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Models updated", "", (AbstractBreezeCustomPanel)new ModelsUpdatedPanel(string, stringBuilder), null, breezeActionEvent -> {
                ModelsUpdatedPanel modelsUpdatedPanel = (ModelsUpdatedPanel)breezeActionEvent.getBreezeCustomPanel();
                if (modelsUpdatedPanel.applyChangesCheckBox.isVisibleAndSelected()) {
                    ApplyChanges.applyChanges(breezeMainPanel.getFrame(), workflow.getAllMeasurements());
                }
            });
        }

        @Override
        public boolean usePreferredSize() {
            return true;
        }

        @Override
        public Object getResult() {
            return null;
        }
    }
}

