/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.record.edit;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import se.prediktera.breeze.backend.entry.RtWorkflow;
import se.prediktera.breeze.common.entry.BasicMasterCache;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.entry.sample.RootSample;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.util.ListHelper;
import se.prediktera.breeze.frontend.main.record.edit.EditCategoriesPanel;
import se.prediktera.breeze.test.stubs.GroupWithoutIO;
import se.prediktera.breeze.test.stubs.MeasurementWithoutIO;
import se.prediktera.breeze.test.stubs.WorkflowWithoutIO;

public class EditCategoriesPanelTest {
    @Before
    public void setMockInstances() {
        BasicMasterCache.getInstance().setMasterCacheInterface(new RtWorkflow());
    }

    @After
    public void resetMockInstances() {
        BasicMasterCache.clearInstance();
    }

    @Test
    public void testRemoveCatClass() {
        BasicSample basicSample = this.createRootSampleWithWorkflow();
        Workflow workflow = basicSample.measurement().getWorkflow();
        CategoryFactor categoryFactor = workflow.getCategoryFactors().get(0);
        CatClass catClass = categoryFactor.getClasses().get(1);
        int n = catClass.getValueIdx();
        categoryFactor.getClasses().remove(catClass);
        EditCategoriesPanel.updateAfterRemove(categoryFactor, workflow, n);
        MatcherAssert.assertThat((Object)basicSample.getChild(0).getSampleValues().getValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(0.0f)));
        MatcherAssert.assertThat((Object)categoryFactor.isMissing(basicSample.getChild(1)), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)basicSample.getChild(2).getSampleValues().getValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(1.0f)));
        MatcherAssert.assertThat((Object)basicSample.getChild(3).getSampleValues().getValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(2.0f)));
        MatcherAssert.assertThat((Object)categoryFactor.getClasses().get(0).getValueIdx(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)categoryFactor.getClasses().get(1).getValueIdx(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)categoryFactor.getClasses().get(2).getValueIdx(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)categoryFactor.getClasses().get(3).getValueIdx(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testSwapCatClass() {
        BasicSample basicSample = this.createRootSampleWithWorkflow();
        Workflow workflow = basicSample.measurement().getWorkflow();
        CategoryFactor categoryFactor = workflow.getCategoryFactors().get(0);
        MatcherAssert.assertThat((Object)basicSample.getChild(0).getSampleValues().getValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(0.0f)));
        MatcherAssert.assertThat((Object)basicSample.getChild(1).getSampleValues().getValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(1.0f)));
        MatcherAssert.assertThat((Object)basicSample.getChild(2).getSampleValues().getValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(2.0f)));
        MatcherAssert.assertThat((Object)basicSample.getChild(3).getSampleValues().getValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(3.0f)));
        List<CatClass> list = categoryFactor.getClasses();
        CatClass catClass = list.get(1);
        list.set(1, list.get(3));
        list.set(3, catClass);
        EditCategoriesPanel.updateAfterSwap(categoryFactor, workflow, new ListHelper.SwapIndex(1, 3));
        MatcherAssert.assertThat((Object)basicSample.getChild(0).getSampleValues().getValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(0.0f)));
        MatcherAssert.assertThat((Object)basicSample.getChild(1).getSampleValues().getValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(3.0f)));
        MatcherAssert.assertThat((Object)basicSample.getChild(2).getSampleValues().getValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(2.0f)));
        MatcherAssert.assertThat((Object)basicSample.getChild(3).getSampleValues().getValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(1.0f)));
    }

    private BasicSample createRootSampleWithWorkflow() {
        WorkflowWithoutIO workflowWithoutIO = new WorkflowWithoutIO();
        GroupWithoutIO groupWithoutIO = new GroupWithoutIO(workflowWithoutIO);
        workflowWithoutIO.addChild(groupWithoutIO);
        MeasurementWithoutIO measurementWithoutIO = new MeasurementWithoutIO(groupWithoutIO);
        groupWithoutIO.addChild(measurementWithoutIO);
        CategoryFactor categoryFactor = this.createTestFactor();
        workflowWithoutIO.getCategoryFactors().add(categoryFactor);
        RootSample rootSample = new RootSample();
        measurementWithoutIO.replaceRootSample(rootSample);
        Sample sample = new Sample();
        sample.getSampleValues().setValue(categoryFactor, 0.0f);
        rootSample.addChild(sample);
        Sample sample2 = new Sample();
        sample2.getSampleValues().setValue(categoryFactor, 1.0f);
        rootSample.addChild(sample2);
        Sample sample3 = new Sample();
        sample3.getSampleValues().setValue(categoryFactor, 2.0f);
        rootSample.addChild(sample3);
        Sample sample4 = new Sample();
        sample4.getSampleValues().setValue(categoryFactor, 3.0f);
        rootSample.addChild(sample4);
        return rootSample;
    }

    private CategoryFactor createTestFactor() {
        CategoryFactor categoryFactor = new CategoryFactor("test");
        categoryFactor.addClass("A");
        categoryFactor.addClass("B");
        categoryFactor.addClass("C");
        categoryFactor.addClass("D");
        return categoryFactor;
    }
}

