/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.record.edit;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.category.CategoryList;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.sample.SampleValues;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.identifier.Identifier;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.main.record.edit.DuplicateValidator;
import se.prediktera.breeze.frontend.main.record.edit.common.AbstractEditEntryMainPanel;
import se.prediktera.breeze.frontend.main.record.edit.common.EditBreezeList;

public class EditIdentifiersPanel
extends AbstractViewPanel {
    private final Workflow workflow;
    private Identifier id;
    private final DuplicateValidator duplicateValidator = new DuplicateValidator();
    private final BreezeInputField nameTextField = new BreezeInputField("Name", "", "");
    private final BreezeButton createCategoryButton;

    public EditIdentifiersPanel(final AbstractEditEntryMainPanel abstractEditEntryMainPanel, final Workflow workflow) {
        this.workflow = workflow;
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 40, 10, 40);
        this.add(this.nameTextField, gridBagConstraints);
        this.nameTextField.addChangeListener(textActionEvent -> {
            this.id.setName(textActionEvent.getText());
            abstractEditEntryMainPanel.refreshListAndUpdateTitleFromEntry(this.id);
            workflow.save();
        });
        this.nameTextField.setMinlength(1);
        this.nameTextField.addValidator(this.duplicateValidator);
        this.createCategoryButton = EntryMainHelper.createButton("Create category from identifier", "material/add", () -> BreezeProgressDialog.startProgress(abstractEditEntryMainPanel.getFrame(), new ProgressAction(this){
            final /* synthetic */ EditIdentifiersPanel this$0;
            {
                this.this$0 = editIdentifiersPanel;
            }

            @Override
            public void runAction() throws Exception {
                this.setInfoText("Creating category from identifier");
                CategoryList categoryList = workflow.getCategoryFactors();
                CategoryFactor categoryFactor = categoryList.add(CategoryFactor.withNoClass(EntryMainHelper.getUniqueName(this.this$0.id.getName(), categoryList.getList())));
                for (Group group : workflow.getChildList()) {
                    for (Measurement measurement : group.getChildList()) {
                        if (!EditIdentifiersPanel.updateSamplesWithIdentifierValue(categoryFactor, this.this$0.id, measurement.getChildList())) continue;
                        measurement.save();
                    }
                }
                workflow.save();
                abstractEditEntryMainPanel.getList(EditBreezeList.BreezeListType.Category).setSelectedValue(categoryFactor);
            }
        }, "Progress"));
    }

    private static boolean updateSamplesWithIdentifierValue(CategoryFactor categoryFactor, Identifier identifier, List<BasicSample> list) {
        boolean bl = false;
        for (BasicSample basicSample : list) {
            Sample sample = (Sample)basicSample;
            String string = sample.getIdentifierProperties().getValue(identifier);
            if (string != null) {
                CatClass catClass = categoryFactor.addClass(string);
                SampleValues sampleValues = basicSample.getSampleValues();
                sampleValues.setValue(categoryFactor, categoryFactor.getClassIndex(catClass));
                bl = true;
            }
            if (!EditIdentifiersPanel.updateSamplesWithIdentifierValue(categoryFactor, identifier, basicSample.getChildList())) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public String getType() {
        return "Identifier";
    }

    @Override
    public void addComponent(BreezeMainPanel breezeMainPanel) {
        breezeMainPanel.addRightButton(this.createCategoryButton);
    }

    @Override
    public void showEntry(Object object, Object object2) {
        if (object instanceof Identifier) {
            this.id = (Identifier)object;
            this.nameTextField.setText(this.id.getName());
            this.nameTextField.requestFocusAndSelectAll();
            this.duplicateValidator.setElement(this.workflow, this.id);
        }
    }
}

