/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.record.edit;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.entry.EntryHolder;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.TextActionEvent;
import se.prediktera.breeze.frontend.common.BreezeTextComponentAncestor;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.main.record.edit.DuplicateValidator;
import se.prediktera.breeze.frontend.main.record.edit.EditCategoriesPanel;
import se.prediktera.breeze.frontend.main.record.edit.common.AbstractEditEntryMainPanel;

public class EditPropertiesPanel
extends AbstractViewPanel
implements BreezeTextComponentAncestor {
    private final DuplicateValidator duplicateValidator = new DuplicateValidator();
    private final EntryHolder entry;
    private PropertyFactor variable;
    private final BreezeButton updateModelsButton;
    private final BreezeInputField nameTextField = new BreezeInputField("Name", "", "");
    private final BreezeInputField unitTextField = new BreezeInputField("Unit", "", "");
    private final BreezeInputField defaultValueTextField = new BreezeInputField("Default value (Optional)", "", "");
    private final BreezeInputField maxInputField = new BreezeInputField("Max", "", "");
    private final BreezeInputField minInputField = new BreezeInputField("Min", "", "");

    public EditPropertiesPanel(AbstractEditEntryMainPanel abstractEditEntryMainPanel, final EntryHolder entryHolder) {
        super(abstractEditEntryMainPanel);
        this.entry = entryHolder;
        this.setBackground(new Color(51, 51, 51));
        this.setLayout(new GridBagLayout());
        this.nameTextField.setName("propertyName");
        this.add(this.nameTextField, GridBagHelper.create(0, new Insets(10, 40, 10, 40)));
        this.unitTextField.setName("propertyUnit");
        this.add(this.unitTextField, GridBagHelper.create(1, new Insets(10, 40, 10, 40)));
        this.defaultValueTextField.setName("propertyDefault");
        this.add(this.defaultValueTextField, GridBagHelper.create(2, new Insets(10, 40, 10, 40)));
        this.minInputField.setValue("0");
        this.add(this.minInputField, GridBagHelper.create(3, new Insets(10, 40, 10, 40)));
        this.maxInputField.setName("propertyMax");
        this.maxInputField.setValue("100");
        this.add(this.maxInputField, GridBagHelper.createLast(4, new Insets(10, 40, 10, 40)));
        TextActionEvent.TextActionListener textActionListener = textActionEvent -> {
            if (this.variable != null) {
                String string = this.nameTextField.getValue();
                this.variable.setName(string);
                this.variable.setUnit(this.unitTextField.getValue());
                if (this.defaultValueTextField.getValue().equals("")) {
                    this.variable.setDefaultValue(null);
                } else {
                    this.variable.setDefaultValue(Float.valueOf((float)this.defaultValueTextField.getNumber()));
                }
                this.variable.setMin((float)this.minInputField.getNumber());
                this.variable.setMax((float)this.maxInputField.getNumber());
                abstractEditEntryMainPanel.refreshListAndUpdateTitleFromEntry(this.variable);
                entryHolder.save();
            }
        };
        this.nameTextField.addChangeListener(textActionListener);
        this.nameTextField.setMinlength(1);
        this.nameTextField.addValidator(this.duplicateValidator);
        this.unitTextField.addChangeListener(textActionListener);
        this.defaultValueTextField.setNumberField(true);
        this.defaultValueTextField.addChangeListener(textActionListener);
        this.minInputField.setNumberField(true);
        this.minInputField.addChangeListener(textActionListener);
        this.maxInputField.setNumberField(true);
        this.maxInputField.addChangeListener(textActionListener);
        this.updateModelsButton = EntryMainHelper.createButton("Update property in models", "material/upgrade", () -> BreezeProgressDialog.startProgress(this.getFrame(), new ProgressAction(this){
            final /* synthetic */ EditPropertiesPanel this$0;
            {
                this.this$0 = editPropertiesPanel;
            }

            @Override
            public void runAction() throws Exception {
                this.setInfoText("Updating property in models");
                StringBuilder stringBuilder = new StringBuilder();
                for (BasicAnalyse basicAnalyse : BreezeMasterCache.getInstance().getAnalyseList()) {
                    Analyse analyse = (Analyse)basicAnalyse;
                    for (PropertyFactor propertyFactor : new ArrayList(analyse.getPropertyFactors().getList())) {
                        if (!propertyFactor.getOrigUid().equals(this.this$0.variable.getOrigUid())) continue;
                        propertyFactor.setName(this.this$0.variable.getName());
                        propertyFactor.setMin(this.this$0.variable.getMin());
                        propertyFactor.setMax(this.this$0.variable.getMax());
                        stringBuilder.append(analyse.getName() + "\n");
                        analyse.updateModel(this.getProgressManager());
                        analyse.save();
                    }
                }
                EditCategoriesPanel.ModelsUpdatedPanel.showMessageAndApplyChanges(this.this$0.getMainPanel(), Workflow.getWorkflow(entryHolder), "Property", stringBuilder);
            }
        }, "Progress"));
        this.updateModelsButton.setName("updatePropertyModels");
    }

    @Override
    public void addComponent(BreezeMainPanel breezeMainPanel) {
        breezeMainPanel.addRightButton(this.updateModelsButton);
    }

    @Override
    public String getType() {
        return "Properties";
    }

    @Override
    public void showEntry(Object object, Object object2) {
        if (object instanceof PropertyFactor) {
            this.variable = (PropertyFactor)object;
            this.nameTextField.setText(this.variable.getName());
            this.unitTextField.setValue(this.variable.getUnit());
            this.nameTextField.requestFocusAndSelectAll();
            this.duplicateValidator.setElement(this.entry, this.variable);
            if (this.variable.getDefaultValue() != null) {
                this.defaultValueTextField.setValue(this.variable.getDefaultValue());
            } else {
                this.defaultValueTextField.setValue("");
            }
            this.minInputField.setValue(this.variable.getMin());
            this.maxInputField.setValue(this.variable.getMax());
        }
    }
}

