/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.record.edit.common;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationPort;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.identifier.Identifier;
import se.prediktera.breeze.entry.workflow.LimitConfiguration;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.entry.EntryMainItemPanel;
import se.prediktera.breeze.frontend.common.entry.EntryTitlePanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.main.record.edit.common.EditBreezeList;
import se.prediktera.breeze.frontend.main.record.edit.common.EditEntryInterface;
import se.prediktera.map.common.error.ErrorHandler;

public abstract class AbstractEditEntryMainPanel
extends EntryMainItemPanel
implements EditEntryInterface {
    protected List<ViewClass> viewClassList = new ArrayList<ViewClass>();
    protected final Entry entry;
    protected Entry rootEntry;
    private final BreezeButton moveUpButton = new BreezeButton();
    private final BreezeButton moveDownButton = new BreezeButton();
    private final JPanel centerPanel = new JPanel(new GridBagLayout());
    private final JPanel editListPanel = new JPanel(new GridBagLayout());
    private final List<EditBreezeList> editLists = new ArrayList<EditBreezeList>();

    public AbstractEditEntryMainPanel(BreezeFrame breezeFrame, BreezeType breezeType, String string, Entry entry, Entry entry2, boolean bl) {
        super(breezeFrame, breezeType, string + " options: " + entry.getName(), false, true);
        this.entry = entry;
        this.rootEntry = entry2;
        this.verticalLabelPanel.setVisible(false);
        this.addCustomInput(this.centerPanel, entry);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = this.centerPanel.getComponentCount();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.centerPanel.add((Component)this.editListPanel, gridBagConstraints);
        this.editListPanel.setOpaque(false);
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.centerPanel.setBackground(breezeTheme.getPanelBackground());
        this.entryPanel.add((Component)new BreezeScrollPane(this.centerPanel), "Center");
        this.moveUpButton.setDesc("Up");
        this.moveUpButton.setIcon(new ImageIcon(this.getClass().getResource("/images/material/arrow_upward.png")));
        this.moveUpButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                EditBreezeList editBreezeList = AbstractEditEntryMainPanel.this.getSelectedList();
                if (editBreezeList != null) {
                    editBreezeList.moveUpSelected();
                }
            }
        });
        this.addLeftButton(this.moveUpButton);
        this.moveDownButton.setDesc("Down");
        this.moveDownButton.setDescForeground(breezeTheme.getButtonForeground());
        this.moveDownButton.setIcon(new ImageIcon(this.getClass().getResource("/images/material/arrow_downward.png")));
        this.moveDownButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                EditBreezeList editBreezeList = AbstractEditEntryMainPanel.this.getSelectedList();
                if (editBreezeList != null) {
                    editBreezeList.moveDownSelected();
                }
            }
        });
        this.addLeftButton(this.moveDownButton);
    }

    @Override
    protected Component CreateTitlePanel(String string) {
        return EntryTitlePanel.createTitleLabel(string);
    }

    protected void addCustomInput(JPanel jPanel, Entry entry) {
    }

    @Override
    public void setLists(List<ViewClass> list, List list2, String string) {
        for (ViewClass object2 : list) {
            EditViewClass editViewClass = (EditViewClass)object2;
            EditBreezeList.BreezeListType breezeListType = (EditBreezeList.BreezeListType)((Object)editViewClass.getValue());
            EditBreezeList editBreezeList = new EditBreezeList(breezeListType);
            editBreezeList.setText(editViewClass.getName());
            editBreezeList.setList(this, editViewClass.list);
            editBreezeList.setEditable(editViewClass.editable);
            editBreezeList.setCollapsed(editViewClass.collapsed);
            editBreezeList.setToggleEnabled(editViewClass.collapsed);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = this.editListPanel.getComponentCount();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.insets = new Insets(12, 12, 0, 5);
            this.editListPanel.add((Component)editBreezeList, gridBagConstraints);
            this.editLists.add(editBreezeList);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = this.editListPanel.getComponentCount();
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        this.editListPanel.add((Component)jPanel, gridBagConstraints);
        super.setLists(list, list2, string);
    }

    @Override
    public void selectFirstItem(boolean bl) {
        this.selectFirstItem();
    }

    public void selectEmptyView() {
        AbstractEditEntryMainPanel abstractEditEntryMainPanel = this;
        SwingUtilities.invokeLater(() -> abstractEditEntryMainPanel.showEmptyPage());
    }

    public void selectEntryAndSave(Object object) {
        this.selectEntry(object);
        this.rootEntry.save();
    }

    @Override
    public void selectEntry(Object object) {
        this.refreshListAndUpdateTitleFromEntry(object);
        this.getSelectedList().setSelectedValue(object);
    }

    public void selectEntry(EditBreezeList.BreezeListType breezeListType, Object object) {
        this.refreshListAndUpdateTitleFromEntry(object);
        this.getList(breezeListType).setSelectedValue(object);
    }

    public void selectEntries(EditBreezeList.BreezeListType breezeListType, Object[] objectArray) {
        if (objectArray.length > 0) {
            this.refreshListAndUpdateTitleFromEntry(objectArray[0]);
        }
        this.getList(breezeListType).setSelectedValues(objectArray);
    }

    public void updateSelected() {
        EditBreezeList editBreezeList = this.getSelectedList();
        if (editBreezeList != null) {
            editBreezeList.updateSelected();
        }
    }

    public void valueSelected(Object object, EditBreezeList.BreezeListType breezeListType) {
        boolean bl = !(object instanceof SegmentationPort);
        this.setRemovedEnabled(bl);
        this.moveUpButton.setEnabled(bl);
        this.moveDownButton.setEnabled(bl);
        for (ViewClass viewClass : this.viewClassList) {
            if (!viewClass.getValue().equals((Object)breezeListType)) continue;
            this.setViewClass(viewClass, object);
            break;
        }
    }

    @Override
    protected boolean canAddEntry() {
        return false;
    }

    @Override
    public void entryDeleteClicked(Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        EditBreezeList editBreezeList = this.getSelectedList();
        if (editBreezeList == null) {
            throw new ErrorHandler.InformationMessageException("No selection, nothing to delete");
        }
        Object[] objectArray = editBreezeList.getSelectedValues();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                if (objectArray[i] instanceof FunctionTreeNode) {
                    stringBuilder.append(((FunctionTreeNode)objectArray[i]).getAliasOrNodeString());
                    continue;
                }
                stringBuilder.append(objectArray[i].toString());
            }
        }
        String string = AbstractEditEntryMainPanel.getDeleteText(stringBuilder.toString());
        BreezeOptionDialog.showDialog(this, AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Confirm delete", string, breezeActionEvent -> {
            EditBreezeList editBreezeList = this.getSelectedList();
            if (editBreezeList != null) {
                editBreezeList.removeSelected();
                if (editBreezeList.getItemCount() == 0) {
                    this.selectFirstItem();
                }
            }
            this.updateSelected();
        });
    }

    public static String getDeleteText(String string) {
        StringBuilder stringBuilder = new StringBuilder("You are about to delete ").append(string).append(" and all entered values will be deleted");
        stringBuilder.append("\n\n\n\nAre you sure you want to continue?");
        return stringBuilder.toString();
    }

    public static String getDeleteText(List list) {
        if (list.size() == 1) {
            Object e = list.get(0);
            if (e instanceof FunctionTreeNode) {
                return AbstractEditEntryMainPanel.getDeleteText(((FunctionTreeNode)e).getAliasOrNodeString());
            }
            return AbstractEditEntryMainPanel.getDeleteText(e.toString());
        }
        StringBuilder stringBuilder = new StringBuilder("You are about to delete ").append(list.size()).append(" objects and all entered values will be deleted");
        stringBuilder.append("\n\n\n\nAre you sure you want to continue?");
        return stringBuilder.toString();
    }

    public final boolean selectFirstItem() {
        for (EditBreezeList editBreezeList : this.editLists) {
            if (!editBreezeList.selectFirstItem()) continue;
            return true;
        }
        this.selectEmptyView();
        return false;
    }

    public final void refreshListAndUpdateTitleFromEntry(Object object) {
        for (EditBreezeList editBreezeList : this.editLists) {
            editBreezeList.repaint();
        }
        this.updateTitle(this.getViewClass(), object);
        this.repaint();
    }

    public final void setSelectedValue(Object object) {
        this.setSelectedTypeAndValue(this.getListType(object), object);
    }

    private EditBreezeList.BreezeListType getListType(Object object) {
        if (object instanceof Identifier) {
            return EditBreezeList.BreezeListType.Identifier;
        }
        if (object instanceof PropertyFactor) {
            return EditBreezeList.BreezeListType.Property;
        }
        if (object instanceof CategoryFactor) {
            return EditBreezeList.BreezeListType.Category;
        }
        if (object instanceof LimitConfiguration) {
            return EditBreezeList.BreezeListType.Limit;
        }
        return EditBreezeList.BreezeListType.Property;
    }

    @Override
    public final void setSelectedTypeAndValue(EditBreezeList.BreezeListType breezeListType, Object object) {
        if (object != null) {
            if (object instanceof NodeClass) {
                object = ((NodeClass)object).getNode();
            }
            for (EditBreezeList editBreezeList : this.editLists) {
                if (editBreezeList.getType() != breezeListType) {
                    editBreezeList.clearSelection();
                    continue;
                }
                if (editBreezeList.getSelectedValue() == object) continue;
                editBreezeList.setSelectedValue(object);
            }
            this.valueSelected(object, breezeListType);
        }
    }

    private final EditBreezeList getSelectedList() {
        for (EditBreezeList editBreezeList : this.editLists) {
            if (editBreezeList.getSelectedValue() == null) continue;
            return editBreezeList;
        }
        return null;
    }

    public final EditBreezeList getList(EditBreezeList.BreezeListType breezeListType) {
        for (EditBreezeList editBreezeList : this.editLists) {
            if (!editBreezeList.getType().equals((Object)breezeListType)) continue;
            return editBreezeList;
        }
        return null;
    }

    protected static void addChildNodesRecursive(List<NodeClass> list, Node node, int n) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() == 3 || !AbstractEditEntryMainPanel.hasChildNodes(node2)) continue;
            list.add(new NodeClass(node2, n));
            AbstractEditEntryMainPanel.addChildNodesRecursive(list, node2, n + 1);
        }
    }

    private static boolean hasChildNodes(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() == 3) continue;
            return true;
        }
        return false;
    }

    @Override
    public Entry getRootEntry() {
        return this.rootEntry;
    }

    protected class EditViewClass
    extends ViewClass {
        public final List list;
        public boolean editable;
        public boolean collapsed;

        public EditViewClass(AbstractEditEntryMainPanel abstractEditEntryMainPanel, EditBreezeList.BreezeListType breezeListType, CreateViewPanelCallback createViewPanelCallback, List list) {
            this(abstractEditEntryMainPanel, breezeListType, createViewPanelCallback, list, true, false);
        }

        public EditViewClass(AbstractEditEntryMainPanel abstractEditEntryMainPanel, EditBreezeList.BreezeListType breezeListType, CreateViewPanelCallback createViewPanelCallback, List list, boolean bl, boolean bl2) {
            super(breezeListType.getName(), abstractEditEntryMainPanel.new SwitchAbstractViewPanel(createViewPanelCallback), (Object)breezeListType);
            this.list = list;
            this.editable = bl;
            this.collapsed = bl2;
        }
    }

    protected static class NodeClass {
        private final Node node;
        private final int level;

        public NodeClass(Node node, int n) {
            this.node = node;
            this.level = n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" - ".repeat(Math.max(0, this.level)));
            stringBuilder.append(this.node.getNodeName());
            return stringBuilder.toString();
        }

        @Generated
        public Node getNode() {
            return this.node;
        }
    }

    protected static interface CreateViewPanelCallback {
        public AbstractViewPanel createPanel();
    }

    private class SwitchAbstractViewPanel
    extends ViewContainer {
        private final CreateViewPanelCallback createCallback;

        public SwitchAbstractViewPanel(CreateViewPanelCallback createViewPanelCallback) {
            this.createCallback = createViewPanelCallback;
        }

        @Override
        public String getType() {
            return null;
        }

        @Override
        public void showEntry(Object object, Object object2) {
            this.removeViewPanels();
            AbstractViewPanel abstractViewPanel = this.createCallback.createPanel();
            abstractViewPanel.setBgColor(BreezeTheme.getInstance().getPanelBackground());
            this.addViewPanel((Component)((Object)abstractViewPanel));
            abstractViewPanel.showEntry(object, object2);
        }
    }
}

