/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.record.edit.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.TreeModel;
import lombok.Generated;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.AnalyseSpectralGroup;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.identifier.Identifier;
import se.prediktera.breeze.entry.workflow.LimitConfiguration;
import se.prediktera.breeze.entry.workflow.VisualisationNode;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.ArrayListModel;
import se.prediktera.breeze.frontend.common.ArrayTreeModel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.LabelEntry;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.BreezeTree;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.common.util.ListHelper;
import se.prediktera.breeze.frontend.main.play.WorkflowMainPanel;
import se.prediktera.breeze.frontend.main.record.edit.common.EditEntryInterface;

public class EditBreezeList
extends JPanel {
    private EditEntryInterface editList;
    private final BreezeListType type;
    private boolean editable = true;
    private final BreezeButton addButton;
    private final BreezeButton expandButton;
    private final BreezeTree breezeTree = new BreezeTree();
    private final JLabel nameLabel = new BreezeLabel("", true, 14);
    private final JLabel numberLabel = new BreezeLabel("", false, 14);
    public MouseListener mouseClicked = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            super.mouseClicked(mouseEvent);
            EditBreezeList.this.setCollapsed(EditBreezeList.this.breezeTree.isVisible());
        }
    };

    public EditBreezeList(BreezeListType breezeListType) {
        this(breezeListType, BreezeProperties.getInstance().getEntryWidth());
    }

    public EditBreezeList(BreezeListType breezeListType, int n) {
        this.type = breezeListType;
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.nameLabel.addMouseListener(this.mouseClicked);
        this.nameLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.numberLabel, gridBagConstraints);
        this.addButton = EntryMainHelper.createButton("", "add2", this::addItemToTree);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.addButton, gridBagConstraints);
        this.breezeTree.addTreeSelectionListener(treeSelectionEvent -> this.updateSelected());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)((Object)this.breezeTree), gridBagConstraints);
        this.expandButton = EntryMainHelper.createButton("", "arrowdown", () -> this.setCollapsed(this.breezeTree.isVisible()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.expandButton, gridBagConstraints);
        this.breezeTree.setCellRenderer(new LabelEntry((int)((double)n * breezeListType.getWidthFactor()), 14));
        this.breezeTree.setSelectionBackground(new Color(102, 102, 102));
        this.breezeTree.addScroll();
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.breezeTree.setBackground(breezeTheme.getPanelBackground());
        this.nameLabel.setForeground(breezeTheme.getLabelForegroundDifuse());
        this.numberLabel.setForeground(breezeTheme.getLabelForegroundDifuse());
    }

    public void clearSelection() {
        this.breezeTree.clearSelection();
    }

    public int getItemCount() {
        TreeModel treeModel = this.getModel();
        if (treeModel instanceof ArrayListModel) {
            return ((ArrayListModel)((Object)treeModel)).getSize();
        }
        if (treeModel instanceof ArrayTreeModel) {
            return ((ArrayTreeModel)treeModel).getList().size();
        }
        return 0;
    }

    public TreeModel getModel() {
        return this.breezeTree.getModel();
    }

    public Object getSelectedValue() {
        return this.breezeTree.getSelectedValue();
    }

    public Object[] getSelectedValues() {
        return this.breezeTree.getSelectedValues();
    }

    public void moveDownSelected() {
        this.breezeTree.moveSelected(true);
        if (this.type.isExpand()) {
            this.breezeTree.expandAll();
        }
        this.saveEntryOrWorkflow();
    }

    public void moveUpSelected() {
        this.breezeTree.moveSelected(false);
        if (this.type.isExpand()) {
            this.breezeTree.expandAll();
        }
        this.saveEntryOrWorkflow();
    }

    public void removeSelected() {
        Workflow workflow = this.getWorkflow();
        for (Object object : this.breezeTree.getSelectedValues()) {
            this.breezeTree.removeItem(object);
            if (workflow == null) continue;
            if (object instanceof Factor) {
                Factor factor = (Factor)object;
                WorkflowMainPanel.removeFactorFromSamples(workflow, factor);
                continue;
            }
            if (!(object instanceof Identifier)) continue;
            Identifier identifier = (Identifier)object;
            workflow.getIdentifiers().removeIdentifierFromSamples(workflow, identifier);
        }
        this.saveEntryOrWorkflow();
    }

    public void setToggleEnabled(boolean bl) {
        this.expandButton.setEnabled(bl);
        this.nameLabel.removeMouseListener(this.mouseClicked);
        if (bl) {
            this.nameLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.nameLabel.addMouseListener(this.mouseClicked);
        } else {
            this.nameLabel.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void setCollapsed(boolean bl) {
        if (bl) {
            this.breezeTree.setVisible(false);
            this.expandButton.setIcon(ImageHelper.getResourceIcon("explore/expand_less"));
            this.addButton.setVisible(false);
        } else {
            this.breezeTree.setVisible(true);
            this.expandButton.setIcon(ImageHelper.getResourceIcon("explore/expand_more"));
            this.addButton.setVisible(this.editable);
        }
    }

    public void setRootVisible(boolean bl) {
        this.breezeTree.setRootVisible(bl);
    }

    public boolean isExpanded() {
        return this.breezeTree.isVisible();
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
        this.addButton.setVisible(bl);
    }

    public void setList(EditEntryInterface editEntryInterface, List list) {
        this.editList = editEntryInterface;
        this.setModel(list);
        this.addButton.setToolTipText("Add " + this.type.getDescription());
        this.addButton.setName(this.type.getName("add"));
        this.breezeTree.setName(this.type.getName("tree"));
        this.expandButton.setName(this.type.getName("toogle"));
    }

    public boolean updateList(List list) {
        Object object = this.getSelectedValue();
        this.setModel(list);
        if (list.contains(object)) {
            this.setSelectedValue(object);
            return true;
        }
        return false;
    }

    private void setModel(List list) {
        this.breezeTree.setModel(list);
        if (this.type.isExpand()) {
            this.breezeTree.expandAll();
        }
        this.numberLabel.setText("(" + this.getItemCount() + ")");
    }

    public boolean selectFirstItem() {
        if (this.isExpanded() && this.getItemCount() > 0) {
            this.setSelectedIndex(0);
            return true;
        }
        return false;
    }

    public void setSelectedIndex(int n) {
        this.breezeTree.setSelectedIndex(n);
    }

    public void setText(String string) {
        this.nameLabel.setText(string);
    }

    private void addItemToTree() {
        this.breezeTree.requestFocus();
        BreezeProgressDialog.startProgress(this.editList.getFrame(), new ProgressAction(){

            @Override
            public void runAction() throws Exception {
                this.setInfoText("Creating " + String.valueOf((Object)EditBreezeList.this.type));
                Entry entry = EditBreezeList.this.editList.getRootEntry();
                Group group = null;
                Workflow workflow = null;
                if (entry instanceof Group) {
                    group = (Group)entry;
                    workflow = group.getParent();
                } else if (entry instanceof Workflow) {
                    workflow = (Workflow)entry;
                }
                switch (EditBreezeList.this.type.ordinal()) {
                    case 2: {
                        CategoryFactor categoryFactor = CategoryFactor.withNoClass(EntryMainHelper.getUniqueName("Category", workflow.getCategoryFactors().getList()));
                        ListHelper.addItem(EditBreezeList.this.breezeTree, (Object)categoryFactor);
                        break;
                    }
                    case 4: {
                        SegmentationNode segmentationNode = SegmentationNode.createDefault();
                        segmentationNode.setParent(workflow.getRoot());
                        ListHelper.addItem(EditBreezeList.this.breezeTree, (Object)segmentationNode);
                        break;
                    }
                    case 0: {
                        Identifier identifier = new Identifier(EntryMainHelper.getUniqueName("Name", workflow.getIdentifiers().getList()));
                        ListHelper.addItem(EditBreezeList.this.breezeTree, (Object)identifier);
                        break;
                    }
                    case 1: {
                        PropertyFactor propertyFactor = new PropertyFactor(EntryMainHelper.getUniqueName("Property", workflow.getPropertyFactors().getList()));
                        ListHelper.addItem(EditBreezeList.this.breezeTree, (Object)propertyFactor);
                        break;
                    }
                    case 6: {
                        VisualisationNode visualisationNode = workflow.getVisualisationNode();
                        LimitConfiguration limitConfiguration = visualisationNode.createLimitFromModel(this.getProgressManager(), EntryMainHelper.getUniqueName("Limit", visualisationNode.getLimitList()));
                        ListHelper.addItem(EditBreezeList.this.breezeTree, (Object)limitConfiguration);
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 7: {
                        ListHelper.addItem(EditBreezeList.this.breezeTree, (Object)new AnalyseSpectralGroup((Analyse)entry, false));
                        break;
                    }
                    case 8: {
                        ListHelper.addItem(EditBreezeList.this.breezeTree, (Object)new AnalyseSpectralGroup((Analyse)entry, true));
                        break;
                    }
                }
                EditBreezeList.this.breezeTree.expandAll();
                EditBreezeList.this.saveEntryOrWorkflow();
            }
        }, "Progress");
    }

    public void updateSelected() {
        this.editList.setSelectedTypeAndValue(this.type, this.getSelectedValue());
        this.numberLabel.setText("(" + this.getItemCount() + ")");
    }

    public void setSelectedValue(Object object) {
        this.breezeTree.setSelectedValue(object);
        if (this.type.isExpand()) {
            this.breezeTree.expandAll();
        }
    }

    public void setSelectedValues(Object[] objectArray) {
        this.breezeTree.setSelectedValues(objectArray);
    }

    private void saveEntryOrWorkflow() {
        Workflow workflow = this.getWorkflow();
        if (workflow != null) {
            workflow.save();
        } else {
            this.editList.getRootEntry().save();
        }
    }

    private Workflow getWorkflow() {
        Entry entry = this.editList.getRootEntry();
        if (entry instanceof Workflow) {
            return (Workflow)entry;
        }
        if (entry instanceof Group) {
            return ((Group)entry).getParent();
        }
        return null;
    }

    @Generated
    public BreezeListType getType() {
        return this.type;
    }

    @Generated
    public BreezeTree getBreezeTree() {
        return this.breezeTree;
    }

    public static enum BreezeListType {
        Identifier("Identifiers", "Sample name or number", false),
        Property("Properties", "Quantification variable", false),
        Category("Categories", "Classification variable", false),
        Settings("Settings", true),
        AnalyseTree("Analyse Tree", "Segmentation or Descriptor", true),
        Descriptor("Descriptors", true),
        Limit("Limits", false),
        RecordGroups("Record Groups", false),
        ExternalTestGroups("External Record Test Groups", false);

        private final String name;
        private final boolean expand;
        private final String description;

        private BreezeListType(String string2, boolean bl) {
            this(string2, null, bl);
        }

        private BreezeListType(String string2, String string3, boolean bl) {
            this.name = string2;
            this.description = string3 != null ? string3 : this.toString();
            this.expand = bl;
        }

        public String getName(String string) {
            return string + String.valueOf((Object)this);
        }

        public String getNameWithDescription() {
            return this.name() + " (" + this.description + ")";
        }

        public double getWidthFactor() {
            if (this.equals((Object)AnalyseTree)) {
                return 0.6;
            }
            return 0.85;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public boolean isExpand() {
            return this.expand;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }
    }
}

