/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.record.measurement;

import java.util.ArrayList;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.realtime.descriptor.usgs.DepthRegistrationPanel;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.average.AverageSpectrumViewPanel;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.entry.EntryMeasurementPanel;
import se.prediktera.breeze.frontend.common.entry.comment.CommentOverviewPanel;
import se.prediktera.breeze.frontend.common.swing.notification.NotificationPanel;
import se.prediktera.breeze.frontend.common.view.MeasurementViewPanel;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.main.play.GraphOverviewPanel;
import se.prediktera.breeze.frontend.main.record.measurement.panel.MetaPanel;
import se.prediktera.breeze.frontend.main.record.measurement.panel.PixelExploreInterface;
import se.prediktera.breeze.frontend.main.record.measurement.panel.PixelExplorePanel;
import se.prediktera.breeze.frontend.main.record.measurement.panel.SpectralPanel;
import se.prediktera.breeze.frontend.main.record.panel.GroupMainPanel;
import se.prediktera.breeze.frontend.main.record.panel.PostProcessingRecordPanel;
import se.prediktera.map.register.RegInfo;

public class RecordMeasurementPanel
extends EntryMeasurementPanel {
    public RecordMeasurementPanel(BreezeProgress breezeProgress, GroupMainPanel groupMainPanel, Group group) {
        super(breezeProgress, groupMainPanel, BreezeType.Project, group.getName(), "Recorder", group);
        ArrayList<ViewClass> arrayList = new ArrayList<ViewClass>();
        Workflow workflow = group.getParent();
        this.measurementViewPanel = new MeasurementViewPanel(this, workflow);
        arrayList.add(new ViewClass("Table", this.measurementViewPanel));
        if (RegInfo.isGeoFeature() && workflow.getDepthRegistration()) {
            arrayList.add(new ViewClass("Depth Reg.", new DepthRegistrationPanel(this, workflow)));
        }
        arrayList.add(new ViewClass("Pixel Explore", new PixelExploreInterface.PixelExploreWithSamplesPanel(this, workflow, PixelExplorePanel.PixelExploreType.Normal)));
        arrayList.add(new ViewClass("Spectral Viewer", new AverageSpectrumViewPanel(this, workflow)));
        arrayList.add(new ViewClass("Analyse Tree", new GraphOverviewPanel(this, workflow)));
        arrayList.add(new ViewClass("References", new SpectralPanel(this)));
        arrayList.add(new ViewClass("Import / Export", new PostProcessingRecordPanel(this)));
        arrayList.add(new ViewClass("Metadata", new MetaPanel(this)));
        arrayList.add(new ViewClass("Comments", new CommentOverviewPanel(this)));
        arrayList.add(new ViewClass("Notifications", new NotificationPanel(this)));
        this.setLists(arrayList, group.getChildList(), "RecordSmall2");
    }

    @Override
    public Workflow getStudyContext() {
        return this.getGroup().getParent();
    }
}

