/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.record.measurement.panel;

import java.awt.Component;
import java.awt.Insets;
import java.util.List;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNodeList;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionHelper;
import se.prediktera.breeze.common.realtime.segmentation.spatial.ManualSegmentation;
import se.prediktera.breeze.common.realtime.unmixing.SelectMembersPanel;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;

public class AddSamplesPanel
extends AbstractBreezeCustomPanel.DefaultBreezeCustomPanel {
    private final Workflow workflow;
    private final BreezeComboBoxInputField<SegmentationNode> segmenationComboBox = new BreezeComboBoxInputField("Segmentation", "", BreezeInputFieldHelper.Format.TwoRows);
    private final BreezeComboBoxInputField<CatClass> classComboBox = new BreezeComboBoxInputField("Class", "", BreezeInputFieldHelper.Format.TwoRows);
    private final BreezeCheckBox addOnlyIncludedCheckBox = new BreezeCheckBox("Add only from included pixels", true);
    private final BreezeCheckBox mergeCheckBox = new BreezeCheckBox("Merge into one sample", false);

    public AddSamplesPanel(Workflow workflow) {
        this.workflow = workflow;
        List<SegmentationNode> list = AddSamplesPanel.getManualSegmentations(workflow);
        this.add((Component)new BreezeLabel("Add samples to" + (list.isEmpty() ? " a new manual segmentation" : "")), GridBagHelper.create(this.getComponentCount(), new Insets(24, 24, 0, 24)));
        this.segmenationComboBox.setRenderer(new BreezeTablePanel.FunctionCellRenderer());
        this.segmenationComboBox.setChangedListener(segmentationNode -> {
            ManualSegmentation manualSegmentation;
            CategoryFactor categoryFactor;
            this.classComboBox.removeAllItems();
            SegmentationNode segmentationNode2 = this.segmenationComboBox.getSelectedItem();
            if (segmentationNode2 != null && (categoryFactor = (manualSegmentation = (ManualSegmentation)segmentationNode2.getFunction()).getCategoryFactor(null)) != null) {
                this.classComboBox.addList(categoryFactor.getClasses());
                this.classComboBox.setSelectedItem(manualSegmentation.getCatClass());
            }
            this.classComboBox.setVisible(this.classComboBox.getItemCount() > 0);
        });
        this.segmenationComboBox.addList(list);
        if (this.segmenationComboBox.getItemCount() > 0) {
            this.add(this.segmenationComboBox, GridBagHelper.create(this.getComponentCount(), new Insets(24, 30, 0, 24)));
        }
        this.segmenationComboBox.setEnabled(this.segmenationComboBox.getItemCount() > 1);
        this.classComboBox.setRenderer(new SelectMembersPanel.CatClassListCellRenderer());
        this.classComboBox.setVisible(this.classComboBox.getItemCount() > 0);
        this.add(this.classComboBox, GridBagHelper.create(this.getComponentCount(), new Insets(24, 30, 0, 24)));
        this.addEndBlock();
        this.add((Component)this.addOnlyIncludedCheckBox, GridBagHelper.create(this.getComponentCount(), new Insets(24, 30, 0, 24)));
        this.add((Component)this.mergeCheckBox, GridBagHelper.create(this.getComponentCount(), new Insets(12, 30, 0, 24)));
    }

    @Override
    public Object getResult() {
        return null;
    }

    public SegmentationNode getOrCreateSegmentationNode() {
        SegmentationNode segmentationNode = this.segmenationComboBox.getSelectedItem();
        if (segmentationNode == null) {
            segmentationNode = (SegmentationNode)FunctionHelper.createNew(new ManualSegmentation.Info());
            segmentationNode.recreateSegmentationPorts(this.workflow);
            this.workflow.getRoot().addChild(segmentationNode);
            this.workflow.getVisualisationNode().setDefaultLevel(true);
            this.workflow.save();
        }
        return segmentationNode;
    }

    public boolean addOnlyIncuded() {
        return this.addOnlyIncludedCheckBox.isSelected();
    }

    public boolean merge() {
        return this.mergeCheckBox.isSelected();
    }

    public CatClass getCatClass() {
        return this.classComboBox.getSelectedItem();
    }

    protected static List<SegmentationNode> getManualSegmentations(Workflow workflow) {
        int n = workflow.getSegmentationLevel();
        SegmentationNodeList segmentationNodeList = workflow.getSegmentationNodes(n);
        List<SegmentationNode> list = segmentationNodeList.getManualSegmentations();
        if (list.isEmpty()) {
            for (int i = 0; i <= 2; ++i) {
                list.addAll(workflow.getSegmentationNodes(i).getManualSegmentations());
                if (list.size() <= 0) continue;
                workflow.getVisualisationNode().setDefaultLevel(true);
                workflow.save();
                break;
            }
        }
        return list;
    }
}

