/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.record.measurement.panel;

import java.util.ArrayList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionHelper;
import se.prediktera.breeze.common.realtime.segmentation.model.ModelSegmentation;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.main.record.measurement.panel.AddSamplesPanel;
import se.prediktera.breeze.test.stubs.MeasurementWithoutIO;

public class ExplorePanelTest {
    @Test
    public void testGetOrCreateManualSegmentationFirstLevel() {
        MeasurementWithoutIO measurementWithoutIO = new MeasurementWithoutIO();
        Workflow workflow = measurementWithoutIO.getWorkflow();
        SegmentationNode segmentationNode = new AddSamplesPanel(workflow).getOrCreateSegmentationNode();
        MatcherAssert.assertThat((Object)(segmentationNode != null ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.getSegmentationNodeCount(workflow), (Matcher)CoreMatchers.is((Object)1));
        SegmentationNode segmentationNode2 = new AddSamplesPanel(workflow).getOrCreateSegmentationNode();
        MatcherAssert.assertThat((Object)(segmentationNode2 != null ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.getSegmentationNodeCount(workflow), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testGetOrCreateManualSegmentationRootLevelWithManualSegmentation() {
        MeasurementWithoutIO measurementWithoutIO = new MeasurementWithoutIO();
        Workflow workflow = measurementWithoutIO.getWorkflow();
        SegmentationNode segmentationNode = new AddSamplesPanel(workflow).getOrCreateSegmentationNode();
        MatcherAssert.assertThat((Object)(segmentationNode != null ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.getSegmentationNodeCount(workflow), (Matcher)CoreMatchers.is((Object)1));
        workflow.getVisualisationNode().setSegmentationLevel(0);
        SegmentationNode segmentationNode2 = new AddSamplesPanel(workflow).getOrCreateSegmentationNode();
        MatcherAssert.assertThat((Object)(segmentationNode2 != null ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.getSegmentationNodeCount(workflow), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testGetOrCreateManualSegmentationSecondLevel() {
        MeasurementWithoutIO measurementWithoutIO = new MeasurementWithoutIO();
        Workflow workflow = measurementWithoutIO.getWorkflow();
        this.addModelSegmentation(workflow);
        MatcherAssert.assertThat((Object)this.getSegmentationNodeCount(workflow), (Matcher)CoreMatchers.is((Object)1));
        SegmentationNode segmentationNode = new AddSamplesPanel(workflow).getOrCreateSegmentationNode();
        MatcherAssert.assertThat((Object)(segmentationNode != null ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.getSegmentationNodeCount(workflow), (Matcher)CoreMatchers.is((Object)2));
        SegmentationNode segmentationNode2 = new AddSamplesPanel(workflow).getOrCreateSegmentationNode();
        MatcherAssert.assertThat((Object)(segmentationNode2 != null ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.getSegmentationNodeCount(workflow), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testGetOrCreateManualSegmentationFirstLevelWithModel() {
        MeasurementWithoutIO measurementWithoutIO = new MeasurementWithoutIO();
        Workflow workflow = measurementWithoutIO.getWorkflow();
        this.addModelSegmentation(workflow);
        MatcherAssert.assertThat((Object)this.getSegmentationNodeCount(workflow), (Matcher)CoreMatchers.is((Object)1));
        SegmentationNode segmentationNode = new AddSamplesPanel(workflow).getOrCreateSegmentationNode();
        MatcherAssert.assertThat((Object)(segmentationNode != null ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.getSegmentationNodeCount(workflow), (Matcher)CoreMatchers.is((Object)2));
        workflow.getVisualisationNode().setSegmentationLevel(0);
        SegmentationNode segmentationNode2 = new AddSamplesPanel(workflow).getOrCreateSegmentationNode();
        MatcherAssert.assertThat((Object)(segmentationNode2 != null ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.getSegmentationNodeCount(workflow), (Matcher)CoreMatchers.is((Object)2));
    }

    private int getSegmentationNodeCount(Workflow workflow) {
        ArrayList<SegmentationNode> arrayList = new ArrayList<SegmentationNode>();
        SegmentationNode.addSegmentationsRecursive(arrayList, workflow.getRoot());
        return arrayList.size();
    }

    private void addModelSegmentation(Workflow workflow) {
        SegmentationNode segmentationNode = (SegmentationNode)FunctionHelper.createNew(new ModelSegmentation.Info());
        segmentationNode.recreateSegmentationPorts(workflow);
        workflow.getRoot().addChild(segmentationNode);
        workflow.getVisualisationNode().setDefaultLevel(true);
    }
}

