/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.record.measurement.panel;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import se.prediktera.breeze.common.entry.ObjectWithChildrenAndParent;
import se.prediktera.breeze.common.entry.ThingWithName;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationIdentifier;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNodeList;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AdditionalFactor;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.workflow.BasicWorkflow;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.table.BreezeInteractionTable;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanelInterface;
import se.prediktera.breeze.frontend.common.swing.table.DefaultBreezeTableImpl;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailHelper;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailSample;

public class MeasurementTableModel
extends DefaultBreezeTableImpl {
    private BreezeInteractionTable interactionTable;
    private Workflow root;
    private SegmentationNodeList segmentationNodes;
    private Runnable tableUpdatedCallback;

    public MeasurementTableModel(BreezeInteractionTable breezeInteractionTable) {
        this.interactionTable = breezeInteractionTable;
    }

    public MeasurementTableModel(Workflow workflow) {
        this.root = workflow;
    }

    public MeasurementTableModel() {
    }

    public void setRoot(Workflow workflow) {
        this.root = workflow;
    }

    @Override
    public Vector createVOVector(Object object) {
        return MeasurementTableModel.createTableRowVector((Sample)object, this.addSegmentation());
    }

    private SegmentationNodeList addSegmentation() {
        if (this.segmentationNodes != null && this.segmentationNodes.size() > 1) {
            return this.segmentationNodes;
        }
        return null;
    }

    public static Vector<String> createTableRowVector(ArrayList<Sample> arrayList, TableSource tableSource, ArrayList<SegmentationIdentifier> arrayList2, boolean bl, DataCellSerializer dataCellSerializer) {
        boolean bl2 = true;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        Workflow workflow = null;
        for (Sample sample : arrayList) {
            SegmentationIdentifier segmentationIdentifier = arrayList2.get(n++);
            if (sample != null) {
                Measurement measurement = sample.measurement();
                Group group = measurement.getParent();
                workflow = group.getParent();
                if (bl2 || bl) {
                    vector.add(dataCellSerializer.toString(sample, sample));
                }
                if (bl2) {
                    vector.add(dataCellSerializer.toString(sample, group));
                    vector.add(dataCellSerializer.toString(sample, measurement));
                    for (ThingWithName thingWithName : workflow.getIdentifiers()) {
                        vector.add(dataCellSerializer.toString(sample, thingWithName));
                    }
                    for (ThingWithName thingWithName : workflow.getCategoryFactors()) {
                        vector.add(dataCellSerializer.toString(sample, thingWithName));
                    }
                    for (ThingWithName thingWithName : workflow.getPropertyFactors()) {
                        vector.add(dataCellSerializer.toString(sample, thingWithName));
                    }
                    bl2 = false;
                }
                MeasurementTableModel.addSerializedSampleDescriptors(vector, sample, tableSource, segmentationIdentifier, dataCellSerializer);
                continue;
            }
            int n2 = MeasurementTableModel.getDescriptorNodes(workflow, false, tableSource, segmentationIdentifier).size();
            ++n2;
            for (int i = 0; i < n2; ++i) {
                vector.add("");
            }
        }
        return vector;
    }

    public static Vector createTableRowVector(Sample sample, SegmentationNodeList segmentationNodeList) {
        ObjectWithChildrenAndParent<Workflow, Group> objectWithChildrenAndParent;
        Vector<Object> vector = new Vector<Object>();
        Measurement measurement = sample.measurement();
        Group group = measurement.getParent();
        vector.add(sample);
        vector.add(group);
        if (segmentationNodeList != null) {
            objectWithChildrenAndParent = segmentationNodeList.getSegmentation(sample.getSegmentationHashId());
            if (objectWithChildrenAndParent != null) {
                vector.add(objectWithChildrenAndParent);
            } else {
                vector.add("N/A");
            }
        }
        objectWithChildrenAndParent = group.getParent();
        int n = ((Workflow)objectWithChildrenAndParent).getSegmentationLevel();
        String string = ((Workflow)objectWithChildrenAndParent).getSegmentationHashId();
        vector.add((Object)new ThumbnailSample(measurement.getCustomImageFile(), measurement, sample));
        for (ThingWithName thingWithName : ((Workflow)objectWithChildrenAndParent).getIdentifiers()) {
            vector.add(thingWithName);
        }
        for (ThingWithName thingWithName : ((BasicWorkflow)((Object)objectWithChildrenAndParent)).getCategoryFactors()) {
            vector.add(thingWithName);
        }
        for (ThingWithName thingWithName : ((BasicWorkflow)((Object)objectWithChildrenAndParent)).getPropertyFactors()) {
            vector.add(thingWithName);
        }
        MeasurementTableModel.addSampleDescriptors(vector, sample, true, measurement, group, TableSource.Table, new SegmentationIdentifier(n, string));
        return vector;
    }

    public static Vector<String> addSerializedSampleDescriptors(Vector<String> vector, Sample sample, TableSource tableSource, SegmentationIdentifier segmentationIdentifier, DataCellSerializer dataCellSerializer) {
        Measurement measurement = sample.measurement();
        Group group = measurement.getParent();
        Workflow workflow = group.getParent();
        for (DescriptorTreeNode descriptorTreeNode : workflow.getSegmentationLevelDescriptorNodes(segmentationIdentifier, true)) {
            if (!MeasurementTableModel.showInTable(descriptorTreeNode, tableSource)) continue;
            FunctionResult functionResult = sample.getFunctionResult(descriptorTreeNode.getUid());
            AbstractBreezeFunction abstractBreezeFunction = descriptorTreeNode.getFunction();
            if (functionResult != null) {
                List<AdditionalFactor> list;
                if (abstractBreezeFunction.hasResult(descriptorTreeNode.getIndex())) {
                    vector.add(dataCellSerializer.toString(sample, functionResult));
                }
                if ((list = descriptorTreeNode.getAdditionalFactors()) == null || tableSource.equals((Object)TableSource.Export)) continue;
                for (AdditionalFactor additionalFactor : list) {
                    vector.add(dataCellSerializer.toString(sample, (Object)ThumbnailHelper.create(measurement, sample, descriptorTreeNode, additionalFactor, true, true)));
                }
                continue;
            }
            if (!abstractBreezeFunction.hasResult(descriptorTreeNode.getIndex())) continue;
            vector.add(dataCellSerializer.toString(sample, new FunctionResult(descriptorTreeNode, 0.0f)));
        }
        return vector;
    }

    public static Vector addSampleDescriptors(Vector vector, Sample sample, boolean bl, Measurement measurement, Group group, TableSource tableSource, SegmentationIdentifier segmentationIdentifier) {
        Workflow workflow = group.getParent();
        for (DescriptorTreeNode descriptorTreeNode : workflow.getSegmentationLevelDescriptorNodes(segmentationIdentifier, true)) {
            if (!MeasurementTableModel.showInTable(descriptorTreeNode, tableSource)) continue;
            FunctionResult functionResult = sample.getFunctionResult(descriptorTreeNode.getUid());
            AbstractBreezeFunction abstractBreezeFunction = descriptorTreeNode.getFunction();
            if (functionResult != null) {
                List<AdditionalFactor> list;
                if (bl && abstractBreezeFunction.hasThumbnail(descriptorTreeNode.getIndex())) {
                    vector.add(ThumbnailHelper.create(measurement, sample, descriptorTreeNode));
                }
                if (abstractBreezeFunction.hasResult(descriptorTreeNode.getIndex())) {
                    vector.add(functionResult);
                }
                if ((list = descriptorTreeNode.getAdditionalFactors()) == null) continue;
                for (AdditionalFactor additionalFactor : list) {
                    vector.add(ThumbnailHelper.create(measurement, sample, descriptorTreeNode, additionalFactor, true, true));
                }
                continue;
            }
            if (!abstractBreezeFunction.hasResult(descriptorTreeNode.getIndex())) continue;
            vector.add(new FunctionResult(descriptorTreeNode, 0.0f));
        }
        return vector;
    }

    @Override
    public List<Object> getTableHeader(List list) {
        if (this.interactionTable != null) {
            this.root = this.interactionTable.getRoot();
        }
        if (this.root != null) {
            this.segmentationNodes = this.root.getSegmentationNodes();
            return MeasurementTableModel.getTableHeaderList(this.root, this.addSegmentation() != null, true, TableSource.Table);
        }
        return new ArrayList<Object>();
    }

    public void setTableUpdatedCallback(Runnable runnable) {
        this.tableUpdatedCallback = runnable;
    }

    @Override
    public void tableUpdated(BreezeTable breezeTable) {
        if (this.tableUpdatedCallback != null) {
            this.tableUpdatedCallback.run();
        }
    }

    public static List<Object> getTableHeaderList(Workflow workflow, boolean bl, boolean bl2, TableSource tableSource) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : MeasurementTableModel.collectTableHeader(workflow, bl, bl2, tableSource, new SegmentationIdentifier(workflow.getSegmentationLevel(), workflow.getSegmentationHashId()))) {
            arrayList.add(MeasurementTableModel.getHeaderInfo(object));
        }
        return arrayList;
    }

    public static boolean showInTable(DescriptorTreeNode descriptorTreeNode, TableSource tableSource) {
        if (tableSource.equals((Object)TableSource.Table) && !descriptorTreeNode.getFunction().showInTable()) {
            return false;
        }
        return descriptorTreeNode.isEnabled() && !descriptorTreeNode.isHieararchyConnectionDescriptor();
    }

    private static BreezeTablePanelInterface.HeaderInfo getHeaderInfo(Object object) {
        BreezeTablePanelInterface.HeaderInfo headerInfo = new BreezeTablePanelInterface.HeaderInfo();
        if (object instanceof DescriptorTreeNode) {
            DescriptorTreeNode descriptorTreeNode = (DescriptorTreeNode)object;
            headerInfo.name = descriptorTreeNode.getAliasOrNodeString(FunctionTreeNode.TextType.Table);
            headerInfo.color = BreezeTheme.getInstance().getDescriptorColor();
        } else if (object instanceof DescriptorThumbnail) {
            DescriptorThumbnail descriptorThumbnail = (DescriptorThumbnail)object;
            headerInfo.name = descriptorThumbnail.node.getAliasOrNodeString(FunctionTreeNode.TextType.TableThumbnail);
            headerInfo.color = BreezeTheme.getInstance().getDescriptorColor();
        } else if (object instanceof AdditionalFactor) {
            AdditionalFactor additionalFactor = (AdditionalFactor)object;
            headerInfo.name = additionalFactor.getName();
            headerInfo.color = BreezeTheme.getInstance().getDescriptorColor();
        } else if (object instanceof Factor) {
            Factor factor = (Factor)object;
            headerInfo.name = factor.getName();
        } else {
            headerInfo.name = object.toString();
        }
        return headerInfo;
    }

    public static List<Object> collectCsvTableHeader(Workflow workflow, TableSource tableSource, ArrayList<SegmentationIdentifier> arrayList, boolean bl) {
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        boolean bl2 = true;
        for (SegmentationIdentifier segmentationIdentifier : arrayList) {
            if (bl || bl2) {
                arrayList2.add("Sample");
            }
            if (bl2) {
                arrayList2.add("Group");
                arrayList2.add("Measurement");
                for (ThingWithName thingWithName : workflow.getIdentifiers()) {
                    arrayList2.add(thingWithName);
                }
                for (ThingWithName thingWithName : workflow.getCategoryFactors()) {
                    arrayList2.add(thingWithName);
                }
                for (ThingWithName thingWithName : workflow.getPropertyFactors()) {
                    arrayList2.add(thingWithName);
                }
                bl2 = false;
            }
            arrayList2.addAll(MeasurementTableModel.getDescriptorNodes(workflow, false, tableSource, segmentationIdentifier));
        }
        return arrayList2;
    }

    public static List<Object> collectTableHeader(Workflow workflow, boolean bl, boolean bl2, TableSource tableSource, SegmentationIdentifier segmentationIdentifier) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add("Sample");
        arrayList.add("Group");
        if (bl) {
            arrayList.add("Segmentation");
        }
        if (bl2) {
            arrayList.add("Image");
        } else {
            arrayList.add("Measurement");
        }
        for (ThingWithName thingWithName : workflow.getIdentifiers()) {
            arrayList.add(thingWithName);
        }
        for (ThingWithName thingWithName : workflow.getCategoryFactors()) {
            arrayList.add(thingWithName);
        }
        for (ThingWithName thingWithName : workflow.getPropertyFactors()) {
            arrayList.add(thingWithName);
        }
        arrayList.addAll(MeasurementTableModel.getDescriptorNodes(workflow, bl2, tableSource, segmentationIdentifier));
        return arrayList;
    }

    public static List<Object> getDescriptorNodes(Workflow workflow, boolean bl, TableSource tableSource, SegmentationIdentifier segmentationIdentifier) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (DescriptorTreeNode descriptorTreeNode : workflow.getSegmentationLevelDescriptorNodes(segmentationIdentifier, true)) {
            List<AdditionalFactor> list;
            if (!MeasurementTableModel.showInTable(descriptorTreeNode, tableSource)) continue;
            AbstractBreezeFunction abstractBreezeFunction = descriptorTreeNode.getFunction();
            if (bl && abstractBreezeFunction.hasThumbnail(descriptorTreeNode.getIndex())) {
                arrayList.add(new DescriptorThumbnail(descriptorTreeNode));
            }
            if (abstractBreezeFunction.hasResult(descriptorTreeNode.getIndex())) {
                arrayList.add(descriptorTreeNode);
            }
            if ((list = descriptorTreeNode.getAdditionalFactors()) == null || tableSource.equals((Object)TableSource.Export)) continue;
            for (AdditionalFactor additionalFactor : list) {
                arrayList.add(additionalFactor);
            }
        }
        return arrayList;
    }

    public static interface DataCellSerializer {
        public String toString(Sample var1, Object var2);
    }

    public static enum TableSource {
        Table,
        Export;

    }

    private static class DescriptorThumbnail {
        public DescriptorTreeNode node;

        public DescriptorThumbnail(DescriptorTreeNode descriptorTreeNode) {
            this.node = descriptorTreeNode;
        }
    }
}

