/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.record.measurement.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JPanel;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.raw.RtReferenceTarget;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.FieldOfView;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.LengthValue;
import se.prediktera.breeze.common.util.type.Resolution;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.measurement.metadata.MetaDataProperties;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeFieldInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.swing.information.InformationFormat;
import se.prediktera.breeze.frontend.common.swing.information.InformationGroups;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.main.record.measurement.panel.MetaInterface;
import se.prediktera.breeze.frontend.main.record.measurement.panel.SpectralPanel;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.common.update.UpdateHelper;

public class MetaPanel
extends AbstractViewPanel {
    private final InformationPanel informationPanel = new InformationPanel(null, true);
    private final List<InformationPanel> informationCameraPanels = new ArrayList<InformationPanel>();
    private final BreezeButton editButton;
    private final BreezeButton copyButton;
    private final BreezeButton reflectanceTargetButton;
    private final BreezeButton bandNamesButton;

    public MetaPanel(final EntryMainPanel entryMainPanel) {
        super(entryMainPanel);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(BreezeTheme.getInstance().getPanelBackground());
        jPanel.add((Component)new BreezeLabel.BreezeLabelHeader("Metadata"), GridBagHelper.create(jPanel.getComponentCount(), new Insets(0, 0, 0, 0)));
        jPanel.add((Component)this.informationPanel, GridBagHelper.create(jPanel.getComponentCount(), new Insets(0, 0, 0, 0)));
        for (int i = 0; i < HardwareRegistry.MaxSupportedCameras; ++i) {
            InformationPanel informationPanel = new InformationPanel("Camera " + (i + 1), true);
            jPanel.add((Component)informationPanel, GridBagHelper.create(jPanel.getComponentCount(), new Insets(10, 0, 0, 0)));
            this.informationCameraPanels.add(informationPanel);
        }
        jPanel.add((Component)new BreezeLabel(""), GridBagHelper.createLast(jPanel.getComponentCount(), new Insets(0, 0, 0, 0)));
        BreezeScrollPane breezeScrollPane = new BreezeScrollPane(jPanel);
        breezeScrollPane.setHorizontalScrollBarPolicy(31);
        this.add(breezeScrollPane, "Center");
        this.editButton = EntryMainHelper.createButton("Edit metadata", "explore/edit", () -> {
            final List<Measurement> list = Measurement.getMeasurements(entryMainPanel.getSelectedEntries());
            if (!list.isEmpty()) {
                BreezeOptionDialog.showDialog(entryMainPanel.getFrame(), entryMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Edit metadata", "", (AbstractBreezeCustomPanel)new UpdateMetaDataPanel(list), null, breezeActionEvent -> BreezeProgressDialog.startProgressWithCancel(entryMainPanel.getFrame(), new ProgressAction(this){

                    @Override
                    public void runAction() throws Exception {
                        ((UpdateMetaDataPanel)breezeActionEvent.getBreezeCustomPanel()).update(list);
                        entryMainPanel.setDirty(true);
                    }
                }, "Updating"));
            }
        });
        this.copyButton = EntryMainHelper.createButton("copyMetadata", "Copy to clipboard", "material/content_paste", () -> {
            Measurement measurement = (Measurement)entryMainPanel.getSelectedEntry();
            if (measurement != null) {
                StringBuilder stringBuilder = new StringBuilder();
                this.informationPanel.addValues(stringBuilder);
                for (int i = 0; i < this.informationCameraPanels.size(); ++i) {
                    this.informationCameraPanels.get(i).addValues(stringBuilder);
                }
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(stringBuilder.toString()), new StringSelection(stringBuilder.toString()));
            }
        });
        this.reflectanceTargetButton = SpectralPanel.createReflectanceTargetButton(entryMainPanel);
        this.bandNamesButton = EntryMainHelper.createButton("Import band names", "material/file_open", () -> {
            List<Measurement> list = Measurement.getMeasurements(entryMainPanel.getSelectedEntries());
            if (!list.isEmpty()) {
                jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Select band names file", (Component)this.getFrame());
                jopensaveDialog2.addExtension("hdr", "Envi header file");
                jopensaveDialog2.setCurrentDirectory(WorkspaceManager.getInstance().getWorkspace().getPath().toFile());
                if (jopensaveDialog2.openshow()) {
                    BandNames bandNames = new RawHeader(jopensaveDialog2.getSelectedFile()).bandNames();
                    for (Measurement measurement : list) {
                        MetaPanel.updateBandNames(bandNames, measurement.rawFile());
                        MetaPanel.updateBandNames(bandNames, measurement.darkReference());
                        MetaPanel.updateBandNames(bandNames, measurement.whiteReference());
                        DataSetCache.clear(measurement);
                    }
                }
            }
        });
    }

    private static void updateBandNames(BandNames bandNames, RawFile rawFile) {
        if (rawFile != null && !rawFile.isEmpty()) {
            RawHeader rawHeader = rawFile.header();
            rawHeader.setBandNames(bandNames);
            rawHeader.save();
        }
    }

    @Override
    public void addComponent(BreezeMainPanel breezeMainPanel) {
        breezeMainPanel.addRightButton(this.editButton);
        breezeMainPanel.addRightButton(this.copyButton);
        breezeMainPanel.addRightButton(new BreezeSeparator.Vertical());
        breezeMainPanel.addRightButton(this.reflectanceTargetButton);
        breezeMainPanel.addRightButton(new BreezeSeparator.Vertical());
        breezeMainPanel.addRightButton(this.bandNamesButton);
    }

    @Override
    public String getType() {
        return "MetaOverview";
    }

    @Override
    public void showEntry(Object object, Object object2) {
        if (object instanceof MetaInterface) {
            MetaInterface metaInterface = (MetaInterface)object;
            this.informationPanel.setInformationShowIfHasItems(MetaPanel.createList(metaInterface, ""));
            for (int i = 0; i < this.informationCameraPanels.size(); ++i) {
                this.informationCameraPanels.get(i).setInformationShowIfHasItems(MetaPanel.createList(metaInterface, "Camera" + (i + 1)));
            }
        }
    }

    private static InformationPanel.InformationList createList(MetaInterface metaInterface, String string) {
        Object object2;
        Object object;
        InformationPanel.InformationList informationList = new InformationPanel.InformationList(metaInterface);
        if (string.isEmpty() && UpdateHelper.Product.isRunningProductBreeze()) {
            informationList.add("CreatedBy", "N/A");
        }
        for (String object42 : metaInterface.getSortedMetadataKeys()) {
            if (object42.equals("Time")) continue;
            object = object42;
            if (object42.startsWith("Camera")) {
                if (string.isEmpty() || !object42.startsWith(string)) continue;
                object = ((String)object).substring("CameraX".length());
            } else if (!string.isEmpty() || object42.equals("HistogramRange") || object42.contains("ExcludeWavelengths")) continue;
            informationList.add((String)object, metaInterface.getMetaValue(object42));
        }
        if (string.isEmpty() && metaInterface instanceof Measurement) {
            Object object3;
            object2 = (Measurement)metaInterface;
            RawFile rawFile = ((Measurement)object2).rawFile();
            informationList.add("CreatedDate", ((Measurement)object2).getEntryData().getViewCreatedDate());
            object = ((Measurement)object2).getEntryData().getViewModifiedDate();
            if (!((String)object).equals("NA")) {
                informationList.add("ModifiedDate", (String)object);
            }
            informationList.add("MeasurementId", ((Measurement)object2).getEntryData().getUid());
            SpectralReference.WhiteReference whiteReference = ((Measurement)object2).whiteReference();
            if (whiteReference != null && !whiteReference.isEmpty()) {
                String string2;
                object3 = whiteReference.header();
                RtReferenceTarget rtReferenceTarget = ((RawHeader)object3).getReferenceTarget();
                if (rtReferenceTarget != null && (string2 = rtReferenceTarget.getAverage()) != null) {
                    informationList.add("ReflectanceTargetValue", string2);
                }
                MetaPanel.addReferenceMetaData(informationList, (RawHeader)object3, "White");
            }
            if ((object3 = ((Measurement)object2).darkReference()) != null && !object3.isEmpty()) {
                MetaPanel.addReferenceMetaData(informationList, ((SpectralReference)object3).header(), "Dark");
            }
            long l = 0L;
            if (rawFile != null) {
                RawHeader rawHeader = rawFile.header();
                RawHeader.DescriptionData descriptionData = rawHeader.getDescriptionData();
                if (descriptionData != null) {
                    if (descriptionData.temperature != null) {
                        informationList.add("Temperature", descriptionData.temperature.toString());
                    }
                    if (descriptionData.origFile != null) {
                        informationList.add("OrigFile", descriptionData.origFile.getAbsolutePath());
                    }
                }
                l = rawFile.file().length();
            }
            informationList.add("FileSize", UpdateHelper.formatSize((long)l));
        }
        object2 = InformationGroups.getInstance();
        HashSet<InformationGroups.InformationGroup> hashSet = new HashSet<InformationGroups.InformationGroup>();
        for (String string3 : informationList.getOrderedKeys()) {
            hashSet.add(((InformationGroups)object2).get(string3));
        }
        for (InformationGroups.InformationGroup informationGroup : hashSet) {
            informationList.add("_Group#" + informationGroup.name(), "");
        }
        informationList.sortKeys();
        return informationList;
    }

    private static void addReferenceMetaData(InformationPanel.InformationList informationList, RawHeader rawHeader, String string) {
        RawHeader.DescriptionData descriptionData = rawHeader.getDescriptionData();
        if (descriptionData != null) {
            if (descriptionData.temperature != null) {
                informationList.add(string + "Temperature", descriptionData.temperature.toString());
            }
            if (descriptionData.origFile != null) {
                informationList.add(string + "OrigFile", descriptionData.origFile.getAbsolutePath());
            }
            if (descriptionData.integrationTime != null) {
                informationList.add(string + "IntegrationTime", descriptionData.integrationTime.value);
            }
            if (descriptionData.date != null) {
                informationList.add(string + "Date", descriptionData.date);
            }
        }
    }

    public class UpdateMetaDataPanel
    extends AbstractBreezeCustomPanel.DefaultBreezeCustomPanel {
        private final BreezeComboBoxInputField<String> maxSignalInputField = new BreezeComboBoxInputField("Max signal", " ", BreezeInputFieldHelper.Format.TwoRows);
        private final BreezeInputField.Number fieldOfViewInputField = new BreezeInputField.Number("Field of view", "", 0.0, "mm");
        private final BreezeInputField.Number integrationTimeInputField = new BreezeInputField.Number("Integration time", "", 0.0, "\u00b5s");

        public UpdateMetaDataPanel(List<Measurement> list) {
            GridBagConstraints gridBagConstraints = GridBagHelper.create(0, this.getComponentCount(), 1.0, 1.0, 2, new Insets(24, 12, 0, 12));
            gridBagConstraints.anchor = 18;
            this.add((Component)new BreezeLabel("Edit metadata on (" + list.size() + ") measurements"), gridBagConstraints);
            Measurement measurement = list.get(0);
            this.fieldOfViewInputField.setUnit(measurement.getSampleMoverType().getUnit());
            MetaDataProperties metaDataProperties = measurement.getMetaProperties();
            this.maxSignalInputField.setEditable(true);
            for (String string : new String[]{"", "1", "255", "4095", "16383", "65535"}) {
                this.maxSignalInputField.addItem(string);
            }
            this.addField(metaDataProperties, this.maxSignalInputField, "MaxSignal");
            this.addField(metaDataProperties, this.fieldOfViewInputField, "FieldOfView");
            this.addField(metaDataProperties, this.integrationTimeInputField, "IntegrationTime");
            this.addEndBlock();
            this.setPreferredSize(new Dimension(600, 500));
        }

        private void addField(MetaDataProperties metaDataProperties, BreezeFieldInterface breezeFieldInterface, String string) {
            breezeFieldInterface.setLabelWidth(150);
            breezeFieldInterface.setUnitLabelWidth(50);
            breezeFieldInterface.setValue(new InformationFormat.FormatText("").format(metaDataProperties.getMetaValue(string, "")));
            this.add((Component)((Object)breezeFieldInterface), GridBagHelper.create(this.getComponentCount(), new Insets(12, 30, 0, 24)));
        }

        @Override
        public boolean usePreferredSize() {
            return true;
        }

        @Override
        public Object getResult() {
            return null;
        }

        public void update(List<Measurement> list) {
            for (Measurement measurement : list) {
                MetaDataProperties metaDataProperties = measurement.getMetaProperties();
                if (this.maxSignalInputField.hasValue()) {
                    metaDataProperties.addProperty("MaxSignal", this.maxSignalInputField.getValue());
                }
                if (this.fieldOfViewInputField.hasValue()) {
                    float f = this.fieldOfViewInputField.getNumberFloat();
                    metaDataProperties.addProperty("FieldOfView", String.valueOf(f));
                    RawFile rawFile = measurement.rawFile();
                    if (rawFile != null) {
                        RawHeader rawHeader = rawFile.header();
                        Resolution resolution = new Resolution(new FieldOfView(f), rawHeader.pixelWidth());
                        metaDataProperties.addProperty("Resolution", String.valueOf(resolution.value));
                        metaDataProperties.addProperty("Length", String.valueOf(new LengthValue((Resolution)resolution, (FrameCount)rawHeader.frameCount()).value));
                    }
                }
                if (this.integrationTimeInputField.hasValue()) {
                    metaDataProperties.addProperty("IntegrationTime", this.integrationTimeInputField.getValue());
                }
                measurement.save();
            }
        }
    }
}

