/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.record.measurement.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.jblas.FloatMatrix;
import se.prediktera.breeze.backend.measure.applychanges.ApplyChanges;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AdditionalFactor;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.realtime.RtModule;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TransformationParameter;
import se.prediktera.breeze.common.realtime.segmentation.SegmentationMatrix;
import se.prediktera.breeze.common.realtime.unmixing.GaussianResampler;
import se.prediktera.breeze.common.realtime.unmixing.MembersSetting;
import se.prediktera.breeze.common.realtime.unmixing.Reference;
import se.prediktera.breeze.common.realtime.unmixing.SelectMembersPanel;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.image.RtObjectIdentificationHelper;
import se.prediktera.breeze.common.util.image.RtPixel2D;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.entry.analyse.model.CommonModelSettings;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SampleHelper;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.data.DataTemplatesHelper;
import se.prediktera.breeze.evince.matrix.FrameMatrix;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanelInterface;
import se.prediktera.breeze.frontend.common.entry.EntryMeasurementPanel;
import se.prediktera.breeze.frontend.common.pp.DefaultSettingsPanel;
import se.prediktera.breeze.frontend.common.pp.PPEntryMainInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.BreezeTextField;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.BreezeToggleButton;
import se.prediktera.breeze.frontend.common.swing.DeleteCatClassInputField;
import se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.common.view.ViewPanelCustomPanel;
import se.prediktera.breeze.frontend.common.view.preview.VisualisationToolbar;
import se.prediktera.breeze.frontend.common.view.visualization.PlotViewPanel;
import se.prediktera.breeze.frontend.main.play.edit.FunctionParameterCustomInput;
import se.prediktera.breeze.frontend.main.record.measurement.panel.AddSamplesPanel;
import se.prediktera.breeze.frontend.main.record.measurement.panel.PixelExplorePanel;
import se.prediktera.breeze.frontend.wizard.model.panel.ModelButtonHelper;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.LayerMatrix;
import se.prediktera.map.main.Plot_GUI;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.main.script.ScriptHelper;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.map.plot.PlotInit;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;
import se.prediktera.map.plot.axisplot.plot2D.quickspectral.FloatWindowQuickSpectral;
import se.prediktera.map.plot.axisplot.plot2D.quickspectral.QuickSpectralLayer;
import se.prediktera.map.plot.axisplot.plot2D.serie.histogram.bucket.BucketDataClass;
import se.prediktera.map.plot.axisplot.settings.AbstractPlotSettingsBox;
import se.prediktera.map.plot.axisplot.settings.Color.ColorAdvanceFrame;
import se.prediktera.map.plot.axisplot.windows.FloatMainWindow;
import se.prediktera.map.plot.axisplot.windows.LegendWindow;
import se.prediktera.map.plot.layout.AbstractPlotLayout;
import se.prediktera.map.register.RegInfo;

public interface PixelExploreInterface {
    public Measurement getMeasurement();

    public List<RtModule> getTransformationModules();

    public static void addIncludeExcludeToMenu(PlotViewPanel plotViewPanel, BreezeContextMenu breezeContextMenu) {
        breezeContextMenu.addButtonCloseClick("Include", () -> ModelButtonHelper.setTrainTestScatter(plotViewPanel.getMainPanel(), plotViewPanel, true, false));
        breezeContextMenu.addButtonCloseClick("Include Only", () -> ModelButtonHelper.setTrainTestScatter(plotViewPanel.getMainPanel(), plotViewPanel, true, true));
        breezeContextMenu.addButtonCloseClick("Exclude", () -> ModelButtonHelper.setTrainTestScatter(plotViewPanel.getMainPanel(), plotViewPanel, false, false));
        breezeContextMenu.addSeparator();
    }

    private static void addLayerButton(PlotViewPanel plotViewPanel, AbstractPlotLayout abstractPlotLayout) {
        BreezeToggleButton breezeToggleButton = VisualisationToolbar.createButton("", "material/layers", "Show background layer", true, bl -> {
            FloatMainWindow floatMainWindow = abstractPlotLayout.getMainWindow();
            if (floatMainWindow instanceof AbstractAxisPlot) {
                AbstractAxisPlot abstractAxisPlot = (AbstractAxisPlot)floatMainWindow;
                abstractAxisPlot.getLayer(Double.valueOf(abstractAxisPlot.getLayerCount())).setLayerVisible(bl);
                abstractAxisPlot.contentPaint((byte)7);
            }
        });
        breezeToggleButton.setPreferredSize(new Dimension(20, 20));
        plotViewPanel.addToolbarComponent(breezeToggleButton);
    }

    public static class PixelExploreDialogPanel
    extends PixelExplorePanel {
        public PixelExploreDialogPanel(BreezeMainPanel breezeMainPanel, Workflow workflow, Measurement measurement, PixelExplorePanel.PixelExploreType pixelExploreType) {
            super(breezeMainPanel, workflow, measurement, pixelExploreType);
        }
    }

    public static class ModelSectionPanel {
        private final BreezeMainPanel mainpanel;
        private final PixelExplorePanel explorePanel;
        private final Workflow workflow;
        private final DefaultSettingsPanel.SectionPanel modelSection;

        public ModelSectionPanel(BreezeMainPanel breezeMainPanel, PixelExplorePanel pixelExplorePanel, Workflow workflow) {
            this.mainpanel = breezeMainPanel;
            this.explorePanel = pixelExplorePanel;
            this.workflow = workflow;
            this.modelSection = pixelExplorePanel.getRightSettingsPanel(null).addSection("Model (PCA)");
            this.updateSection();
        }

        private void updateSection() {
            this.modelSection.clear();
            if (this.workflow.getModellingExplorePixel()) {
                this.modelSection.addComponent(EntryMainHelper.createButton("Statistics", "explore/stacked_line_chart", () -> BreezeOptionDialog.showDialog(this.mainpanel.getFrame(), this.mainpanel.getPageColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Statistics", "", (AbstractBreezeCustomPanel)new ViewPanelCustomPanel(new PcaModelStatisticsViewContainer(this.mainpanel, "model_p"), this.explorePanel.measurement, 0.85), null, null)));
                this.modelSection.addComponentLast(EntryMainHelper.createButton("Remove", "explore/delete", () -> this.enableModel(false)));
            } else {
                this.modelSection.addComponentLast(EntryMainHelper.createButton("Create", "explore/add", () -> this.enableModel(true)));
            }
            this.modelSection.revalidate();
            this.modelSection.repaint();
        }

        private void enableModel(boolean bl) {
            this.workflow.setModellingExplorePixel(bl);
            this.workflow.save();
            this.updateSection();
            this.explorePanel.reloadEntry();
        }

        public static class PcaModelStatisticsViewContainer
        extends ViewContainer {
            private Object entrydata = null;

            public PcaModelStatisticsViewContainer(BreezeMainPanel breezeMainPanel, String string) {
                super(breezeMainPanel, false);
                this.addViewPanel((Component)((Object)new PlotViewPanel(breezeMainPanel, "Loadings", "LineStacked", string){

                    @Override
                    public boolean hasInteraction(boolean bl) {
                        return true;
                    }

                    @Override
                    public Properties createProperties() {
                        Properties properties = super.createProperties();
                        properties.put("direction", "rows");
                        return properties;
                    }

                    @Override
                    public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
                        Properties properties = new Properties();
                        properties.put("width", "4");
                        properties.put("colorscheme", "hsv");
                        abstractPlotLayout.setColor(new Object[]{"vector", properties});
                        abstractPlotLayout.setLine(new Object[]{"vector", properties});
                        LegendWindow legendWindow = abstractPlotLayout.addLegend(new Object[]{"color", "right", new ScriptHelper.ScriptProperties(new ScriptHelper.Property[]{new ScriptHelper.Property("title", "Component")})});
                        legendWindow.setDimension(Double.valueOf(10.0), Double.valueOf(88.8));
                        legendWindow.setPosition(Double.valueOf(100.0), Double.valueOf(0.0));
                    }

                    @Override
                    protected boolean supportChange() {
                        return false;
                    }
                }), 0, 0, 1, 1);
            }

            @Override
            public boolean showLeftSettingsPanel() {
                return false;
            }

            @Override
            public boolean showRightSettingsPanel() {
                return false;
            }

            @Override
            public void setData(boolean bl) {
                super.showEntry(this.entrydata, null);
            }

            @Override
            public void showEntry(Object object, Object object2) {
                super.showEntry(object, object2);
                this.entrydata = object;
            }
        }
    }

    public static class ImagePlotViewPanel
    extends PlotViewPanel {
        private final Workflow workflow;
        private final int bands;
        private final PlotViewPanel referencePlot;

        public ImagePlotViewPanel(PPEntryMainInterface pPEntryMainInterface, Workflow workflow, int n, PlotViewPanel plotViewPanel) {
            String[] stringArray;
            String string = n == 3 ? "Pseudo RGB image" : "Single band";
            if (n == 3) {
                String[] stringArray2 = new String[4];
                stringArray2[0] = "origmatrix";
                stringArray2[1] = "xtraining";
                stringArray2[2] = "xtraining";
                stringArray = stringArray2;
                stringArray2[3] = "xtraining";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "origmatrix";
                stringArray = stringArray3;
                stringArray3[1] = "xtraining";
            }
            super(pPEntryMainInterface, string, "Contour2D", stringArray);
            this.workflow = workflow;
            this.bands = n;
            this.referencePlot = plotViewPanel;
        }

        public ImagePlotViewPanel(PPEntryMainInterface pPEntryMainInterface, Workflow workflow, String string) {
            super(pPEntryMainInterface, "Title", string);
            this.workflow = workflow;
            this.bands = 1;
            this.referencePlot = null;
        }

        @Override
        public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
            super.plotSetup(abstractPlotLayout);
            if (this.bands == 1) {
                LegendWindow legendWindow = abstractPlotLayout.addLegend(new Object[]{"color", "right", new Properties()});
                legendWindow.setRelativeSize(0.15, 0.8);
                legendWindow.setRelativePosition(0.85, 0.1);
                legendWindow.setTitleNoAutoText("Intensity");
                legendWindow.setDescription("");
                legendWindow.syPercent = 0.05;
                legendWindow.shPercent = 0.9;
            }
            PixelExploreInterface.addLayerButton(this, abstractPlotLayout);
        }

        @Override
        public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
            Object object;
            Case case_ = abstractPlotLayout.getPlotInit().getMatrix(0).getCase();
            if (case_ == null || case_.getOriginalMatrix() == null) {
                return;
            }
            if (this.bands == 1 && !((ColorAdvanceFrame)abstractPlotLayout.getLayer(Double.valueOf(1.0)).getComboBox((byte)3).getAdvanceSettings()).hasAutoScale()) {
                return;
            }
            LayerMatrix layerMatrix = (LayerMatrix)case_.getOriginalMatrix();
            int[] nArray = layerMatrix.getDefaultBand();
            boolean bl = this.bands == 3;
            String string = String.valueOf(bl && abstractPlotLayout.isAbsorbanceData());
            boolean bl2 = this.workflow.getImageHistogramEnable() && this.workflow.getImageHistogramMinBands() > this.bands;
            boolean bl3 = bl2 && this.workflow.getImageHistogramStrechAll();
            boolean bl4 = this.workflow.getImageHistogramNormalizeMin();
            String[] stringArray = null;
            if (!bl3) {
                MaxSignal maxSignal = this.workflow.getMaxSignalForVisualizationOrNull(case_.getConvertTo());
                if (bl2) {
                    stringArray = this.bucket(breezeProgressManager, layerMatrix, string, nArray[0]);
                } else if (maxSignal != null) {
                    stringArray = new String[]{"0", RtDataFormat.toString(maxSignal.value)};
                }
            }
            for (int i = 0; i < this.bands; ++i) {
                object = abstractPlotLayout.getLayer(Double.valueOf((double)i + 1.0));
                PlotInit plotInit = object.getPlotInit();
                Properties properties = new Properties();
                if (bl) {
                    plotInit.ccolorindex = Plot_GUI.getCsh().getRgbIndex(i);
                    object.setLayerName(Plot_GUI.RGB_NAMES[i]);
                    properties.setProperty("colorscheme", Plot_GUI.RGB_NAMES[i]);
                } else {
                    object.setLayerName("Band");
                }
                properties.put("forcereflectance", string);
                if (bl3) {
                    stringArray = this.bucket(breezeProgressManager, layerMatrix, string, nArray[i]);
                }
                if (stringArray != null) {
                    properties.put("min", bl4 ? stringArray[0] : "0");
                    properties.put("max", stringArray[1]);
                }
                object.setColor(new Object[]{"amplitude", properties});
                object.setDataRange(new Object[]{"range", "matrix", (double)this.getBand((AbstractAxisLayer)object, nArray[i] + 1), properties});
            }
            AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(1.0 + (double)this.bands));
            object = new Properties();
            ((Properties)object).setProperty("colorscheme", "gray");
            ((Properties)object).put("forcereflectance", string);
            abstractAxisLayer.setColor(new Object[]{"amplitude", object});
        }

        private String[] bucket(BreezeProgressManager breezeProgressManager, LayerMatrix layerMatrix, String string, int n) {
            Properties properties = new Properties();
            properties.put("buckets", "200");
            properties.put("forcereflectance", string);
            properties.put("percent", String.valueOf((int)(this.workflow.getImageHistogramPerctage() * 100.0)));
            BucketDataClass bucketDataClass = (BucketDataClass)EvinceScriptCommands.apply((ProgressManager)breezeProgressManager, (Object[])new Object[]{"bucket", layerMatrix.getMatrixAt(n), properties});
            return new String[]{bucketDataClass.get("minvalue", properties).toString(), bucketDataClass.get("maxvalue", properties).toString()};
        }

        @Override
        public void addCustomMenuItems(AbstractPlotLayout abstractPlotLayout, BreezeContextMenu breezeContextMenu) {
            if (this.referencePlot != null) {
                PixelExploreInterface.addIncludeExcludeToMenu(this.referencePlot, breezeContextMenu);
            }
            if (this.bands == 1) {
                breezeContextMenu.addButtonCloseClick("Set max", () -> {
                    ColorAdvanceFrame colorAdvanceFrame = (ColorAdvanceFrame)abstractPlotLayout.getLayer(Double.valueOf(1.0)).getComboBox((byte)3).getAdvanceSettings();
                    BreezeOptionDialog.showDialog(this.getFrame(), BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.INPUT_OPTION, "Set max", "Set max value", RtDataFormat.toString(colorAdvanceFrame.getMaxScale()), breezeActionEvent -> {
                        colorAdvanceFrame.setScale(11, false, colorAdvanceFrame.getMinScale(), (double)RtDataFormat.toNumberFloat(breezeActionEvent.result().toString()));
                        this.setDirty(true);
                    });
                });
                breezeContextMenu.addButtonCloseClick("Set min", () -> {
                    ColorAdvanceFrame colorAdvanceFrame = (ColorAdvanceFrame)abstractPlotLayout.getLayer(Double.valueOf(1.0)).getComboBox((byte)3).getAdvanceSettings();
                    BreezeOptionDialog.showDialog(this.getFrame(), BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.INPUT_OPTION, "Set min", "Set min value", RtDataFormat.toString(colorAdvanceFrame.getMinScale()), breezeActionEvent -> {
                        colorAdvanceFrame.setScale(11, false, (double)RtDataFormat.toNumberFloat(breezeActionEvent.result().toString()), colorAdvanceFrame.getMaxScale());
                        this.setDirty(true);
                    });
                });
                breezeContextMenu.addSeparator();
            }
            super.addCustomMenuItems(abstractPlotLayout, breezeContextMenu);
        }

        @Override
        public boolean supportChange() {
            return false;
        }

        @Override
        public boolean hasInteraction(boolean bl) {
            return true;
        }
    }

    public static class SpectralPlotViewPanel
    extends PlotViewPanel {
        private final SpectrumLegendPanel legendPanel;
        private final PixelExploreInterface explorePanel;
        private static File lastFolder;

        public SpectralPlotViewPanel(PPEntryMainInterface pPEntryMainInterface, PixelExploreInterface pixelExploreInterface) {
            super(pPEntryMainInterface, "Normalised pseudo absorbance spectrum", "Spectral", "xtraining");
            this.explorePanel = pixelExploreInterface;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 1;
            this.legendPanel = new SpectrumLegendPanel(this);
            this.add(this.legendPanel, gridBagConstraints);
            BreezeToggleButton breezeToggleButton = VisualisationToolbar.createButton("", "legend", "Legend", false, bl -> {
                this.legendPanel.setVisible(bl);
                if (bl) {
                    SwingUtilities.invokeLater(this.legendPanel::updateList);
                }
            });
            breezeToggleButton.setPreferredSize(new Dimension(20, 20));
            this.addToolbarComponent(breezeToggleButton);
        }

        public void updateLegends() {
            this.legendPanel.updateList();
        }

        @Override
        public Properties createProperties() {
            Properties properties = super.createProperties();
            properties.put("direction", "rows");
            return properties;
        }

        @Override
        public boolean hasInteraction(boolean bl) {
            return true;
        }

        @Override
        public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
            super.plotSetup(abstractPlotLayout);
            FloatWindowQuickSpectral floatWindowQuickSpectral = (FloatWindowQuickSpectral)abstractPlotLayout.getMainWindow();
            floatWindowQuickSpectral.setShowZeroLines(false);
            floatWindowQuickSpectral.setSourcePixelExplore(true);
            QuickSpectralLayer quickSpectralLayer = (QuickSpectralLayer)abstractPlotLayout.getLayer(Double.valueOf(1.0));
            quickSpectralLayer.setShowAverageSpectra(true);
            quickSpectralLayer.setAverageCallback(this.legendPanel::updateList);
            Properties properties = new Properties();
            properties.put("width", "4");
            abstractPlotLayout.setLine(new Object[]{"vector", properties});
            abstractPlotLayout.show("tickdenistyX", Double.valueOf(0.75));
        }

        @Override
        public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
            super.postSetup(breezeProgressManager, abstractPlotLayout);
            abstractPlotLayout.setLabel(new Object[]{"identifier"});
        }

        @Override
        public void addCustomMenuItems(AbstractPlotLayout abstractPlotLayout, BreezeContextMenu breezeContextMenu) {
            Measurement measurement;
            super.addCustomMenuItems(abstractPlotLayout, breezeContextMenu);
            FloatWindowQuickSpectral floatWindowQuickSpectral = (FloatWindowQuickSpectral)abstractPlotLayout.getMainWindow();
            breezeContextMenu.addSeparator();
            breezeContextMenu.addButtonCloseClick("Save spectral data", () -> ((FloatWindowQuickSpectral)floatWindowQuickSpectral).exportSpectra());
            QuickSpectralLayer quickSpectralLayer = (QuickSpectralLayer)floatWindowQuickSpectral.getLayer(0);
            breezeContextMenu.addButtonCloseClick("Pin spectrum", () -> {
                quickSpectralLayer.pinAverages();
                this.legendPanel.updateList();
            });
            Measurement measurement2 = measurement = this.explorePanel != null ? this.explorePanel.getMeasurement() : null;
            if (measurement != null) {
                breezeContextMenu.addButtonCloseClick("Import spectrum", () -> {
                    jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Import spectrum", (Component)this.getFrame());
                    jopensaveDialog2.setPreview(null, true);
                    if (jopensaveDialog2.getSelectedFile() == null) {
                        jopensaveDialog2.setCurrentDirectory(lastFolder);
                    }
                    MembersSetting.EndMemberFileParameter.addAllSupported(jopensaveDialog2);
                    if (jopensaveDialog2.openshow()) {
                        File file = jopensaveDialog2.getSelectedFile();
                        if (file.exists()) {
                            lastFolder = file.getParentFile();
                        }
                        Workflow workflow = measurement.getWorkflow();
                        List<Reference> list = Reference.read(file, workflow);
                        BreezeOptionDialog.showDialog(this.getFrame(), workflow.getType().getPageType().getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Select spectrum", "", (AbstractBreezeCustomPanel)new SelectMembersPanel(this.getFrame(), list, null, null), null, breezeActionEvent -> {
                            for (Reference reference : ((SelectMembersPanel)breezeActionEvent.getBreezeCustomPanel()).getIncluded()) {
                                quickSpectralLayer.getPinnedList().add(new ReferenceAverageSpectra(reference, this, this.explorePanel, (AbstractAxisLayer)quickSpectralLayer));
                            }
                            floatWindowQuickSpectral.calculateBuildAndRepaint();
                            this.legendPanel.updateList();
                        });
                    }
                });
            }
            if (quickSpectralLayer.hasPinnedData()) {
                breezeContextMenu.addButtonCloseClick("Clear pinned spectrum", () -> {
                    quickSpectralLayer.clearAverageList(true);
                    floatWindowQuickSpectral.calculateBuildAndRepaint();
                    this.legendPanel.updateList();
                });
            }
            BreezeCheckBox breezeCheckBox = new BreezeCheckBox("Auto rescale", floatWindowQuickSpectral.isAutoRescale(), bl -> {
                breezeContextMenu.close();
                floatWindowQuickSpectral.setAutoRescale(bl);
                if (bl) {
                    floatWindowQuickSpectral.calculateBuildAndRepaint();
                }
            });
            breezeCheckBox.setFontSize(14);
            breezeContextMenu.addComponent(breezeCheckBox);
        }

        @Override
        public JPanel getLegend() {
            return this.legendPanel;
        }

        public static class SpectrumLegendPanel
        extends JPanel {
            private final SpectralPlotViewPanel plotPanel;
            private final JPanel mainPanel = new JPanel(new GridBagLayout());
            private Object selected;
            private List<QuickSpectralLayer.AverageSpectra> pinnedList;
            private List<QuickSpectralLayer.AverageSpectra> averageList;
            private AbstractPlotLayout plot;

            public SpectrumLegendPanel(SpectralPlotViewPanel spectralPlotViewPanel) {
                super(new BorderLayout());
                this.plotPanel = spectralPlotViewPanel;
                this.setVisible(false);
                this.setPreferredSize(new Dimension(150, 0));
                this.setMinimumSize(new Dimension(150, 0));
                this.setOpaque(false);
                this.mainPanel.setBackground(BreezeTheme.getInstance().getPanelBackground());
                BreezeScrollPane breezeScrollPane = new BreezeScrollPane(this.mainPanel);
                breezeScrollPane.setHorizontalScrollBarPolicy(31);
                this.add((Component)breezeScrollPane, "Center");
                JPanel jPanel = new JPanel(new FlowLayout(0, 10, 5));
                jPanel.setOpaque(false);
                jPanel.add(EntryMainHelper.createButton("Up", "material/arrow_upward", () -> {
                    int n;
                    List list = this.getListForSelected();
                    int n2 = n = this.selected != null ? list.indexOf(this.selected) : 0;
                    if (n > 0) {
                        this.swap(list, n, n - 1);
                        this.plot.endUpdate((byte)7);
                        this.updateList();
                    }
                }));
                jPanel.add(EntryMainHelper.createButton("Down", "material/arrow_downward", () -> {
                    int n;
                    List list = this.getListForSelected();
                    int n2 = n = this.selected != null ? list.indexOf(this.selected) : list.size();
                    if (n < list.size() - 1) {
                        this.swap(list, n, n + 1);
                        this.plot.endUpdate((byte)7);
                        this.updateList();
                    }
                }));
                jPanel.add(EntryMainHelper.createButton("Pin", "explore/push_pin", () -> {
                    AbstractAxisLayer abstractAxisLayer = this.plot.getLayer(Double.valueOf(1.0));
                    if (abstractAxisLayer instanceof QuickSpectralLayer) {
                        QuickSpectralLayer quickSpectralLayer = (QuickSpectralLayer)abstractAxisLayer;
                        quickSpectralLayer.pinAverages();
                        this.updateList();
                    }
                }));
                this.add((Component)jPanel, "South");
            }

            private List getListForSelected() {
                if (this.pinnedList.contains(this.selected)) {
                    return this.pinnedList;
                }
                return this.averageList;
            }

            private void swap(List list, int n, int n2) {
                Object e = list.get(n2);
                Object e2 = list.get(n);
                list.set(n2, e2);
                list.set(n, e);
            }

            public void updateList() {
                if (this.isVisible()) {
                    Object object;
                    this.mainPanel.removeAll();
                    this.plot = this.plotPanel.getVisualization();
                    if (this.plot != null && (object = (QuickSpectralLayer)this.plot.getLayer(Double.valueOf(1.0))) != null) {
                        GridBagConstraints gridBagConstraints;
                        this.pinnedList = object.getPinnedList();
                        if (!this.pinnedList.isEmpty()) {
                            gridBagConstraints = new GridBagConstraints();
                            gridBagConstraints.gridy = this.mainPanel.getComponentCount();
                            gridBagConstraints.insets = new Insets(0, 0, 4, 0);
                            gridBagConstraints.anchor = 17;
                            this.mainPanel.add((Component)new BreezeLabel("Pinned", false, 14), gridBagConstraints);
                            this.addList(this.pinnedList);
                        }
                        this.averageList = object.getAverageList();
                        if (!this.averageList.isEmpty()) {
                            gridBagConstraints = new GridBagConstraints();
                            gridBagConstraints.gridy = this.mainPanel.getComponentCount();
                            gridBagConstraints.insets = new Insets(0, 0, 4, 0);
                            gridBagConstraints.anchor = 17;
                            this.mainPanel.add((Component)new BreezeLabel("Averages", false, 14), gridBagConstraints);
                            this.addList(this.averageList);
                        }
                    }
                    if (this.mainPanel.getComponentCount() == 0) {
                        object = new GridBagConstraints();
                        object.anchor = 17;
                        this.mainPanel.add((Component)new BreezeLabel("No spectrum selected", false, 14), object);
                    }
                    this.mainPanel.revalidate();
                    this.mainPanel.repaint();
                }
            }

            private void addList(final List<QuickSpectralLayer.AverageSpectra> list) {
                for (final QuickSpectralLayer.AverageSpectra averageSpectra : list) {
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridy = this.mainPanel.getComponentCount();
                    gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    final CatClass catClass = new CatClass(averageSpectra.getDescription(), null);
                    catClass.setColor(averageSpectra.getColor());
                    DeleteCatClassInputField deleteCatClassInputField = new DeleteCatClassInputField(catClass, new DeleteCatClassInputField.OnChangeCallback(){
                        final /* synthetic */ SpectrumLegendPanel this$0;
                        {
                            this.this$0 = spectrumLegendPanel;
                        }

                        @Override
                        public void onChange(DeleteCatClassInputField deleteCatClassInputField) {
                            averageSpectra.setDescription(catClass.getName());
                            averageSpectra.setColor(catClass.getColor());
                            this.this$0.plot.endUpdate((byte)7);
                        }

                        @Override
                        public void action() {
                            list.remove(averageSpectra);
                            this.this$0.plot.endUpdate((byte)7);
                            this.this$0.updateList();
                        }
                    });
                    BreezeInputField breezeInputField = deleteCatClassInputField.getLabelField();
                    BreezeTextField breezeTextField = breezeInputField.getTextField();
                    breezeTextField.getTextField().setFont(new Font("Tahoma", 0, 10));
                    breezeInputField.getLabel().setVisible(false);
                    if (this.selected == averageSpectra) {
                        SwingUtilities.invokeLater(breezeInputField::requestFocusAndSelectAll);
                    }
                    deleteCatClassInputField.addFocusListener(new FocusAdapter(this){
                        final /* synthetic */ SpectrumLegendPanel this$0;
                        {
                            this.this$0 = spectrumLegendPanel;
                        }

                        @Override
                        public void focusGained(FocusEvent focusEvent) {
                            this.this$0.selected = averageSpectra;
                        }
                    });
                    this.mainPanel.add((Component)deleteCatClassInputField, gridBagConstraints);
                }
            }

            @Generated
            public JPanel getMainPanel() {
                return this.mainPanel;
            }
        }

        private static class ReferenceAverageSpectra
        extends QuickSpectralLayer.AverageSpectra {
            private final Reference reference;
            private final PlotViewPanel plotViewPanel;
            private final PixelExploreInterface exploreInterface;

            public ReferenceAverageSpectra(Reference reference, PlotViewPanel plotViewPanel, PixelExploreInterface pixelExploreInterface, AbstractAxisLayer abstractAxisLayer) {
                super(abstractAxisLayer, reference.getLength(), 0);
                this.reference = reference;
                this.plotViewPanel = plotViewPanel;
                this.exploreInterface = pixelExploreInterface;
                this.setColor(reference.getColor());
                this.setDescription(reference.getName());
                this.update();
            }

            public void update() {
                DataSet dataSet = this.plotViewPanel.getDataSet();
                if (dataSet == null || dataSet.isCleaned()) {
                    return;
                }
                List<RtModule> list = this.exploreInterface.getTransformationModules();
                float[] fArray = DataTemplatesHelper.getWavelength(dataSet);
                FloatMatrix floatMatrix = this.reference.interpolateTo(fArray, new GaussianResampler());
                this.setSize(floatMatrix.getLength());
                Reference.transform(list, floatMatrix);
                for (int i = 0; i < floatMatrix.rows; ++i) {
                    this.setValue(i, floatMatrix.get(i));
                }
            }
        }
    }

    public static class PixelExploreWithSamplesPanel
    extends PixelExplorePanel {
        private final BreezeButton addSampleButton;
        private final BreezeButton selectFromSamplesButton;
        private final BreezeButton selectFromPixelsButton;
        private final BreezeCheckBox showDescriptorCheckBox = new BreezeCheckBox("Show descriptors", false);

        public PixelExploreWithSamplesPanel(EntryMainPanel entryMainPanel, Workflow workflow, PixelExplorePanel.PixelExploreType pixelExploreType) {
            super(entryMainPanel, workflow, pixelExploreType);
            if (RegInfo.isApplicationFeature()) {
                this.addSampleButton = EntryMainHelper.createButton("Add Sample(s)", "explore/docs_add_on", () -> this.addSampleFromSelection((PlotViewPanel)this.tabViewContainer.getSelectedTab().getPanel()));
                this.addSampleButton.setToolTipText("Add Sample(s) in Table from selected pixels");
            } else {
                this.addSampleButton = null;
            }
            this.selectFromSamplesButton = EntryMainHelper.createButton("Select pixels", "explore/gesture_select", () -> this.selectFromSamples((PlotViewPanel)this.tabViewContainer.getSelectedTab().getPanel()));
            this.selectFromSamplesButton.setToolTipText("Select pixels from selected Sample(s) in Table");
            this.selectFromPixelsButton = EntryMainHelper.createButton("Go to Sample(s)", "explore/tab_move", () -> this.selectSamplesInTable((PlotViewPanel)this.tabViewContainer.getSelectedTab().getPanel()));
            this.selectFromPixelsButton.setToolTipText("Select Sample(s) in Table from selected pixels");
            this.showDescriptorCheckBox.setSelected(workflow.getDescriptorExplorePixel());
            this.showDescriptorCheckBox.addActionListener(actionEvent -> {
                workflow.setDescriptorExplorePixel(this.showDescriptorCheckBox.isSelected());
                workflow.save();
                this.mainpanel.setDirty(true);
            });
        }

        @Override
        public void addComponent(BreezeMainPanel breezeMainPanel) {
            super.addComponent(breezeMainPanel);
            if (this.addSampleButton != null) {
                breezeMainPanel.addRightButton(new BreezeSeparator(1));
                breezeMainPanel.addRightButton(this.addSampleButton);
            }
            breezeMainPanel.addRightButton(new BreezeSeparator(1));
            breezeMainPanel.addRightButton(this.selectFromSamplesButton);
            breezeMainPanel.addRightButton(this.selectFromPixelsButton);
            if (BreezeFrame.isPixelExploreDescriptors()) {
                breezeMainPanel.addRightButton(new BreezeSeparator(1));
                breezeMainPanel.addRightButton(this.showDescriptorCheckBox);
            }
        }

        private void addSampleFromSelection(PlotViewPanel plotViewPanel) {
            final InteractionArray interactionArray = (InteractionArray)plotViewPanel.getVisualization().get("selection");
            final EntryMainPanel entryMainPanel = (EntryMainPanel)this.getMainPanel();
            if (interactionArray != null && interactionArray.hasSelection()) {
                final FrameMatrix frameMatrix = this.getFrameMatrix(plotViewPanel);
                Workflow workflow = this.measurement.getWorkflow();
                BreezeOptionDialog.showDialog(this.getFrame(), entryMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Add sample(s)", "", (AbstractBreezeCustomPanel)new AddSamplesPanel(workflow), null, breezeActionEvent -> {
                    String string;
                    final AddSamplesPanel addSamplesPanel = (AddSamplesPanel)breezeActionEvent.getBreezeCustomPanel();
                    final SegmentationNode segmentationNode = addSamplesPanel.getOrCreateSegmentationNode();
                    FunctionTreeNode functionTreeNode = SegmentationNode.getParentNode(segmentationNode);
                    if (functionTreeNode instanceof FunctionTreeNodeWithId) {
                        FunctionTreeNodeWithId functionTreeNodeWithId = (FunctionTreeNodeWithId)functionTreeNode;
                        string = functionTreeNodeWithId.getUid();
                    } else {
                        string = null;
                    }
                    final Sample sample = this.measurement.getFirstSample(string);
                    BreezeProgressDialog.startProgressWithCancel(this.getFrame(), new ProgressAction(this){
                        final /* synthetic */ PixelExploreWithSamplesPanel this$0;
                        {
                            this.this$0 = pixelExploreWithSamplesPanel;
                        }

                        @Override
                        public void runAction() throws Exception {
                            int n = frameMatrix.getReduce();
                            RtObjectIdentificationHelper.RtIdentifiedObjectList rtIdentifiedObjectList = SampleHelper.getAreas(this.this$0.createBinaryMatrix(frameMatrix, interactionArray, addSamplesPanel.addOnlyIncuded()), false);
                            if (rtIdentifiedObjectList.isEmpty()) {
                                throw new ErrorHandler.InformationMessageException("No included pixels in the selected area");
                            }
                            CatClass catClass = addSamplesPanel.getCatClass();
                            if (addSamplesPanel.merge()) {
                                SampleHelper.addSample(this.this$0.measurement, sample, catClass, segmentationNode, n, rtIdentifiedObjectList.getList());
                            } else {
                                SampleHelper.addSamples(this.this$0.measurement, sample, catClass, segmentationNode, n, rtIdentifiedObjectList.getList());
                            }
                            this.this$0.measurement.save();
                            ApplyChanges.applyChanges((BreezeProgress)this.getProgressManager(), this.this$0.measurement);
                            SwingUtilities.invokeLater(() -> {
                                this.this$0.clearSelection();
                                entryMainPanel.selectTab("Table");
                                entryMainPanel.setDirty(true);
                            });
                        }
                    }, "Create sample(s)");
                });
            } else {
                BreezeOptionDialog.showDialog(entryMainPanel, AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Manual segmentation", "Cannot add sample(s). No selection has been made.\n\nPlease select pixels in scatter or image plot and try again.");
            }
        }

        private void selectFromSamples(PlotViewPanel plotViewPanel) {
            plotViewPanel.getVisualization().select(new Object[]{"clear"});
            BreezeTable breezeTable = ((EntryMeasurementPanel)this.mainpanel).getMeasurementViewPanel().getSampleTablePanel().getTable();
            FrameMatrix frameMatrix = this.getFrameMatrix(plotViewPanel);
            int n = frameMatrix.getFoldN();
            double d = frameMatrix.getReduce();
            ArrayList<Double> arrayList = new ArrayList<Double>();
            for (Object e : breezeTable.getSelectedValues()) {
                for (RtPixel2D rtPixel2D : ((Sample)e).getObjectPixels()) {
                    double d2 = (double)rtPixel2D.x / d;
                    double d3 = (double)rtPixel2D.y / d;
                    arrayList.add(d2 * (double)n + d3 + 1.0);
                }
            }
            plotViewPanel.getVisualization().select(new Object[]{"select", arrayList.toArray(new Double[0])});
        }

        private void selectSamplesInTable(PlotViewPanel plotViewPanel) {
            EntryMeasurementPanel entryMeasurementPanel = (EntryMeasurementPanel)this.getMainPanel();
            BreezeTable breezeTable = entryMeasurementPanel.getMeasurementViewPanel().getSampleTablePanel().getTable();
            ListSelectionModel listSelectionModel = breezeTable.getSelectionModel();
            listSelectionModel.clearSelection();
            InteractionArray interactionArray = (InteractionArray)plotViewPanel.getVisualization().get("selection");
            if (interactionArray != null && interactionArray.hasSelection()) {
                FrameMatrix frameMatrix = this.getFrameMatrix(plotViewPanel);
                SegmentationMatrix segmentationMatrix = this.createBinaryMatrix(frameMatrix, interactionArray, true);
                int n = frameMatrix.getReduce();
                for (int i = 0; i < breezeTable.getRowCount(); ++i) {
                    Sample sample = (Sample)breezeTable.getValueAt(i, 0);
                    Shape shape = sample.getSamplePath().getOrCreateGeneralPath();
                    if (!segmentationMatrix.forEachForwardsContains((n2, n3, n4) -> n2 > 0 && shape.contains(n4 * n, n3 * n))) continue;
                    listSelectionModel.addSelectionInterval(i, i);
                }
            }
            SwingUtilities.invokeLater(() -> entryMeasurementPanel.selectTab("Table"));
        }

        private SegmentationMatrix createBinaryMatrix(FrameMatrix frameMatrix, InteractionArray interactionArray, boolean bl) {
            int n = frameMatrix.getFoldN();
            int n2 = frameMatrix.getFoldK();
            SegmentationMatrix segmentationMatrix = new SegmentationMatrix(n, n2);
            DataSet dataSet = (DataSet)frameMatrix.getCase().getDsContainer().get(0);
            InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)dataSet.getObsDataInfo().getPrimaryColumnByType(1);
            for (int i = interactionArray.getFirstSet(); i <= interactionArray.getLastSet(); ++i) {
                if (!interactionArray.get(i) || bl && !innerColumnBoolean.getValueBool(i)) continue;
                segmentationMatrix.setValue(i % n, i / n, 1);
            }
            return segmentationMatrix;
        }

        private FrameMatrix getFrameMatrix(PlotViewPanel plotViewPanel) {
            return (FrameMatrix)plotViewPanel.getVisualization().getPlotInit().getDataTreeInterface();
        }
    }

    public static class PretreatmentSectionPanel {
        private final EntryMainPanelInterface panel;
        private final DefaultSettingsPanel.SectionPanel transformationsSection;
        private final DefaultSettingsPanel.SectionPanel filterSection;
        private Workflow workflow;
        private FunctionParameterCustomInput.EditTransformationPanel editTransformationPanel;
        private final TransformationParameter transformationParameter;
        private final PretreatmentSource source;

        public PretreatmentSectionPanel(EntryMainPanelInterface entryMainPanelInterface, DefaultSettingsPanel defaultSettingsPanel, PretreatmentSource pretreatmentSource, OnPreatmentChangedCallback onPreatmentChangedCallback) {
            this.panel = entryMainPanelInterface;
            this.source = pretreatmentSource;
            this.transformationParameter = new TransformationParameter();
            this.filterSection = defaultSettingsPanel.addSection("Spectral filters");
            this.editTransformationPanel = new FunctionParameterCustomInput.EditTransformationPanel(this.transformationParameter, entryMainPanelInterface.getFrame(), entryMainPanelInterface.getPageColor(), (functionParameter, object, bl) -> {
                if (pretreatmentSource.equals((Object)PretreatmentSource.PixelExplore)) {
                    this.workflow.setExplorePixelFilter(functionParameter.getValueStr());
                } else {
                    this.workflow.setExploreFilter(functionParameter.getValueStr());
                }
                this.workflow.save();
                onPreatmentChangedCallback.onChange(this.workflow);
            }, "Select spectral filters", false);
            this.filterSection.addComponentVertical(this.editTransformationPanel);
            this.transformationsSection = defaultSettingsPanel.addSection((pretreatmentSource.equals((Object)PretreatmentSource.PixelExplore) ? "Model " : "") + "Pretreatments");
        }

        public void setVisible(boolean bl) {
            this.transformationsSection.setVisible(bl);
        }

        public void update(final PlotViewPanel plotViewPanel, Workflow workflow) {
            this.workflow = workflow;
            this.transformationsSection.clear();
            if (workflow == null) {
                return;
            }
            if (workflow.isXrayData()) {
                if (this.filterSection != null) {
                    this.filterSection.setVisible(false);
                }
                BreezeCheckBox breezeCheckBox = new BreezeCheckBox("Log", true);
                breezeCheckBox.setEnabled(false);
                this.transformationsSection.addComponentVertical(breezeCheckBox);
            } else {
                boolean bl = this.source.equals((Object)PretreatmentSource.PixelExplore);
                this.filterSection.setVisible(true);
                this.transformationParameter.setValueStr(bl ? workflow.getExplorePixelFilter() : workflow.getExploreFilter());
                this.editTransformationPanel.setParameter(this.transformationParameter);
                final BreezeCheckBox breezeCheckBox = new BreezeCheckBox("SNV", bl ? workflow.getModellingExplorePixelSnv() : workflow.getModellingExploreSnv());
                breezeCheckBox.addItemListener(itemEvent -> {
                    if (bl) {
                        workflow.setModellingExplorePixelSnv(breezeCheckBox.isSelected());
                    } else {
                        workflow.setModellingExploreSnv(breezeCheckBox.isSelected());
                    }
                    BreezeProgressDialog.startProgress(this.panel.getFrame(), new ProgressAction(this){
                        final /* synthetic */ PretreatmentSectionPanel this$0;
                        {
                            this.this$0 = pretreatmentSectionPanel;
                        }

                        @Override
                        public void runAction() throws Exception {
                            DataSet dataSet = plotViewPanel.getDataSet();
                            if (dataSet != null) {
                                CommonModelSettings.updateTransformation(dataSet, new ModelProperties.TransformationProperties(Model.Transformation.SNV, breezeCheckBox.isSelected()));
                                dataSet.applyChanges((ProgressManager)this.getProgressManager());
                                this.this$0.panel.setDirty(true);
                            }
                        }
                    }, "Updating", -1);
                });
                this.transformationsSection.addComponent(breezeCheckBox);
                BreezeCheckBox breezeCheckBox2 = new BreezeCheckBox("Center", true);
                breezeCheckBox2.setEnabled(false);
                this.transformationsSection.addComponentLast(breezeCheckBox2);
            }
        }

        public List<RtModule> getTransformationModules() {
            return this.transformationParameter.getTransformationModules(1);
        }

        public static enum PretreatmentSource {
            PixelExplore,
            GroupExplore,
            Other;

        }

        public static interface OnPreatmentChangedCallback {
            public void onChange(Workflow var1);
        }
    }

    public static class ComponentSectionPanel {
        private static final String title = "Components";
        private final DefaultSettingsPanel.SectionPanel componentSection;
        private boolean allowForMoreElementsAfterComponents = false;
        private Object plotOrModel;

        public ComponentSectionPanel(DefaultSettingsPanel defaultSettingsPanel) {
            this.componentSection = defaultSettingsPanel.addSection(title);
        }

        public ComponentSectionPanel(DefaultSettingsPanel defaultSettingsPanel, EntryMainPanelInterface entryMainPanelInterface, PlotViewPanel plotViewPanel, boolean bl) {
            this(defaultSettingsPanel);
            this.allowForMoreElementsAfterComponents = bl;
            this.initiate(entryMainPanelInterface, plotViewPanel);
        }

        public void initiate(EntryMainPanelInterface entryMainPanelInterface, Object object) {
            this.plotOrModel = object;
            this.componentSection.addComponent(ModelButtonHelper.createAddComponentButton(entryMainPanelInterface, object));
            this.componentSection.addComponent(ModelButtonHelper.createRemoveComponentButton(entryMainPanelInterface, object));
            if (this.allowForMoreElementsAfterComponents) {
                this.componentSection.addComponent(ModelButtonHelper.createSetComponentButton(entryMainPanelInterface, object));
            } else {
                this.componentSection.addComponentLast(ModelButtonHelper.createSetComponentButton(entryMainPanelInterface, object));
            }
        }

        public int updateComponents() {
            AbstractModel abstractModel = ModelButtonHelper.getModel(this.plotOrModel);
            if (abstractModel != null) {
                int n = abstractModel.getComponentsInt();
                this.componentSection.setTitle("Components (" + n + ")");
                return n;
            }
            return 0;
        }

        public void setVisible(boolean bl) {
            this.componentSection.setVisible(bl);
        }

        public void addComponent(JComponent jComponent) {
            this.componentSection.addComponentLast(jComponent);
        }
    }

    public static class Descriptor2DPanel
    extends PlotViewPanel {
        private ArrayList<AdditionalFactor.AdditionalFactorNode> additionalFactorNodes = new ArrayList();
        private int index;

        public Descriptor2DPanel(PPEntryMainInterface pPEntryMainInterface) {
            super(pPEntryMainInterface, "Descriptor", "Contour2D", new String[]{"origmatrix", "descriptors"});
        }

        @Override
        public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
            abstractPlotLayout.getMainWindow().supportLayerInteraction = false;
            DataTemplatesHelper.setGrayBackground(abstractPlotLayout, 2.0, BreezeTheme.getInstance().isDarkMode());
            PixelExploreInterface.addLayerButton(this, abstractPlotLayout);
        }

        @Override
        public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
            AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(1.0));
            if (abstractAxisLayer == null) {
                return;
            }
            if (this.index >= 0 && this.index < this.additionalFactorNodes.size()) {
                AdditionalFactor.AdditionalFactorNode additionalFactorNode = this.additionalFactorNodes.get(this.index);
                DescriptorTreeNode descriptorTreeNode = additionalFactorNode.node();
                Factor factor = additionalFactorNode.getFactor();
                this.setTitle(factor.toString());
                String string = descriptorTreeNode.getAnalyseUid() + "_" + factor.getUid();
                abstractAxisLayer.setDataRange(new Object[]{"range", "matrix", string});
                if (descriptorTreeNode.getAnalyse().getModelMethod().isClassification() && descriptorTreeNode.getIndex() == 0) {
                    Properties properties = new Properties();
                    abstractAxisLayer.setColor(new Object[]{"predictioncategory", factor.getUid(), properties});
                } else {
                    Properties properties = new Properties();
                    properties.put("min", RtDataFormat.toString(factor.getMin()));
                    properties.put("max", RtDataFormat.toString(factor.getMax()));
                    abstractAxisLayer.setColor(new Object[]{"amplitude", properties});
                }
            }
        }

        public void setDescriptors(ArrayList<AdditionalFactor.AdditionalFactorNode> arrayList) {
            this.additionalFactorNodes = arrayList;
        }

        public void setVariable(int n) {
            this.index = n;
        }

        @Override
        public boolean supportChange() {
            return false;
        }

        @Override
        public boolean hasInteraction(boolean bl) {
            return true;
        }
    }

    public static class Contour2DPanel
    extends PlotViewPanel {
        public static final String maxVarianceImageTitle = "Max variance image";
        private final String[] explore_layers;
        private final PlotViewPanel referencePlot;

        public Contour2DPanel(PPEntryMainInterface pPEntryMainInterface, String[] stringArray, PlotViewPanel plotViewPanel) {
            super(pPEntryMainInterface, maxVarianceImageTitle, "Contour2D", stringArray);
            this.explore_layers = stringArray;
            this.referencePlot = plotViewPanel;
            this.setName("explorecontour2d");
        }

        @Override
        public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
            if (this.explore_layers.length > 1) {
                DataTemplatesHelper.setGrayBackground(abstractPlotLayout, 2.0, BreezeTheme.getInstance().isDarkMode());
                PixelExploreInterface.addLayerButton(this, abstractPlotLayout);
            }
        }

        @Override
        public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
            AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(1.0));
            if (abstractAxisLayer != null) {
                AbstractPlotSettingsBox abstractPlotSettingsBox = abstractAxisLayer.getSettingsBox(Byte.valueOf((byte)9));
                this.setTitle("Max variance image (Component  " + (abstractPlotSettingsBox.getAxisIndex() + 1) + ")");
            }
        }

        @Override
        protected void changeAxis(boolean bl) {
            super.changeAxis(bl);
            this.postSetup(null, this.getVisualization());
        }

        @Override
        public void addCustomMenuItems(AbstractPlotLayout abstractPlotLayout, BreezeContextMenu breezeContextMenu) {
            PixelExploreInterface.addIncludeExcludeToMenu(this.referencePlot, breezeContextMenu);
            super.addCustomMenuItems(abstractPlotLayout, breezeContextMenu);
        }
    }
}

