/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.record.measurement.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.SwingUtilities;
import lombok.Generated;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AdditionalFactor;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.RtModule;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntrySettingsPanel;
import se.prediktera.breeze.frontend.common.pp.DefaultSettingsPanel;
import se.prediktera.breeze.frontend.common.pp.PPEntryMainInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeSplitPane;
import se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.table.SegmentationPanel;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlPropertyViewPanel;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.TabViewContainer;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.common.view.visualization.PlotViewPanel;
import se.prediktera.breeze.frontend.main.record.measurement.panel.PixelExploreInterface;
import se.prediktera.breeze.frontend.main.record.measurement.panel.WavelengthSettingsPanel;
import se.prediktera.breeze.frontend.main.record.panel.GroupExplorePanel;
import se.prediktera.breeze.frontend.wizard.model.panel.CurveSeparationPanelStep;
import se.prediktera.breeze.frontend.wizard.model.panel.ModelButtonHelper;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.plot.axisplot.plot2D.quickspectral.QuickSpectralLayer;
import se.prediktera.map.plot.layout.AbstractPlotLayout;

public class PixelExplorePanel
extends AbstractViewPanel
implements PixelExploreInterface {
    private final PlotViewPanel referencePlot;
    private final PlotViewPanel pvContour2D;
    private final Properties properties;
    protected Measurement measurement;
    protected TabViewContainer tabViewContainer = null;
    private final WavelengthSettingsPanel leftSettingsPanel;
    private final DefaultSettingsPanel rightSettingsPanel = new DefaultSettingsPanel();
    private PixelExploreInterface.ComponentSectionPanel componentSectionPanel;
    private PixelExploreInterface.SpectralPlotViewPanel spectralPanel;
    private final boolean xRayData;
    private CurveSeparationPanelStep.CurveSeparationScatterPlots xRayPanel;
    private PixelExploreInterface.Contour2DPanel maxVarianceImage;
    private final PixelExploreInterface.PretreatmentSectionPanel pretreatmentSectionPanel;
    private final String reduceText = "Spatial reduce";
    private final BreezeLabel reducedLabel = new BreezeLabel("Spatial reduce", false, 12);
    private final SegmentationPanel segmentationPanel;
    private final BreezeComboBoxInputField<RtFramePredictor.ReferenceConvertTo> convertToComboBox;
    private TabViewContainer descriptorTabViewContainer;
    private PlotViewPanel variancePlot;
    private BreezeButton selectByDensityButton;
    private final ViewContainer leftContainer = new ViewContainer();
    private final ViewContainer rightContainer = new ViewContainer();
    private PixelExploreInterface.Descriptor2DPanel descriptor2DPanel;

    public PixelExplorePanel(BreezeMainPanel breezeMainPanel, Workflow workflow, PixelExploreType pixelExploreType) {
        this(breezeMainPanel, workflow, null, pixelExploreType);
    }

    public PixelExplorePanel(BreezeMainPanel breezeMainPanel, final Workflow workflow2, Measurement measurement, PixelExploreType pixelExploreType) {
        super(breezeMainPanel);
        this.measurement = measurement;
        this.setLayout(new BorderLayout());
        BreezeSplitPane breezeSplitPane = new BreezeSplitPane();
        this.add(breezeSplitPane);
        this.leftSettingsPanel = new WavelengthSettingsPanel(breezeMainPanel);
        String[] stringArray = pixelExploreType.equals((Object)PixelExploreType.Recordings) ? new String[]{"model"} : new String[]{"origmatrix", "model"};
        this.properties = new Properties();
        this.properties.setProperty("closewithhide", "true");
        this.properties.setProperty("showdataset", "true");
        this.xRayData = workflow2.isXrayData();
        breezeSplitPane.setResizeWeight(0.5);
        breezeSplitPane.setLeftComponent((Component)((Object)this.leftContainer));
        breezeSplitPane.setRightComponent((Component)((Object)this.rightContainer));
        if (this.xRayData) {
            this.xRayPanel = new CurveSeparationPanelStep.CurveSeparationScatterPlots(breezeMainPanel, false);
            this.leftContainer.addViewPanel((Component)((Object)this.xRayPanel), 0, 0, 1, 1);
            this.referencePlot = this.xRayPanel.getPlot();
        } else {
            this.spectralPanel = new PixelExploreInterface.SpectralPlotViewPanel(this, breezeMainPanel, this){
                final /* synthetic */ PixelExplorePanel this$0;
                {
                    this.this$0 = pixelExplorePanel;
                    super(pPEntryMainInterface, pixelExploreInterface);
                }

                @Override
                public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
                    super.postSetup(breezeProgressManager, abstractPlotLayout);
                    int n = abstractPlotLayout.getPlotInit().getReduce();
                    if (workflow2.getDefaultReduce() == 0) {
                        if (n > 1) {
                            this.this$0.reducedLabel.setText("Spatial reduce (by factor " + n + ")");
                        } else {
                            this.this$0.reducedLabel.setText("Spatial reduce (none)");
                        }
                    } else {
                        this.this$0.reducedLabel.setText("Spatial reduce");
                    }
                    this.this$0.leftSettingsPanel.setDataSet(this.getDataSet());
                }
            };
            this.leftContainer.addViewPanel((Component)((Object)this.spectralPanel), 0, 0, 1, 1);
            this.referencePlot = this.spectralPanel;
            this.variancePlot = new PlotViewPanel(breezeMainPanel, "Variance scatter", "Scatter2DDensity", "model"){

                @Override
                public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
                    abstractPlotLayout.setSize(new Object[]{"fixed", 3.0});
                }

                @Override
                public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
                    super.postSetup(breezeProgressManager, abstractPlotLayout);
                    GroupExplorePanel.checkAxis(abstractPlotLayout, PixelExplorePanel.this.componentSectionPanel.updateComponents());
                }

                @Override
                public void addCustomMenuItems(AbstractPlotLayout abstractPlotLayout, BreezeContextMenu breezeContextMenu) {
                    PixelExploreInterface.addIncludeExcludeToMenu(this, breezeContextMenu);
                    super.addCustomMenuItems(abstractPlotLayout, breezeContextMenu);
                }
            };
            this.leftContainer.addViewPanel((Component)((Object)this.variancePlot), 0, 1, 1, 1);
            this.variancePlot.setName("explorescatter");
        }
        ModelButtonHelper.addTools(this, this.rightSettingsPanel);
        DefaultSettingsPanel.SectionPanel sectionPanel = this.rightSettingsPanel.addSection("Include / Exclude");
        sectionPanel.addComponent(ModelButtonHelper.createIncludeButtonScatter(this.mainpanel, this.referencePlot));
        sectionPanel.addComponent(ModelButtonHelper.createIncludeOnlyButtonScatter(this.mainpanel, this.referencePlot));
        sectionPanel.addComponentLast(ModelButtonHelper.createExcludeButtonScatter(this.mainpanel, this.referencePlot));
        DefaultSettingsPanel.SectionPanel sectionPanel2 = this.rightSettingsPanel.addSection("Select");
        if (!this.xRayData) {
            this.selectByDensityButton = ModelButtonHelper.createSelectByDensityButton(this.mainpanel, this.variancePlot);
            sectionPanel2.addComponent(this.selectByDensityButton);
        }
        if (BreezeFrame.isSelectSimilarFeature()) {
            sectionPanel2.addComponent(ModelButtonHelper.createSelectBorderButton(this.mainpanel, this.referencePlot, false));
            sectionPanel2.addComponentLast(ModelButtonHelper.createSelectSimilarButton(this.mainpanel, this.referencePlot));
        } else {
            sectionPanel2.addComponentLast(ModelButtonHelper.createSelectBorderButton(this.mainpanel, this.referencePlot, false));
        }
        this.pretreatmentSectionPanel = new PixelExploreInterface.PretreatmentSectionPanel(breezeMainPanel, this.rightSettingsPanel, PixelExploreInterface.PretreatmentSectionPanel.PretreatmentSource.PixelExplore, workflow -> {
            DataSetCache.reload(this.measurement);
            this.reloadEntry();
        });
        this.pretreatmentSectionPanel.update(this.referencePlot, workflow2);
        if (!this.xRayData) {
            new PixelExploreInterface.ModelSectionPanel(this.mainpanel, this, workflow2);
            this.componentSectionPanel = new PixelExploreInterface.ComponentSectionPanel(this.rightSettingsPanel, this.mainpanel, this.variancePlot, false);
        }
        DefaultSettingsPanel.SectionPanel sectionPanel3 = this.rightSettingsPanel.addSection("Other");
        sectionPanel3.addComponentLast(ModelButtonHelper.createResetButton(this.mainpanel, this.referencePlot, this::reloadEntry));
        if (!pixelExploreType.equals((Object)PixelExploreType.TestScan)) {
            sectionPanel3.addComponentVertical(this.reducedLabel);
            sectionPanel3.addComponentHorizontal(new XmlPropertyViewPanel.ReduceComboBox(workflow2.getDefaultReduce(), reduceItem -> {
                this.reducedLabel.setText("Spatial reduce");
                workflow2.setDefaultReduce(reduceItem.getIndex());
                workflow2.save();
                DataSetCache.clearRecursive(workflow2);
                this.reloadEntry();
            }), 4);
        }
        this.convertToComboBox = new BreezeComboBoxInputField<RtFramePredictor.ReferenceConvertTo>("Convert to", RtFramePredictor.ReferenceConvertTo.supported(this.measurement), workflow2.getPixelExploreReferenceConvertTo(), referenceConvertTo -> {
            workflow2.setPixelExploreReferenceConvertTo((RtFramePredictor.ReferenceConvertTo)((Object)referenceConvertTo));
            DataSetCache.clearMeasurements(this.measurement.getParent());
            this.clearSelection();
            this.reloadEntry();
        }, BreezeInputFieldHelper.Format.TwoRows);
        this.convertToComboBox.getComboBox().setMinimumSize(new Dimension(120, 26));
        this.convertToComboBox.getComboBox().setPreferredSize(new Dimension(120, 26));
        this.segmentationPanel = new SegmentationPanel(BreezeInputFieldHelper.Format.TwoRows, bl -> {
            if (bl) {
                DataSetCache.clearMeasurements(this.measurement.getParent());
            }
            this.reloadEntry();
        });
        if (pixelExploreType.equals((Object)PixelExploreType.Recorder)) {
            sectionPanel3.addComponentHorizontal(this.convertToComboBox);
            sectionPanel3.addComponentHorizontal(this.segmentationPanel.getSegmentationComboBox());
            sectionPanel3.addComponentHorizontal(this.segmentationPanel.getSegmentationIdComboBox());
        }
        if (pixelExploreType.equals((Object)PixelExploreType.Normal)) {
            this.descriptor2DPanel = new PixelExploreInterface.Descriptor2DPanel((PPEntryMainInterface)breezeMainPanel);
            this.descriptorTabViewContainer = new TabViewContainer(this.mainpanel){

                @Override
                public void updateSelected(ViewClass viewClass) {
                    PixelExplorePanel.this.descriptor2DPanel.setVariable(this.getSelectedTabIndex());
                    super.updateSelected(viewClass);
                }
            };
            this.rightContainer.addViewPanel((Component)((Object)this.descriptorTabViewContainer), 1, 0, 1, 2);
            this.descriptorTabViewContainer.setVisible(false);
        }
        this.tabViewContainer = new TabViewContainer(this.mainpanel);
        if (!this.xRayData) {
            this.maxVarianceImage = new PixelExploreInterface.Contour2DPanel((PPEntryMainInterface)breezeMainPanel, stringArray, this.referencePlot);
            this.tabViewContainer.addTab(this.maxVarianceImage);
        }
        this.pvContour2D = new PixelExploreInterface.ImagePlotViewPanel((PPEntryMainInterface)this.mainpanel, workflow2, 3, this.referencePlot);
        this.tabViewContainer.addTab(this.pvContour2D);
        this.tabViewContainer.addTab(new PixelExploreInterface.ImagePlotViewPanel((PPEntryMainInterface)this.mainpanel, workflow2, 1, this.referencePlot));
        this.rightContainer.addViewPanel((Component)((Object)this.tabViewContainer), 2, 0, 1, 2);
        this.tabViewContainer.setSelectedTab(0, 0);
    }

    @Override
    public Measurement getMeasurement() {
        return this.measurement;
    }

    @Override
    public List<RtModule> getTransformationModules() {
        return this.pretreatmentSectionPanel.getTransformationModules();
    }

    public static List<DescriptorTreeNode> getDescriptors(Workflow workflow) {
        ArrayList<DescriptorTreeNode> arrayList = new ArrayList<DescriptorTreeNode>();
        for (DescriptorTreeNode descriptorTreeNode : workflow.getSegmentationLevelDescriptorNodes(false)) {
            if (!descriptorTreeNode.isEnabled() || !descriptorTreeNode.hasThumbnailResult() || descriptorTreeNode.getAnalyse() == null || descriptorTreeNode.getFactor() == null) continue;
            arrayList.add(descriptorTreeNode);
        }
        return arrayList;
    }

    @Override
    public void addComponent(BreezeMainPanel breezeMainPanel) {
        super.addComponent(breezeMainPanel);
        breezeMainPanel.addRightButton(this.segmentationPanel);
        breezeMainPanel.addRightButton(this.convertToComboBox);
    }

    @Override
    public WavelengthSettingsPanel getLeftSettingsPanel() {
        return this.leftSettingsPanel;
    }

    @Override
    public DefaultSettingsPanel getRightSettingsPanel(EntrySettingsPanel entrySettingsPanel) {
        return this.rightSettingsPanel;
    }

    @Override
    public boolean showLeftSettingsPanel() {
        return false;
    }

    @Override
    public boolean showRightSettingsPanel() {
        return true;
    }

    public void reloadEntry() {
        this.showEntry(this.measurement, null);
    }

    @Override
    public void showEntry(Object object, Object object2) {
        AbstractPlotLayout abstractPlotLayout;
        Workflow workflow = Workflow.getWorkflow(object);
        if (workflow != null) {
            if (this.descriptorTabViewContainer != null) {
                this.descriptorTabViewContainer.removeTabs();
                if (workflow.getDescriptorExplorePixel()) {
                    List<DescriptorTreeNode> list = PixelExplorePanel.getDescriptors(workflow);
                    abstractPlotLayout = new ArrayList();
                    for (DescriptorTreeNode descriptorTreeNode : list) {
                        abstractPlotLayout.add((AdditionalFactor.AdditionalFactorNode)new AdditionalFactor.AdditionalFactorNode(descriptorTreeNode, null));
                        this.descriptorTabViewContainer.addTab(descriptorTreeNode.getAliasOrNodeString(FunctionTreeNode.TextType.Table), this.descriptor2DPanel);
                        List<AdditionalFactor> list2 = descriptorTreeNode.getAdditionalFactors();
                        if (list2 == null) continue;
                        for (AdditionalFactor additionalFactor : list2) {
                            abstractPlotLayout.add(new AdditionalFactor.AdditionalFactorNode(descriptorTreeNode, additionalFactor));
                            this.descriptorTabViewContainer.addTab(additionalFactor.getFactor().toString(), this.descriptor2DPanel);
                        }
                    }
                    this.descriptor2DPanel.setDescriptors((ArrayList<AdditionalFactor.AdditionalFactorNode>)abstractPlotLayout);
                    this.descriptorTabViewContainer.setVisible(!list.isEmpty());
                    if (this.descriptorTabViewContainer.isVisible()) {
                        this.descriptorTabViewContainer.setSelectedTab(0, 0);
                    }
                } else {
                    this.descriptorTabViewContainer.setVisible(false);
                }
            }
            if (this.xRayData) {
                this.xRayPanel.updateTabs(workflow);
            } else {
                boolean bl = workflow.getModellingExplorePixel();
                this.variancePlot.setVisible(bl);
                this.selectByDensityButton.setVisible(bl);
                this.componentSectionPanel.setVisible(bl);
                this.pretreatmentSectionPanel.setVisible(bl);
                if (bl) {
                    if (!this.tabViewContainer.hasPanel(this.maxVarianceImage)) {
                        this.tabViewContainer.insertTab("Max variance image", this.maxVarianceImage);
                        this.tabViewContainer.setSelectedTab(0, 0);
                    }
                } else if (this.tabViewContainer != null) {
                    this.tabViewContainer.removeTab(this.maxVarianceImage);
                }
            }
        }
        this.leftContainer.showEntry(object, object2);
        this.rightContainer.showEntry(object, object2);
        if (object instanceof Measurement) {
            boolean bl = this.measurement != object;
            this.measurement = (Measurement)object;
            if (this.spectralPanel != null) {
                this.spectralPanel.setTitle(PixelExplorePanel.getSpectralTitleCheckFiltered(this.measurement, PixelExploreInterface.PretreatmentSectionPanel.PretreatmentSource.PixelExplore, this.getActualConvertTo(this.measurement)));
                abstractPlotLayout = this.spectralPanel.getVisualization();
                if (abstractPlotLayout != null) {
                    QuickSpectralLayer quickSpectralLayer = (QuickSpectralLayer)abstractPlotLayout.getLayer(Double.valueOf(1.0));
                    if (bl) {
                        // empty if block
                    }
                    quickSpectralLayer.clearAverageList(false);
                }
            }
            this.convertToComboBox.setVisible(this.measurement.hasReferences());
            this.segmentationPanel.updateSegmentations(workflow);
        }
        this.onContentReady(() -> {
            if (this.referencePlot != null) {
                AbstractDataMatrix abstractDataMatrix = this.referencePlot.getOriginalMatrix();
                this.clearSelection(this.pvContour2D != null && abstractDataMatrix != null && abstractDataMatrix.getN() == 1);
            } else {
                this.clearSelection();
            }
        });
    }

    private RtFramePredictor.ReferenceConvertTo getActualConvertTo(Measurement measurement) {
        if (measurement.hasReferences()) {
            return this.convertToComboBox.getSelectedItem();
        }
        return RtFramePredictor.ReferenceConvertTo.None;
    }

    public static String getSpectralTitleCheckFiltered(Measurement measurement, PixelExploreInterface.PretreatmentSectionPanel.PretreatmentSource pretreatmentSource) {
        return PixelExplorePanel.getSpectralTitleCheckFiltered(measurement, pretreatmentSource, null);
    }

    public static String getSpectralTitleCheckFiltered(Measurement measurement, PixelExploreInterface.PretreatmentSectionPanel.PretreatmentSource pretreatmentSource, RtFramePredictor.ReferenceConvertTo referenceConvertTo) {
        String string = PixelExplorePanel.getSpectralTitle(measurement, pretreatmentSource, referenceConvertTo);
        if (measurement != null) {
            String string2;
            Workflow workflow = measurement.getWorkflow();
            String string3 = string2 = pretreatmentSource.equals((Object)PixelExploreInterface.PretreatmentSectionPanel.PretreatmentSource.PixelExplore) ? workflow.getExplorePixelFilter() : workflow.getExploreFilter();
            if (!string2.isEmpty()) {
                return string + " *filtered";
            }
        }
        return string;
    }

    public static String getSpectralTitle(Measurement measurement) {
        return PixelExplorePanel.getSpectralTitle(measurement, PixelExploreInterface.PretreatmentSectionPanel.PretreatmentSource.Other, null);
    }

    public static String getSpectralTitle(Measurement measurement, PixelExploreInterface.PretreatmentSectionPanel.PretreatmentSource pretreatmentSource, RtFramePredictor.ReferenceConvertTo referenceConvertTo) {
        boolean bl = pretreatmentSource.equals((Object)PixelExploreInterface.PretreatmentSectionPanel.PretreatmentSource.PixelExplore);
        if (bl && referenceConvertTo != null) {
            return referenceConvertTo.getPlotTitle(measurement);
        }
        if (measurement != null) {
            RtFramePredictor.ReferenceConvertTo referenceConvertTo2 = measurement.getDataFormat();
            if (referenceConvertTo2 != null) {
                return referenceConvertTo2.getPlotTitle(measurement);
            }
            RtFramePredictor.RefSettings refSettings = measurement.getRefSettings(bl ? measurement.getWorkflow().getPixelExploreReferenceConvertTo() : null);
            if (refSettings.referenceType.using()) {
                return refSettings.convertTo.getPlotTitle(measurement);
            }
        }
        return RtFramePredictor.ReferenceConvertTo.None.getPlotTitle(measurement);
    }

    @Override
    public boolean contentReady() {
        return this.leftContainer.contentReady() && this.rightContainer.contentReady();
    }

    protected final void clearSelection() {
        this.clearSelection(false);
    }

    protected final void clearSelection(boolean bl) {
        if (this.referencePlot != null && this.referencePlot.getVisualization() != null && this.pvContour2D != null && this.pvContour2D.getVisualization() != null) {
            SwingUtilities.invokeLater(() -> {
                this.referencePlot.getVisualization().clearSelection();
                this.pvContour2D.getVisualization().clearSelection();
                if (this.maxVarianceImage != null) {
                    this.maxVarianceImage.getVisualization().clearSelection();
                }
                if (this.spectralPanel != null) {
                    this.spectralPanel.updateLegends();
                }
                if (bl) {
                    this.pvContour2D.selectAll();
                }
            });
        }
    }

    @Override
    public String getType() {
        return "PixelExplore";
    }

    @Generated
    public ViewContainer getLeftContainer() {
        return this.leftContainer;
    }

    public static enum PixelExploreType {
        Normal,
        Recordings,
        TestScan,
        Recorder;

    }
}

