/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.record.measurement.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.backend.measure.applychanges.ApplyChanges;
import se.prediktera.breeze.common.entry.measurement.MeasurementFileLocation;
import se.prediktera.breeze.common.entry.tree.functiontree.EvaluateResult;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.raw.RtReferenceTarget;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.evince.data.PixelDataHelper;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.ThumbnailManager;
import se.prediktera.breeze.frontend.common.pp.PPEntryMainInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeLabelField;
import se.prediktera.breeze.frontend.common.swing.BreezeRadioButton;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.swing.dialog.WizardCustomPanel;
import se.prediktera.breeze.frontend.common.swing.table.BreezeHtmlPanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.common.view.preview.CropImagePanel;
import se.prediktera.breeze.frontend.common.view.visualization.PlotViewPanel;
import se.prediktera.breeze.frontend.common.view.visualization.SimpleImageViewPanel;
import se.prediktera.breeze.frontend.hardware.ConnectProgressAction;
import se.prediktera.breeze.frontend.main.settings.measurement.ImportReferencePanel;
import se.prediktera.breeze.frontend.main.settings.measurement.ReferenceHelper;
import se.prediktera.breeze.frontend.main.settings.measurement.SpectralReferences;
import se.prediktera.breeze.frontend.main.settings.sensor.InsetsPanel;
import se.prediktera.breeze.hardware.CalibratedReflectanceTargetList;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.camera.FakeCamera;
import se.prediktera.breeze.hardware.camera.HySpexCamera;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.breeze.util.raw.RawHelper;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.plot.axisplot.AbstractAxisLayer;
import se.prediktera.map.plot.axisplot.plot2D.contour2D.Contour2D;
import se.prediktera.map.plot.axisplot.windows.LegendWindow;
import se.prediktera.map.plot.layout.AbstractPlotLayout;

public class SpectralPanel
extends ViewContainer {
    protected static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final BreezeButton compressReferencesButton;
    private final ReferenceContour reference100ContourWhite;
    private final ReferenceContour reference0ContourDark;
    private final BreezeButton extractReferenceFromImageButton;
    private MaxSignal maxsignal;
    private final ReferenceLineAverage whiteRefLinePlot;
    private final ReferenceLineAverage darkRefLinePlot;
    private final BreezeButton reflectanceTargetButton;
    private final BreezeButton copyReferenceButton;
    private Measurement measurement;
    private static final String darkWhiteTitle = "Dark and white reference";
    private final PlotViewPanel darkWhitePlot;
    private final CorrectedPanel correctedPanel = new CorrectedPanel(this);
    private final BreezeButton importReferenceButton;
    private SimpleImageViewPanel darkReferenceImage;
    private SimpleImageViewPanel whiteReferenceImage;

    public SpectralPanel(BreezeMainPanel breezeMainPanel) {
        super(breezeMainPanel, false);
        this.darkWhitePlot = new PlotViewPanel(breezeMainPanel, darkWhiteTitle, "Line", new String[]{"reference_100_line", "reference_0_line"}){

            @Override
            public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
                super.plotSetup(abstractPlotLayout);
                Properties properties = new Properties();
                properties.put("width", "5");
                abstractPlotLayout.setLine(new Object[]{"vector", properties});
                abstractPlotLayout.show("autorescale", Double.valueOf(0.0));
            }

            @Override
            public void dataUpdated(AbstractPlotLayout abstractPlotLayout, int n, boolean bl) {
                AbstractAxisLayer abstractAxisLayer = abstractPlotLayout.getLayer(Double.valueOf(2.0 - (double)n));
                if (abstractAxisLayer != null) {
                    abstractAxisLayer.setLayerVisible(bl);
                }
            }

            @Override
            public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
                super.postSetup(breezeProgressManager, abstractPlotLayout);
                abstractPlotLayout.setDataRange(new Object[]{"Y", "AVERAGE"});
                AbstractDataMatrix abstractDataMatrix = abstractPlotLayout.getPlotInit().getMatrix(0);
                if (SpectralPanel.this.maxsignal != null) {
                    double d = SpectralPanel.this.maxsignal.value;
                    abstractPlotLayout.show("ymin", Double.valueOf(-d * 0.05));
                    abstractPlotLayout.show("ymax", Double.valueOf(d * 1.05));
                }
                abstractPlotLayout.show("xmin", Double.valueOf((double)(-abstractDataMatrix.getK()) * 0.05));
                abstractPlotLayout.show("xmax", Double.valueOf((double)abstractDataMatrix.getK() * 1.05));
                abstractPlotLayout.getLayer(Double.valueOf(1.0)).setColor(new Object[]{"fixed", Color.black});
                abstractPlotLayout.getLayer(Double.valueOf(2.0)).setColor(new Object[]{"fixed", SpectralPanel.this.getWhiteReferenceColor()});
            }

            @Override
            public String[] getMatrixType() {
                String[] stringArray = super.getMatrixType();
                if (SpectralPanel.this.correctedPanel.isSelected()) {
                    return new String[]{stringArray[0] + "_reftarget", stringArray[1]};
                }
                return stringArray;
            }
        };
        this.addViewPanel((Component)((Object)this.darkWhitePlot), 0, 0, 1, 4);
        this.whiteRefLinePlot = new ReferenceLineAverage(breezeMainPanel, "White reference", "reference_100_line", this.getWhiteReferenceColor());
        this.addViewPanel((Component)((Object)this.whiteRefLinePlot), 1, 0, 1, 1);
        this.reference100ContourWhite = new ReferenceContour(breezeMainPanel, "reference_100_contour");
        this.addViewPanel((Component)((Object)this.reference100ContourWhite), 1, 1, 1, 1);
        this.reference100ContourWhite.getTitleLabel().setIcon(ImageHelper.getResourceIcon("error"));
        this.darkRefLinePlot = new ReferenceLineAverage(breezeMainPanel, "Dark reference", "reference_0_line", Color.black);
        this.addViewPanel((Component)((Object)this.darkRefLinePlot), 1, 2, 1, 1);
        this.reference0ContourDark = new ReferenceContour(breezeMainPanel, "reference_0_contour");
        this.addViewPanel((Component)((Object)this.reference0ContourDark), 1, 3, 1, 1);
        this.reference0ContourDark.getTitleLabel().setIcon(ImageHelper.getResourceIcon("error"));
        this.reflectanceTargetButton = SpectralPanel.createReflectanceTargetButton(breezeMainPanel);
        this.importReferenceButton = EntryMainHelper.createButton("importReference", "Import", "material/open_in_new", () -> SpectralPanel.importReference(breezeMainPanel, Measurement.getMeasurements(breezeMainPanel.getSelectedEntries()), WorkspaceManager.getWorkspaceFolder()));
        this.compressReferencesButton = EntryMainHelper.createButton("compress", "Reference averaging", "material/compress", () -> BreezeOptionDialog.showDialog(breezeMainPanel.getFrame(), breezeMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Store references raw data as average", "", (AbstractBreezeCustomPanel)this.getCompressMessage(), null, breezeActionEvent -> this.compressReferences()));
        this.extractReferenceFromImageButton = EntryMainHelper.createButton("extract", "Extract white reference", "material/ink_selection", () -> BreezeOptionDialog.showDialog(breezeMainPanel.getFrame(), breezeMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.WIZARD_OPTION, "", "", (AbstractBreezeCustomPanel)new WizardCustomPanel(new String[]{"Select white reference", "Set calibrated reflectance target"}, new CropImagePanel(this.measurement.getThumbnailFile(), InsetsPanel.InsetsType.WhiteReference), new ReflectanceTargetPanel(breezeMainPanel)), null, breezeActionEvent -> {
            final WizardCustomPanel wizardCustomPanel = (WizardCustomPanel)breezeActionEvent.getBreezeCustomPanel();
            BreezeProgressDialog.startProgressWithCancel(breezeMainPanel.getFrame(), new ProgressAction(this){
                final /* synthetic */ SpectralPanel this$0;
                {
                    this.this$0 = spectralPanel;
                }

                @Override
                public void runAction() {
                    CropImagePanel cropImagePanel = (CropImagePanel)wizardCustomPanel.getPanel(0);
                    RawHelper.extractWhite(this.this$0.measurement.rawFile().file(), new MeasurementFileLocation.WhiteRef().file(this.this$0.measurement), new MeasurementFileLocation.DarkRef().file(this.this$0.measurement), new int[]{cropImagePanel.top(), cropImagePanel.bottomPos(), cropImagePanel.left(), cropImagePanel.rightPos()});
                    this.this$0.measurement.clearCache();
                    ReflectanceTargetPanel reflectanceTargetPanel = (ReflectanceTargetPanel)wizardCustomPanel.getPanel(1);
                    reflectanceTargetPanel.perform(this.getProgressManager(), List.of(this.this$0.measurement));
                    this.this$0.measurement.clearCache();
                }
            }, "Extracting white reference");
        }));
        this.copyReferenceButton = EntryMainHelper.createButton("copyReference", "Copy references", "material/file_copy", () -> this.openCopyReferenceDialog(breezeMainPanel));
        this.copyReferenceButton.setToolTipText("Copy references to Breeze Runtime");
    }

    public static void importReference(final BreezeMainPanel breezeMainPanel, final List<Measurement> list, File file) {
        BreezeOptionDialog.showDialog(breezeMainPanel.getFrame(), breezeMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Import reference(s)", "", (AbstractBreezeCustomPanel)new ImportReferencePanel(breezeMainPanel, new FakeCamera.FakeCameraFromMeasurement(list.getFirst()), file), null, breezeActionEvent -> BreezeProgressDialog.startProgressWithCancel(breezeMainPanel.getFrame(), new ProgressAction(){

            @Override
            public void runAction() {
                ((ImportReferencePanel)breezeActionEvent.getBreezeCustomPanel()).doImportIntoMeasurements(this.getProgressManager(), list);
                breezeMainPanel.setDirty(true);
            }
        }, "Importing reference(s)"));
    }

    private void compressReferences() {
        final List<Measurement> list = Measurement.getMeasurements(this.getMainPanel().getSelectedEntries()).stream().filter(measurement -> !measurement.whiteReference().isCompressed() && !measurement.darkReference().isCompressed()).toList();
        if (list.isEmpty()) {
            throw new ErrorHandler.InformationMessageException("No measurement reference to create average from");
        }
        BreezeProgressDialog.startProgressWithCancel(this.getMainPanel().getFrame(), new ProgressAction(this){
            final /* synthetic */ SpectralPanel this$0;
            {
                this.this$0 = spectralPanel;
            }

            @Override
            public void runAction() {
                TcpManager.getInstance().transformData(this.getProgressManager(), list, Camera.TransformAlgorithm.CompressReferences, false, "", "", false);
            }

            @Override
            public void actionFinished() {
                DataSetCache.clearMeasurements(list);
                list.forEach(Measurement::clearFilesCache);
                this.this$0.getMainPanel().setDirty(true);
            }
        }, "Averaging references and storing data");
    }

    private void openCopyReferenceDialog(BreezeMainPanel breezeMainPanel) {
        if (!FileHelper.exists(this.measurement.darkReference().file()) || !FileHelper.exists(this.measurement.whiteReference().file())) {
            throw new ErrorHandler.WarningMessageException("Missing reference file(s)");
        }
        BreezeOptionDialog.showDialog(this.mainpanel, AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Confirm copy", "Do you want to copy dark and white references to the connected camera in Breeze Runtime?", breezeActionEvent -> new ConnectProgressAction.ConnectCamera(breezeMainPanel.getFrame(), HardwareRegistry.getInstance().getActiveCamera()){

            @Override
            public void afterConnection(BreezeProgress breezeProgress, Camera camera) {
                ReferenceHelper.setDarkReference(camera, SpectralPanel.this.measurement.darkReference().file(), SpectralPanel.this.measurement.getIntegrationTime());
                ReferenceHelper.setWhiteReference(camera, SpectralPanel.this.measurement.whiteReference().file(), SpectralPanel.this.measurement.getIntegrationTime());
                ToastHandler.getInstance().showToast(SpectralPanel.this.getFrame(), "References copied to Runtime");
            }
        });
    }

    private BreezeHtmlPanel getCompressMessage() {
        StringBuilder stringBuilder = new StringBuilder("<html>This action will calculate the average of all reference and only store the average value for each reference and create an image representation of the raw data");
        stringBuilder.append("<br/>");
        stringBuilder.append("<br/>");
        List<Measurement> list = Measurement.getMeasurements(this.getMainPanel().getSelectedEntries());
        if (list.stream().noneMatch(measurement -> FileHelper.exists(measurement.darkReference().file()) || FileHelper.exists(measurement.whiteReference().file()))) {
            return new BreezeHtmlPanel("No references"){

                @Override
                public void customButton(BreezeButton breezeButton, BreezeButton breezeButton2, BreezeButton breezeButton3) {
                    breezeButton2.setVisible(false);
                    breezeButton3.setText("Ok");
                }
            };
        }
        boolean bl = list.size() > 1;
        stringBuilder.append("<table border='1' cellpadding='5' cellspacing='0' bordercolor='#CCCCCC'>").append("<tr>");
        if (bl) {
            stringBuilder.append("<th>Measurement</th>");
        }
        stringBuilder.append("<th>Reference name</th>").append("<th>Original size</th>").append("<th>New size (estimated)</th>").append("</tr>");
        for (Measurement measurement2 : list) {
            String string;
            double d;
            boolean bl2 = FileHelper.exists(measurement2.darkReference().file());
            boolean bl3 = FileHelper.exists(measurement2.whiteReference().file());
            if (!bl2 && !bl3) {
                stringBuilder.append("<tr>");
                SpectralPanel.setRowMeasurementName(measurement2, bl, stringBuilder, true);
                stringBuilder.append("<td colspan=3 align='center'><i>No references</i></td></tr>");
                continue;
            }
            long l = (long)measurement2.rawFile().header().pixelWidth().value * 4L * (long)measurement2.rawFile().header().bandCount().value;
            if (bl2) {
                d = (double)(measurement2.rawFile().header().pixelWidth().value * measurement2.darkReference().header().frameCount().value * 4) * 0.55;
                string = FileUtils.byteCountToDisplaySize((long)(l + (long)d));
                stringBuilder.append("<tr>");
                SpectralPanel.setRowMeasurementName(measurement2, bl, stringBuilder, true);
                stringBuilder.append("<td>Dark reference</td>");
                if (measurement2.darkReference().isCompressed()) {
                    stringBuilder.append("<td colspan=2 align='center'><i>Already stored as average</i>");
                } else {
                    stringBuilder.append("<td>").append(FileUtils.byteCountToDisplaySize((long)measurement2.darkReference().file().length())).append("</td>").append("<td>").append(string);
                }
                stringBuilder.append("</td></tr>");
            }
            if (!bl3) continue;
            d = (double)(measurement2.rawFile().header().pixelWidth().value * measurement2.whiteReference().header().frameCount().value * 4) * 0.55;
            string = FileUtils.byteCountToDisplaySize((long)(l + (long)d));
            stringBuilder.append("<tr>");
            SpectralPanel.setRowMeasurementName(measurement2, bl, stringBuilder, false);
            stringBuilder.append("<td>White reference</td>");
            if (measurement2.whiteReference().isCompressed()) {
                stringBuilder.append("<td colspan=2 align='center'><i>Already stored as average</i>");
            } else {
                stringBuilder.append("<td>").append(FileUtils.byteCountToDisplaySize((long)measurement2.whiteReference().file().length())).append("</td>").append("<td>").append(string);
            }
            stringBuilder.append("</td></tr>");
        }
        stringBuilder.append("</table>");
        stringBuilder.append("<br/><br/>");
        stringBuilder.append("<b>This action cannot be undone</b>");
        stringBuilder.append("<br/><br/>");
        stringBuilder.append("<a href='").append("https://help.prediktera.com/breeze/reference-averaging").append("'>Click here to find out more</a>");
        stringBuilder.append("</html>");
        return new BreezeHtmlPanel(stringBuilder.toString()){

            @Override
            public void customButton(BreezeButton breezeButton, BreezeButton breezeButton2, BreezeButton breezeButton3) {
                breezeButton2.setText("Continue");
                breezeButton3.setText("Abort");
            }
        };
    }

    private static void setRowMeasurementName(Measurement measurement, boolean bl, StringBuilder stringBuilder, boolean bl2) {
        boolean bl3 = FileHelper.exists(measurement.darkReference().file());
        boolean bl4 = FileHelper.exists(measurement.whiteReference().file());
        if (bl) {
            if (bl3 && bl4 && bl2) {
                stringBuilder.append("<td rowspan=2>");
                stringBuilder.append(measurement.getName()).append("</td>");
            } else if (bl3 ^ bl4 || !bl3) {
                stringBuilder.append("<td>");
                stringBuilder.append(measurement.getName()).append("</td>");
            }
        }
    }

    public static BreezeButton createReflectanceTargetButton(BreezeMainPanel breezeMainPanel) {
        return EntryMainHelper.createButton("reflectanceTarget", "Reflectance target", "material/open_in_new", () -> SpectralPanel.applyReflectanceTargetOnMeasurements(breezeMainPanel, Measurement.getMeasurements(breezeMainPanel.getSelectedEntries())));
    }

    public static void applyReflectanceTargetOnMeasurements(BreezeMainPanel breezeMainPanel, List<Measurement> list) {
        BreezeOptionDialog.showDialog(breezeMainPanel.getFrame(), breezeMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.POPUP_OPTION, "Calibrated reflectance target", "", (AbstractBreezeCustomPanel)new ReflectanceTargetPanel(breezeMainPanel), null, breezeActionEvent -> ((ReflectanceTargetPanel)breezeActionEvent.getBreezeCustomPanel()).perform(list));
    }

    protected boolean isRuntime() {
        return false;
    }

    @Override
    public void addComponent(BreezeMainPanel breezeMainPanel) {
        super.addComponent(breezeMainPanel);
        if (!this.isRuntime()) {
            breezeMainPanel.addRightButton(this.importReferenceButton);
            breezeMainPanel.addRightButton(this.copyReferenceButton);
            breezeMainPanel.addRightButton(new BreezeSeparator(1));
            breezeMainPanel.addRightButton(this.compressReferencesButton);
            breezeMainPanel.addRightButton(this.extractReferenceFromImageButton);
            breezeMainPanel.addRightButton(new BreezeSeparator(1));
            breezeMainPanel.addRightButton(this.reflectanceTargetButton);
            breezeMainPanel.addRightButton(this.correctedPanel);
        }
    }

    private Color getWhiteReferenceColor() {
        if (BreezeTheme.getInstance().isDarkMode()) {
            return Color.white;
        }
        return RtPerfectSpread.generateColor(1);
    }

    @Override
    public void showEntry(Object object, Object object2) {
        super.showEntry(object, object2);
        this.measurement = Measurement.getMeasurement(object);
        this.maxsignal = MaxSignal.getDefaultIfNull(this.getMaxSignal(this.measurement));
        this.correctedPanel.showEntry(this.measurement);
        EvaluateResult evaluateResult = SpectralPanel.getWarning(object);
        if (evaluateResult != null) {
            this.reference100ContourWhite.setTitle(evaluateResult.getDescription() + " (colored white)");
        } else {
            this.reference100ContourWhite.setTitle("");
        }
        if (!this.isRuntime()) {
            this.setImagesForCompressedReferences();
        }
        this.updatePlotTitles();
    }

    private static EvaluateResult getWarning(Object object) {
        if (object instanceof Measurement) {
            Measurement measurement = (Measurement)object;
            return measurement.getWarningById("EM0005");
        }
        if (object instanceof SpectralReferences) {
            SpectralReferences spectralReferences = (SpectralReferences)object;
            ArrayList<EvaluateResult> arrayList = new ArrayList<EvaluateResult>();
            SpectralReference.addWarnings(spectralReferences.whiteReference, arrayList);
            return EvaluateResult.getWarningById(arrayList, "EM0005");
        }
        return null;
    }

    protected void updatePlotTitles() {
        this.updatePlotTile(this.getWhiteRefLinePlot(), this.measurement.whiteReference());
        this.updatePlotTile(this.getDarkRefLinePlot(), this.measurement.darkReference());
    }

    private void updatePlotTile(ReferenceLineAverage referenceLineAverage, SpectralReference spectralReference) {
        if (spectralReference != null && spectralReference.fileExists()) {
            referenceLineAverage.setTitle(referenceLineAverage.getOrigTitle() + "  (" + sdf.format(spectralReference.getDate()) + ")");
        } else {
            referenceLineAverage.setTitle(referenceLineAverage.getOrigTitle());
        }
    }

    private void setImagesForCompressedReferences() {
        if (this.darkReferenceImage != null) {
            this.removeViewPanel((Component)((Object)this.darkReferenceImage));
        }
        this.removeViewPanel((Component)((Object)this.reference0ContourDark));
        if (this.whiteReferenceImage != null) {
            this.removeViewPanel((Component)((Object)this.whiteReferenceImage));
        }
        this.removeViewPanel((Component)((Object)this.reference100ContourWhite));
        if (this.measurement == null) {
            this.repaint();
            return;
        }
        if (FileHelper.exists(this.measurement.whiteReference().thumbNailFile())) {
            this.whiteReferenceImage = new SimpleImageViewPanel(this.measurement.whiteReference().thumbNailFile());
            this.addViewPanel((Component)((Object)this.whiteReferenceImage), 1, 1, 1, 1);
        } else {
            this.addViewPanel((Component)((Object)this.reference100ContourWhite), 1, 1, 1, 1);
        }
        if (FileHelper.exists(this.measurement.darkReference().thumbNailFile())) {
            this.darkReferenceImage = new SimpleImageViewPanel(this.measurement.darkReference().thumbNailFile());
            this.addViewPanel((Component)((Object)this.darkReferenceImage), 1, 3, 1, 1);
        } else {
            this.addViewPanel((Component)((Object)this.reference0ContourDark), 1, 3, 1, 1);
        }
        this.repaint();
    }

    protected ReferenceLineAverage getWhiteRefLinePlot() {
        return this.whiteRefLinePlot;
    }

    protected ReferenceLineAverage getDarkRefLinePlot() {
        return this.darkRefLinePlot;
    }

    protected MaxSignal getMaxSignal(Measurement measurement) {
        if (measurement != null) {
            return measurement.getMaxSignal();
        }
        return null;
    }

    private static class CorrectedPanel
    extends JPanel {
        private final BreezeCheckBox checkBox;
        private final BreezeLabelField labelField;

        public CorrectedPanel(SpectralPanel spectralPanel) {
            super(new GridBagLayout());
            this.setOpaque(false);
            this.checkBox = new BreezeCheckBox("Visualize corrected reflectance target", false, bl -> {
                spectralPanel.darkWhitePlot.setTitle(SpectralPanel.darkWhiteTitle + (bl ? " (Corrected refl. target)" : ""));
                spectralPanel.getMainPanel().setDirty(true);
            });
            this.add((Component)this.checkBox, GridBagHelper.create(0, new Insets(0, 0, 0, 0)));
            this.labelField = new BreezeLabelField("Value:", 40, 0, "", 0, 17, 14);
            this.add((Component)this.labelField, GridBagHelper.create(1, new Insets(0, 32, 0, 0)));
        }

        public void showEntry(Measurement measurement) {
            StringBuilder stringBuilder = new StringBuilder();
            if (measurement != null) {
                RtReferenceTarget rtReferenceTarget = measurement.whiteReference().getReferenceTarget();
                if (rtReferenceTarget != null) {
                    stringBuilder.append(rtReferenceTarget.getAverage());
                    String string = measurement.getMetaProperties().getMetaValueNullIfMissing("ReflectanceTarget");
                    if (string != null) {
                        stringBuilder.append(" (");
                        stringBuilder.append(new File(string).getName());
                        stringBuilder.append(")");
                    }
                } else {
                    stringBuilder.append("None");
                }
            } else {
                stringBuilder.append("None");
            }
            this.labelField.setValue(stringBuilder.toString());
        }

        public boolean isSelected() {
            return this.checkBox.isSelected();
        }
    }

    protected static class ReferenceLineAverage
    extends PlotViewPanel {
        private final Color color;
        private final String origTitle;

        public ReferenceLineAverage(BreezeMainPanel breezeMainPanel, String string, String string2, Color color) {
            super((PPEntryMainInterface)breezeMainPanel, string, "Line", new String[]{string2});
            this.color = color;
            this.origTitle = string;
        }

        @Override
        public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
            super.plotSetup(abstractPlotLayout);
            Properties properties = new Properties();
            properties.put("width", "5");
            abstractPlotLayout.setLine(new Object[]{"vector", properties});
        }

        @Override
        public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
            super.postSetup(breezeProgressManager, abstractPlotLayout);
            abstractPlotLayout.setDataRange(new Object[]{"Y", "AVERAGE"});
            abstractPlotLayout.setColor(new Object[]{"fixed", this.color});
        }

        @Generated
        public String getOrigTitle() {
            return this.origTitle;
        }
    }

    private static class ReferenceContour
    extends PlotViewPanel {
        private final int reflectance;

        public ReferenceContour(BreezeMainPanel breezeMainPanel, String string) {
            super((PPEntryMainInterface)breezeMainPanel, "", "Contour2D", new String[]{string});
            this.getContentPanel().setBorder(BorderFactory.createLineBorder(BreezeTheme.getInstance().getLabelForeground()));
            String[] stringArray = string.split("_");
            this.reflectance = stringArray.length > 1 ? RtDataFormat.toNumberInt(stringArray[1]) : 0;
        }

        @Override
        public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
            super.plotSetup(abstractPlotLayout);
            Properties properties = new Properties();
            int[][] nArray = BreezeProperties.getInstance().getColorScale().create().createColorIndex(false);
            properties.setProperty("colorscheme", "[custom]");
            properties.setProperty("colors", "255");
            properties.setProperty("color1", "rgba(0,0,0,1)");
            for (int i = 1; i < 254; ++i) {
                properties.setProperty("color" + (i + 1), "rgba(" + nArray[i][0] + "," + nArray[i][1] + "," + nArray[i][2] + ",1)");
            }
            properties.setProperty("color255", "rgba(255,255,255,1)");
            properties.put("min", "0");
            properties.put("max", "100");
            abstractPlotLayout.setColor(new Object[]{"amplitude", properties});
            LegendWindow legendWindow = abstractPlotLayout.addLegend(new Object[]{"color", "right", properties});
            legendWindow.setDimension(Double.valueOf(10.0), Double.valueOf(100.0));
            legendWindow.setPosition(Double.valueOf(100.0), Double.valueOf(50.0));
            legendWindow.setTitleNoAutoText("Intensity");
            legendWindow.setDescription("");
            legendWindow.syPercent = 0.05;
            legendWindow.shPercent = 0.9;
            abstractPlotLayout.getLayer(Double.valueOf(1.0)).setLayerName((this.reflectance == 0 ? "Dark" : "White") + " reference intensity");
        }

        @Override
        public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
            super.postSetup(breezeProgressManager, abstractPlotLayout);
            ((Contour2D)abstractPlotLayout).getAxisPlot().setKeepAspectRatio(false);
            AbstractDataMatrix abstractDataMatrix = abstractPlotLayout.getInitMatrix(0);
            if (abstractDataMatrix != null) {
                abstractPlotLayout.setDataRange(new Object[]{"range", "matrix", (double)(abstractDataMatrix.getMatrixCount() / 2) + 1.0});
            }
        }

        @Override
        protected boolean supportChange() {
            return false;
        }

        @Override
        protected boolean foldImageData() {
            return false;
        }
    }

    public static class ReflectanceTargetPanel
    extends AbstractBreezeCustomPanel {
        private final BreezeMainPanel mainPanel;
        private final BreezeRadioButton fromFileRadioButton;
        private final HySpexCamera.CalibratedReflectanceTargetInputField calibratedReflectanceTargetInputField;
        private final BreezeInputField.Number fixedNumberInputField;

        public ReflectanceTargetPanel(BreezeMainPanel breezeMainPanel) {
            this.mainPanel = breezeMainPanel;
            this.setOpaque(false);
            this.setLayout(new GridBagLayout());
            ButtonGroup buttonGroup = new ButtonGroup();
            this.fromFileRadioButton = new BreezeRadioButton("From vector file", buttonGroup, true);
            this.add((Component)this.fromFileRadioButton, GridBagHelper.create(this.getComponentCount(), new Insets(20, 0, 0, 0)));
            this.calibratedReflectanceTargetInputField = new HySpexCamera.CalibratedReflectanceTargetInputField(breezeMainPanel, "");
            this.add((Component)this.calibratedReflectanceTargetInputField, GridBagHelper.create(this.getComponentCount(), new Insets(20, 20, 0, 0)));
            this.fromFileRadioButton.setCallback((breezeRadioButton, bl) -> this.setFromFile(bl));
            this.add((Component)new BreezeRadioButton("From scalar value (1 = 100% white)", buttonGroup, false, (breezeRadioButton, bl) -> this.setFromFile(!bl)), GridBagHelper.create(this.getComponentCount(), new Insets(20, 0, 0, 0)));
            this.fixedNumberInputField = new BreezeInputField.Number("", 1.0, " ");
            this.fixedNumberInputField.setUnitLabelWidth(100);
            this.add((Component)this.fixedNumberInputField, GridBagHelper.createLast(this.getComponentCount(), new Insets(20, 20, 0, 0)));
            this.setFromFile(true);
            this.setPreferredSize(new Dimension(600, 600));
        }

        private void setFromFile(boolean bl) {
            this.calibratedReflectanceTargetInputField.setEditable(bl);
            this.fixedNumberInputField.setEnabled(!bl);
        }

        public void perform(final List<Measurement> list) {
            BreezeProgressDialog.startProgressWithCancel(this.mainPanel.getFrame(), new ProgressAction(this){
                final /* synthetic */ ReflectanceTargetPanel this$0;
                {
                    this.this$0 = reflectanceTargetPanel;
                }

                @Override
                public void runAction() {
                    this.this$0.perform(this.getProgressManager(), list);
                }
            }, "Updating calibrated reflectance target");
        }

        public void perform(BreezeProgressManager breezeProgressManager, List<Measurement> list) {
            int n = breezeProgressManager.setGroupMaximumAndReset(list.size());
            for (Measurement measurement : list) {
                breezeProgressManager.setInfoText("Measurement: " + measurement.getName());
                SpectralReference.WhiteReference whiteReference = measurement.whiteReference();
                if (!FileHelper.exists(whiteReference.file())) {
                    breezeProgressManager.incStepGroup(n);
                    continue;
                }
                RawHeader rawHeader = whiteReference.header();
                CalibratedReflectanceTargetList calibratedReflectanceTargetList = null;
                if (this.fromFileRadioButton.isSelected()) {
                    if (this.calibratedReflectanceTargetInputField.hasValue()) {
                        File file = this.calibratedReflectanceTargetInputField.getFile();
                        if (!file.exists()) {
                            throw new RuntimeException("Cannot locate calibrated reflectance target file: " + file.getAbsolutePath());
                        }
                        measurement.getMetaProperties().addProperty("ReflectanceTarget", file.getAbsolutePath());
                        calibratedReflectanceTargetList = CalibratedReflectanceTargetList.fromTargetFile(file);
                    }
                } else {
                    calibratedReflectanceTargetList = new CalibratedReflectanceTargetList();
                    calibratedReflectanceTargetList.add(0, this.fixedNumberInputField.getNumberFloat());
                    measurement.getMetaProperties().removeProperty("ReflectanceTarget");
                }
                measurement.save();
                rawHeader.readIfNeeded();
                if (calibratedReflectanceTargetList != null) {
                    rawHeader.setReferenceTarget(calibratedReflectanceTargetList.getReferenceTarget(rawHeader.bandNames()));
                } else {
                    rawHeader.setReferenceTarget(null);
                }
                rawHeader.save();
                ThumbnailManager.deleteAndRemoveMeasurementImageFromCache(measurement);
                PixelDataHelper.clearSpectralMatrixCache();
                DataSetCache.clearParents(measurement);
                breezeProgressManager.incStepGroup(n);
            }
            ApplyChanges.applyChanges(breezeProgressManager, list, true);
            this.mainPanel.repaintEntryList();
            this.mainPanel.setDirty(true);
        }

        @Override
        public Object getResult() {
            return null;
        }

        @Override
        public boolean usePreferredSize() {
            return true;
        }
    }
}

