/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.record.measurement.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanelInterface;
import se.prediktera.breeze.frontend.common.pp.DefaultSettingsPanel;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.swing.table.BreezeIntervalClass;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTableActions;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectWavelengthPanelStep;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBoolean;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.datainfo.VariablesInfo;
import se.prediktera.map.datasetcontainer.dataset.DataSet;

public class WavelengthSettingsPanel
extends DefaultSettingsPanel
implements SelectWavelengthPanelStep.ImportanceValue.WavelengthImportanceCallback {
    private final BreezeTablePanel wavelengthTablePanel = new BreezeTablePanel();
    private DataSet dataSet;
    private ArrayList<SelectWavelengthPanelStep.WavelengthClass> wList;

    public WavelengthSettingsPanel(final EntryMainPanelInterface entryMainPanelInterface) {
        super(300, true);
        DefaultSettingsPanel.SectionPanel sectionPanel = this.addSection("Wavelengths");
        sectionPanel.addComponent(EntryMainHelper.createButton("Include", "explore/library_add", () -> this.changeIncluded(true, false)));
        sectionPanel.addComponent(EntryMainHelper.createButton("Include Only", "explore/add_box", () -> this.changeIncluded(true, true)));
        sectionPanel.addComponent(EntryMainHelper.createButton("Exclude", "explore/disabled_by_default", () -> this.changeIncluded(false, false)));
        sectionPanel.addComponentLast(EntryMainHelper.createApplyButton(entryMainPanelInterface, new ProgressAction(this){
            final /* synthetic */ WavelengthSettingsPanel this$0;
            {
                this.this$0 = wavelengthSettingsPanel;
            }

            @Override
            public void runAction() throws Exception {
                if (this.this$0.dataSet != null) {
                    VariablesInfo variablesInfo = this.this$0.dataSet.getVarDataInfo();
                    InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)variablesInfo.getPrimaryColumnByType(1);
                    for (int i = 0; i < this.this$0.wList.size(); ++i) {
                        innerColumnBoolean.setValueBool(this.this$0.wList.get(i).getIndex(), this.this$0.wList.get(i).isIncluded());
                    }
                    this.this$0.dataSet.updateReferences((ProgressManager)this.getProgressManager(), true);
                    this.this$0.dataSet.applyChanges((ProgressManager)this.getProgressManager());
                    entryMainPanelInterface.setDirty(true);
                }
            }
        }));
        BreezeTable breezeTable = this.wavelengthTablePanel.getTable();
        breezeTable.setSelectionMode(2);
        this.wavelengthTablePanel.initTable(new SelectWavelengthPanelStep.WavelengthTableModel(false, this), null, false);
        this.wavelengthTablePanel.setSortable(true);
        this.wavelengthTablePanel.addRowHeader(60, 14);
        this.wavelengthTablePanel.addIntervalListener(new int[]{0}, () -> {});
        this.wavelengthTablePanel.getScrollPane().setHorizontalScrollBarPolicy(31);
        this.wavelengthTablePanel.setRowHeight(30);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                int n = WavelengthSettingsPanel.this.getWidth();
                if (n > 100) {
                    WavelengthSettingsPanel.this.wavelengthTablePanel.setPreferredSize(new Dimension(n - 30, 0));
                    WavelengthSettingsPanel.this.wavelengthTablePanel.revalidate();
                    WavelengthSettingsPanel.this.wavelengthTablePanel.repaint();
                }
            }
        });
        int n = this.contentPanel.getComponentCount();
        this.contentPanel.add((Component)((Object)this.wavelengthTablePanel), GridBagHelper.createLast(n, new Insets(2, 5, 0, 0)));
        breezeTable.addMouseListener(new TableCellPopupAdapter(entryMainPanelInterface.getFrame(), this.wavelengthTablePanel));
    }

    @Override
    public String getDescription() {
        return "Wavelengths";
    }

    private void changeIncluded(boolean bl, boolean bl2) {
        if (bl2) {
            BreezeTable breezeTable = this.wavelengthTablePanel.getTable();
            for (int i = 0; i < ((JTable)((Object)breezeTable)).getRowCount(); ++i) {
                ((BreezeIntervalClass)((JTable)((Object)breezeTable)).getValueAt(i, 0)).setIncluded(false);
            }
        }
        for (Object e : this.wavelengthTablePanel.getSelectedValues()) {
            ((BreezeIntervalClass)e).setIncluded(bl);
        }
        this.wavelengthTablePanel.repaint();
    }

    public void setDataSet(DataSet dataSet) {
        if (this.dataSet != dataSet) {
            this.dataSet = dataSet;
            this.wList = new ArrayList();
            if (dataSet != null) {
                VariablesInfo variablesInfo = dataSet.getVarDataInfo();
                InnerColumnString innerColumnString = (InnerColumnString)variablesInfo.getPrimaryColumnByType(0);
                InnerColumnBoolean innerColumnBoolean = (InnerColumnBoolean)variablesInfo.getPrimaryColumnByType(1);
                for (int i = 0; i < innerColumnString.getSize(); ++i) {
                    String string = innerColumnString.getValueLocal(i);
                    if (RtDataFormat.isNumber(string)) {
                        string = RtDataFormat.toString(RtDataFormat.toNumber(string));
                    }
                    SelectWavelengthPanelStep.WavelengthClass wavelengthClass = new SelectWavelengthPanelStep.WavelengthClass(string, i);
                    wavelengthClass.setIncluded(innerColumnBoolean.getValueBool(i));
                    this.wList.add(wavelengthClass);
                }
            }
            this.wavelengthTablePanel.setTableList(this.wList, this.wList.isEmpty() ? null : this.wList.get(0), true);
        }
    }

    @Override
    public float getValue(int n) {
        return 0.0f;
    }

    public static class TableCellPopupAdapter
    extends MouseAdapter {
        private final BreezeFrame frame;
        private final BreezeTable table;
        private final BreezeTableActions actions;

        public TableCellPopupAdapter(BreezeFrame breezeFrame, BreezeTablePanel breezeTablePanel) {
            this.frame = breezeFrame;
            this.table = breezeTablePanel.getTable();
            this.actions = new BreezeTableActions((JTable)((Object)this.table), true, true);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                BreezeContextMenu breezeContextMenu2 = new BreezeContextMenu(this.frame, Color.red);
                breezeContextMenu2.addSubMenu("Select", breezeContextMenu -> breezeContextMenu.addButtonCloseClick("Water absorption wavelengths", () -> this.table.setSelectedRows(TableCellPopupAdapter.getSelectedRowsWithinRanges((JTable)((Object)this.table)))));
                if (this.actions != null) {
                    this.actions.addToPopupMenu(breezeContextMenu2);
                }
                if (breezeContextMenu2.resize()) {
                    this.frame.addPage((JPanel)((Object)breezeContextMenu2));
                    breezeContextMenu2.setPositionLater(mouseEvent);
                }
            }
        }

        public static List<Integer> getSelectedRowsWithinRanges(JTable jTable) {
            int n2 = jTable.getRowCount();
            BandNames bandNames = new BandNames(new String[0]);
            for (int i = 0; i < n2; ++i) {
                bandNames.add(((SelectWavelengthPanelStep.WavelengthClass)jTable.getValueAt((int)i, (int)0)).name);
            }
            boolean[] blArray = bandNames.getWaterAbsoptionIndexes();
            return IntStream.range(0, blArray.length).filter(n -> blArray[n]).boxed().collect(Collectors.toList());
        }
    }
}

