/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.record.panel;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import se.prediktera.breeze.backend.measure.applychanges.ApplyChanges;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNodeList;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.segmentation.SegmentationMatrix;
import se.prediktera.breeze.common.realtime.segmentation.spatial.ManualSegmentation;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.image.RtObjectIdentificationHelper;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SampleHelper;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.DefaultSettingsPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeLabelField;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.swing.table.BreezeInteractionTable;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanelInterface;
import se.prediktera.breeze.frontend.common.swing.table.renderer.BreezeTableCellRenderer;
import se.prediktera.breeze.frontend.main.play.edit.FunctionPropertyPanel;
import se.prediktera.breeze.frontend.main.record.measurement.panel.MeasurementTableModel;
import se.prediktera.breeze.frontend.main.record.panel.MeasurementTableInteraction;
import se.prediktera.breeze.frontend.main.record.panel.SelectClassPanel;
import se.prediktera.breeze.frontend.main.record.panel.SelectHelper;
import se.prediktera.breeze.frontend.main.record.panel.SelectIntervalPanel;
import se.prediktera.breeze.frontend.main.record.panel.SelectRandomPanel;
import se.prediktera.breeze.frontend.main.record.panel.SelectValuePanel;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;

public class EditMeasurementTableInteraction
extends MeasurementTableInteraction {
    private final TableSettingsPanel tableSettingsPanel;

    public EditMeasurementTableInteraction(EntryMainPanel entryMainPanel, Workflow workflow) {
        super(entryMainPanel, workflow, true, true, true);
        this.tableSettingsPanel = new TableSettingsPanel(entryMainPanel);
        this.setRightSettingsPanel(this.tableSettingsPanel);
    }

    @Override
    public void showEntry(final Object object, Object object2) {
        super.showEntry(object, object2);
        ThreadUtil.runAfterConditionIsMet(new ThreadUtil.RunAfterConditionIsMetCallback(){
            final /* synthetic */ EditMeasurementTableInteraction this$0;
            {
                this.this$0 = editMeasurementTableInteraction;
            }

            @Override
            public boolean conditionIsMet() {
                return this.this$0.contentReady();
            }

            @Override
            public void actionToRun() {
                SwingUtilities.invokeLater(() -> this.this$0.tableSettingsPanel.update(this.this$0.getInnerTable(), object));
            }
        });
    }

    private BreezeTablePanel getInnerTable() {
        BreezeInteractionTable breezeInteractionTable = this.getTable();
        if (breezeInteractionTable != null) {
            return breezeInteractionTable.getInnerTable();
        }
        return null;
    }

    @Override
    public void applyChangesOnPanel(BreezeProgressManager breezeProgressManager) {
        ApplyChanges.applyChanges((BreezeProgress)breezeProgressManager, Measurement.getMeasurements(this.entrydata));
        this.mainpanel.setDirty(true);
    }

    @Override
    public int getSegmentationLevel() {
        Workflow workflow = Workflow.getWorkflow(this.entrydata);
        if (workflow != null) {
            return workflow.getSegmentationLevel();
        }
        return 0;
    }

    public static class TableSettingsPanel
    extends DefaultSettingsPanel {
        private final DefaultSettingsPanel.SectionCollapsePanel segmentationSection;
        private BreezeTablePanel tablePanel;
        private final EntryMainPanel mainPanel;
        private Object entrydata;
        private BreezeLabelField rowsLabel;
        private BreezeLabelField columnsLabel;
        private BreezeLabelField selectedLabel;

        public TableSettingsPanel(EntryMainPanel entryMainPanel) {
            super(300, false);
            this.mainPanel = entryMainPanel;
            DefaultSettingsPanel.SectionCollapsePanel sectionCollapsePanel = this.addCollapseSection("Information", false);
            this.rowsLabel = new BreezeLabelField("Rows", 80, "0", 0);
            sectionCollapsePanel.addComponentHorizontal(this.rowsLabel, 2);
            this.columnsLabel = new BreezeLabelField("Columns", 80, "0", 0);
            sectionCollapsePanel.addComponentHorizontal(this.columnsLabel, 2);
            this.selectedLabel = new BreezeLabelField("Selected", 80, "0", 0);
            sectionCollapsePanel.addComponentHorizontal(this.selectedLabel, 2);
            DefaultSettingsPanel.SectionCollapsePanel sectionCollapsePanel2 = this.addCollapseSection("Selection", false);
            sectionCollapsePanel2.addComponent(EntryMainHelper.createButton("By interval", "selectby/Select_By_Interval", () -> TableSettingsPanel.selectByInterval(entryMainPanel, this.tablePanel)));
            sectionCollapsePanel2.addComponent(EntryMainHelper.createButton("By class", "selectby/Select_By_Class", () -> TableSettingsPanel.selectByClass(entryMainPanel, this.tablePanel, Workflow.getWorkflow(this.entrydata))));
            sectionCollapsePanel2.addComponentLast(EntryMainHelper.createButton("By value", "selectby/Select_By_Value", () -> TableSettingsPanel.selectByValue(entryMainPanel, this.tablePanel, Workflow.getWorkflow(this.entrydata))));
            this.segmentationSection = this.addCollapseSection("Segmentation", false);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    this.updateSections();
                }
            });
        }

        public void update(BreezeTablePanel breezeTablePanel, Object object) {
            this.entrydata = object;
            if (this.tablePanel != breezeTablePanel) {
                this.tablePanel = breezeTablePanel;
                final BreezeTable breezeTable = breezeTablePanel.getTable();
                BreezeTablePanelInterface breezeTablePanelInterface = breezeTablePanel.getTablePanel();
                if (breezeTablePanelInterface instanceof MeasurementTableModel) {
                    MeasurementTableModel measurementTableModel = (MeasurementTableModel)breezeTablePanelInterface;
                    measurementTableModel.setTableUpdatedCallback(() -> this.updateTableInfo(breezeTable));
                }
                this.updateTableInfo(breezeTable);
                breezeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
                    final /* synthetic */ TableSettingsPanel this$0;
                    {
                        this.this$0 = tableSettingsPanel;
                    }

                    @Override
                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        this.this$0.selectedLabel.setValue(breezeTable.getSelectedRowCount());
                    }
                });
            }
            this.updateSections();
        }

        private void updateTableInfo(BreezeTable breezeTable) {
            this.rowsLabel.setValue(breezeTable.getRowCount());
            this.columnsLabel.setValue(breezeTable.getColumnCount());
            this.selectedLabel.setValue(breezeTable.getSelectedRowCount());
        }

        public void updateSections() {
            if (this.getWidth() == 0) {
                return;
            }
            Workflow workflow = Workflow.getWorkflow(this.entrydata);
            this.segmentationSection.clear();
            if (workflow != null) {
                if (workflow.getSegmentationLevel() == 0) {
                    this.addSegmentation(this.tablePanel, workflow, workflow.getRoot());
                }
                SegmentationNodeList segmentationNodeList = workflow.getSegmentationNodes();
                for (SegmentationNode segmentationNode : segmentationNodeList) {
                    this.addSegmentation(this.tablePanel, workflow, segmentationNode);
                }
            }
            this.segmentationSection.update();
            this.repaint();
        }

        private void addSegmentation(BreezeTablePanel breezeTablePanel, Workflow workflow, FunctionTreeNode functionTreeNode) {
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setOpaque(false);
            GridBagConstraints gridBagConstraints = GridBagHelper.createLeft(0, new Insets(0, 0, 0, 0));
            gridBagConstraints.fill = 2;
            BreezeLabel breezeLabel = new BreezeLabel("", true);
            breezeLabel.setAbbreviatedText(functionTreeNode.getAliasOrNodeString(), (int)((double)this.segmentationSection.getWidth() * 0.75));
            jPanel.add((Component)breezeLabel, gridBagConstraints);
            this.segmentationSection.addComponentHorizontal(jPanel);
            BreezeButton breezeButton = EntryMainHelper.createButton("", "help", () -> AbstractBreezeFunctionInfo.showHelpOnline(functionTreeNode.getFunction().getInfo()));
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.anchor = 13;
            jPanel.add((Component)breezeButton, gridBagConstraints2);
            this.segmentationSection.addComponentHorizontal(new FunctionPropertyPanel(this.mainPanel.getFrame(), workflow, workflow, functionTreeNode, bl -> {
                workflow.save();
                workflow.setApplyChangesNeededOnAllMeasurements();
                this.mainPanel.repaintEntryList();
            }, BreezeInputFieldHelper.Format.TwoRows));
            if (functionTreeNode instanceof SegmentationNode) {
                SegmentationNode segmentationNode = (SegmentationNode)functionTreeNode;
                if (breezeTablePanel != null) {
                    Measurement measurement;
                    Object object;
                    this.segmentationSection.addComponentHorizontal(new BreezeLabel("Samples"));
                    this.segmentationSection.addComponentHorizontal(new JSeparator(), 5);
                    JPanel jPanel2 = new JPanel(new FlowLayout(0, 20, 5));
                    jPanel2.setOpaque(false);
                    if (functionTreeNode.getFunction() instanceof ManualSegmentation && (object = this.entrydata) instanceof Measurement) {
                        measurement = (Measurement)object;
                        jPanel2.add(EntryMainHelper.createButton("Add", "material/add", () -> TableSettingsPanel.addSamples(this.mainPanel, breezeTablePanel, segmentationNode, measurement.getRootSample(), measurement)));
                    }
                    jPanel2.add(EntryMainHelper.createButton("Remove selected", "material/delete", () -> TableSettingsPanel.deleteSelectedSamples(this.mainPanel, breezeTablePanel)));
                    object = this.entrydata;
                    if (object instanceof Measurement) {
                        measurement = (Measurement)object;
                        jPanel2.add(EntryMainHelper.createButton("Save", "file_save", () -> TableSettingsPanel.savePixelMask(this.mainPanel, breezeTablePanel, measurement)));
                    }
                    this.segmentationSection.addComponentHorizontal(jPanel2);
                }
            }
        }

        public static void selectByInterval(BreezeMainPanel breezeMainPanel, BreezeTablePanel breezeTablePanel) {
            BreezeOptionDialog.showDialog(breezeMainPanel.getFrame(), breezeMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.CONFIRM_INFORMATION_OPTION, "Selection by interval", "", (AbstractBreezeCustomPanel)new SelectIntervalPanel(), null, breezeActionEvent -> ((SelectIntervalPanel)breezeActionEvent.getBreezeCustomPanel()).apply(breezeTablePanel.getTable()));
        }

        public static void selectByClass(BreezeMainPanel breezeMainPanel, BreezeTablePanel breezeTablePanel, Workflow workflow) {
            BreezeOptionDialog.showDialog(breezeMainPanel.getFrame(), breezeMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.CONFIRM_INFORMATION_OPTION, "Selection by class", "", (AbstractBreezeCustomPanel)new SelectClassPanel(workflow), null, breezeActionEvent -> ((SelectClassPanel)breezeActionEvent.getBreezeCustomPanel()).apply(breezeTablePanel.getTable()));
        }

        public static void selectByValue(BreezeMainPanel breezeMainPanel, BreezeTablePanel breezeTablePanel, Workflow workflow) {
            BreezeOptionDialog.showDialog(breezeMainPanel.getFrame(), breezeMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.CONFIRM_INFORMATION_OPTION, "Selection by value", "", (AbstractBreezeCustomPanel)new SelectValuePanel(workflow), null, breezeActionEvent -> ((SelectValuePanel)breezeActionEvent.getBreezeCustomPanel()).apply(breezeTablePanel.getTable()));
        }

        public static void selectByRandom(BreezeMainPanel breezeMainPanel, BreezeTablePanel breezeTablePanel) {
            BreezeOptionDialog.showDialog(breezeMainPanel.getFrame(), breezeMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.CONFIRM_INFORMATION_OPTION, "Selection by random", "", (AbstractBreezeCustomPanel)new SelectRandomPanel(), null, breezeActionEvent -> ((SelectRandomPanel)breezeActionEvent.getBreezeCustomPanel()).apply(breezeTablePanel.getTable()));
        }

        public static void selectIncExc(BreezeMainPanel breezeMainPanel, final BreezeTablePanel breezeTablePanel, final boolean bl) {
            BreezeProgressDialog.startProgress(breezeMainPanel.getFrame(), new ProgressAction(){

                @Override
                public void runAction() {
                    BreezeTable breezeTable = breezeTablePanel.getTable();
                    List<Integer> list = SelectHelper.get(breezeTable, bl);
                    SelectHelper.select(breezeTable, list);
                }
            }, "Selecting");
        }

        public static void addSamples(EntryMainPanel entryMainPanel, BreezeTablePanel breezeTablePanel, SegmentationNode segmentationNode, Sample sample, Measurement measurement) {
            jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Select pixel masks", (Component)entryMainPanel);
            jopensaveDialog2.addExtension(new String[]{"txt", "csv"}, "CSV and txt files");
            jopensaveDialog2.addAllSupported();
            jopensaveDialog2.setMultiSelectionEnabled(true);
            if (jopensaveDialog2.openshow()) {
                for (File file : jopensaveDialog2.getSelectedFiles()) {
                    List<SegmentationMatrix> list = SampleHelper.readBooleanMatrixFromFile(file, null, measurement.rawFile().header().pixelWidth().value);
                    for (SegmentationMatrix segmentationMatrix : list) {
                        RtObjectIdentificationHelper.RtIdentifiedObjectList rtIdentifiedObjectList = SampleHelper.getAreas(segmentationMatrix, false);
                        SampleHelper.addSamples(measurement, sample, null, segmentationNode, 1, rtIdentifiedObjectList.getList());
                    }
                }
                measurement.save();
                entryMainPanel.setDirty(true);
            }
        }

        public static void deleteSelectedSamples(BreezeMainPanel breezeMainPanel, BreezeTablePanel breezeTablePanel) {
            BreezeOptionDialog.showDialog(breezeMainPanel.getFrame(), breezeMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Confirm delete", "Are you sure that you want to delete the selected Sample(s)?", null, breezeActionEvent -> TableSettingsPanel.withSamples(breezeMainPanel, breezeTablePanel, list -> list.forEach(sample -> {
                BasicSample basicSample = sample.getParent();
                if (basicSample != null) {
                    basicSample.removeChild((BasicSample)sample);
                }
            }), null));
        }

        public static void deleteSelectedMeasurement(BreezeMainPanel breezeMainPanel, BreezeTablePanel breezeTablePanel) {
            List<Measurement> list = TableSettingsPanel.getSelectedMeasurements(breezeTablePanel);
            BreezeOptionDialog.showDialog(breezeMainPanel.getFrame(), breezeMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Confirm delete", "Are you sure that you want to delete the selected (" + list.size() + ") Measurement(s)?", null, breezeActionEvent -> {
                for (Measurement measurement : list) {
                    DataSetCache.clearParents(measurement);
                    measurement.delete(true);
                    measurement.getParent().removeChild(measurement);
                }
                breezeMainPanel.setDirty(true);
            });
        }

        public static List<Measurement> getSelectedMeasurements(BreezeTablePanel breezeTablePanel) {
            HashSet<Measurement> hashSet = new HashSet<Measurement>();
            for (Object e : breezeTablePanel.getSelectedValues()) {
                if (!(e instanceof Sample)) continue;
                Sample sample = (Sample)e;
                hashSet.add(sample.measurement());
            }
            return new ArrayList<Measurement>(hashSet);
        }

        public static void withSamples(BreezeMainPanel breezeMainPanel, BreezeTablePanel breezeTablePanel, WithSampleCallback withSampleCallback, BreezeProgressManager breezeProgressManager) {
            HashSet<Measurement> hashSet = new HashSet<Measurement>();
            ArrayList<Sample> arrayList = new ArrayList<Sample>();
            for (Object object : breezeTablePanel.getSelectedValues()) {
                if (!(object instanceof Sample)) continue;
                Sample sample = (Sample)object;
                hashSet.add(sample.measurement());
                arrayList.add(sample);
            }
            withSampleCallback.withSample(arrayList);
            for (Measurement measurement : hashSet) {
                DataSetCache.clearParents(measurement);
                measurement.save();
            }
            if (breezeProgressManager != null) {
                ApplyChanges.applyChanges((BreezeProgress)breezeProgressManager, new ArrayList<Measurement>(hashSet));
            }
            breezeMainPanel.setDirty(true);
        }

        public static void savePixelMask(EntryMainPanel entryMainPanel, BreezeTablePanel breezeTablePanel, Measurement measurement) {
            jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Save pixel mask", (Component)entryMainPanel);
            jopensaveDialog2.addExtension(new String[]{"txt", "csv"}, "CSV and txt files");
            jopensaveDialog2.addAllSupported();
            jopensaveDialog2.setFileName(measurement.getName() + "_PixelMask.csv");
            if (jopensaveDialog2.saveshow()) {
                ArrayList<Sample> arrayList = new ArrayList<Sample>();
                for (int i = 0; i < breezeTablePanel.getTable().getRowCount(); ++i) {
                    arrayList.add(BreezeTableCellRenderer.getSampleAt((JTable)((Object)breezeTablePanel.getTable()), i));
                }
                SampleHelper.fromSamples(measurement, arrayList).save(jopensaveDialog2.getSelectedFile());
            }
        }

        public static interface WithSampleCallback {
            public void withSample(List<Sample> var1);
        }
    }
}

