/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.record.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.swing.DefaultComboBoxModel;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.ThingWithName;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.realtime.RtModule;
import se.prediktera.breeze.common.realtime.unmixing.SelectMembersPanel;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.evince.EvinceHelper;
import se.prediktera.breeze.evince.datasource.MeasurementDataSource;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntrySettingsPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeTextField;
import se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.swing.table.SegmentationPanel;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.common.view.ViewPanelCustomPanel;
import se.prediktera.breeze.frontend.common.view.preview.InteractionPreviewPanel;
import se.prediktera.breeze.frontend.common.view.visualization.PlotSettingsPanel;
import se.prediktera.breeze.frontend.common.view.visualization.PlotViewPanel;
import se.prediktera.breeze.frontend.main.record.measurement.panel.PixelExploreInterface;
import se.prediktera.breeze.frontend.main.record.measurement.panel.PixelExplorePanel;
import se.prediktera.breeze.frontend.main.record.panel.GroupPlotPanel;
import se.prediktera.breeze.frontend.main.record.panel.MeasurementTableInteraction;
import se.prediktera.breeze.frontend.wizard.model.panel.CurveSeparationPanelStep;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.swing.ComboItem;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.plot.AbstractPlot;
import se.prediktera.map.plot.PlotPopupMenu;
import se.prediktera.map.plot.axisplot.plot2D.quickspectral.QuickSpectral;
import se.prediktera.map.plot.axisplot.plot2D.quickspectral.QuickSpectralLayer;
import se.prediktera.map.plot.axisplot.windows.LegendWindow;
import se.prediktera.map.plot.layout.AbstractPlotLayout;
import se.prediktera.map.register.RegInfo;

public class GroupExplorePanel
extends ViewContainer
implements PixelExploreInterface {
    private final CurveSeparationPanelStep.CurveSeparationScatterPlots xRayPanel;
    private final PlotViewPanel spectralPlot;
    private final PlotViewPanel viewPanel;
    private ThingWithName entrydata;
    private final InteractionPreviewPanel previewPanel;
    private final PlotSettingsPanel plotSettingsPanel;
    private final PixelExploreInterface.ComponentSectionPanel componentSectionPanel;
    private SegmentationPanel segmentationPanel;
    private Measurement measurement;

    public GroupExplorePanel(BreezeProgress breezeProgress, EntryMainPanel entryMainPanel, Workflow workflow) {
        super(entryMainPanel, false);
        this.xRayPanel = new CurveSeparationPanelStep.CurveSeparationScatterPlots(entryMainPanel, true);
        this.addViewPanel((Component)((Object)this.xRayPanel), 0, 0, 1, 2);
        this.spectralPlot = new PixelExploreInterface.SpectralPlotViewPanel(entryMainPanel, this);
        this.addViewPanel((Component)((Object)this.spectralPlot), 0, 0, 1, 1, null, 1.0, 1.0);
        this.viewPanel = new PlotViewPanel(entryMainPanel, "Explore Measurements", "Scatter2D", "model"){

            @Override
            public void plotSetup(AbstractPlotLayout abstractPlotLayout) {
                super.plotSetup(abstractPlotLayout);
                LegendWindow legendWindow = abstractPlotLayout.addLegend(new Object[]{"color", "right", new Properties()});
                legendWindow.setRelativeSize(0.1, 0.6);
                legendWindow.setRelativePosition(0.85, 0.2);
                abstractPlotLayout.getLayer(Double.valueOf(1.0)).setLayerName("Samples");
            }

            @Override
            public void postSetup(BreezeProgressManager breezeProgressManager, AbstractPlotLayout abstractPlotLayout) {
                super.postSetup(breezeProgressManager, abstractPlotLayout);
                GroupExplorePanel.checkAxis(abstractPlotLayout, GroupExplorePanel.this.componentSectionPanel.updateComponents());
            }

            @Override
            public void addCustomMenuItems(AbstractPlotLayout abstractPlotLayout, BreezeContextMenu breezeContextMenu) {
                PixelExploreInterface.addIncludeExcludeToMenu(this, breezeContextMenu);
                super.addCustomMenuItems(abstractPlotLayout, breezeContextMenu);
                Factor factor = GroupExplorePanel.this.plotSettingsPanel.getSelectedFactor();
                if (GroupExplorePanel.this.entrydata != null && factor != null) {
                    breezeContextMenu.addComponent(new BreezeLabel(factor.toString()));
                    if (factor instanceof PropertyFactor) {
                        BreezeTextField breezeTextField = new BreezeTextField();
                        breezeTextField.setText("");
                        breezeTextField.setNumberField(true);
                        breezeTextField.addChangeListener(textActionEvent -> GroupExplorePanel.this.onInputChange(breezeContextMenu, abstractPlotLayout, factor, textActionEvent, textActionEvent.isFocusLost()));
                        breezeTextField.requestFocus();
                        breezeContextMenu.addComponent(breezeTextField);
                    } else {
                        CategoryFactor categoryFactor = (CategoryFactor)factor;
                        BreezeComboBox breezeComboBox = new BreezeComboBox(false);
                        breezeComboBox.setModel(new DefaultComboBoxModel<Object>(categoryFactor.getClasses().toArray()));
                        breezeComboBox.setRenderer(new SelectMembersPanel.CatClassListCellRenderer());
                        breezeComboBox.addActionListener(actionEvent -> GroupExplorePanel.this.onInputChange(breezeContextMenu, abstractPlotLayout, factor, actionEvent, false));
                        breezeComboBox.requestFocus();
                        breezeContextMenu.addComponent(breezeComboBox);
                        BreezeTextField breezeTextField = new BreezeTextField();
                        breezeTextField.setText("New class");
                        breezeTextField.addChangeListener(textActionEvent -> GroupExplorePanel.this.onInputChange(breezeContextMenu, abstractPlotLayout, factor, textActionEvent, textActionEvent.isFocusLost()));
                        breezeContextMenu.addComponent(breezeTextField);
                    }
                }
            }
        };
        this.viewPanel.setName("exploreplot");
        this.viewPanel.addComponent(EntryMainHelper.createOpenMeasurementFromPlotButton(this.mainpanel, this.viewPanel));
        this.addViewPanel((Component)((Object)this.viewPanel), 0, 1, 1, 1, null, 1.0, 2.0);
        this.previewPanel = new InteractionPreviewPanel(workflow);
        this.setLeftSettingsPanel(this.previewPanel);
        this.plotSettingsPanel = new PlotSettingsPanel(this, this.viewPanel, this.previewPanel, true);
        this.componentSectionPanel = this.plotSettingsPanel.getComponentSectionPanel();
        this.componentSectionPanel.addComponent(EntryMainHelper.createButton("Statistics", "explore/stacked_line_chart", () -> BreezeOptionDialog.showDialog(this.mainpanel.getFrame(), this.mainpanel.getPageColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Statistics", "", (AbstractBreezeCustomPanel)new ViewPanelCustomPanel(new PixelExploreInterface.ModelSectionPanel.PcaModelStatisticsViewContainer(this.mainpanel, "model_p"), this.entrydata, 0.85), null, null)));
        this.viewPanel.addComponent(EntryMainHelper.createButton("Save", "file_save", () -> PlotPopupMenu.showSaveDialog((AbstractPlot)this.viewPanel.getVisualization(), (String)this.entrydata.getName())));
        this.viewPanel.addSeparator();
        if (entryMainPanel.getPageType().equals((Object)BreezeType.Project)) {
            if (RegInfo.isApplicationFeature()) {
                this.viewPanel.addComponent(EntryMainHelper.createButton("Add Sample model", "material/tab_new_right", () -> MeasurementTableInteraction.addNewSegmentation(entryMainPanel, Workflow.getWorkflow(this.entrydata))));
            }
            this.viewPanel.addComponent(EntryMainHelper.createButton("Add Variable or Id", "material/variable_add", () -> MeasurementTableInteraction.addColumn(entryMainPanel, Workflow.getWorkflow(this.entrydata))));
            this.viewPanel.addSeparator();
        }
        this.segmentationPanel = new SegmentationPanel(BreezeInputFieldHelper.Format.TwoRows, bl -> {
            if (bl) {
                DataSetCache.clear(this.entrydata);
            }
            this.showEntry(this.entrydata, null);
        });
        this.viewPanel.addComponent(this.segmentationPanel);
        this.viewPanel.addSeparator();
        this.viewPanel.addComponent(EntryMainHelper.createButton("More plots", "material/analytics", () -> BreezeOptionDialog.showDialog(this.mainpanel.getFrame(), this.viewPanel.getMainPanel().getPageColor(), AbstractBreezeDialog.MessageType.NO_BUTTON_OPTION, "Plots", "", (AbstractBreezeCustomPanel)new ViewPanelCustomPanel(new GroupPlotPanel(this.viewPanel.getMainPanel(), this.entrydata), this.entrydata, 0.85), null, null)));
        this.viewPanel.addSeparator();
        if (EvinceHelper.exists()) {
            this.viewPanel.addComponent(EntryMainHelper.createButton("Open in Evince", "Evince_24", () -> BreezeProgressDialog.startProgressWithCancel(this.mainpanel.getFrame(), new ProgressAction(){

                @Override
                public void runAction() throws Exception {
                    File file = new File(((Entry)GroupExplorePanel.this.entrydata).getFolder(), "Export");
                    File file2 = new File(file, FileHelper.createValidFilename(GroupExplorePanel.this.entrydata.getName()) + "_" + new SimpleDateFormat("yyyy_MM_dd_HH_mm").format(new Date()) + ".map");
                    BreezeProgressManager breezeProgressManager = this.getProgressManager();
                    EvinceScriptCommands.save((ProgressManager)breezeProgressManager, (Project_GUI)GroupExplorePanel.this.spectralPlot.getDataSet().getProject_GUI(), (String)file2.getAbsolutePath(), null);
                    DataSet dataSet = (DataSet)EvinceScriptCommands.load((ProgressManager)this.getProgressManager(), (String)file2.getAbsolutePath());
                    EvinceScriptCommands.createTable((ProgressManager)breezeProgressManager, (String)"viewdataset", (DataTreeInterface)dataSet);
                    DataTreeInterface dataTreeInterface = dataSet.getNodeByName("PCAModel");
                    QuickSpectral quickSpectral = (QuickSpectral)EvinceScriptCommands.createPlot((ProgressManager)breezeProgressManager, (String)"spectral", (DataTreeInterface)dataSet.getMatrix(0));
                    quickSpectral.setTitle(GroupExplorePanel.this.spectralPlot.getTitle());
                    EvinceScriptCommands.createPlot((ProgressManager)breezeProgressManager, (String)"score2d", (DataTreeInterface)dataTreeInterface);
                    dataSet.getProject_GUI().save((ProgressManager)breezeProgressManager, false, false, true);
                    EvinceHelper.startEvinceWithProject(file2);
                }
            }, "Opening Evince")));
        }
    }

    public void onInputChange(BreezeContextMenu breezeContextMenu, AbstractPlotLayout abstractPlotLayout, Factor factor, ActionEvent actionEvent, boolean bl) {
        if (!bl) {
            this.setSampleValue(abstractPlotLayout, factor, actionEvent.getSource().toString());
        }
        breezeContextMenu.close(false, null);
    }

    private void setSampleValue(AbstractPlotLayout abstractPlotLayout, Factor factor, Object object) {
        MeasurementDataSource measurementDataSource = (MeasurementDataSource)abstractPlotLayout.getPlotInit().getMatrix(0).getCase().getDataSource();
        HashSet<Measurement> hashSet = new HashSet<Measurement>();
        InteractionArray interactionArray = (InteractionArray)abstractPlotLayout.get("selection");
        for (int i = interactionArray.getFirstSet(); i <= interactionArray.getLastSet(); ++i) {
            if (!interactionArray.get(i)) continue;
            Sample sample = measurementDataSource.getSampleAt(i);
            sample.setSampleVariableOrIdentifier(factor, object.toString());
            hashSet.add(sample.measurement());
        }
        Workflow workflow = null;
        for (Measurement measurement : hashSet) {
            if (workflow == null) {
                workflow = measurement.getWorkflow();
                workflow.save();
            }
            measurement.save();
        }
        this.mainpanel.setDirty(true);
    }

    @Override
    public void showEntry(Object object, Object object2) {
        boolean bl;
        Workflow workflow = Workflow.getWorkflow(object);
        boolean bl2 = workflow != null && workflow.isXrayData();
        this.xRayPanel.setVisible(bl2);
        if (bl2) {
            this.xRayPanel.updateTabs(workflow);
        }
        this.spectralPlot.setVisible(!bl2);
        this.viewPanel.setVisible(!bl2);
        super.showEntry(object, object2);
        if (this.plotSettingsPanel != null) {
            this.plotSettingsPanel.setData((Entry)object, bl2, bl2 ? this.xRayPanel.getPlot() : this.viewPanel);
        }
        boolean bl3 = bl = object != this.entrydata;
        if (bl) {
            this.previewPanel.enableInteraction(this.mainpanel);
            this.entrydata = (ThingWithName)object;
            this.previewPanel.clearSelection("No selection");
        }
        if (workflow != null) {
            this.measurement = workflow.getFirstMeasurementWithData();
            this.spectralPlot.setTitle(PixelExplorePanel.getSpectralTitleCheckFiltered(this.measurement, PixelExploreInterface.PretreatmentSectionPanel.PretreatmentSource.GroupExplore));
        }
        this.segmentationPanel.updateSegmentations(workflow);
        AbstractPlotLayout abstractPlotLayout = this.spectralPlot.getVisualization();
        if (abstractPlotLayout != null) {
            QuickSpectralLayer quickSpectralLayer = (QuickSpectralLayer)abstractPlotLayout.getLayer(Double.valueOf(1.0));
            quickSpectralLayer.clearAverageList(bl);
        }
        this.onContentReady(() -> (bl2 ? this.xRayPanel.getPlot() : this.spectralPlot).selectFirstRowIfNoSelection());
    }

    @Override
    public Measurement getMeasurement() {
        return this.measurement;
    }

    @Override
    public List<RtModule> getTransformationModules() {
        return this.plotSettingsPanel.getTransformationModules();
    }

    @Override
    public boolean showLeftSettingsPanel() {
        return true;
    }

    @Override
    public EntrySettingsPanel.SettingsComponent getRightSettingsPanel(EntrySettingsPanel entrySettingsPanel) {
        return this.plotSettingsPanel;
    }

    @Override
    public boolean showRightSettingsPanel() {
        return true;
    }

    public static void checkAxis(AbstractPlotLayout abstractPlotLayout, int n) {
        if (n >= 2) {
            ComboItem comboItem = (ComboItem)abstractPlotLayout.getSettingBoxSelectedItem((byte)0);
            ComboItem comboItem2 = (ComboItem)abstractPlotLayout.getSettingBoxSelectedItem((byte)1);
            if (comboItem.getIndex() == comboItem2.getIndex()) {
                abstractPlotLayout.setDataRange(new Object[]{"x", "value", (double)(n - 1)});
                abstractPlotLayout.setDataRange(new Object[]{"y", "value", (double)n});
            }
        }
    }
}

