/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.record.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.table.TableModel;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.AnalyseList;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.identifier.Identifier;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.DeleteEntryCustomPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.LabelEntry;
import se.prediktera.breeze.frontend.common.entry.OpenEntryProgressAction;
import se.prediktera.breeze.frontend.common.swing.BreezeActionListener;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeList;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeTogglePanel;
import se.prediktera.breeze.frontend.common.swing.table.BreezeInteractionTable;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.common.swing.table.SortedTableModel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.common.view.preview.InteractionPreviewPanel;
import se.prediktera.breeze.frontend.common.view.visualization.TableViewPanel;
import se.prediktera.breeze.frontend.main.model.ModelMainPanel;
import se.prediktera.breeze.frontend.main.record.edit.common.EditBreezeList;
import se.prediktera.breeze.frontend.main.record.measurement.panel.MeasurementTable;
import se.prediktera.breeze.frontend.wizard.model.ClassificationModelWizard;
import se.prediktera.breeze.frontend.wizard.model.QuantificationModelWizard;
import se.prediktera.breeze.frontend.wizard.model.SampleModelWizard;
import se.prediktera.map.data.AbstractTable;
import se.prediktera.map.register.RegInfo;

public class MeasurementTableInteraction
extends ViewContainer {
    private final TableViewPanel viewPanel;
    private InteractionPreviewPanel previewPanel;
    protected Object entrydata = null;

    public MeasurementTableInteraction(final EntryMainPanel entryMainPanel, final Workflow workflow, final boolean bl, final boolean bl2, boolean bl3) {
        super(entryMainPanel, false);
        if (bl3) {
            this.previewPanel = new InteractionPreviewPanel(workflow);
            this.setLeftSettingsPanel(this.previewPanel);
        }
        this.viewPanel = new TableViewPanel(this, entryMainPanel, "", "MeasurementTable", "xtraining"){
            final /* synthetic */ MeasurementTableInteraction this$0;
            {
                this.this$0 = measurementTableInteraction;
                super(pPEntryMainInterface, string, string2, string3);
            }

            @Override
            public boolean hasInteraction(boolean bl3) {
                return true;
            }

            @Override
            public void tableSetup(AbstractTable abstractTable) throws Exception {
                MeasurementTable measurementTable = (MeasurementTable)abstractTable;
                measurementTable.setScrollToVisible(bl);
                BreezeTablePanel breezeTablePanel = measurementTable.getInnerTable();
                TableModel tableModel = breezeTablePanel.getTable().getModel();
                if (tableModel instanceof SortedTableModel) {
                    ((SortedTableModel)tableModel).sortByColumn(0, bl2);
                }
                breezeTablePanel.setRowHeight(BreezeProperties.getInstance().getTableCellHeight());
                breezeTablePanel.setColumnWidth(BreezeProperties.getInstance().getTableCellWidth());
                breezeTablePanel.setAbstractViewPanel(this.this$0);
                if (this.this$0.entrydata != null) {
                    if (workflow != null) {
                        breezeTablePanel.setVisualisationNode(workflow, this.this$0.entrydata);
                    } else if (this.this$0.entrydata instanceof Workflow) {
                        breezeTablePanel.setVisualisationNode((Workflow)this.this$0.entrydata, this.this$0.entrydata);
                    }
                }
                breezeTablePanel.addPreviewColumnListener(this.this$0.previewPanel);
                breezeTablePanel.addToToolbar(EntryMainHelper.createButton("Table height", "material/height", () -> this.this$0.getTable().getInnerTable().showCellHeightDialog(entryMainPanel)));
                breezeTablePanel.addToToolbar(EntryMainHelper.createButton("Table width", "material/width", () -> this.this$0.getTable().getInnerTable().showCellWidthDialog(entryMainPanel)));
                breezeTablePanel.addToToolbar(EntryMainHelper.createButton("Table auto-fit", "material/fit_width", () -> {
                    this.this$0.getTable().getInnerTable().setColumnWidth(0);
                    BreezeProperties.getInstance().setTableCellWidth(0);
                }));
                if (this.this$0.previewPanel != null) {
                    this.this$0.previewPanel.getLegendCallback().setTable(breezeTablePanel.getTable());
                }
            }
        };
        this.addViewPanel((Component)((Object)this.viewPanel), 0, 0, 1, 1);
        this.viewPanel.setName("measurementTable");
        this.viewPanel.addComponent(EntryMainHelper.createButton("Go to measurement", "explore/tab_move", () -> EntryMainHelper.showMeasurementPanel((BreezeMainPanel)entryMainPanel, this.getTable().getSelectedSample())));
        this.viewPanel.addSeparator();
        if (entryMainPanel.getPageType().equals((Object)BreezeType.Project)) {
            if (RegInfo.isApplicationFeature()) {
                this.viewPanel.addComponent(EntryMainHelper.createButton("Add Sample model", "material/tab_new_right", () -> MeasurementTableInteraction.addNewSegmentation(entryMainPanel, Workflow.getWorkflow(this.entrydata))));
            }
            this.viewPanel.addComponent(EntryMainHelper.createButton("Add Variable or Id", "material/variable_add", () -> MeasurementTableInteraction.addColumn(entryMainPanel, Workflow.getWorkflow(this.entrydata))));
            this.viewPanel.addSeparator();
        }
        this.viewPanel.addComponent(EntryMainHelper.createApplyButton(entryMainPanel));
    }

    @Override
    public void setData(boolean bl) {
        this.mainpanel.setDirty(true);
    }

    @Override
    public void showEntry(Object object, Object object2) {
        Entry entry;
        super.showEntry(object, object2);
        if (object != this.entrydata) {
            this.entrydata = object;
            if (this.previewPanel != null) {
                if (object instanceof Workflow) {
                    entry = (Workflow)object;
                    this.previewPanel.setWorkflow((Workflow)entry);
                }
                this.previewPanel.enableInteraction(this.mainpanel);
                this.previewPanel.clearSelection();
            }
        }
        if (object instanceof Entry) {
            entry = (Entry)object;
            this.setVisualisationNode(Workflow.getWorkflow(object), entry);
        }
        this.onContentReady(this.viewPanel::selectFirstRowIfNoSelection);
    }

    public void setVisualisationNode(Workflow workflow, Entry entry) {
        BreezeInteractionTable breezeInteractionTable = this.getTable();
        if (breezeInteractionTable != null) {
            BreezeTablePanel breezeTablePanel = breezeInteractionTable.getInnerTable();
            breezeTablePanel.setVisualisationNode(workflow, entry);
        }
    }

    protected BreezeInteractionTable getTable() {
        return (BreezeInteractionTable)this.viewPanel.getVisualization();
    }

    public static void addNewSegmentation(final EntryMainPanel entryMainPanel, final Workflow workflow) {
        final AnalyseList analyseList = BreezeMasterCache.getInstance().getAnalyseList();
        final SampleModelWizard.Info info = new SampleModelWizard.Info();
        BreezeOptionDialog.showDialog(entryMainPanel.getFrame(), entryMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.INPUT_OPTION, "New segmentation", "Enter name for the new " + info.getName() + " Model:", EntryMainHelper.getUniqueName(info.getName() + " - " + workflow.getName(), analyseList), new BreezeActionListener(){

            @Override
            public void actionPerformed(BreezeActionListener.BreezeActionEvent breezeActionEvent) {
                Analyse analyse = ModelMainPanel.createAnalyseAndSave(workflow, breezeActionEvent.result().toString(), info);
                analyseList.add(analyse);
                this.startSampleModelWizard(entryMainPanel, analyse);
            }

            private void startSampleModelWizard(final EntryMainPanel entryMainPanel2, final Analyse analyse) {
                BreezeProgressDialog.startProgress(entryMainPanel2.getFrame(), new OpenEntryProgressAction.OpenEntryDialogProgressAction(this, entryMainPanel2.getFrame()){

                    @Override
                    protected BreezeMainPanel createOpenPanel() {
                        return ModelMainPanel.createModelWizard(this.getProgressManager(), entryMainPanel2, analyse, () -> entryMainPanel2.setDirty(true));
                    }
                }, "Opening...");
            }
        });
    }

    public static void addNewModel(EntryMainPanel entryMainPanel, Workflow workflow) {
        ArrayList<BreezeTogglePanel.ToggleItem> arrayList = new ArrayList<BreezeTogglePanel.ToggleItem>();
        arrayList.add(new ModelMainPanel.ModelToggleItem(workflow, new SampleModelWizard.Info()));
        arrayList.add(new ModelMainPanel.ModelToggleItem(workflow, new QuantificationModelWizard.Info()));
        arrayList.add(new ModelMainPanel.ModelToggleItem(workflow, new ClassificationModelWizard.Info()));
        BreezeOptionDialog.showDialog(entryMainPanel.getFrame(), entryMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.CANCEL_OPTION, "New Model", "", (AbstractBreezeCustomPanel)new BreezeTogglePanel(arrayList, entryMainPanel.getPageType(), "", (breezeTogglePanel, toggleItem) -> {
            if (workflow != null) {
                breezeTogglePanel.setInputName(toggleItem.getName() + " - " + workflow.getName());
            } else {
                breezeTogglePanel.setInputName(toggleItem.getName());
            }
        }, 0), null, breezeActionEvent -> {});
    }

    public static void addColumn(BreezeMainPanel breezeMainPanel, Workflow workflow) {
        MeasurementTableInteraction.addColumn(breezeMainPanel, workflow, 1);
    }

    public static void addColumn(final BreezeMainPanel breezeMainPanel, final Workflow workflow, int n) {
        BreezeOptionDialog.showDialog(breezeMainPanel.getFrame(), breezeMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.POPUP_OPTION, "Add Variable or Id", "", (AbstractBreezeCustomPanel)new AddColumnPanel(n), null, new BreezeActionListener(){

            @Override
            public void actionPerformed(BreezeActionListener.BreezeActionEvent breezeActionEvent) {
                AddColumnPanel addColumnPanel = (AddColumnPanel)breezeActionEvent.getBreezeCustomPanel();
                this.addColumn(addColumnPanel.getType(), addColumnPanel.getVariableName());
                workflow.save();
                DataSetCache.clear(workflow);
                breezeMainPanel.setDirty(true);
            }

            private void addColumn(EditBreezeList.BreezeListType breezeListType, String string) {
                switch (breezeListType) {
                    case Category: {
                        workflow.getCategoryFactors().add(CategoryFactor.withNoClass(EntryMainHelper.getUniqueName(string, workflow.getCategoryFactors().getList())));
                        break;
                    }
                    case Identifier: {
                        workflow.getIdentifiers().add(new Identifier(EntryMainHelper.getUniqueName(string, workflow.getIdentifiers().getList())));
                        break;
                    }
                    case Property: {
                        workflow.getPropertyFactors().add(new PropertyFactor(EntryMainHelper.getUniqueName(string, workflow.getPropertyFactors().getList())));
                        break;
                    }
                }
            }
        });
    }

    public static class AddColumnPanel
    extends AbstractBreezeCustomPanel {
        private final BreezeList list = new BreezeList();
        private final BreezeInputField nameField = new BreezeInputField("Name:", "", "");

        public AddColumnPanel() {
            this(1);
        }

        public AddColumnPanel(int n) {
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            this.setPreferredSize(new Dimension(550, 400));
            DeleteEntryCustomPanel.TextArea textArea = new DeleteEntryCustomPanel.TextArea("Type:");
            textArea.setName("topText");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(40, 12, 0, 12);
            this.add((Component)textArea, gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.insets = new Insets(6, 24, 0, 12);
            this.list.setBackground(BreezeTheme.getInstance().getDialogBackground());
            this.list.setSelectionMode(0);
            this.list.setCellRenderer(new LabelEntry(150, 14){

                @Override
                protected String getText(Object object) {
                    EditBreezeList.BreezeListType breezeListType = (EditBreezeList.BreezeListType)((Object)object);
                    return breezeListType.getNameWithDescription();
                }
            });
            this.list.setModel(Arrays.asList(EditBreezeList.BreezeListType.Identifier, EditBreezeList.BreezeListType.Property, EditBreezeList.BreezeListType.Category));
            this.list.addListSelectionListener(listSelectionEvent -> {
                this.nameField.setText(this.list.getSelectedValue().toString());
                this.nameField.requestFocusAndSelectAll();
            });
            this.list.setSelectedIndex(n);
            this.add((Component)((Object)this.list), gridBagConstraints2);
            this.add((Component)this.nameField, GridBagHelper.create(2, new Insets(12, 12, 40, 12)));
        }

        @Override
        public void customButton(BreezeButton breezeButton, BreezeButton breezeButton2, BreezeButton breezeButton3) {
            breezeButton2.setText("Add");
        }

        public EditBreezeList.BreezeListType getType() {
            return (EditBreezeList.BreezeListType)((Object)this.list.getSelectedValue());
        }

        public String getVariableName() {
            return this.nameField.getValue();
        }

        @Override
        public Object getResult() {
            return null;
        }

        @Override
        public boolean usePreferredSize() {
            return true;
        }
    }
}

