/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.record.panel;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import se.prediktera.breeze.entry.analyse.model.Model;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;
import se.prediktera.breeze.frontend.main.record.panel.SelectHelper;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.datasetcontainer.matrix.ModelMatrix;
import se.prediktera.map.model.AbstractModel;
import se.prediktera.mda.selection.Grid;
import se.prediktera.mda.selection.MarengoTodeschini2;
import se.prediktera.mda.selection.MtSample;

public class SelectBinningPanel
extends AbstractBreezeCustomPanel {
    private final BreezeInputField percentInputField = new BreezeInputField.Number("Percentage that should be selected (0-100)", 50.0, "");

    public SelectBinningPanel() {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        this.add((Component)this.percentInputField, GridBagHelper.createWithWeigthX1(this.getComponentCount(), new Insets(40, 0, 0, 0)));
        this.percentInputField.requestFocusAndSelectAll();
    }

    @Override
    public Object getResult() {
        return null;
    }

    public void apply(Model model, BreezeTable breezeTable) {
        ArrayList<Integer> arrayList;
        AbstractModel abstractModel = model.getModel();
        if (abstractModel != null) {
            ModelMatrix modelMatrix = abstractModel.getScores();
            int n = (int)((double)modelMatrix.getK() * (this.percentInputField.getNumber() / 100.0));
            int[] nArray = modelMatrix.getKref();
            MarengoTodeschini2 marengoTodeschini2 = new MarengoTodeschini2(modelMatrix);
            Grid grid = marengoTodeschini2.selectSamples(n, 0);
            ArrayList arrayList2 = grid.getSamples();
            arrayList = new ArrayList<Integer>();
            for (int i = 0; i < arrayList2.size(); ++i) {
                arrayList.add(nArray[((MtSample)arrayList2.get(i)).getIdx()]);
            }
        } else {
            throw new ErrorHandler.InformationMessageException("Model is missing");
        }
        SelectHelper.select(breezeTable, arrayList);
    }
}

