/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.record.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.FactorOrDescriptor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.ArrayListModel;
import se.prediktera.breeze.frontend.common.entry.LabelEntry;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeList;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.main.record.panel.SelectHelper;

public class SelectClassPanel
extends AbstractBreezeCustomPanel {
    private final BreezeComboBoxInputField<FactorOrDescriptor> categoryComboBox = new BreezeComboBoxInputField("Category");
    private final BreezeInputField percentInputField = new BreezeInputField.Number("Percentage that should be selected from each class randomly (0-100)", 100.0, "");
    private final BreezeCheckBox onlyIncluded = new BreezeCheckBox("Only from included", true);
    private final BreezeList list = new BreezeList();

    public SelectClassPanel(Workflow workflow) {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        this.categoryComboBox.addList(workflow.getCategoryFactors().getList());
        if (this.categoryComboBox.getItemCount() > 0) {
            this.categoryComboBox.addSeparator();
        }
        this.categoryComboBox.addList(this.getCategoryDescriptors(workflow));
        this.categoryComboBox.setChangedListener(factorOrDescriptor -> this.updateList());
        this.categoryComboBox.setRenderer(new BreezeTablePanel.FunctionCellRenderer());
        this.updateList();
        this.add(this.categoryComboBox, GridBagHelper.createWithWeigthX1(this.getComponentCount(), new Insets(20, 0, 0, 0)));
        this.add((Component)new BreezeLabel("Class"), GridBagHelper.createWithWeigthX1(this.getComponentCount(), new Insets(10, 0, 0, 0)));
        BreezeScrollPane breezeScrollPane = new BreezeScrollPane((Component)((Object)this.list));
        breezeScrollPane.setHorizontalScrollBarPolicy(31);
        this.list.setCellRenderer(new LabelEntry(150, 14));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)breezeScrollPane, gridBagConstraints);
        this.add((Component)this.percentInputField, GridBagHelper.createWithWeigthX1(this.getComponentCount(), new Insets(20, 0, 0, 0)));
        this.add((Component)this.onlyIncluded, GridBagHelper.createWithWeigthX1(this.getComponentCount(), new Insets(20, 0, 0, 0)));
        this.setPreferredSize(new Dimension(600, 700));
    }

    private List<FactorOrDescriptor> getCategoryDescriptors(Workflow workflow) {
        ArrayList<FactorOrDescriptor> arrayList = new ArrayList<FactorOrDescriptor>();
        for (DescriptorTreeNode descriptorTreeNode : workflow.getSegmentationLevelDescriptorNodes(true)) {
            if (!(descriptorTreeNode.getFactor() instanceof CategoryFactor)) continue;
            arrayList.add(descriptorTreeNode);
        }
        return arrayList;
    }

    @Override
    public boolean usePreferredSize() {
        return true;
    }

    private void updateList() {
        FactorOrDescriptor factorOrDescriptor = this.categoryComboBox.getSelectedItem();
        if (factorOrDescriptor != null) {
            this.list.setModel(new ArrayListModel(SelectClassPanel.getCategory(factorOrDescriptor).getGroupedClasses()));
            if (this.list.getItemCount() > 0) {
                this.list.setSelectedIndex(0);
            }
        }
    }

    private static CategoryFactor getCategory(FactorOrDescriptor factorOrDescriptor) {
        DescriptorTreeNode descriptorTreeNode;
        Factor factor;
        if (factorOrDescriptor instanceof CategoryFactor) {
            CategoryFactor categoryFactor = (CategoryFactor)factorOrDescriptor;
            return categoryFactor;
        }
        if (factorOrDescriptor instanceof DescriptorTreeNode && (factor = (descriptorTreeNode = (DescriptorTreeNode)factorOrDescriptor).getFactor()) instanceof CategoryFactor) {
            CategoryFactor categoryFactor = (CategoryFactor)factor;
            return categoryFactor;
        }
        return null;
    }

    @Override
    public Object getResult() {
        return this.list.getSelectedValue();
    }

    public void apply(BreezeTable breezeTable) {
        FactorOrDescriptor factorOrDescriptor = this.categoryComboBox.getSelectedItem();
        if (factorOrDescriptor != null) {
            List<CatClass> list = SelectClassPanel.getCategory(factorOrDescriptor).getClasses();
            List<Integer> list2 = this.onlyIncluded.isSelected() ? SelectHelper.getIncluded(breezeTable) : SelectHelper.getAll(breezeTable);
            double d = this.percentInputField.getNumber();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (Object e : this.list.getSelectedValuesList()) {
                int n = list.indexOf(e);
                List<Integer> list3 = SelectHelper.getValueIndex(breezeTable, list2, factorOrDescriptor, new SelectHelper.ValueWithinRange(n, SelectHelper.ValueWithinRange.RangeType.Equals));
                if (d < 100.0) {
                    arrayList.addAll(SelectHelper.getRandom(list3, d));
                    continue;
                }
                arrayList.addAll(list3);
            }
            SelectHelper.select(breezeTable, arrayList);
        }
    }
}

