/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.record.panel;

import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.swing.ListSelectionModel;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.FactorOrDescriptor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.BreezeIndexIntervalClass;

public class SelectHelper {
    public static List<Integer> getIncluded(BreezeTable breezeTable) {
        return SelectHelper.get(breezeTable, true);
    }

    public static List<Integer> get(BreezeTable breezeTable, boolean bl) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < breezeTable.getRowCount(); ++i) {
            Object object = breezeTable.getValueAt(i, 0);
            if (object instanceof BreezeIndexIntervalClass) {
                BreezeIndexIntervalClass breezeIndexIntervalClass = (BreezeIndexIntervalClass)object;
                if (breezeIndexIntervalClass.isIncluded() != bl) continue;
                arrayList.add(i);
                continue;
            }
            arrayList.add(i);
        }
        return arrayList;
    }

    public static List<Integer> getAll(BreezeTable breezeTable) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < breezeTable.getRowCount(); ++i) {
            arrayList.add(i);
        }
        return arrayList;
    }

    public static List<Integer> getInterval(List<Integer> list, int n, int n2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = n; i < list.size(); i += n2) {
            Integer n3 = list.get(i);
            arrayList.add(n3);
        }
        return arrayList;
    }

    public static List<Integer> getValueIndex(BreezeTable breezeTable, List<Integer> list, FactorOrDescriptor factorOrDescriptor, ValueWithinRange valueWithinRange) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            DescriptorTreeNode descriptorTreeNode;
            Serializable serializable;
            Integer n = list.get(i);
            Object object = breezeTable.getValueAt(n, 0);
            Sample sample = Sample.getSample(object);
            if (sample == null) continue;
            if (factorOrDescriptor instanceof Factor) {
                Factor factor = (Factor)factorOrDescriptor;
                serializable = sample.getVariableValue(factor);
                if (serializable == null || !valueWithinRange.within(((Float)serializable).floatValue())) continue;
                arrayList.add(n);
                continue;
            }
            if (!(factorOrDescriptor instanceof DescriptorTreeNode) || (serializable = sample.getFunctionResult((descriptorTreeNode = (DescriptorTreeNode)factorOrDescriptor).getUid())) == null || !valueWithinRange.within(((FunctionResult)serializable).getValue())) continue;
            arrayList.add(n);
        }
        return arrayList;
    }

    public static List<Integer> getRandom(List<Integer> list, double d) {
        double d2 = Math.max(Math.min(d / 100.0, 1.0), 0.0);
        int n = (int)((double)list.size() * d2);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list);
        Collections.shuffle(arrayList, ThreadLocalRandom.current());
        return arrayList.subList(0, n).stream().sorted().toList();
    }

    public static void select(BreezeTable breezeTable, List<Integer> list) {
        breezeTable.clearSelection();
        ListSelectionModel listSelectionModel = breezeTable.getSelectionModel();
        boolean bl = true;
        int n = 0;
        listSelectionModel.setValueIsAdjusting(true);
        for (int i = 0; i < list.size(); ++i) {
            Integer n2 = list.get(i);
            if (bl) {
                n = n2;
                listSelectionModel.setSelectionInterval(n2, n2);
                bl = false;
                continue;
            }
            listSelectionModel.addSelectionInterval(n2, n2);
        }
        listSelectionModel.setValueIsAdjusting(false);
        breezeTable.scrollRectToVisible(new Rectangle(breezeTable.getCellRect(n, 0, true)));
    }

    public static class ValueWithinRange {
        public float min;
        public float max;
        private final RangeType minType;
        private final RangeType maxType;

        public ValueWithinRange(float f, RangeType rangeType) {
            this(f, rangeType, 0.0f, RangeType.None);
        }

        public ValueWithinRange(float f, RangeType rangeType, float f2, RangeType rangeType2) {
            this.min = f;
            this.minType = rangeType;
            this.max = f2;
            this.maxType = rangeType2;
        }

        public boolean within(float f) {
            if (this.minType.included()) {
                boolean bl = this.compare(f, this.min, this.minType);
                if (this.maxType.included()) {
                    return bl && this.compare(f, this.max, this.maxType);
                }
                return bl;
            }
            if (this.maxType.included()) {
                return this.compare(f, this.max, this.maxType);
            }
            return false;
        }

        private boolean compare(float f, float f2, RangeType rangeType) {
            return switch (rangeType.ordinal()) {
                case 1 -> {
                    if (f == f2) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if (f < f2) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if (f <= f2) {
                        yield true;
                    }
                    yield false;
                }
                case 4 -> {
                    if (f > f2) {
                        yield true;
                    }
                    yield false;
                }
                case 5 -> {
                    if (f >= f2) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw new IllegalArgumentException("Unknown RangeType: " + String.valueOf((Object)rangeType));
            };
        }

        public static enum RangeType {
            None("Excluded"),
            Equals("="),
            Less("<"),
            LessEquals("<="),
            Greater(">"),
            GreaterEquals(">=");

            private final String description;

            private RangeType(String string2) {
                this.description = string2;
            }

            public boolean included() {
                return !this.equals((Object)None);
            }

            public String toString() {
                return this.description;
            }
        }
    }
}

