/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.record.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import se.prediktera.breeze.common.entry.factor.FactorOrDescriptor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.main.record.panel.SelectHelper;

public class SelectValuePanel
extends AbstractBreezeCustomPanel {
    private final BreezeComboBoxInputField<FactorOrDescriptor> propertyComboBox = new BreezeComboBoxInputField("Property");
    private final BreezeCheckBox onlyIncluded = new BreezeCheckBox("Only from included", true);
    private final BreezeInputField.Number minValueInputField = new BreezeInputField.Number("Min", -100.0, "");
    private final BreezeComboBoxInputField<SelectHelper.ValueWithinRange.RangeType> minTypeInputField = new BreezeComboBoxInputField(" ", "", BreezeInputFieldHelper.Format.TwoRows);
    private final BreezeInputField.Number maxValueInputField = new BreezeInputField.Number("Max", 100.0, "");
    private final BreezeComboBoxInputField<SelectHelper.ValueWithinRange.RangeType> maxTypeInputField = new BreezeComboBoxInputField(" ", "", BreezeInputFieldHelper.Format.TwoRows);

    public SelectValuePanel(Workflow workflow) {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        this.propertyComboBox.addList(workflow.getPropertyFactors().getList());
        if (this.propertyComboBox.getItemCount() > 0) {
            this.propertyComboBox.addSeparator();
        }
        this.propertyComboBox.addList(this.getPropertyDescriptors(workflow));
        this.propertyComboBox.setRenderer(new BreezeTablePanel.FunctionCellRenderer());
        this.add(this.propertyComboBox, GridBagHelper.createWithWeigthX1(this.getComponentCount(), new Insets(20, 0, 0, 0)));
        this.add((Component)new BreezeLabel("Range"), GridBagHelper.createWithWeigthX1(this.getComponentCount(), new Insets(20, 0, 0, 0)));
        this.minTypeInputField.setItems(List.of(SelectHelper.ValueWithinRange.RangeType.values()));
        this.minTypeInputField.setSelectedItem(SelectHelper.ValueWithinRange.RangeType.Greater);
        this.minTypeInputField.setValueWidth(100);
        this.minTypeInputField.setChangedListener(rangeType -> this.minValueInputField.setEnabled(rangeType.included()));
        this.maxTypeInputField.setItems(List.of(SelectHelper.ValueWithinRange.RangeType.values()));
        this.maxTypeInputField.setSelectedItem(SelectHelper.ValueWithinRange.RangeType.Less);
        this.maxTypeInputField.setValueWidth(100);
        this.maxTypeInputField.setChangedListener(rangeType -> this.maxValueInputField.setEnabled(rangeType.included()));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        jPanel.add(this.minTypeInputField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        jPanel.add((Component)this.minValueInputField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        jPanel.add(this.maxTypeInputField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        jPanel.add((Component)this.maxValueInputField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
        this.add((Component)this.onlyIncluded, GridBagHelper.createWithWeigthX1(this.getComponentCount(), new Insets(20, 0, 0, 0)));
        this.setPreferredSize(new Dimension(600, 400));
    }

    private List<FactorOrDescriptor> getPropertyDescriptors(Workflow workflow) {
        ArrayList<FactorOrDescriptor> arrayList = new ArrayList<FactorOrDescriptor>();
        for (DescriptorTreeNode descriptorTreeNode : workflow.getSegmentationLevelDescriptorNodes(true)) {
            if (!(descriptorTreeNode.getFactor() instanceof PropertyFactor)) continue;
            arrayList.add(descriptorTreeNode);
        }
        return arrayList;
    }

    @Override
    public boolean usePreferredSize() {
        return true;
    }

    @Override
    public Object getResult() {
        return null;
    }

    public void apply(BreezeTable breezeTable) {
        FactorOrDescriptor factorOrDescriptor = this.propertyComboBox.getSelectedItem();
        if (factorOrDescriptor != null) {
            List<Integer> list = this.onlyIncluded.isSelected() ? SelectHelper.getIncluded(breezeTable) : SelectHelper.getAll(breezeTable);
            ArrayList<Integer> arrayList = new ArrayList<Integer>(SelectHelper.getValueIndex(breezeTable, list, factorOrDescriptor, new SelectHelper.ValueWithinRange(this.minValueInputField.getNumberFloat(), this.minTypeInputField.getSelectedItem(), this.maxValueInputField.getNumberFloat(), this.maxTypeInputField.getSelectedItem())));
            SelectHelper.select(breezeTable, arrayList);
        }
    }
}

