/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.main.settings;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.io.Serializable;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportBreezeRuntime;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeExternalLinkPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeRadioButton;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.main.settings.MaintenancePanel;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.tcp.TcpManager;

public class BreezeRuntimeSettingsPanel
extends AbstractViewPanel
implements MaintenancePanel.ConnectCallback {
    private final BreezeRadioButton localRadioButton;
    private final BreezeRadioButton remoteRadioButton;
    private final BreezeCheckBox showTerminalWindow;
    private final JPanel remotePanel = new JPanel(new GridBagLayout());
    private final BreezeInputField hostInputField;
    private final PredictionSettingsPanel predictionSettingsPanel;

    public BreezeRuntimeSettingsPanel(MaintenancePanel maintenancePanel) {
        super(maintenancePanel);
        this.setLayout(new GridBagLayout());
        Serializable serializable = new JPanel(new GridBagLayout());
        serializable.setOpaque(false);
        int n = 0;
        serializable.add(new BreezeLabel("Runtime settings", false, 16), this.createGridBagConstraints(n++));
        serializable.add(new BreezeSeparator(), this.createGridBagConstraints(n++));
        JLabel jLabel = new JLabel("The Runtime connects to cameras and other hardware, and performs predictions and other calculations.");
        Font font = jLabel.getFont();
        jLabel.setFont(new Font(font.getFontName(), font.getStyle(), 14));
        BreezeExternalLinkPanel breezeExternalLinkPanel = new BreezeExternalLinkPanel(jLabel, "settings");
        serializable.add(breezeExternalLinkPanel, this.createGridBagConstraints(n++));
        JLabel jLabel2 = new JLabel("Runtime location:");
        jLabel2.setFont(new Font(font.getFontName(), font.getStyle(), 14));
        serializable.add(jLabel2, this.createGridBagConstraints(n++, 12, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.localRadioButton = new BreezeRadioButton("Local on this computer", 14, buttonGroup, true, null);
        this.localRadioButton.addItemListener(this::radioButtonStateChanged);
        serializable.add(this.localRadioButton, this.createGridBagConstraints(n++));
        this.showTerminalWindow = new BreezeCheckBox("When Runtime starts, display the Runtime log in a terminal window", BreezeProperties.getInstance().showTerminalWindow(), BreezeProperties.getInstance()::setShowTerminalWindow);
        serializable.add(this.showTerminalWindow, this.createGridBagConstraints(n++, 12, 24));
        JLabel jLabel3 = new JLabel("Export the current workspace, including settings and prepared Runtime workflows, for use on another computer.");
        jLabel3.setFont(new Font(font.getFontName(), font.getStyle(), 14));
        serializable.add(jLabel3, this.createGridBagConstraints(n++, 12, 24));
        BreezeButton breezeButton = EntryMainHelper.createTextButton("Export Runtime workspace", () -> PPExportBreezeRuntime.exportRuntimeWorkspace(maintenancePanel));
        breezeButton.setPreferredSize(new Dimension(200, 30));
        serializable.add(breezeButton, this.createGridBagConstraints(n++, 12, 24));
        this.remoteRadioButton = new BreezeRadioButton("Remote computer (advanced)", 14, buttonGroup, false, null);
        this.remoteRadioButton.addItemListener(this::radioButtonStateChanged);
        serializable.add(this.remoteRadioButton, this.createGridBagConstraints(n++, 12, 0));
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.localRadioButton.setForeground(breezeTheme.getLabelForeground());
        this.remoteRadioButton.setForeground(breezeTheme.getLabelForeground());
        this.remotePanel.setOpaque(false);
        this.hostInputField = new BreezeInputField();
        this.hostInputField.setDescription("Remote Runtime address");
        this.hostInputField.setFormat(BreezeInputFieldHelper.Format.OneRow);
        this.hostInputField.setUnit("");
        this.hostInputField.addChangeListener(textActionEvent -> BreezeProperties.getInstance().setBreezeRuntimeHost(textActionEvent.getText()));
        GridBagConstraints gridBagConstraints = this.createGridBagConstraints(0, 6, 24);
        gridBagConstraints.fill = 1;
        this.remotePanel.add((Component)this.hostInputField, gridBagConstraints);
        JLabel jLabel4 = new JLabel("Note that Breeze Runtime must be running on the remote computer before Breeze can connect to it");
        jLabel4.setFont(new Font(font.getFontName(), font.getStyle(), 14));
        this.remotePanel.add((Component)jLabel4, this.createGridBagConstraints(1, 12, 24));
        serializable.add(this.remotePanel, this.createGridBagConstraints(n++));
        this.add((Component)serializable, this.createMainPanelGridBagConstraints());
        serializable = new CollapsePanel();
        this.add((Component)serializable, this.createMainPanelGridBagConstraints());
        ((CollapsePanel)serializable).setTitle("Runtime TCP ports");
        ((CollapsePanel)serializable).addPanel(new BreezeInputField.Number("Command port", (double)BreezeProperties.getInstance().getCommandPort(), "", textActionEvent -> BreezeProperties.getInstance().setCommandPort(textActionEvent.getValueInt())));
        ((CollapsePanel)serializable).addPanel(new BreezeInputField.Number("Event port", (double)BreezeProperties.getInstance().getEventPort(), "", textActionEvent -> BreezeProperties.getInstance().setEventPort(textActionEvent.getValueInt())));
        ((CollapsePanel)serializable).addPanel(new BreezeInputField.Number("First data stream port", (double)BreezeProperties.getInstance().getDataStreamPort(), "", textActionEvent -> BreezeProperties.getInstance().setStreamPort(textActionEvent.getValueInt())));
        ((CollapsePanel)serializable).setCollapsed(false);
        serializable = this.createMainPanelGridBagConstraints();
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).weighty = 1.0;
        this.predictionSettingsPanel = new PredictionSettingsPanel();
        this.add(this.predictionSettingsPanel, serializable);
    }

    private GridBagConstraints createMainPanelGridBagConstraints() {
        GridBagConstraints gridBagConstraints = GridBagHelper.createLeft(this.getComponentCount(), new Insets(12, 0, 0, 0));
        gridBagConstraints.fill = 2;
        return gridBagConstraints;
    }

    private GridBagConstraints createGridBagConstraints(int n) {
        return this.createGridBagConstraints(n, 10, 0);
    }

    private GridBagConstraints createGridBagConstraints(int n, int n2, int n3) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(n2, n3, 0, 0);
        return gridBagConstraints;
    }

    @Override
    public String getType() {
        return "Runtime";
    }

    @Override
    public void showEntry(Object object, Object object2) {
        this.hostInputField.setValue(BreezeProperties.getInstance().getBreezeRuntimeHost());
        if (BreezeProperties.getInstance().isBreezeRuntimeLocalHost()) {
            this.localRadioButton.setSelected(true);
        } else {
            this.remoteRadioButton.setSelected(true);
        }
        this.updateControls();
        this.predictionSettingsPanel.showEntry();
    }

    @Override
    public void updateFromCamera(Camera camera, boolean bl) {
    }

    @Override
    public void setBgColor(Color color) {
        super.setBgColor(color);
    }

    @Override
    public void afterConnection(Camera camera) {
    }

    private void radioButtonStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            BreezeProperties.getInstance().setBreezeRuntimeLocal(itemEvent.getSource() == this.localRadioButton);
            this.updateControls();
        }
    }

    public String toString() {
        return "";
    }

    private void updateControls() {
        boolean bl = this.localRadioButton.isSelected();
        this.showTerminalWindow.setEnabled(bl);
        this.remotePanel.setVisible(!bl);
    }

    public static class PredictionSettingsPanel
    extends CollapsePanel {
        private final BreezeCheckBox gpuButton;
        private final BreezeInputField.Number predictThreadsInputField;
        private final BreezeInputField.Number onnxThreadsInputField;
        private BreezeInputField.Number onnxGlobalsInterThreadsInputField;
        private BreezeInputField.Number onnxGlobalsIntraThreadsInputField;
        private BreezeCheckBox onnxGlobalsSpinWait;
        private final BreezeInputField.Number predictorBlockFactorInputField;
        private final BreezeInputField.Number applyChangesChunksInputField;

        public PredictionSettingsPanel() {
            super("Prediction settings");
            this.setCollapsed(false);
            this.predictThreadsInputField = new BreezeInputField.Number("Predictor threads", 0.0, "", textActionEvent -> TcpManager.getInstance().setProperty("PredictorThreads", textActionEvent.getText()));
            this.addPanel(this.predictThreadsInputField);
            this.onnxThreadsInputField = new BreezeInputField.Number("ONNX threads", 0.0, "", textActionEvent -> TcpManager.getInstance().setProperty("OnnxThreads", textActionEvent.getText()));
            this.addPanel(this.onnxThreadsInputField);
            this.addPanel(new BreezeCheckBox("Save ONNX input images for troubleshooting to the workspace/Data/Temp folder", BreezeProperties.getInstance().saveOnnxInputImages(), bl -> BreezeProperties.getInstance().setSaveOnnxInputImages(bl)));
            if (BreezeFrame.isOnnxGlobalsFeature()) {
                this.onnxGlobalsInterThreadsInputField = new BreezeInputField.Number("Onnx global inter threads", 0.0, "", textActionEvent -> TcpManager.getInstance().setProperty("OnnxGlobalsThreadsInter", textActionEvent.getText()));
                this.addPanel(this.onnxGlobalsInterThreadsInputField);
                this.onnxGlobalsIntraThreadsInputField = new BreezeInputField.Number("Onnx global intra threads", 0.0, "", textActionEvent -> TcpManager.getInstance().setProperty("OnnxGlobalsThreadsIntra", textActionEvent.getText()));
                this.addPanel(this.onnxGlobalsIntraThreadsInputField);
                this.onnxGlobalsSpinWait = new BreezeCheckBox("Onnx global SpinWait", true, bl -> TcpManager.getInstance().setProperty("OnnxGlobalsSpinWait", String.valueOf(bl)));
                this.addPanel(this.onnxGlobalsSpinWait);
            }
            this.predictorBlockFactorInputField = new BreezeInputField.Number("Predictor block factor", 0.0, "", textActionEvent -> TcpManager.getInstance().setProperty("PredictorBlockFactor", textActionEvent.getText()));
            this.addPanel(this.predictorBlockFactorInputField);
            this.applyChangesChunksInputField = new BreezeInputField.Number("Apply changes chunks", 0.0, "", textActionEvent -> TcpManager.getInstance().setProperty("ApplyChangesChunks", textActionEvent.getText()));
            this.addPanel(this.applyChangesChunksInputField);
            this.gpuButton = new BreezeCheckBox("Use hardware acceleration (beta)", BreezeProperties.getInstance().useHardwareAcceleration(), bl -> BreezeProperties.getInstance().setUseHardwareAcceleration(bl));
            this.addPanel(new BreezeExternalLinkPanel(this.gpuButton, "enabling-gpu-acceleration"));
            this.setCollapseCallback(this::setValues);
        }

        public void showEntry() {
            this.setValues(this.isExpanded());
        }

        private void setValues(boolean bl) {
            if (bl) {
                this.predictThreadsInputField.setValue(TcpManager.getInstance().getProperty("PredictorThreads"));
                this.onnxThreadsInputField.setValue(TcpManager.getInstance().getProperty("OnnxThreads"));
                if (BreezeFrame.isOnnxGlobalsFeature()) {
                    this.onnxGlobalsSpinWait.setSelected(Boolean.parseBoolean(TcpManager.getInstance().getProperty("OnnxGlobalsSpinWait")));
                    this.onnxGlobalsInterThreadsInputField.setValue(TcpManager.getInstance().getProperty("OnnxGlobalsThreadsInter"));
                    this.onnxGlobalsIntraThreadsInputField.setValue(TcpManager.getInstance().getProperty("OnnxGlobalsThreadsIntra"));
                }
                this.predictorBlockFactorInputField.setValue(TcpManager.getInstance().getProperty("PredictorBlockFactor"));
                this.applyChangesChunksInputField.setValue(TcpManager.getInstance().getProperty("ApplyChangesChunks"));
                String string = TcpManager.getInstance().getProperty("HardwareSettings");
                if (!string.equals("AVAILABLE")) {
                    this.gpuButton.setEnabled(false);
                    this.gpuButton.setToolTipText(string);
                }
            }
        }
    }
}

